/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/k8s.min.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * The secret's value will be presented as the content of a file whose
 * name is defined in the item path. If no items are defined, the name of
 * the file is the secret.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.SecretVolumeSource}
 */
public final class SecretVolumeSource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.SecretVolumeSource)
    SecretVolumeSourceOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SecretVolumeSource.newBuilder() to construct.
  private SecretVolumeSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SecretVolumeSource() {
    secret_ = "";
    items_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SecretVolumeSource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.K8sMinProto
        .internal_static_google_cloud_run_v2_SecretVolumeSource_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.K8sMinProto
        .internal_static_google_cloud_run_v2_SecretVolumeSource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.SecretVolumeSource.class,
            com.google.cloud.run.v2.SecretVolumeSource.Builder.class);
  }

  public static final int SECRET_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object secret_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the secret in Cloud Secret Manager.
   * Format: {secret} if the secret is in the same project.
   * projects/{project}/secrets/{secret} if the secret is
   * in a different project.
   * </pre>
   *
   * <code>string secret = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The secret.
   */
  @java.lang.Override
  public java.lang.String getSecret() {
    java.lang.Object ref = secret_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      secret_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the secret in Cloud Secret Manager.
   * Format: {secret} if the secret is in the same project.
   * projects/{project}/secrets/{secret} if the secret is
   * in a different project.
   * </pre>
   *
   * <code>string secret = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for secret.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSecretBytes() {
    java.lang.Object ref = secret_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      secret_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ITEMS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.run.v2.VersionToPath> items_;

  /**
   *
   *
   * <pre>
   * If unspecified, the volume will expose a file whose name is the
   * secret, relative to VolumeMount.mount_path.
   * If specified, the key will be used as the version to fetch from Cloud
   * Secret Manager and the path will be the name of the file exposed in the
   * volume. When items are defined, they must specify a path and a version.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.run.v2.VersionToPath> getItemsList() {
    return items_;
  }

  /**
   *
   *
   * <pre>
   * If unspecified, the volume will expose a file whose name is the
   * secret, relative to VolumeMount.mount_path.
   * If specified, the key will be used as the version to fetch from Cloud
   * Secret Manager and the path will be the name of the file exposed in the
   * volume. When items are defined, they must specify a path and a version.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.run.v2.VersionToPathOrBuilder>
      getItemsOrBuilderList() {
    return items_;
  }

  /**
   *
   *
   * <pre>
   * If unspecified, the volume will expose a file whose name is the
   * secret, relative to VolumeMount.mount_path.
   * If specified, the key will be used as the version to fetch from Cloud
   * Secret Manager and the path will be the name of the file exposed in the
   * volume. When items are defined, they must specify a path and a version.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
   */
  @java.lang.Override
  public int getItemsCount() {
    return items_.size();
  }

  /**
   *
   *
   * <pre>
   * If unspecified, the volume will expose a file whose name is the
   * secret, relative to VolumeMount.mount_path.
   * If specified, the key will be used as the version to fetch from Cloud
   * Secret Manager and the path will be the name of the file exposed in the
   * volume. When items are defined, they must specify a path and a version.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.VersionToPath getItems(int index) {
    return items_.get(index);
  }

  /**
   *
   *
   * <pre>
   * If unspecified, the volume will expose a file whose name is the
   * secret, relative to VolumeMount.mount_path.
   * If specified, the key will be used as the version to fetch from Cloud
   * Secret Manager and the path will be the name of the file exposed in the
   * volume. When items are defined, they must specify a path and a version.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.VersionToPathOrBuilder getItemsOrBuilder(int index) {
    return items_.get(index);
  }

  public static final int DEFAULT_MODE_FIELD_NUMBER = 3;
  private int defaultMode_ = 0;

  /**
   *
   *
   * <pre>
   * Integer representation of mode bits to use on created files by default.
   * Must be a value between 0000 and 0777 (octal), defaulting to 0444.
   * Directories within the path are not affected by  this setting.
   *
   * Notes
   *
   * * Internally, a umask of 0222 will be applied to any non-zero value.
   * * This is an integer representation of the mode bits. So, the octal
   * integer value should look exactly as the chmod numeric notation with a
   * leading zero. Some examples: for chmod 640 (u=rw,g=r), set to 0640 (octal)
   * or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or
   * 493 (base-10).
   * * This might be in conflict with other options that affect the
   * file mode, like fsGroup, and the result can be other mode bits set.
   *
   * This might be in conflict with other options that affect the
   * file mode, like fsGroup, and as a result, other mode bits could be set.
   * </pre>
   *
   * <code>int32 default_mode = 3;</code>
   *
   * @return The defaultMode.
   */
  @java.lang.Override
  public int getDefaultMode() {
    return defaultMode_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(secret_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, secret_);
    }
    for (int i = 0; i < items_.size(); i++) {
      output.writeMessage(2, items_.get(i));
    }
    if (defaultMode_ != 0) {
      output.writeInt32(3, defaultMode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(secret_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, secret_);
    }
    for (int i = 0; i < items_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, items_.get(i));
    }
    if (defaultMode_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, defaultMode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.SecretVolumeSource)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.SecretVolumeSource other =
        (com.google.cloud.run.v2.SecretVolumeSource) obj;

    if (!getSecret().equals(other.getSecret())) return false;
    if (!getItemsList().equals(other.getItemsList())) return false;
    if (getDefaultMode() != other.getDefaultMode()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SECRET_FIELD_NUMBER;
    hash = (53 * hash) + getSecret().hashCode();
    if (getItemsCount() > 0) {
      hash = (37 * hash) + ITEMS_FIELD_NUMBER;
      hash = (53 * hash) + getItemsList().hashCode();
    }
    hash = (37 * hash) + DEFAULT_MODE_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultMode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.SecretVolumeSource parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.SecretVolumeSource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.SecretVolumeSource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.SecretVolumeSource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.SecretVolumeSource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.SecretVolumeSource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.SecretVolumeSource parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.SecretVolumeSource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.SecretVolumeSource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.SecretVolumeSource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.SecretVolumeSource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.SecretVolumeSource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.SecretVolumeSource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The secret's value will be presented as the content of a file whose
   * name is defined in the item path. If no items are defined, the name of
   * the file is the secret.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.SecretVolumeSource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.SecretVolumeSource)
      com.google.cloud.run.v2.SecretVolumeSourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_SecretVolumeSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_SecretVolumeSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.SecretVolumeSource.class,
              com.google.cloud.run.v2.SecretVolumeSource.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.SecretVolumeSource.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      secret_ = "";
      if (itemsBuilder_ == null) {
        items_ = java.util.Collections.emptyList();
      } else {
        items_ = null;
        itemsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      defaultMode_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_SecretVolumeSource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.SecretVolumeSource getDefaultInstanceForType() {
      return com.google.cloud.run.v2.SecretVolumeSource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.SecretVolumeSource build() {
      com.google.cloud.run.v2.SecretVolumeSource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.SecretVolumeSource buildPartial() {
      com.google.cloud.run.v2.SecretVolumeSource result =
          new com.google.cloud.run.v2.SecretVolumeSource(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.run.v2.SecretVolumeSource result) {
      if (itemsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          items_ = java.util.Collections.unmodifiableList(items_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.items_ = items_;
      } else {
        result.items_ = itemsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.run.v2.SecretVolumeSource result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.secret_ = secret_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.defaultMode_ = defaultMode_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.SecretVolumeSource) {
        return mergeFrom((com.google.cloud.run.v2.SecretVolumeSource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.SecretVolumeSource other) {
      if (other == com.google.cloud.run.v2.SecretVolumeSource.getDefaultInstance()) return this;
      if (!other.getSecret().isEmpty()) {
        secret_ = other.secret_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (itemsBuilder_ == null) {
        if (!other.items_.isEmpty()) {
          if (items_.isEmpty()) {
            items_ = other.items_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureItemsIsMutable();
            items_.addAll(other.items_);
          }
          onChanged();
        }
      } else {
        if (!other.items_.isEmpty()) {
          if (itemsBuilder_.isEmpty()) {
            itemsBuilder_.dispose();
            itemsBuilder_ = null;
            items_ = other.items_;
            bitField0_ = (bitField0_ & ~0x00000002);
            itemsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getItemsFieldBuilder()
                    : null;
          } else {
            itemsBuilder_.addAllMessages(other.items_);
          }
        }
      }
      if (other.getDefaultMode() != 0) {
        setDefaultMode(other.getDefaultMode());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                secret_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.run.v2.VersionToPath m =
                    input.readMessage(
                        com.google.cloud.run.v2.VersionToPath.parser(), extensionRegistry);
                if (itemsBuilder_ == null) {
                  ensureItemsIsMutable();
                  items_.add(m);
                } else {
                  itemsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                defaultMode_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object secret_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the secret in Cloud Secret Manager.
     * Format: {secret} if the secret is in the same project.
     * projects/{project}/secrets/{secret} if the secret is
     * in a different project.
     * </pre>
     *
     * <code>string secret = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The secret.
     */
    public java.lang.String getSecret() {
      java.lang.Object ref = secret_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        secret_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the secret in Cloud Secret Manager.
     * Format: {secret} if the secret is in the same project.
     * projects/{project}/secrets/{secret} if the secret is
     * in a different project.
     * </pre>
     *
     * <code>string secret = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for secret.
     */
    public com.google.protobuf.ByteString getSecretBytes() {
      java.lang.Object ref = secret_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        secret_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the secret in Cloud Secret Manager.
     * Format: {secret} if the secret is in the same project.
     * projects/{project}/secrets/{secret} if the secret is
     * in a different project.
     * </pre>
     *
     * <code>string secret = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The secret to set.
     * @return This builder for chaining.
     */
    public Builder setSecret(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      secret_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the secret in Cloud Secret Manager.
     * Format: {secret} if the secret is in the same project.
     * projects/{project}/secrets/{secret} if the secret is
     * in a different project.
     * </pre>
     *
     * <code>string secret = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecret() {
      secret_ = getDefaultInstance().getSecret();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the secret in Cloud Secret Manager.
     * Format: {secret} if the secret is in the same project.
     * projects/{project}/secrets/{secret} if the secret is
     * in a different project.
     * </pre>
     *
     * <code>string secret = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for secret to set.
     * @return This builder for chaining.
     */
    public Builder setSecretBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      secret_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.run.v2.VersionToPath> items_ =
        java.util.Collections.emptyList();

    private void ensureItemsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        items_ = new java.util.ArrayList<com.google.cloud.run.v2.VersionToPath>(items_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.VersionToPath,
            com.google.cloud.run.v2.VersionToPath.Builder,
            com.google.cloud.run.v2.VersionToPathOrBuilder>
        itemsBuilder_;

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public java.util.List<com.google.cloud.run.v2.VersionToPath> getItemsList() {
      if (itemsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(items_);
      } else {
        return itemsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public int getItemsCount() {
      if (itemsBuilder_ == null) {
        return items_.size();
      } else {
        return itemsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public com.google.cloud.run.v2.VersionToPath getItems(int index) {
      if (itemsBuilder_ == null) {
        return items_.get(index);
      } else {
        return itemsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public Builder setItems(int index, com.google.cloud.run.v2.VersionToPath value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.set(index, value);
        onChanged();
      } else {
        itemsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public Builder setItems(
        int index, com.google.cloud.run.v2.VersionToPath.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.set(index, builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public Builder addItems(com.google.cloud.run.v2.VersionToPath value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.add(value);
        onChanged();
      } else {
        itemsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public Builder addItems(int index, com.google.cloud.run.v2.VersionToPath value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.add(index, value);
        onChanged();
      } else {
        itemsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public Builder addItems(com.google.cloud.run.v2.VersionToPath.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.add(builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public Builder addItems(
        int index, com.google.cloud.run.v2.VersionToPath.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.add(index, builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public Builder addAllItems(
        java.lang.Iterable<? extends com.google.cloud.run.v2.VersionToPath> values) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
        onChanged();
      } else {
        itemsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public Builder clearItems() {
      if (itemsBuilder_ == null) {
        items_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        itemsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public Builder removeItems(int index) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.remove(index);
        onChanged();
      } else {
        itemsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public com.google.cloud.run.v2.VersionToPath.Builder getItemsBuilder(int index) {
      return getItemsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public com.google.cloud.run.v2.VersionToPathOrBuilder getItemsOrBuilder(int index) {
      if (itemsBuilder_ == null) {
        return items_.get(index);
      } else {
        return itemsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.run.v2.VersionToPathOrBuilder>
        getItemsOrBuilderList() {
      if (itemsBuilder_ != null) {
        return itemsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(items_);
      }
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public com.google.cloud.run.v2.VersionToPath.Builder addItemsBuilder() {
      return getItemsFieldBuilder()
          .addBuilder(com.google.cloud.run.v2.VersionToPath.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public com.google.cloud.run.v2.VersionToPath.Builder addItemsBuilder(int index) {
      return getItemsFieldBuilder()
          .addBuilder(index, com.google.cloud.run.v2.VersionToPath.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * If unspecified, the volume will expose a file whose name is the
     * secret, relative to VolumeMount.mount_path.
     * If specified, the key will be used as the version to fetch from Cloud
     * Secret Manager and the path will be the name of the file exposed in the
     * volume. When items are defined, they must specify a path and a version.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VersionToPath items = 2;</code>
     */
    public java.util.List<com.google.cloud.run.v2.VersionToPath.Builder> getItemsBuilderList() {
      return getItemsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.VersionToPath,
            com.google.cloud.run.v2.VersionToPath.Builder,
            com.google.cloud.run.v2.VersionToPathOrBuilder>
        getItemsFieldBuilder() {
      if (itemsBuilder_ == null) {
        itemsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.VersionToPath,
                com.google.cloud.run.v2.VersionToPath.Builder,
                com.google.cloud.run.v2.VersionToPathOrBuilder>(
                items_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        items_ = null;
      }
      return itemsBuilder_;
    }

    private int defaultMode_;

    /**
     *
     *
     * <pre>
     * Integer representation of mode bits to use on created files by default.
     * Must be a value between 0000 and 0777 (octal), defaulting to 0444.
     * Directories within the path are not affected by  this setting.
     *
     * Notes
     *
     * * Internally, a umask of 0222 will be applied to any non-zero value.
     * * This is an integer representation of the mode bits. So, the octal
     * integer value should look exactly as the chmod numeric notation with a
     * leading zero. Some examples: for chmod 640 (u=rw,g=r), set to 0640 (octal)
     * or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or
     * 493 (base-10).
     * * This might be in conflict with other options that affect the
     * file mode, like fsGroup, and the result can be other mode bits set.
     *
     * This might be in conflict with other options that affect the
     * file mode, like fsGroup, and as a result, other mode bits could be set.
     * </pre>
     *
     * <code>int32 default_mode = 3;</code>
     *
     * @return The defaultMode.
     */
    @java.lang.Override
    public int getDefaultMode() {
      return defaultMode_;
    }

    /**
     *
     *
     * <pre>
     * Integer representation of mode bits to use on created files by default.
     * Must be a value between 0000 and 0777 (octal), defaulting to 0444.
     * Directories within the path are not affected by  this setting.
     *
     * Notes
     *
     * * Internally, a umask of 0222 will be applied to any non-zero value.
     * * This is an integer representation of the mode bits. So, the octal
     * integer value should look exactly as the chmod numeric notation with a
     * leading zero. Some examples: for chmod 640 (u=rw,g=r), set to 0640 (octal)
     * or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or
     * 493 (base-10).
     * * This might be in conflict with other options that affect the
     * file mode, like fsGroup, and the result can be other mode bits set.
     *
     * This might be in conflict with other options that affect the
     * file mode, like fsGroup, and as a result, other mode bits could be set.
     * </pre>
     *
     * <code>int32 default_mode = 3;</code>
     *
     * @param value The defaultMode to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultMode(int value) {

      defaultMode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Integer representation of mode bits to use on created files by default.
     * Must be a value between 0000 and 0777 (octal), defaulting to 0444.
     * Directories within the path are not affected by  this setting.
     *
     * Notes
     *
     * * Internally, a umask of 0222 will be applied to any non-zero value.
     * * This is an integer representation of the mode bits. So, the octal
     * integer value should look exactly as the chmod numeric notation with a
     * leading zero. Some examples: for chmod 640 (u=rw,g=r), set to 0640 (octal)
     * or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or
     * 493 (base-10).
     * * This might be in conflict with other options that affect the
     * file mode, like fsGroup, and the result can be other mode bits set.
     *
     * This might be in conflict with other options that affect the
     * file mode, like fsGroup, and as a result, other mode bits could be set.
     * </pre>
     *
     * <code>int32 default_mode = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultMode() {
      bitField0_ = (bitField0_ & ~0x00000004);
      defaultMode_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.SecretVolumeSource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.SecretVolumeSource)
  private static final com.google.cloud.run.v2.SecretVolumeSource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.SecretVolumeSource();
  }

  public static com.google.cloud.run.v2.SecretVolumeSource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SecretVolumeSource> PARSER =
      new com.google.protobuf.AbstractParser<SecretVolumeSource>() {
        @java.lang.Override
        public SecretVolumeSource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SecretVolumeSource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SecretVolumeSource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.SecretVolumeSource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
