/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/revision.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.run.v2;

public interface RevisionOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.run.v2.Revision)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. The unique name of this Revision.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Output only. The unique name of this Revision.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. Server assigned unique identifier for the Revision. The value
   * is a UUID4 string and guaranteed to remain unchanged until the resource is
   * deleted.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  java.lang.String getUid();

  /**
   *
   *
   * <pre>
   * Output only. Server assigned unique identifier for the Revision. The value
   * is a UUID4 string and guaranteed to remain unchanged until the resource is
   * deleted.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  com.google.protobuf.ByteString getUidBytes();

  /**
   *
   *
   * <pre>
   * Output only. A number that monotonically increases every time the user
   * modifies the desired state.
   * </pre>
   *
   * <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The generation.
   */
  long getGeneration();

  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  int getLabelsCount();

  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  boolean containsLabels(java.lang.String key);

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();

  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();

  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);

  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getAnnotationsCount();

  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  boolean containsAnnotations(java.lang.String key);

  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getAnnotations();

  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap();

  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  /* nullable */
  java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);

  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.lang.String getAnnotationsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the deletion time. It is only
   * populated as a response to a Delete request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  boolean hasDeleteTime();

  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the deletion time. It is only
   * populated as a response to a Delete request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  com.google.protobuf.Timestamp getDeleteTime();

  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the deletion time. It is only
   * populated as a response to a Delete request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted. It is only populated as a response to a Delete
   * request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  boolean hasExpireTime();

  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted. It is only populated as a response to a Delete
   * request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireTime.
   */
  com.google.protobuf.Timestamp getExpireTime();

  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted. It is only populated as a response to a Delete
   * request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * The least stable launch stage needed to create this resource, as defined by
   * [Google Cloud Platform Launch
   * Stages](https://cloud.google.com/terms/launch-stages). Cloud Run supports
   * `ALPHA`, `BETA`, and `GA`.
   *
   * Note that this value might not be what was used
   * as input. For example, if ALPHA was provided as input in the parent
   * resource, but only BETA and GA-level features are were, this field will be
   * BETA.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 10;</code>
   *
   * @return The enum numeric value on the wire for launchStage.
   */
  int getLaunchStageValue();

  /**
   *
   *
   * <pre>
   * The least stable launch stage needed to create this resource, as defined by
   * [Google Cloud Platform Launch
   * Stages](https://cloud.google.com/terms/launch-stages). Cloud Run supports
   * `ALPHA`, `BETA`, and `GA`.
   *
   * Note that this value might not be what was used
   * as input. For example, if ALPHA was provided as input in the parent
   * resource, but only BETA and GA-level features are were, this field will be
   * BETA.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 10;</code>
   *
   * @return The launchStage.
   */
  com.google.api.LaunchStage getLaunchStage();

  /**
   *
   *
   * <pre>
   * Output only. The name of the parent service.
   * </pre>
   *
   * <code>
   * string service = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The service.
   */
  java.lang.String getService();

  /**
   *
   *
   * <pre>
   * Output only. The name of the parent service.
   * </pre>
   *
   * <code>
   * string service = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for service.
   */
  com.google.protobuf.ByteString getServiceBytes();

  /**
   *
   *
   * <pre>
   * Scaling settings for this revision.
   * </pre>
   *
   * <code>.google.cloud.run.v2.RevisionScaling scaling = 12;</code>
   *
   * @return Whether the scaling field is set.
   */
  boolean hasScaling();

  /**
   *
   *
   * <pre>
   * Scaling settings for this revision.
   * </pre>
   *
   * <code>.google.cloud.run.v2.RevisionScaling scaling = 12;</code>
   *
   * @return The scaling.
   */
  com.google.cloud.run.v2.RevisionScaling getScaling();

  /**
   *
   *
   * <pre>
   * Scaling settings for this revision.
   * </pre>
   *
   * <code>.google.cloud.run.v2.RevisionScaling scaling = 12;</code>
   */
  com.google.cloud.run.v2.RevisionScalingOrBuilder getScalingOrBuilder();

  /**
   *
   *
   * <pre>
   * VPC Access configuration for this Revision. For more information, visit
   * https://cloud.google.com/run/docs/configuring/connecting-vpc.
   * </pre>
   *
   * <code>.google.cloud.run.v2.VpcAccess vpc_access = 13;</code>
   *
   * @return Whether the vpcAccess field is set.
   */
  boolean hasVpcAccess();

  /**
   *
   *
   * <pre>
   * VPC Access configuration for this Revision. For more information, visit
   * https://cloud.google.com/run/docs/configuring/connecting-vpc.
   * </pre>
   *
   * <code>.google.cloud.run.v2.VpcAccess vpc_access = 13;</code>
   *
   * @return The vpcAccess.
   */
  com.google.cloud.run.v2.VpcAccess getVpcAccess();

  /**
   *
   *
   * <pre>
   * VPC Access configuration for this Revision. For more information, visit
   * https://cloud.google.com/run/docs/configuring/connecting-vpc.
   * </pre>
   *
   * <code>.google.cloud.run.v2.VpcAccess vpc_access = 13;</code>
   */
  com.google.cloud.run.v2.VpcAccessOrBuilder getVpcAccessOrBuilder();

  /**
   *
   *
   * <pre>
   * Sets the maximum number of requests that each serving instance can receive.
   * </pre>
   *
   * <code>int32 max_instance_request_concurrency = 34;</code>
   *
   * @return The maxInstanceRequestConcurrency.
   */
  int getMaxInstanceRequestConcurrency();

  /**
   *
   *
   * <pre>
   * Max allowed time for an instance to respond to a request.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 15;</code>
   *
   * @return Whether the timeout field is set.
   */
  boolean hasTimeout();

  /**
   *
   *
   * <pre>
   * Max allowed time for an instance to respond to a request.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 15;</code>
   *
   * @return The timeout.
   */
  com.google.protobuf.Duration getTimeout();

  /**
   *
   *
   * <pre>
   * Max allowed time for an instance to respond to a request.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 15;</code>
   */
  com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder();

  /**
   *
   *
   * <pre>
   * Email address of the IAM service account associated with the revision of
   * the service. The service account represents the identity of the running
   * revision, and determines what permissions the revision has.
   * </pre>
   *
   * <code>string service_account = 16;</code>
   *
   * @return The serviceAccount.
   */
  java.lang.String getServiceAccount();

  /**
   *
   *
   * <pre>
   * Email address of the IAM service account associated with the revision of
   * the service. The service account represents the identity of the running
   * revision, and determines what permissions the revision has.
   * </pre>
   *
   * <code>string service_account = 16;</code>
   *
   * @return The bytes for serviceAccount.
   */
  com.google.protobuf.ByteString getServiceAccountBytes();

  /**
   *
   *
   * <pre>
   * Holds the single container that defines the unit of execution for this
   * Revision.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 17;</code>
   */
  java.util.List<com.google.cloud.run.v2.Container> getContainersList();

  /**
   *
   *
   * <pre>
   * Holds the single container that defines the unit of execution for this
   * Revision.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 17;</code>
   */
  com.google.cloud.run.v2.Container getContainers(int index);

  /**
   *
   *
   * <pre>
   * Holds the single container that defines the unit of execution for this
   * Revision.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 17;</code>
   */
  int getContainersCount();

  /**
   *
   *
   * <pre>
   * Holds the single container that defines the unit of execution for this
   * Revision.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 17;</code>
   */
  java.util.List<? extends com.google.cloud.run.v2.ContainerOrBuilder> getContainersOrBuilderList();

  /**
   *
   *
   * <pre>
   * Holds the single container that defines the unit of execution for this
   * Revision.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 17;</code>
   */
  com.google.cloud.run.v2.ContainerOrBuilder getContainersOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Volume volumes = 18;</code>
   */
  java.util.List<com.google.cloud.run.v2.Volume> getVolumesList();

  /**
   *
   *
   * <pre>
   * A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Volume volumes = 18;</code>
   */
  com.google.cloud.run.v2.Volume getVolumes(int index);

  /**
   *
   *
   * <pre>
   * A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Volume volumes = 18;</code>
   */
  int getVolumesCount();

  /**
   *
   *
   * <pre>
   * A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Volume volumes = 18;</code>
   */
  java.util.List<? extends com.google.cloud.run.v2.VolumeOrBuilder> getVolumesOrBuilderList();

  /**
   *
   *
   * <pre>
   * A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Volume volumes = 18;</code>
   */
  com.google.cloud.run.v2.VolumeOrBuilder getVolumesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * The execution environment being used to host this Revision.
   * </pre>
   *
   * <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 20;</code>
   *
   * @return The enum numeric value on the wire for executionEnvironment.
   */
  int getExecutionEnvironmentValue();

  /**
   *
   *
   * <pre>
   * The execution environment being used to host this Revision.
   * </pre>
   *
   * <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 20;</code>
   *
   * @return The executionEnvironment.
   */
  com.google.cloud.run.v2.ExecutionEnvironment getExecutionEnvironment();

  /**
   *
   *
   * <pre>
   * A reference to a customer managed encryption key (CMEK) to use to encrypt
   * this container image. For more information, go to
   * https://cloud.google.com/run/docs/securing/using-cmek
   * </pre>
   *
   * <code>string encryption_key = 21 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The encryptionKey.
   */
  java.lang.String getEncryptionKey();

  /**
   *
   *
   * <pre>
   * A reference to a customer managed encryption key (CMEK) to use to encrypt
   * this container image. For more information, go to
   * https://cloud.google.com/run/docs/securing/using-cmek
   * </pre>
   *
   * <code>string encryption_key = 21 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for encryptionKey.
   */
  com.google.protobuf.ByteString getEncryptionKeyBytes();

  /**
   *
   *
   * <pre>
   * Enables service mesh connectivity.
   * </pre>
   *
   * <code>.google.cloud.run.v2.ServiceMesh service_mesh = 22;</code>
   *
   * @return Whether the serviceMesh field is set.
   */
  boolean hasServiceMesh();

  /**
   *
   *
   * <pre>
   * Enables service mesh connectivity.
   * </pre>
   *
   * <code>.google.cloud.run.v2.ServiceMesh service_mesh = 22;</code>
   *
   * @return The serviceMesh.
   */
  com.google.cloud.run.v2.ServiceMesh getServiceMesh();

  /**
   *
   *
   * <pre>
   * Enables service mesh connectivity.
   * </pre>
   *
   * <code>.google.cloud.run.v2.ServiceMesh service_mesh = 22;</code>
   */
  com.google.cloud.run.v2.ServiceMeshOrBuilder getServiceMeshOrBuilder();

  /**
   *
   *
   * <pre>
   * The action to take if the encryption key is revoked.
   * </pre>
   *
   * <code>.google.cloud.run.v2.EncryptionKeyRevocationAction encryption_key_revocation_action = 23;
   * </code>
   *
   * @return The enum numeric value on the wire for encryptionKeyRevocationAction.
   */
  int getEncryptionKeyRevocationActionValue();

  /**
   *
   *
   * <pre>
   * The action to take if the encryption key is revoked.
   * </pre>
   *
   * <code>.google.cloud.run.v2.EncryptionKeyRevocationAction encryption_key_revocation_action = 23;
   * </code>
   *
   * @return The encryptionKeyRevocationAction.
   */
  com.google.cloud.run.v2.EncryptionKeyRevocationAction getEncryptionKeyRevocationAction();

  /**
   *
   *
   * <pre>
   * If encryption_key_revocation_action is SHUTDOWN, the duration before
   * shutting down all instances. The minimum increment is 1 hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration encryption_key_shutdown_duration = 24;</code>
   *
   * @return Whether the encryptionKeyShutdownDuration field is set.
   */
  boolean hasEncryptionKeyShutdownDuration();

  /**
   *
   *
   * <pre>
   * If encryption_key_revocation_action is SHUTDOWN, the duration before
   * shutting down all instances. The minimum increment is 1 hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration encryption_key_shutdown_duration = 24;</code>
   *
   * @return The encryptionKeyShutdownDuration.
   */
  com.google.protobuf.Duration getEncryptionKeyShutdownDuration();

  /**
   *
   *
   * <pre>
   * If encryption_key_revocation_action is SHUTDOWN, the duration before
   * shutting down all instances. The minimum increment is 1 hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration encryption_key_shutdown_duration = 24;</code>
   */
  com.google.protobuf.DurationOrBuilder getEncryptionKeyShutdownDurationOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Indicates whether the resource's reconciliation is still in
   * progress. See comments in `Service.reconciling` for additional information
   * on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>bool reconciling = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reconciling.
   */
  boolean getReconciling();

  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Revision, containing its readiness
   * status, and detailed error information in case it did not reach a serving
   * state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.run.v2.Condition> getConditionsList();

  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Revision, containing its readiness
   * status, and detailed error information in case it did not reach a serving
   * state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.run.v2.Condition getConditions(int index);

  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Revision, containing its readiness
   * status, and detailed error information in case it did not reach a serving
   * state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getConditionsCount();

  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Revision, containing its readiness
   * status, and detailed error information in case it did not reach a serving
   * state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.run.v2.ConditionOrBuilder> getConditionsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Revision, containing its readiness
   * status, and detailed error information in case it did not reach a serving
   * state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.run.v2.ConditionOrBuilder getConditionsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. The generation of this Revision currently serving traffic. See
   * comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run.
   * </pre>
   *
   * <code>int64 observed_generation = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The observedGeneration.
   */
  long getObservedGeneration();

  /**
   *
   *
   * <pre>
   * Output only. The Google Console URI to obtain logs for the Revision.
   * </pre>
   *
   * <code>string log_uri = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The logUri.
   */
  java.lang.String getLogUri();

  /**
   *
   *
   * <pre>
   * Output only. The Google Console URI to obtain logs for the Revision.
   * </pre>
   *
   * <code>string log_uri = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for logUri.
   */
  com.google.protobuf.ByteString getLogUriBytes();

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 37 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  boolean getSatisfiesPzs();

  /**
   *
   *
   * <pre>
   * Enable session affinity.
   * </pre>
   *
   * <code>bool session_affinity = 38;</code>
   *
   * @return The sessionAffinity.
   */
  boolean getSessionAffinity();

  /**
   *
   *
   * <pre>
   * Output only. The current effective scaling settings for the revision.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.RevisionScalingStatus scaling_status = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the scalingStatus field is set.
   */
  boolean hasScalingStatus();

  /**
   *
   *
   * <pre>
   * Output only. The current effective scaling settings for the revision.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.RevisionScalingStatus scaling_status = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The scalingStatus.
   */
  com.google.cloud.run.v2.RevisionScalingStatus getScalingStatus();

  /**
   *
   *
   * <pre>
   * Output only. The current effective scaling settings for the revision.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.RevisionScalingStatus scaling_status = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.run.v2.RevisionScalingStatusOrBuilder getScalingStatusOrBuilder();

  /**
   *
   *
   * <pre>
   * The node selector for the revision.
   * </pre>
   *
   * <code>.google.cloud.run.v2.NodeSelector node_selector = 40;</code>
   *
   * @return Whether the nodeSelector field is set.
   */
  boolean hasNodeSelector();

  /**
   *
   *
   * <pre>
   * The node selector for the revision.
   * </pre>
   *
   * <code>.google.cloud.run.v2.NodeSelector node_selector = 40;</code>
   *
   * @return The nodeSelector.
   */
  com.google.cloud.run.v2.NodeSelector getNodeSelector();

  /**
   *
   *
   * <pre>
   * The node selector for the revision.
   * </pre>
   *
   * <code>.google.cloud.run.v2.NodeSelector node_selector = 40;</code>
   */
  com.google.cloud.run.v2.NodeSelectorOrBuilder getNodeSelectorOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Output only. True if GPU zonal redundancy is disabled on this
   * revision.
   * </pre>
   *
   * <code>
   * optional bool gpu_zonal_redundancy_disabled = 48 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the gpuZonalRedundancyDisabled field is set.
   */
  boolean hasGpuZonalRedundancyDisabled();

  /**
   *
   *
   * <pre>
   * Optional. Output only. True if GPU zonal redundancy is disabled on this
   * revision.
   * </pre>
   *
   * <code>
   * optional bool gpu_zonal_redundancy_disabled = 48 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The gpuZonalRedundancyDisabled.
   */
  boolean getGpuZonalRedundancyDisabled();

  /**
   *
   *
   * <pre>
   * Output only. Email address of the authenticated creator.
   * </pre>
   *
   * <code>string creator = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The creator.
   */
  java.lang.String getCreator();

  /**
   *
   *
   * <pre>
   * Output only. Email address of the authenticated creator.
   * </pre>
   *
   * <code>string creator = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for creator.
   */
  com.google.protobuf.ByteString getCreatorBytes();

  /**
   *
   *
   * <pre>
   * Output only. A system-generated fingerprint for this version of the
   * resource. May be used to detect modification conflict during updates.
   * </pre>
   *
   * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();

  /**
   *
   *
   * <pre>
   * Output only. A system-generated fingerprint for this version of the
   * resource. May be used to detect modification conflict during updates.
   * </pre>
   *
   * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();
}
