/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/k8s.min.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * Represents a volume backed by a Cloud Storage bucket using Cloud Storage
 * FUSE.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.GCSVolumeSource}
 */
public final class GCSVolumeSource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.GCSVolumeSource)
    GCSVolumeSourceOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use GCSVolumeSource.newBuilder() to construct.
  private GCSVolumeSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GCSVolumeSource() {
    bucket_ = "";
    mountOptions_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GCSVolumeSource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.K8sMinProto
        .internal_static_google_cloud_run_v2_GCSVolumeSource_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.K8sMinProto
        .internal_static_google_cloud_run_v2_GCSVolumeSource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.GCSVolumeSource.class,
            com.google.cloud.run.v2.GCSVolumeSource.Builder.class);
  }

  public static final int BUCKET_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bucket_ = "";

  /**
   *
   *
   * <pre>
   * Cloud Storage Bucket name.
   * </pre>
   *
   * <code>string bucket = 1;</code>
   *
   * @return The bucket.
   */
  @java.lang.Override
  public java.lang.String getBucket() {
    java.lang.Object ref = bucket_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bucket_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Cloud Storage Bucket name.
   * </pre>
   *
   * <code>string bucket = 1;</code>
   *
   * @return The bytes for bucket.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBucketBytes() {
    java.lang.Object ref = bucket_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bucket_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int READ_ONLY_FIELD_NUMBER = 2;
  private boolean readOnly_ = false;

  /**
   *
   *
   * <pre>
   * If true, the volume will be mounted as read only for all mounts.
   * </pre>
   *
   * <code>bool read_only = 2;</code>
   *
   * @return The readOnly.
   */
  @java.lang.Override
  public boolean getReadOnly() {
    return readOnly_;
  }

  public static final int MOUNT_OPTIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList mountOptions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * A list of additional flags to pass to the gcsfuse CLI.
   * Options should be specified without the leading "--".
   * </pre>
   *
   * <code>repeated string mount_options = 3;</code>
   *
   * @return A list containing the mountOptions.
   */
  public com.google.protobuf.ProtocolStringList getMountOptionsList() {
    return mountOptions_;
  }

  /**
   *
   *
   * <pre>
   * A list of additional flags to pass to the gcsfuse CLI.
   * Options should be specified without the leading "--".
   * </pre>
   *
   * <code>repeated string mount_options = 3;</code>
   *
   * @return The count of mountOptions.
   */
  public int getMountOptionsCount() {
    return mountOptions_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of additional flags to pass to the gcsfuse CLI.
   * Options should be specified without the leading "--".
   * </pre>
   *
   * <code>repeated string mount_options = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The mountOptions at the given index.
   */
  public java.lang.String getMountOptions(int index) {
    return mountOptions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of additional flags to pass to the gcsfuse CLI.
   * Options should be specified without the leading "--".
   * </pre>
   *
   * <code>repeated string mount_options = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the mountOptions at the given index.
   */
  public com.google.protobuf.ByteString getMountOptionsBytes(int index) {
    return mountOptions_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, bucket_);
    }
    if (readOnly_ != false) {
      output.writeBool(2, readOnly_);
    }
    for (int i = 0; i < mountOptions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, mountOptions_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, bucket_);
    }
    if (readOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, readOnly_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < mountOptions_.size(); i++) {
        dataSize += computeStringSizeNoTag(mountOptions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getMountOptionsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.GCSVolumeSource)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.GCSVolumeSource other = (com.google.cloud.run.v2.GCSVolumeSource) obj;

    if (!getBucket().equals(other.getBucket())) return false;
    if (getReadOnly() != other.getReadOnly()) return false;
    if (!getMountOptionsList().equals(other.getMountOptionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + BUCKET_FIELD_NUMBER;
    hash = (53 * hash) + getBucket().hashCode();
    hash = (37 * hash) + READ_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReadOnly());
    if (getMountOptionsCount() > 0) {
      hash = (37 * hash) + MOUNT_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getMountOptionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.GCSVolumeSource parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.GCSVolumeSource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.GCSVolumeSource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.GCSVolumeSource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.GCSVolumeSource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.GCSVolumeSource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.GCSVolumeSource parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.GCSVolumeSource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.GCSVolumeSource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.GCSVolumeSource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.GCSVolumeSource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.GCSVolumeSource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.GCSVolumeSource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a volume backed by a Cloud Storage bucket using Cloud Storage
   * FUSE.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.GCSVolumeSource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.GCSVolumeSource)
      com.google.cloud.run.v2.GCSVolumeSourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_GCSVolumeSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_GCSVolumeSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.GCSVolumeSource.class,
              com.google.cloud.run.v2.GCSVolumeSource.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.GCSVolumeSource.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bucket_ = "";
      readOnly_ = false;
      mountOptions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_GCSVolumeSource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.GCSVolumeSource getDefaultInstanceForType() {
      return com.google.cloud.run.v2.GCSVolumeSource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.GCSVolumeSource build() {
      com.google.cloud.run.v2.GCSVolumeSource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.GCSVolumeSource buildPartial() {
      com.google.cloud.run.v2.GCSVolumeSource result =
          new com.google.cloud.run.v2.GCSVolumeSource(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.run.v2.GCSVolumeSource result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.bucket_ = bucket_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.readOnly_ = readOnly_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        mountOptions_.makeImmutable();
        result.mountOptions_ = mountOptions_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.GCSVolumeSource) {
        return mergeFrom((com.google.cloud.run.v2.GCSVolumeSource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.GCSVolumeSource other) {
      if (other == com.google.cloud.run.v2.GCSVolumeSource.getDefaultInstance()) return this;
      if (!other.getBucket().isEmpty()) {
        bucket_ = other.bucket_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getReadOnly() != false) {
        setReadOnly(other.getReadOnly());
      }
      if (!other.mountOptions_.isEmpty()) {
        if (mountOptions_.isEmpty()) {
          mountOptions_ = other.mountOptions_;
          bitField0_ |= 0x00000004;
        } else {
          ensureMountOptionsIsMutable();
          mountOptions_.addAll(other.mountOptions_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                bucket_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                readOnly_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureMountOptionsIsMutable();
                mountOptions_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object bucket_ = "";

    /**
     *
     *
     * <pre>
     * Cloud Storage Bucket name.
     * </pre>
     *
     * <code>string bucket = 1;</code>
     *
     * @return The bucket.
     */
    public java.lang.String getBucket() {
      java.lang.Object ref = bucket_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucket_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage Bucket name.
     * </pre>
     *
     * <code>string bucket = 1;</code>
     *
     * @return The bytes for bucket.
     */
    public com.google.protobuf.ByteString getBucketBytes() {
      java.lang.Object ref = bucket_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage Bucket name.
     * </pre>
     *
     * <code>string bucket = 1;</code>
     *
     * @param value The bucket to set.
     * @return This builder for chaining.
     */
    public Builder setBucket(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bucket_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage Bucket name.
     * </pre>
     *
     * <code>string bucket = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBucket() {
      bucket_ = getDefaultInstance().getBucket();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage Bucket name.
     * </pre>
     *
     * <code>string bucket = 1;</code>
     *
     * @param value The bytes for bucket to set.
     * @return This builder for chaining.
     */
    public Builder setBucketBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bucket_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean readOnly_;

    /**
     *
     *
     * <pre>
     * If true, the volume will be mounted as read only for all mounts.
     * </pre>
     *
     * <code>bool read_only = 2;</code>
     *
     * @return The readOnly.
     */
    @java.lang.Override
    public boolean getReadOnly() {
      return readOnly_;
    }

    /**
     *
     *
     * <pre>
     * If true, the volume will be mounted as read only for all mounts.
     * </pre>
     *
     * <code>bool read_only = 2;</code>
     *
     * @param value The readOnly to set.
     * @return This builder for chaining.
     */
    public Builder setReadOnly(boolean value) {

      readOnly_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If true, the volume will be mounted as read only for all mounts.
     * </pre>
     *
     * <code>bool read_only = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReadOnly() {
      bitField0_ = (bitField0_ & ~0x00000002);
      readOnly_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList mountOptions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureMountOptionsIsMutable() {
      if (!mountOptions_.isModifiable()) {
        mountOptions_ = new com.google.protobuf.LazyStringArrayList(mountOptions_);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * A list of additional flags to pass to the gcsfuse CLI.
     * Options should be specified without the leading "--".
     * </pre>
     *
     * <code>repeated string mount_options = 3;</code>
     *
     * @return A list containing the mountOptions.
     */
    public com.google.protobuf.ProtocolStringList getMountOptionsList() {
      mountOptions_.makeImmutable();
      return mountOptions_;
    }

    /**
     *
     *
     * <pre>
     * A list of additional flags to pass to the gcsfuse CLI.
     * Options should be specified without the leading "--".
     * </pre>
     *
     * <code>repeated string mount_options = 3;</code>
     *
     * @return The count of mountOptions.
     */
    public int getMountOptionsCount() {
      return mountOptions_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of additional flags to pass to the gcsfuse CLI.
     * Options should be specified without the leading "--".
     * </pre>
     *
     * <code>repeated string mount_options = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The mountOptions at the given index.
     */
    public java.lang.String getMountOptions(int index) {
      return mountOptions_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of additional flags to pass to the gcsfuse CLI.
     * Options should be specified without the leading "--".
     * </pre>
     *
     * <code>repeated string mount_options = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the mountOptions at the given index.
     */
    public com.google.protobuf.ByteString getMountOptionsBytes(int index) {
      return mountOptions_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * A list of additional flags to pass to the gcsfuse CLI.
     * Options should be specified without the leading "--".
     * </pre>
     *
     * <code>repeated string mount_options = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The mountOptions to set.
     * @return This builder for chaining.
     */
    public Builder setMountOptions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMountOptionsIsMutable();
      mountOptions_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of additional flags to pass to the gcsfuse CLI.
     * Options should be specified without the leading "--".
     * </pre>
     *
     * <code>repeated string mount_options = 3;</code>
     *
     * @param value The mountOptions to add.
     * @return This builder for chaining.
     */
    public Builder addMountOptions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMountOptionsIsMutable();
      mountOptions_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of additional flags to pass to the gcsfuse CLI.
     * Options should be specified without the leading "--".
     * </pre>
     *
     * <code>repeated string mount_options = 3;</code>
     *
     * @param values The mountOptions to add.
     * @return This builder for chaining.
     */
    public Builder addAllMountOptions(java.lang.Iterable<java.lang.String> values) {
      ensureMountOptionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mountOptions_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of additional flags to pass to the gcsfuse CLI.
     * Options should be specified without the leading "--".
     * </pre>
     *
     * <code>repeated string mount_options = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMountOptions() {
      mountOptions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of additional flags to pass to the gcsfuse CLI.
     * Options should be specified without the leading "--".
     * </pre>
     *
     * <code>repeated string mount_options = 3;</code>
     *
     * @param value The bytes of the mountOptions to add.
     * @return This builder for chaining.
     */
    public Builder addMountOptionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureMountOptionsIsMutable();
      mountOptions_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.GCSVolumeSource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.GCSVolumeSource)
  private static final com.google.cloud.run.v2.GCSVolumeSource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.GCSVolumeSource();
  }

  public static com.google.cloud.run.v2.GCSVolumeSource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GCSVolumeSource> PARSER =
      new com.google.protobuf.AbstractParser<GCSVolumeSource>() {
        @java.lang.Override
        public GCSVolumeSource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GCSVolumeSource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GCSVolumeSource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.GCSVolumeSource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
