/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/vendor_settings.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.run.v2;

public interface BuildConfigOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.run.v2.BuildConfig)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. The Cloud Build name of the latest successful deployment of
   * the function.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Output only. The Cloud Build name of the latest successful deployment of
   * the function.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The Cloud Storage bucket URI where the function source code is located.
   * </pre>
   *
   * <code>string source_location = 2;</code>
   *
   * @return The sourceLocation.
   */
  java.lang.String getSourceLocation();

  /**
   *
   *
   * <pre>
   * The Cloud Storage bucket URI where the function source code is located.
   * </pre>
   *
   * <code>string source_location = 2;</code>
   *
   * @return The bytes for sourceLocation.
   */
  com.google.protobuf.ByteString getSourceLocationBytes();

  /**
   *
   *
   * <pre>
   * Optional. The name of the function (as defined in source code) that will be
   * executed. Defaults to the resource name suffix, if not specified. For
   * backward compatibility, if function with given name is not found, then the
   * system will try to use function named "function".
   * </pre>
   *
   * <code>string function_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The functionTarget.
   */
  java.lang.String getFunctionTarget();

  /**
   *
   *
   * <pre>
   * Optional. The name of the function (as defined in source code) that will be
   * executed. Defaults to the resource name suffix, if not specified. For
   * backward compatibility, if function with given name is not found, then the
   * system will try to use function named "function".
   * </pre>
   *
   * <code>string function_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for functionTarget.
   */
  com.google.protobuf.ByteString getFunctionTargetBytes();

  /**
   *
   *
   * <pre>
   * Optional. Artifact Registry URI to store the built image.
   * </pre>
   *
   * <code>string image_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The imageUri.
   */
  java.lang.String getImageUri();

  /**
   *
   *
   * <pre>
   * Optional. Artifact Registry URI to store the built image.
   * </pre>
   *
   * <code>string image_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for imageUri.
   */
  com.google.protobuf.ByteString getImageUriBytes();

  /**
   *
   *
   * <pre>
   * Optional. The base image used to build the function.
   * </pre>
   *
   * <code>string base_image = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The baseImage.
   */
  java.lang.String getBaseImage();

  /**
   *
   *
   * <pre>
   * Optional. The base image used to build the function.
   * </pre>
   *
   * <code>string base_image = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for baseImage.
   */
  com.google.protobuf.ByteString getBaseImageBytes();

  /**
   *
   *
   * <pre>
   * Optional. Sets whether the function will receive automatic base image
   * updates.
   * </pre>
   *
   * <code>bool enable_automatic_updates = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableAutomaticUpdates.
   */
  boolean getEnableAutomaticUpdates();

  /**
   *
   *
   * <pre>
   * Optional. Name of the Cloud Build Custom Worker Pool that should be used to
   * build the Cloud Run function. The format of this field is
   * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
   * `{project}` and `{region}` are the project id and region respectively where
   * the worker pool is defined and `{workerPool}` is the short name of the
   * worker pool.
   * </pre>
   *
   * <code>
   * string worker_pool = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The workerPool.
   */
  java.lang.String getWorkerPool();

  /**
   *
   *
   * <pre>
   * Optional. Name of the Cloud Build Custom Worker Pool that should be used to
   * build the Cloud Run function. The format of this field is
   * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
   * `{project}` and `{region}` are the project id and region respectively where
   * the worker pool is defined and `{workerPool}` is the short name of the
   * worker pool.
   * </pre>
   *
   * <code>
   * string worker_pool = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for workerPool.
   */
  com.google.protobuf.ByteString getWorkerPoolBytes();

  /**
   *
   *
   * <pre>
   * Optional. User-provided build-time environment variables for the function
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getEnvironmentVariablesCount();

  /**
   *
   *
   * <pre>
   * Optional. User-provided build-time environment variables for the function
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  boolean containsEnvironmentVariables(java.lang.String key);

  /** Use {@link #getEnvironmentVariablesMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables();

  /**
   *
   *
   * <pre>
   * Optional. User-provided build-time environment variables for the function
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariablesMap();

  /**
   *
   *
   * <pre>
   * Optional. User-provided build-time environment variables for the function
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  /* nullable */
  java.lang.String getEnvironmentVariablesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);

  /**
   *
   *
   * <pre>
   * Optional. User-provided build-time environment variables for the function
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.lang.String getEnvironmentVariablesOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. Service account to be used for building the container. The format
   * of this field is
   * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
   * </pre>
   *
   * <code>string service_account = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The serviceAccount.
   */
  java.lang.String getServiceAccount();

  /**
   *
   *
   * <pre>
   * Optional. Service account to be used for building the container. The format
   * of this field is
   * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
   * </pre>
   *
   * <code>string service_account = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for serviceAccount.
   */
  com.google.protobuf.ByteString getServiceAccountBytes();
}
