/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AttributesConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CATALOG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/catalogs/{catalog}/attributesConfig");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String catalog;

    @Deprecated
    protected AttributesConfigName() {
        this.project = null;
        this.location = null;
        this.catalog = null;
    }

    private AttributesConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.catalog = (String)Preconditions.checkNotNull((Object)builder.getCatalog());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AttributesConfigName of(String project, String location, String catalog) {
        return AttributesConfigName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).build();
    }

    public static String format(String project, String location, String catalog) {
        return AttributesConfigName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).build().toString();
    }

    public static AttributesConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CATALOG.validatedMatch(formattedString, "AttributesConfigName.parse: formattedString not in valid format");
        return AttributesConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("catalog"));
    }

    public static List<AttributesConfigName> parseList(List<String> formattedStrings) {
        ArrayList<AttributesConfigName> list = new ArrayList<AttributesConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AttributesConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AttributesConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AttributesConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CATALOG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AttributesConfigName attributesConfigName = this;
            synchronized (attributesConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.catalog != null) {
                        fieldMapBuilder.put((Object)"catalog", (Object)this.catalog);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CATALOG.instantiate(new String[]{"project", this.project, "location", this.location, "catalog", this.catalog});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AttributesConfigName that = (AttributesConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.catalog, that.catalog);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.catalog);
    }

    public static class Builder {
        private String project;
        private String location;
        private String catalog;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        private Builder(AttributesConfigName attributesConfigName) {
            this.project = attributesConfigName.project;
            this.location = attributesConfigName.location;
            this.catalog = attributesConfigName.catalog;
        }

        public AttributesConfigName build() {
            return new AttributesConfigName(this);
        }
    }
}

