/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MerchantCenterAccountLinkName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CATALOG_MERCHANT_CENTER_ACCOUNT_LINK = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/catalogs/{catalog}/merchantCenterAccountLinks/{merchant_center_account_link}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String catalog;
    private final String merchantCenterAccountLink;

    @Deprecated
    protected MerchantCenterAccountLinkName() {
        this.project = null;
        this.location = null;
        this.catalog = null;
        this.merchantCenterAccountLink = null;
    }

    private MerchantCenterAccountLinkName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.catalog = (String)Preconditions.checkNotNull((Object)builder.getCatalog());
        this.merchantCenterAccountLink = (String)Preconditions.checkNotNull((Object)builder.getMerchantCenterAccountLink());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getMerchantCenterAccountLink() {
        return this.merchantCenterAccountLink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MerchantCenterAccountLinkName of(String project, String location, String catalog, String merchantCenterAccountLink) {
        return MerchantCenterAccountLinkName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setMerchantCenterAccountLink(merchantCenterAccountLink).build();
    }

    public static String format(String project, String location, String catalog, String merchantCenterAccountLink) {
        return MerchantCenterAccountLinkName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setMerchantCenterAccountLink(merchantCenterAccountLink).build().toString();
    }

    public static MerchantCenterAccountLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CATALOG_MERCHANT_CENTER_ACCOUNT_LINK.validatedMatch(formattedString, "MerchantCenterAccountLinkName.parse: formattedString not in valid format");
        return MerchantCenterAccountLinkName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("catalog"), (String)matchMap.get("merchant_center_account_link"));
    }

    public static List<MerchantCenterAccountLinkName> parseList(List<String> formattedStrings) {
        ArrayList<MerchantCenterAccountLinkName> list = new ArrayList<MerchantCenterAccountLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MerchantCenterAccountLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MerchantCenterAccountLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MerchantCenterAccountLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CATALOG_MERCHANT_CENTER_ACCOUNT_LINK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MerchantCenterAccountLinkName merchantCenterAccountLinkName = this;
            synchronized (merchantCenterAccountLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.catalog != null) {
                        fieldMapBuilder.put((Object)"catalog", (Object)this.catalog);
                    }
                    if (this.merchantCenterAccountLink != null) {
                        fieldMapBuilder.put((Object)"merchant_center_account_link", (Object)this.merchantCenterAccountLink);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CATALOG_MERCHANT_CENTER_ACCOUNT_LINK.instantiate(new String[]{"project", this.project, "location", this.location, "catalog", this.catalog, "merchant_center_account_link", this.merchantCenterAccountLink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            MerchantCenterAccountLinkName that = (MerchantCenterAccountLinkName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.merchantCenterAccountLink, that.merchantCenterAccountLink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.catalog);
        h *= 1000003;
        return h ^= Objects.hashCode(this.merchantCenterAccountLink);
    }

    public static class Builder {
        private String project;
        private String location;
        private String catalog;
        private String merchantCenterAccountLink;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getMerchantCenterAccountLink() {
            return this.merchantCenterAccountLink;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder setMerchantCenterAccountLink(String merchantCenterAccountLink) {
            this.merchantCenterAccountLink = merchantCenterAccountLink;
            return this;
        }

        private Builder(MerchantCenterAccountLinkName merchantCenterAccountLinkName) {
            this.project = merchantCenterAccountLinkName.project;
            this.location = merchantCenterAccountLinkName.location;
            this.catalog = merchantCenterAccountLinkName.catalog;
            this.merchantCenterAccountLink = merchantCenterAccountLinkName.merchantCenterAccountLink;
        }

        public MerchantCenterAccountLinkName build() {
            return new MerchantCenterAccountLinkName(this);
        }
    }
}

