/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/resourcemanager/v3/folders.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.resourcemanager.v3;

public interface FolderOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.resourcemanager.v3.Folder)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the folder.
   * Its format is `folders/{folder_id}`, for example: "folders/1234".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the folder.
   * Its format is `folders/{folder_id}`, for example: "folders/1234".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The folder's parent's resource name.
   * Updates to the folder's parent must be performed using
   * [MoveFolder][google.cloud.resourcemanager.v3.Folders.MoveFolder].
   * </pre>
   *
   * <code>string parent = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parent.
   */
  java.lang.String getParent();

  /**
   *
   *
   * <pre>
   * Required. The folder's parent's resource name.
   * Updates to the folder's parent must be performed using
   * [MoveFolder][google.cloud.resourcemanager.v3.Folders.MoveFolder].
   * </pre>
   *
   * <code>string parent = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * The folder's display name.
   * A folder's display name must be unique amongst its siblings. For example,
   * no two folders with the same parent can share the same display name.
   * The display name must start and end with a letter or digit, may contain
   * letters, digits, spaces, hyphens and underscores and can be no longer
   * than 30 characters. This is captured by the regular expression:
   * `[&#92;p{L}&#92;p{N}]([&#92;p{L}&#92;p{N}_- ]{0,28}[&#92;p{L}&#92;p{N}])?`.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();

  /**
   *
   *
   * <pre>
   * The folder's display name.
   * A folder's display name must be unique amongst its siblings. For example,
   * no two folders with the same parent can share the same display name.
   * The display name must start and end with a letter or digit, may contain
   * letters, digits, spaces, hyphens and underscores and can be no longer
   * than 30 characters. This is captured by the regular expression:
   * `[&#92;p{L}&#92;p{N}]([&#92;p{L}&#92;p{N}_- ]{0,28}[&#92;p{L}&#92;p{N}])?`.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. The lifecycle state of the folder.
   * Updates to the state must be performed using
   * [DeleteFolder][google.cloud.resourcemanager.v3.Folders.DeleteFolder] and
   * [UndeleteFolder][google.cloud.resourcemanager.v3.Folders.UndeleteFolder].
   * </pre>
   *
   * <code>
   * .google.cloud.resourcemanager.v3.Folder.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();

  /**
   *
   *
   * <pre>
   * Output only. The lifecycle state of the folder.
   * Updates to the state must be performed using
   * [DeleteFolder][google.cloud.resourcemanager.v3.Folders.DeleteFolder] and
   * [UndeleteFolder][google.cloud.resourcemanager.v3.Folders.UndeleteFolder].
   * </pre>
   *
   * <code>
   * .google.cloud.resourcemanager.v3.Folder.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.cloud.resourcemanager.v3.Folder.State getState();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the folder was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the folder was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the folder was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the folder was last modified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the folder was last modified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the folder was last modified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the folder was requested to be deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  boolean hasDeleteTime();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the folder was requested to be deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  com.google.protobuf.Timestamp getDeleteTime();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the folder was requested to be deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. A checksum computed by the server based on the current value
   * of the folder resource. This may be sent on update and delete requests to
   * ensure the client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();

  /**
   *
   *
   * <pre>
   * Output only. A checksum computed by the server based on the current value
   * of the folder resource. This may be sent on update and delete requests to
   * ensure the client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();
}
