/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/resourcemanager/v3/tag_bindings.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.resourcemanager.v3;

/**
 *
 *
 * <pre>
 * An EffectiveTag represents a tag that applies to a resource during policy
 * evaluation. Tags can be either directly bound to a resource or inherited from
 * its ancestor. EffectiveTag contains the name and
 * namespaced_name of the tag value and tag key, with additional fields of
 * `inherited` to indicate the inheritance status of the effective tag.
 * </pre>
 *
 * Protobuf type {@code google.cloud.resourcemanager.v3.EffectiveTag}
 */
public final class EffectiveTag extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.resourcemanager.v3.EffectiveTag)
    EffectiveTagOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use EffectiveTag.newBuilder() to construct.
  private EffectiveTag(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EffectiveTag() {
    tagValue_ = "";
    namespacedTagValue_ = "";
    tagKey_ = "";
    namespacedTagKey_ = "";
    tagKeyParentName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EffectiveTag();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.resourcemanager.v3.TagBindingsProto
        .internal_static_google_cloud_resourcemanager_v3_EffectiveTag_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.resourcemanager.v3.TagBindingsProto
        .internal_static_google_cloud_resourcemanager_v3_EffectiveTag_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.resourcemanager.v3.EffectiveTag.class,
            com.google.cloud.resourcemanager.v3.EffectiveTag.Builder.class);
  }

  public static final int TAG_VALUE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tagValue_ = "";

  /**
   *
   *
   * <pre>
   * Resource name for TagValue in the format `tagValues/456`.
   * </pre>
   *
   * <code>string tag_value = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The tagValue.
   */
  @java.lang.Override
  public java.lang.String getTagValue() {
    java.lang.Object ref = tagValue_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tagValue_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Resource name for TagValue in the format `tagValues/456`.
   * </pre>
   *
   * <code>string tag_value = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for tagValue.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTagValueBytes() {
    java.lang.Object ref = tagValue_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tagValue_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAMESPACED_TAG_VALUE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object namespacedTagValue_ = "";

  /**
   *
   *
   * <pre>
   * The namespaced name of the TagValue. Can be in the form
   * `{organization_id}/{tag_key_short_name}/{tag_value_short_name}` or
   * `{project_id}/{tag_key_short_name}/{tag_value_short_name}` or
   * `{project_number}/{tag_key_short_name}/{tag_value_short_name}`.
   * </pre>
   *
   * <code>string namespaced_tag_value = 2;</code>
   *
   * @return The namespacedTagValue.
   */
  @java.lang.Override
  public java.lang.String getNamespacedTagValue() {
    java.lang.Object ref = namespacedTagValue_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      namespacedTagValue_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The namespaced name of the TagValue. Can be in the form
   * `{organization_id}/{tag_key_short_name}/{tag_value_short_name}` or
   * `{project_id}/{tag_key_short_name}/{tag_value_short_name}` or
   * `{project_number}/{tag_key_short_name}/{tag_value_short_name}`.
   * </pre>
   *
   * <code>string namespaced_tag_value = 2;</code>
   *
   * @return The bytes for namespacedTagValue.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNamespacedTagValueBytes() {
    java.lang.Object ref = namespacedTagValue_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      namespacedTagValue_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TAG_KEY_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tagKey_ = "";

  /**
   *
   *
   * <pre>
   * The name of the TagKey, in the format `tagKeys/{id}`, such as
   * `tagKeys/123`.
   * </pre>
   *
   * <code>string tag_key = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The tagKey.
   */
  @java.lang.Override
  public java.lang.String getTagKey() {
    java.lang.Object ref = tagKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tagKey_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The name of the TagKey, in the format `tagKeys/{id}`, such as
   * `tagKeys/123`.
   * </pre>
   *
   * <code>string tag_key = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for tagKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTagKeyBytes() {
    java.lang.Object ref = tagKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tagKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAMESPACED_TAG_KEY_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object namespacedTagKey_ = "";

  /**
   *
   *
   * <pre>
   * The namespaced name of the TagKey. Can be in the form
   * `{organization_id}/{tag_key_short_name}` or
   * `{project_id}/{tag_key_short_name}` or
   * `{project_number}/{tag_key_short_name}`.
   * </pre>
   *
   * <code>string namespaced_tag_key = 4;</code>
   *
   * @return The namespacedTagKey.
   */
  @java.lang.Override
  public java.lang.String getNamespacedTagKey() {
    java.lang.Object ref = namespacedTagKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      namespacedTagKey_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The namespaced name of the TagKey. Can be in the form
   * `{organization_id}/{tag_key_short_name}` or
   * `{project_id}/{tag_key_short_name}` or
   * `{project_number}/{tag_key_short_name}`.
   * </pre>
   *
   * <code>string namespaced_tag_key = 4;</code>
   *
   * @return The bytes for namespacedTagKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNamespacedTagKeyBytes() {
    java.lang.Object ref = namespacedTagKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      namespacedTagKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TAG_KEY_PARENT_NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tagKeyParentName_ = "";

  /**
   *
   *
   * <pre>
   * The parent name of the tag key.
   * Must be in the format `organizations/{organization_id}` or
   * `projects/{project_number}`
   * </pre>
   *
   * <code>string tag_key_parent_name = 6;</code>
   *
   * @return The tagKeyParentName.
   */
  @java.lang.Override
  public java.lang.String getTagKeyParentName() {
    java.lang.Object ref = tagKeyParentName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tagKeyParentName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The parent name of the tag key.
   * Must be in the format `organizations/{organization_id}` or
   * `projects/{project_number}`
   * </pre>
   *
   * <code>string tag_key_parent_name = 6;</code>
   *
   * @return The bytes for tagKeyParentName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTagKeyParentNameBytes() {
    java.lang.Object ref = tagKeyParentName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tagKeyParentName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INHERITED_FIELD_NUMBER = 5;
  private boolean inherited_ = false;

  /**
   *
   *
   * <pre>
   * Indicates the inheritance status of a tag value
   * attached to the given resource. If the tag value is inherited from one of
   * the resource's ancestors, inherited will be true. If false, then the tag
   * value is directly attached to the resource, inherited will be false.
   * </pre>
   *
   * <code>bool inherited = 5;</code>
   *
   * @return The inherited.
   */
  @java.lang.Override
  public boolean getInherited() {
    return inherited_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tagValue_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tagValue_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespacedTagValue_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, namespacedTagValue_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tagKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tagKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespacedTagKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, namespacedTagKey_);
    }
    if (inherited_ != false) {
      output.writeBool(5, inherited_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tagKeyParentName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, tagKeyParentName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tagValue_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tagValue_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespacedTagValue_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, namespacedTagValue_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tagKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, tagKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespacedTagKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, namespacedTagKey_);
    }
    if (inherited_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, inherited_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tagKeyParentName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, tagKeyParentName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.resourcemanager.v3.EffectiveTag)) {
      return super.equals(obj);
    }
    com.google.cloud.resourcemanager.v3.EffectiveTag other =
        (com.google.cloud.resourcemanager.v3.EffectiveTag) obj;

    if (!getTagValue().equals(other.getTagValue())) return false;
    if (!getNamespacedTagValue().equals(other.getNamespacedTagValue())) return false;
    if (!getTagKey().equals(other.getTagKey())) return false;
    if (!getNamespacedTagKey().equals(other.getNamespacedTagKey())) return false;
    if (!getTagKeyParentName().equals(other.getTagKeyParentName())) return false;
    if (getInherited() != other.getInherited()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TAG_VALUE_FIELD_NUMBER;
    hash = (53 * hash) + getTagValue().hashCode();
    hash = (37 * hash) + NAMESPACED_TAG_VALUE_FIELD_NUMBER;
    hash = (53 * hash) + getNamespacedTagValue().hashCode();
    hash = (37 * hash) + TAG_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getTagKey().hashCode();
    hash = (37 * hash) + NAMESPACED_TAG_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getNamespacedTagKey().hashCode();
    hash = (37 * hash) + TAG_KEY_PARENT_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getTagKeyParentName().hashCode();
    hash = (37 * hash) + INHERITED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getInherited());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.resourcemanager.v3.EffectiveTag parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.resourcemanager.v3.EffectiveTag parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.EffectiveTag parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.resourcemanager.v3.EffectiveTag parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.EffectiveTag parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.resourcemanager.v3.EffectiveTag parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.EffectiveTag parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.resourcemanager.v3.EffectiveTag parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.EffectiveTag parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.resourcemanager.v3.EffectiveTag parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.EffectiveTag parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.resourcemanager.v3.EffectiveTag parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.resourcemanager.v3.EffectiveTag prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * An EffectiveTag represents a tag that applies to a resource during policy
   * evaluation. Tags can be either directly bound to a resource or inherited from
   * its ancestor. EffectiveTag contains the name and
   * namespaced_name of the tag value and tag key, with additional fields of
   * `inherited` to indicate the inheritance status of the effective tag.
   * </pre>
   *
   * Protobuf type {@code google.cloud.resourcemanager.v3.EffectiveTag}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.resourcemanager.v3.EffectiveTag)
      com.google.cloud.resourcemanager.v3.EffectiveTagOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.resourcemanager.v3.TagBindingsProto
          .internal_static_google_cloud_resourcemanager_v3_EffectiveTag_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.resourcemanager.v3.TagBindingsProto
          .internal_static_google_cloud_resourcemanager_v3_EffectiveTag_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.resourcemanager.v3.EffectiveTag.class,
              com.google.cloud.resourcemanager.v3.EffectiveTag.Builder.class);
    }

    // Construct using com.google.cloud.resourcemanager.v3.EffectiveTag.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      tagValue_ = "";
      namespacedTagValue_ = "";
      tagKey_ = "";
      namespacedTagKey_ = "";
      tagKeyParentName_ = "";
      inherited_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.resourcemanager.v3.TagBindingsProto
          .internal_static_google_cloud_resourcemanager_v3_EffectiveTag_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.resourcemanager.v3.EffectiveTag getDefaultInstanceForType() {
      return com.google.cloud.resourcemanager.v3.EffectiveTag.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.resourcemanager.v3.EffectiveTag build() {
      com.google.cloud.resourcemanager.v3.EffectiveTag result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.resourcemanager.v3.EffectiveTag buildPartial() {
      com.google.cloud.resourcemanager.v3.EffectiveTag result =
          new com.google.cloud.resourcemanager.v3.EffectiveTag(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.resourcemanager.v3.EffectiveTag result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.tagValue_ = tagValue_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.namespacedTagValue_ = namespacedTagValue_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.tagKey_ = tagKey_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.namespacedTagKey_ = namespacedTagKey_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.tagKeyParentName_ = tagKeyParentName_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.inherited_ = inherited_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.resourcemanager.v3.EffectiveTag) {
        return mergeFrom((com.google.cloud.resourcemanager.v3.EffectiveTag) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.resourcemanager.v3.EffectiveTag other) {
      if (other == com.google.cloud.resourcemanager.v3.EffectiveTag.getDefaultInstance())
        return this;
      if (!other.getTagValue().isEmpty()) {
        tagValue_ = other.tagValue_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getNamespacedTagValue().isEmpty()) {
        namespacedTagValue_ = other.namespacedTagValue_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getTagKey().isEmpty()) {
        tagKey_ = other.tagKey_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getNamespacedTagKey().isEmpty()) {
        namespacedTagKey_ = other.namespacedTagKey_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getTagKeyParentName().isEmpty()) {
        tagKeyParentName_ = other.tagKeyParentName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getInherited() != false) {
        setInherited(other.getInherited());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                tagValue_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                namespacedTagValue_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                tagKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                namespacedTagKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                inherited_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 50:
              {
                tagKeyParentName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object tagValue_ = "";

    /**
     *
     *
     * <pre>
     * Resource name for TagValue in the format `tagValues/456`.
     * </pre>
     *
     * <code>string tag_value = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The tagValue.
     */
    public java.lang.String getTagValue() {
      java.lang.Object ref = tagValue_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tagValue_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Resource name for TagValue in the format `tagValues/456`.
     * </pre>
     *
     * <code>string tag_value = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for tagValue.
     */
    public com.google.protobuf.ByteString getTagValueBytes() {
      java.lang.Object ref = tagValue_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tagValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Resource name for TagValue in the format `tagValues/456`.
     * </pre>
     *
     * <code>string tag_value = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The tagValue to set.
     * @return This builder for chaining.
     */
    public Builder setTagValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tagValue_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource name for TagValue in the format `tagValues/456`.
     * </pre>
     *
     * <code>string tag_value = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTagValue() {
      tagValue_ = getDefaultInstance().getTagValue();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource name for TagValue in the format `tagValues/456`.
     * </pre>
     *
     * <code>string tag_value = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for tagValue to set.
     * @return This builder for chaining.
     */
    public Builder setTagValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tagValue_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object namespacedTagValue_ = "";

    /**
     *
     *
     * <pre>
     * The namespaced name of the TagValue. Can be in the form
     * `{organization_id}/{tag_key_short_name}/{tag_value_short_name}` or
     * `{project_id}/{tag_key_short_name}/{tag_value_short_name}` or
     * `{project_number}/{tag_key_short_name}/{tag_value_short_name}`.
     * </pre>
     *
     * <code>string namespaced_tag_value = 2;</code>
     *
     * @return The namespacedTagValue.
     */
    public java.lang.String getNamespacedTagValue() {
      java.lang.Object ref = namespacedTagValue_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        namespacedTagValue_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The namespaced name of the TagValue. Can be in the form
     * `{organization_id}/{tag_key_short_name}/{tag_value_short_name}` or
     * `{project_id}/{tag_key_short_name}/{tag_value_short_name}` or
     * `{project_number}/{tag_key_short_name}/{tag_value_short_name}`.
     * </pre>
     *
     * <code>string namespaced_tag_value = 2;</code>
     *
     * @return The bytes for namespacedTagValue.
     */
    public com.google.protobuf.ByteString getNamespacedTagValueBytes() {
      java.lang.Object ref = namespacedTagValue_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        namespacedTagValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The namespaced name of the TagValue. Can be in the form
     * `{organization_id}/{tag_key_short_name}/{tag_value_short_name}` or
     * `{project_id}/{tag_key_short_name}/{tag_value_short_name}` or
     * `{project_number}/{tag_key_short_name}/{tag_value_short_name}`.
     * </pre>
     *
     * <code>string namespaced_tag_value = 2;</code>
     *
     * @param value The namespacedTagValue to set.
     * @return This builder for chaining.
     */
    public Builder setNamespacedTagValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      namespacedTagValue_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The namespaced name of the TagValue. Can be in the form
     * `{organization_id}/{tag_key_short_name}/{tag_value_short_name}` or
     * `{project_id}/{tag_key_short_name}/{tag_value_short_name}` or
     * `{project_number}/{tag_key_short_name}/{tag_value_short_name}`.
     * </pre>
     *
     * <code>string namespaced_tag_value = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNamespacedTagValue() {
      namespacedTagValue_ = getDefaultInstance().getNamespacedTagValue();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The namespaced name of the TagValue. Can be in the form
     * `{organization_id}/{tag_key_short_name}/{tag_value_short_name}` or
     * `{project_id}/{tag_key_short_name}/{tag_value_short_name}` or
     * `{project_number}/{tag_key_short_name}/{tag_value_short_name}`.
     * </pre>
     *
     * <code>string namespaced_tag_value = 2;</code>
     *
     * @param value The bytes for namespacedTagValue to set.
     * @return This builder for chaining.
     */
    public Builder setNamespacedTagValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      namespacedTagValue_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object tagKey_ = "";

    /**
     *
     *
     * <pre>
     * The name of the TagKey, in the format `tagKeys/{id}`, such as
     * `tagKeys/123`.
     * </pre>
     *
     * <code>string tag_key = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The tagKey.
     */
    public java.lang.String getTagKey() {
      java.lang.Object ref = tagKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tagKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the TagKey, in the format `tagKeys/{id}`, such as
     * `tagKeys/123`.
     * </pre>
     *
     * <code>string tag_key = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for tagKey.
     */
    public com.google.protobuf.ByteString getTagKeyBytes() {
      java.lang.Object ref = tagKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tagKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the TagKey, in the format `tagKeys/{id}`, such as
     * `tagKeys/123`.
     * </pre>
     *
     * <code>string tag_key = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The tagKey to set.
     * @return This builder for chaining.
     */
    public Builder setTagKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tagKey_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the TagKey, in the format `tagKeys/{id}`, such as
     * `tagKeys/123`.
     * </pre>
     *
     * <code>string tag_key = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTagKey() {
      tagKey_ = getDefaultInstance().getTagKey();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the TagKey, in the format `tagKeys/{id}`, such as
     * `tagKeys/123`.
     * </pre>
     *
     * <code>string tag_key = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for tagKey to set.
     * @return This builder for chaining.
     */
    public Builder setTagKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tagKey_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object namespacedTagKey_ = "";

    /**
     *
     *
     * <pre>
     * The namespaced name of the TagKey. Can be in the form
     * `{organization_id}/{tag_key_short_name}` or
     * `{project_id}/{tag_key_short_name}` or
     * `{project_number}/{tag_key_short_name}`.
     * </pre>
     *
     * <code>string namespaced_tag_key = 4;</code>
     *
     * @return The namespacedTagKey.
     */
    public java.lang.String getNamespacedTagKey() {
      java.lang.Object ref = namespacedTagKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        namespacedTagKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The namespaced name of the TagKey. Can be in the form
     * `{organization_id}/{tag_key_short_name}` or
     * `{project_id}/{tag_key_short_name}` or
     * `{project_number}/{tag_key_short_name}`.
     * </pre>
     *
     * <code>string namespaced_tag_key = 4;</code>
     *
     * @return The bytes for namespacedTagKey.
     */
    public com.google.protobuf.ByteString getNamespacedTagKeyBytes() {
      java.lang.Object ref = namespacedTagKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        namespacedTagKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The namespaced name of the TagKey. Can be in the form
     * `{organization_id}/{tag_key_short_name}` or
     * `{project_id}/{tag_key_short_name}` or
     * `{project_number}/{tag_key_short_name}`.
     * </pre>
     *
     * <code>string namespaced_tag_key = 4;</code>
     *
     * @param value The namespacedTagKey to set.
     * @return This builder for chaining.
     */
    public Builder setNamespacedTagKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      namespacedTagKey_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The namespaced name of the TagKey. Can be in the form
     * `{organization_id}/{tag_key_short_name}` or
     * `{project_id}/{tag_key_short_name}` or
     * `{project_number}/{tag_key_short_name}`.
     * </pre>
     *
     * <code>string namespaced_tag_key = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNamespacedTagKey() {
      namespacedTagKey_ = getDefaultInstance().getNamespacedTagKey();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The namespaced name of the TagKey. Can be in the form
     * `{organization_id}/{tag_key_short_name}` or
     * `{project_id}/{tag_key_short_name}` or
     * `{project_number}/{tag_key_short_name}`.
     * </pre>
     *
     * <code>string namespaced_tag_key = 4;</code>
     *
     * @param value The bytes for namespacedTagKey to set.
     * @return This builder for chaining.
     */
    public Builder setNamespacedTagKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      namespacedTagKey_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object tagKeyParentName_ = "";

    /**
     *
     *
     * <pre>
     * The parent name of the tag key.
     * Must be in the format `organizations/{organization_id}` or
     * `projects/{project_number}`
     * </pre>
     *
     * <code>string tag_key_parent_name = 6;</code>
     *
     * @return The tagKeyParentName.
     */
    public java.lang.String getTagKeyParentName() {
      java.lang.Object ref = tagKeyParentName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tagKeyParentName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The parent name of the tag key.
     * Must be in the format `organizations/{organization_id}` or
     * `projects/{project_number}`
     * </pre>
     *
     * <code>string tag_key_parent_name = 6;</code>
     *
     * @return The bytes for tagKeyParentName.
     */
    public com.google.protobuf.ByteString getTagKeyParentNameBytes() {
      java.lang.Object ref = tagKeyParentName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tagKeyParentName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The parent name of the tag key.
     * Must be in the format `organizations/{organization_id}` or
     * `projects/{project_number}`
     * </pre>
     *
     * <code>string tag_key_parent_name = 6;</code>
     *
     * @param value The tagKeyParentName to set.
     * @return This builder for chaining.
     */
    public Builder setTagKeyParentName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tagKeyParentName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The parent name of the tag key.
     * Must be in the format `organizations/{organization_id}` or
     * `projects/{project_number}`
     * </pre>
     *
     * <code>string tag_key_parent_name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTagKeyParentName() {
      tagKeyParentName_ = getDefaultInstance().getTagKeyParentName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The parent name of the tag key.
     * Must be in the format `organizations/{organization_id}` or
     * `projects/{project_number}`
     * </pre>
     *
     * <code>string tag_key_parent_name = 6;</code>
     *
     * @param value The bytes for tagKeyParentName to set.
     * @return This builder for chaining.
     */
    public Builder setTagKeyParentNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tagKeyParentName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean inherited_;

    /**
     *
     *
     * <pre>
     * Indicates the inheritance status of a tag value
     * attached to the given resource. If the tag value is inherited from one of
     * the resource's ancestors, inherited will be true. If false, then the tag
     * value is directly attached to the resource, inherited will be false.
     * </pre>
     *
     * <code>bool inherited = 5;</code>
     *
     * @return The inherited.
     */
    @java.lang.Override
    public boolean getInherited() {
      return inherited_;
    }

    /**
     *
     *
     * <pre>
     * Indicates the inheritance status of a tag value
     * attached to the given resource. If the tag value is inherited from one of
     * the resource's ancestors, inherited will be true. If false, then the tag
     * value is directly attached to the resource, inherited will be false.
     * </pre>
     *
     * <code>bool inherited = 5;</code>
     *
     * @param value The inherited to set.
     * @return This builder for chaining.
     */
    public Builder setInherited(boolean value) {

      inherited_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates the inheritance status of a tag value
     * attached to the given resource. If the tag value is inherited from one of
     * the resource's ancestors, inherited will be true. If false, then the tag
     * value is directly attached to the resource, inherited will be false.
     * </pre>
     *
     * <code>bool inherited = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInherited() {
      bitField0_ = (bitField0_ & ~0x00000020);
      inherited_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.resourcemanager.v3.EffectiveTag)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.resourcemanager.v3.EffectiveTag)
  private static final com.google.cloud.resourcemanager.v3.EffectiveTag DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.resourcemanager.v3.EffectiveTag();
  }

  public static com.google.cloud.resourcemanager.v3.EffectiveTag getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EffectiveTag> PARSER =
      new com.google.protobuf.AbstractParser<EffectiveTag>() {
        @java.lang.Override
        public EffectiveTag parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EffectiveTag> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EffectiveTag> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.resourcemanager.v3.EffectiveTag getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
