/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/resourcemanager/v3/tag_keys.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.resourcemanager.v3;

public interface TagKeyOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.resourcemanager.v3.TagKey)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Immutable. The resource name for a TagKey. Must be in the format
   * `tagKeys/{tag_key_id}`, where `tag_key_id` is the generated numeric id for
   * the TagKey.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Immutable. The resource name for a TagKey. Must be in the format
   * `tagKeys/{tag_key_id}`, where `tag_key_id` is the generated numeric id for
   * the TagKey.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the TagKey's parent. A TagKey can be
   * parented by an Organization or a Project. For a TagKey parented by an
   * Organization, its parent must be in the form `organizations/{org_id}`. For
   * a TagKey parented by a Project, its parent can be in the form
   * `projects/{project_id}` or `projects/{project_number}`.
   * </pre>
   *
   * <code>string parent = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The parent.
   */
  java.lang.String getParent();

  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the TagKey's parent. A TagKey can be
   * parented by an Organization or a Project. For a TagKey parented by an
   * Organization, its parent must be in the form `organizations/{org_id}`. For
   * a TagKey parented by a Project, its parent can be in the form
   * `projects/{project_id}` or `projects/{project_number}`.
   * </pre>
   *
   * <code>string parent = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Required. Immutable. The user friendly name for a TagKey. The short name
   * should be unique for TagKeys within the same tag namespace.
   *
   * The short name must be 1-63 characters, beginning and ending with
   * an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_),
   * dots (.), and alphanumerics between.
   * </pre>
   *
   * <code>
   * string short_name = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The shortName.
   */
  java.lang.String getShortName();

  /**
   *
   *
   * <pre>
   * Required. Immutable. The user friendly name for a TagKey. The short name
   * should be unique for TagKeys within the same tag namespace.
   *
   * The short name must be 1-63 characters, beginning and ending with
   * an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_),
   * dots (.), and alphanumerics between.
   * </pre>
   *
   * <code>
   * string short_name = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for shortName.
   */
  com.google.protobuf.ByteString getShortNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. Immutable. Namespaced name of the TagKey.
   * </pre>
   *
   * <code>
   * string namespaced_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The namespacedName.
   */
  java.lang.String getNamespacedName();

  /**
   *
   *
   * <pre>
   * Output only. Immutable. Namespaced name of the TagKey.
   * </pre>
   *
   * <code>
   * string namespaced_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for namespacedName.
   */
  com.google.protobuf.ByteString getNamespacedNameBytes();

  /**
   *
   *
   * <pre>
   * Optional. User-assigned description of the TagKey. Must not exceed 256
   * characters.
   *
   * Read-write.
   * </pre>
   *
   * <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();

  /**
   *
   *
   * <pre>
   * Optional. User-assigned description of the TagKey. Must not exceed 256
   * characters.
   *
   * Read-write.
   * </pre>
   *
   * <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Output only. Creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. Creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. Creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. Update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. Update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Entity tag which users can pass to prevent race conditions. This
   * field is always set in server responses. See UpdateTagKeyRequest for
   * details.
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();

  /**
   *
   *
   * <pre>
   * Optional. Entity tag which users can pass to prevent race conditions. This
   * field is always set in server responses. See UpdateTagKeyRequest for
   * details.
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();

  /**
   *
   *
   * <pre>
   * Optional. A purpose denotes that this Tag is intended for use in policies
   * of a specific policy engine, and will involve that policy engine in
   * management operations involving this Tag. A purpose does not grant a
   * policy engine exclusive rights to the Tag, and it may be referenced by
   * other policy engines.
   *
   * A purpose cannot be changed once set.
   * </pre>
   *
   * <code>
   * .google.cloud.resourcemanager.v3.Purpose purpose = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for purpose.
   */
  int getPurposeValue();

  /**
   *
   *
   * <pre>
   * Optional. A purpose denotes that this Tag is intended for use in policies
   * of a specific policy engine, and will involve that policy engine in
   * management operations involving this Tag. A purpose does not grant a
   * policy engine exclusive rights to the Tag, and it may be referenced by
   * other policy engines.
   *
   * A purpose cannot be changed once set.
   * </pre>
   *
   * <code>
   * .google.cloud.resourcemanager.v3.Purpose purpose = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The purpose.
   */
  com.google.cloud.resourcemanager.v3.Purpose getPurpose();

  /**
   *
   *
   * <pre>
   * Optional. Purpose data corresponds to the policy system that the tag is
   * intended for. See documentation for `Purpose` for formatting of this field.
   *
   * Purpose data cannot be changed once set.
   * </pre>
   *
   * <code>map&lt;string, string&gt; purpose_data = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getPurposeDataCount();

  /**
   *
   *
   * <pre>
   * Optional. Purpose data corresponds to the policy system that the tag is
   * intended for. See documentation for `Purpose` for formatting of this field.
   *
   * Purpose data cannot be changed once set.
   * </pre>
   *
   * <code>map&lt;string, string&gt; purpose_data = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  boolean containsPurposeData(java.lang.String key);

  /** Use {@link #getPurposeDataMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getPurposeData();

  /**
   *
   *
   * <pre>
   * Optional. Purpose data corresponds to the policy system that the tag is
   * intended for. See documentation for `Purpose` for formatting of this field.
   *
   * Purpose data cannot be changed once set.
   * </pre>
   *
   * <code>map&lt;string, string&gt; purpose_data = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.Map<java.lang.String, java.lang.String> getPurposeDataMap();

  /**
   *
   *
   * <pre>
   * Optional. Purpose data corresponds to the policy system that the tag is
   * intended for. See documentation for `Purpose` for formatting of this field.
   *
   * Purpose data cannot be changed once set.
   * </pre>
   *
   * <code>map&lt;string, string&gt; purpose_data = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  /* nullable */
  java.lang.String getPurposeDataOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);

  /**
   *
   *
   * <pre>
   * Optional. Purpose data corresponds to the policy system that the tag is
   * intended for. See documentation for `Purpose` for formatting of this field.
   *
   * Purpose data cannot be changed once set.
   * </pre>
   *
   * <code>map&lt;string, string&gt; purpose_data = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.lang.String getPurposeDataOrThrow(java.lang.String key);
}
