/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InsightTypeConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INSIGHT_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/insightTypes/{insight_type}/config");
    private static final PathTemplate ORGANIZATION_LOCATION_INSIGHT_TYPE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/insightTypes/{insight_type}/config");
    private static final PathTemplate BILLING_ACCOUNT_LOCATION_INSIGHT_TYPE = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/locations/{location}/insightTypes/{insight_type}/config");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String insightType;
    private final String organization;
    private final String billingAccount;

    @Deprecated
    protected InsightTypeConfigName() {
        this.project = null;
        this.location = null;
        this.insightType = null;
        this.organization = null;
        this.billingAccount = null;
    }

    private InsightTypeConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.insightType = (String)Preconditions.checkNotNull((Object)builder.getInsightType());
        this.organization = null;
        this.billingAccount = null;
        this.pathTemplate = PROJECT_LOCATION_INSIGHT_TYPE;
    }

    private InsightTypeConfigName(OrganizationLocationInsightTypeBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.insightType = (String)Preconditions.checkNotNull((Object)builder.getInsightType());
        this.project = null;
        this.billingAccount = null;
        this.pathTemplate = ORGANIZATION_LOCATION_INSIGHT_TYPE;
    }

    private InsightTypeConfigName(BillingAccountLocationInsightTypeBuilder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.insightType = (String)Preconditions.checkNotNull((Object)builder.getInsightType());
        this.project = null;
        this.organization = null;
        this.pathTemplate = BILLING_ACCOUNT_LOCATION_INSIGHT_TYPE;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInsightType() {
        return this.insightType;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectLocationInsightTypeBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationLocationInsightTypeBuilder newOrganizationLocationInsightTypeBuilder() {
        return new OrganizationLocationInsightTypeBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static BillingAccountLocationInsightTypeBuilder newBillingAccountLocationInsightTypeBuilder() {
        return new BillingAccountLocationInsightTypeBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InsightTypeConfigName of(String project, String location, String insightType) {
        return InsightTypeConfigName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static InsightTypeConfigName ofProjectLocationInsightTypeName(String project, String location, String insightType) {
        return InsightTypeConfigName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static InsightTypeConfigName ofOrganizationLocationInsightTypeName(String organization, String location, String insightType) {
        return InsightTypeConfigName.newOrganizationLocationInsightTypeBuilder().setOrganization(organization).setLocation(location).setInsightType(insightType).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static InsightTypeConfigName ofBillingAccountLocationInsightTypeName(String billingAccount, String location, String insightType) {
        return InsightTypeConfigName.newBillingAccountLocationInsightTypeBuilder().setBillingAccount(billingAccount).setLocation(location).setInsightType(insightType).build();
    }

    public static String format(String project, String location, String insightType) {
        return InsightTypeConfigName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationInsightTypeName(String project, String location, String insightType) {
        return InsightTypeConfigName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationLocationInsightTypeName(String organization, String location, String insightType) {
        return InsightTypeConfigName.newOrganizationLocationInsightTypeBuilder().setOrganization(organization).setLocation(location).setInsightType(insightType).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatBillingAccountLocationInsightTypeName(String billingAccount, String location, String insightType) {
        return InsightTypeConfigName.newBillingAccountLocationInsightTypeBuilder().setBillingAccount(billingAccount).setLocation(location).setInsightType(insightType).build().toString();
    }

    public static InsightTypeConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_INSIGHT_TYPE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_INSIGHT_TYPE.match(formattedString);
            return InsightTypeConfigName.ofProjectLocationInsightTypeName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("insight_type"));
        }
        if (ORGANIZATION_LOCATION_INSIGHT_TYPE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_INSIGHT_TYPE.match(formattedString);
            return InsightTypeConfigName.ofOrganizationLocationInsightTypeName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("insight_type"));
        }
        if (BILLING_ACCOUNT_LOCATION_INSIGHT_TYPE.matches(formattedString)) {
            Map matchMap = BILLING_ACCOUNT_LOCATION_INSIGHT_TYPE.match(formattedString);
            return InsightTypeConfigName.ofBillingAccountLocationInsightTypeName((String)matchMap.get("billing_account"), (String)matchMap.get("location"), (String)matchMap.get("insight_type"));
        }
        throw new ValidationException("InsightTypeConfigName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<InsightTypeConfigName> parseList(List<String> formattedStrings) {
        ArrayList<InsightTypeConfigName> list = new ArrayList<InsightTypeConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InsightTypeConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InsightTypeConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InsightTypeConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INSIGHT_TYPE.matches(formattedString) || ORGANIZATION_LOCATION_INSIGHT_TYPE.matches(formattedString) || BILLING_ACCOUNT_LOCATION_INSIGHT_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InsightTypeConfigName insightTypeConfigName = this;
            synchronized (insightTypeConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.insightType != null) {
                        fieldMapBuilder.put((Object)"insight_type", (Object)this.insightType);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put((Object)"billing_account", (Object)this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            InsightTypeConfigName that = (InsightTypeConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.insightType, that.insightType) && Objects.equals(this.organization, that.organization) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.insightType);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class BillingAccountLocationInsightTypeBuilder {
        private String billingAccount;
        private String location;
        private String insightType;

        protected BillingAccountLocationInsightTypeBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInsightType() {
            return this.insightType;
        }

        public BillingAccountLocationInsightTypeBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public BillingAccountLocationInsightTypeBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public BillingAccountLocationInsightTypeBuilder setInsightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        public InsightTypeConfigName build() {
            return new InsightTypeConfigName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationLocationInsightTypeBuilder {
        private String organization;
        private String location;
        private String insightType;

        protected OrganizationLocationInsightTypeBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInsightType() {
            return this.insightType;
        }

        public OrganizationLocationInsightTypeBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationInsightTypeBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationInsightTypeBuilder setInsightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        public InsightTypeConfigName build() {
            return new InsightTypeConfigName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String insightType;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInsightType() {
            return this.insightType;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInsightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        private Builder(InsightTypeConfigName insightTypeConfigName) {
            Preconditions.checkArgument((boolean)Objects.equals(insightTypeConfigName.pathTemplate, PROJECT_LOCATION_INSIGHT_TYPE), (Object)"toBuilder is only supported when InsightTypeConfigName has the pattern of projects/{project}/locations/{location}/insightTypes/{insight_type}/config");
            this.project = insightTypeConfigName.project;
            this.location = insightTypeConfigName.location;
            this.insightType = insightTypeConfigName.insightType;
        }

        public InsightTypeConfigName build() {
            return new InsightTypeConfigName(this);
        }
    }
}

