/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InsightTypeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INSIGHT_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/insightTypes/{insight_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String insightType;

    @Deprecated
    protected InsightTypeName() {
        this.project = null;
        this.location = null;
        this.insightType = null;
    }

    private InsightTypeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.insightType = (String)Preconditions.checkNotNull((Object)builder.getInsightType());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInsightType() {
        return this.insightType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InsightTypeName of(String project, String location, String insightType) {
        return InsightTypeName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).build();
    }

    public static String format(String project, String location, String insightType) {
        return InsightTypeName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).build().toString();
    }

    public static InsightTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_INSIGHT_TYPE.validatedMatch(formattedString, "InsightTypeName.parse: formattedString not in valid format");
        return InsightTypeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("insight_type"));
    }

    public static List<InsightTypeName> parseList(List<String> formattedStrings) {
        ArrayList<InsightTypeName> list = new ArrayList<InsightTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InsightTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InsightTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InsightTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INSIGHT_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InsightTypeName insightTypeName = this;
            synchronized (insightTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.insightType != null) {
                        fieldMapBuilder.put((Object)"insight_type", (Object)this.insightType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_INSIGHT_TYPE.instantiate(new String[]{"project", this.project, "location", this.location, "insight_type", this.insightType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            InsightTypeName that = (InsightTypeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.insightType, that.insightType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.insightType);
    }

    public static class Builder {
        private String project;
        private String location;
        private String insightType;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInsightType() {
            return this.insightType;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInsightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        private Builder(InsightTypeName insightTypeName) {
            this.project = insightTypeName.project;
            this.location = insightTypeName.location;
            this.insightType = insightTypeName.insightType;
        }

        public InsightTypeName build() {
            return new InsightTypeName(this);
        }
    }
}

