/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/pubsublite/v1/common.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.pubsublite.proto;

/**
 *
 *
 * <pre>
 * Configuration for a Pub/Sub Lite subscription that writes messages to a
 * destination. User subscriber clients must not connect to this subscription.
 * </pre>
 *
 * Protobuf type {@code google.cloud.pubsublite.v1.ExportConfig}
 */
public final class ExportConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.pubsublite.v1.ExportConfig)
    ExportConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportConfig.newBuilder() to construct.
  private ExportConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportConfig() {
    desiredState_ = 0;
    currentState_ = 0;
    deadLetterTopic_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.pubsublite.proto.CommonProto
        .internal_static_google_cloud_pubsublite_v1_ExportConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.pubsublite.proto.CommonProto
        .internal_static_google_cloud_pubsublite_v1_ExportConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.pubsublite.proto.ExportConfig.class,
            com.google.cloud.pubsublite.proto.ExportConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The desired export state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.pubsublite.v1.ExportConfig.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Messages are being exported.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    /**
     *
     *
     * <pre>
     * Exporting messages is suspended.
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    PAUSED(2),
    /**
     *
     *
     * <pre>
     * Messages cannot be exported due to permission denied errors. Output only.
     * </pre>
     *
     * <code>PERMISSION_DENIED = 3;</code>
     */
    PERMISSION_DENIED(3),
    /**
     *
     *
     * <pre>
     * Messages cannot be exported due to missing resources. Output only.
     * </pre>
     *
     * <code>NOT_FOUND = 4;</code>
     */
    NOT_FOUND(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Messages are being exported.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Exporting messages is suspended.
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    public static final int PAUSED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Messages cannot be exported due to permission denied errors. Output only.
     * </pre>
     *
     * <code>PERMISSION_DENIED = 3;</code>
     */
    public static final int PERMISSION_DENIED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Messages cannot be exported due to missing resources. Output only.
     * </pre>
     *
     * <code>NOT_FOUND = 4;</code>
     */
    public static final int NOT_FOUND_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        case 2:
          return PAUSED;
        case 3:
          return PERMISSION_DENIED;
        case 4:
          return NOT_FOUND;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.pubsublite.proto.ExportConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.pubsublite.v1.ExportConfig.State)
  }

  public interface PubSubConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.pubsublite.v1.ExportConfig.PubSubConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the Pub/Sub topic.
     * Structured like: projects/{project_number}/topics/{topic_id}.
     * The topic may be changed.
     * </pre>
     *
     * <code>string topic = 1;</code>
     *
     * @return The topic.
     */
    java.lang.String getTopic();
    /**
     *
     *
     * <pre>
     * The name of the Pub/Sub topic.
     * Structured like: projects/{project_number}/topics/{topic_id}.
     * The topic may be changed.
     * </pre>
     *
     * <code>string topic = 1;</code>
     *
     * @return The bytes for topic.
     */
    com.google.protobuf.ByteString getTopicBytes();
  }
  /**
   *
   *
   * <pre>
   * Configuration for exporting to a Pub/Sub topic.
   * </pre>
   *
   * Protobuf type {@code google.cloud.pubsublite.v1.ExportConfig.PubSubConfig}
   */
  public static final class PubSubConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.pubsublite.v1.ExportConfig.PubSubConfig)
      PubSubConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PubSubConfig.newBuilder() to construct.
    private PubSubConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PubSubConfig() {
      topic_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PubSubConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.pubsublite.proto.CommonProto
          .internal_static_google_cloud_pubsublite_v1_ExportConfig_PubSubConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.pubsublite.proto.CommonProto
          .internal_static_google_cloud_pubsublite_v1_ExportConfig_PubSubConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.class,
              com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.Builder.class);
    }

    public static final int TOPIC_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object topic_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Pub/Sub topic.
     * Structured like: projects/{project_number}/topics/{topic_id}.
     * The topic may be changed.
     * </pre>
     *
     * <code>string topic = 1;</code>
     *
     * @return The topic.
     */
    @java.lang.Override
    public java.lang.String getTopic() {
      java.lang.Object ref = topic_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        topic_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Pub/Sub topic.
     * Structured like: projects/{project_number}/topics/{topic_id}.
     * The topic may be changed.
     * </pre>
     *
     * <code>string topic = 1;</code>
     *
     * @return The bytes for topic.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTopicBytes() {
      java.lang.Object ref = topic_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        topic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, topic_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, topic_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig other =
          (com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig) obj;

      if (!getTopic().equals(other.getTopic())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TOPIC_FIELD_NUMBER;
      hash = (53 * hash) + getTopic().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for exporting to a Pub/Sub topic.
     * </pre>
     *
     * Protobuf type {@code google.cloud.pubsublite.v1.ExportConfig.PubSubConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.pubsublite.v1.ExportConfig.PubSubConfig)
        com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.pubsublite.proto.CommonProto
            .internal_static_google_cloud_pubsublite_v1_ExportConfig_PubSubConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.pubsublite.proto.CommonProto
            .internal_static_google_cloud_pubsublite_v1_ExportConfig_PubSubConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.class,
                com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.Builder.class);
      }

      // Construct using com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        topic_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.pubsublite.proto.CommonProto
            .internal_static_google_cloud_pubsublite_v1_ExportConfig_PubSubConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig
          getDefaultInstanceForType() {
        return com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig build() {
        com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig buildPartial() {
        com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig result =
            new com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.topic_ = topic_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig) {
          return mergeFrom((com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig other) {
        if (other
            == com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.getDefaultInstance())
          return this;
        if (!other.getTopic().isEmpty()) {
          topic_ = other.topic_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  topic_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object topic_ = "";
      /**
       *
       *
       * <pre>
       * The name of the Pub/Sub topic.
       * Structured like: projects/{project_number}/topics/{topic_id}.
       * The topic may be changed.
       * </pre>
       *
       * <code>string topic = 1;</code>
       *
       * @return The topic.
       */
      public java.lang.String getTopic() {
        java.lang.Object ref = topic_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          topic_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Pub/Sub topic.
       * Structured like: projects/{project_number}/topics/{topic_id}.
       * The topic may be changed.
       * </pre>
       *
       * <code>string topic = 1;</code>
       *
       * @return The bytes for topic.
       */
      public com.google.protobuf.ByteString getTopicBytes() {
        java.lang.Object ref = topic_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          topic_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Pub/Sub topic.
       * Structured like: projects/{project_number}/topics/{topic_id}.
       * The topic may be changed.
       * </pre>
       *
       * <code>string topic = 1;</code>
       *
       * @param value The topic to set.
       * @return This builder for chaining.
       */
      public Builder setTopic(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        topic_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Pub/Sub topic.
       * Structured like: projects/{project_number}/topics/{topic_id}.
       * The topic may be changed.
       * </pre>
       *
       * <code>string topic = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopic() {
        topic_ = getDefaultInstance().getTopic();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Pub/Sub topic.
       * Structured like: projects/{project_number}/topics/{topic_id}.
       * The topic may be changed.
       * </pre>
       *
       * <code>string topic = 1;</code>
       *
       * @param value The bytes for topic to set.
       * @return This builder for chaining.
       */
      public Builder setTopicBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        topic_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.pubsublite.v1.ExportConfig.PubSubConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.pubsublite.v1.ExportConfig.PubSubConfig)
    private static final com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig();
    }

    public static com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PubSubConfig> PARSER =
        new com.google.protobuf.AbstractParser<PubSubConfig>() {
          @java.lang.Override
          public PubSubConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PubSubConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PubSubConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int destinationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PUBSUB_CONFIG(3),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 3:
          return PUBSUB_CONFIG;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int DESIRED_STATE_FIELD_NUMBER = 1;
  private int desiredState_ = 0;
  /**
   *
   *
   * <pre>
   * The desired state of this export. Setting this to values other than
   * `ACTIVE` and `PAUSED` will result in an error.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.ExportConfig.State desired_state = 1;</code>
   *
   * @return The enum numeric value on the wire for desiredState.
   */
  @java.lang.Override
  public int getDesiredStateValue() {
    return desiredState_;
  }
  /**
   *
   *
   * <pre>
   * The desired state of this export. Setting this to values other than
   * `ACTIVE` and `PAUSED` will result in an error.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.ExportConfig.State desired_state = 1;</code>
   *
   * @return The desiredState.
   */
  @java.lang.Override
  public com.google.cloud.pubsublite.proto.ExportConfig.State getDesiredState() {
    com.google.cloud.pubsublite.proto.ExportConfig.State result =
        com.google.cloud.pubsublite.proto.ExportConfig.State.forNumber(desiredState_);
    return result == null
        ? com.google.cloud.pubsublite.proto.ExportConfig.State.UNRECOGNIZED
        : result;
  }

  public static final int CURRENT_STATE_FIELD_NUMBER = 6;
  private int currentState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the export, which may be different to the
   * desired state due to errors. This field is output only.
   * </pre>
   *
   * <code>
   * .google.cloud.pubsublite.v1.ExportConfig.State current_state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for currentState.
   */
  @java.lang.Override
  public int getCurrentStateValue() {
    return currentState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the export, which may be different to the
   * desired state due to errors. This field is output only.
   * </pre>
   *
   * <code>
   * .google.cloud.pubsublite.v1.ExportConfig.State current_state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The currentState.
   */
  @java.lang.Override
  public com.google.cloud.pubsublite.proto.ExportConfig.State getCurrentState() {
    com.google.cloud.pubsublite.proto.ExportConfig.State result =
        com.google.cloud.pubsublite.proto.ExportConfig.State.forNumber(currentState_);
    return result == null
        ? com.google.cloud.pubsublite.proto.ExportConfig.State.UNRECOGNIZED
        : result;
  }

  public static final int DEAD_LETTER_TOPIC_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deadLetterTopic_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of an optional Pub/Sub Lite topic to publish messages
   * that can not be exported to the destination. For example, the message can
   * not be published to the Pub/Sub service because it does not satisfy the
   * constraints documented at https://cloud.google.com/pubsub/docs/publisher.
   *
   * Structured like:
   * projects/{project_number}/locations/{location}/topics/{topic_id}.
   * Must be within the same project and location as the subscription. The topic
   * may be changed or removed.
   * </pre>
   *
   * <code>
   * string dead_letter_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The deadLetterTopic.
   */
  @java.lang.Override
  public java.lang.String getDeadLetterTopic() {
    java.lang.Object ref = deadLetterTopic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deadLetterTopic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of an optional Pub/Sub Lite topic to publish messages
   * that can not be exported to the destination. For example, the message can
   * not be published to the Pub/Sub service because it does not satisfy the
   * constraints documented at https://cloud.google.com/pubsub/docs/publisher.
   *
   * Structured like:
   * projects/{project_number}/locations/{location}/topics/{topic_id}.
   * Must be within the same project and location as the subscription. The topic
   * may be changed or removed.
   * </pre>
   *
   * <code>
   * string dead_letter_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for deadLetterTopic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeadLetterTopicBytes() {
    java.lang.Object ref = deadLetterTopic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deadLetterTopic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PUBSUB_CONFIG_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Messages are automatically written from the Pub/Sub Lite topic associated
   * with this subscription to a Pub/Sub topic.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.ExportConfig.PubSubConfig pubsub_config = 3;</code>
   *
   * @return Whether the pubsubConfig field is set.
   */
  @java.lang.Override
  public boolean hasPubsubConfig() {
    return destinationCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Messages are automatically written from the Pub/Sub Lite topic associated
   * with this subscription to a Pub/Sub topic.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.ExportConfig.PubSubConfig pubsub_config = 3;</code>
   *
   * @return The pubsubConfig.
   */
  @java.lang.Override
  public com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig getPubsubConfig() {
    if (destinationCase_ == 3) {
      return (com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig) destination_;
    }
    return com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Messages are automatically written from the Pub/Sub Lite topic associated
   * with this subscription to a Pub/Sub topic.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.ExportConfig.PubSubConfig pubsub_config = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfigOrBuilder
      getPubsubConfigOrBuilder() {
    if (destinationCase_ == 3) {
      return (com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig) destination_;
    }
    return com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (desiredState_
        != com.google.cloud.pubsublite.proto.ExportConfig.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, desiredState_);
    }
    if (destinationCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig) destination_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deadLetterTopic_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, deadLetterTopic_);
    }
    if (currentState_
        != com.google.cloud.pubsublite.proto.ExportConfig.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, currentState_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (desiredState_
        != com.google.cloud.pubsublite.proto.ExportConfig.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, desiredState_);
    }
    if (destinationCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig) destination_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deadLetterTopic_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, deadLetterTopic_);
    }
    if (currentState_
        != com.google.cloud.pubsublite.proto.ExportConfig.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, currentState_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.pubsublite.proto.ExportConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.pubsublite.proto.ExportConfig other =
        (com.google.cloud.pubsublite.proto.ExportConfig) obj;

    if (desiredState_ != other.desiredState_) return false;
    if (currentState_ != other.currentState_) return false;
    if (!getDeadLetterTopic().equals(other.getDeadLetterTopic())) return false;
    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 3:
        if (!getPubsubConfig().equals(other.getPubsubConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DESIRED_STATE_FIELD_NUMBER;
    hash = (53 * hash) + desiredState_;
    hash = (37 * hash) + CURRENT_STATE_FIELD_NUMBER;
    hash = (53 * hash) + currentState_;
    hash = (37 * hash) + DEAD_LETTER_TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getDeadLetterTopic().hashCode();
    switch (destinationCase_) {
      case 3:
        hash = (37 * hash) + PUBSUB_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getPubsubConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.pubsublite.proto.ExportConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.pubsublite.proto.ExportConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.ExportConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.pubsublite.proto.ExportConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.ExportConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.pubsublite.proto.ExportConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.ExportConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.pubsublite.proto.ExportConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.ExportConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.pubsublite.proto.ExportConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.ExportConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.pubsublite.proto.ExportConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.pubsublite.proto.ExportConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a Pub/Sub Lite subscription that writes messages to a
   * destination. User subscriber clients must not connect to this subscription.
   * </pre>
   *
   * Protobuf type {@code google.cloud.pubsublite.v1.ExportConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.pubsublite.v1.ExportConfig)
      com.google.cloud.pubsublite.proto.ExportConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.pubsublite.proto.CommonProto
          .internal_static_google_cloud_pubsublite_v1_ExportConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.pubsublite.proto.CommonProto
          .internal_static_google_cloud_pubsublite_v1_ExportConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.pubsublite.proto.ExportConfig.class,
              com.google.cloud.pubsublite.proto.ExportConfig.Builder.class);
    }

    // Construct using com.google.cloud.pubsublite.proto.ExportConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      desiredState_ = 0;
      currentState_ = 0;
      deadLetterTopic_ = "";
      if (pubsubConfigBuilder_ != null) {
        pubsubConfigBuilder_.clear();
      }
      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.pubsublite.proto.CommonProto
          .internal_static_google_cloud_pubsublite_v1_ExportConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.pubsublite.proto.ExportConfig getDefaultInstanceForType() {
      return com.google.cloud.pubsublite.proto.ExportConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.pubsublite.proto.ExportConfig build() {
      com.google.cloud.pubsublite.proto.ExportConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.pubsublite.proto.ExportConfig buildPartial() {
      com.google.cloud.pubsublite.proto.ExportConfig result =
          new com.google.cloud.pubsublite.proto.ExportConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.pubsublite.proto.ExportConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.desiredState_ = desiredState_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.currentState_ = currentState_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.deadLetterTopic_ = deadLetterTopic_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.pubsublite.proto.ExportConfig result) {
      result.destinationCase_ = destinationCase_;
      result.destination_ = this.destination_;
      if (destinationCase_ == 3 && pubsubConfigBuilder_ != null) {
        result.destination_ = pubsubConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.pubsublite.proto.ExportConfig) {
        return mergeFrom((com.google.cloud.pubsublite.proto.ExportConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.pubsublite.proto.ExportConfig other) {
      if (other == com.google.cloud.pubsublite.proto.ExportConfig.getDefaultInstance()) return this;
      if (other.desiredState_ != 0) {
        setDesiredStateValue(other.getDesiredStateValue());
      }
      if (other.currentState_ != 0) {
        setCurrentStateValue(other.getCurrentStateValue());
      }
      if (!other.getDeadLetterTopic().isEmpty()) {
        deadLetterTopic_ = other.deadLetterTopic_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getDestinationCase()) {
        case PUBSUB_CONFIG:
          {
            mergePubsubConfig(other.getPubsubConfig());
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                desiredState_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 26:
              {
                input.readMessage(getPubsubConfigFieldBuilder().getBuilder(), extensionRegistry);
                destinationCase_ = 3;
                break;
              } // case 26
            case 42:
              {
                deadLetterTopic_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            case 48:
              {
                currentState_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private int desiredState_ = 0;
    /**
     *
     *
     * <pre>
     * The desired state of this export. Setting this to values other than
     * `ACTIVE` and `PAUSED` will result in an error.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig.State desired_state = 1;</code>
     *
     * @return The enum numeric value on the wire for desiredState.
     */
    @java.lang.Override
    public int getDesiredStateValue() {
      return desiredState_;
    }
    /**
     *
     *
     * <pre>
     * The desired state of this export. Setting this to values other than
     * `ACTIVE` and `PAUSED` will result in an error.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig.State desired_state = 1;</code>
     *
     * @param value The enum numeric value on the wire for desiredState to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredStateValue(int value) {
      desiredState_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired state of this export. Setting this to values other than
     * `ACTIVE` and `PAUSED` will result in an error.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig.State desired_state = 1;</code>
     *
     * @return The desiredState.
     */
    @java.lang.Override
    public com.google.cloud.pubsublite.proto.ExportConfig.State getDesiredState() {
      com.google.cloud.pubsublite.proto.ExportConfig.State result =
          com.google.cloud.pubsublite.proto.ExportConfig.State.forNumber(desiredState_);
      return result == null
          ? com.google.cloud.pubsublite.proto.ExportConfig.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The desired state of this export. Setting this to values other than
     * `ACTIVE` and `PAUSED` will result in an error.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig.State desired_state = 1;</code>
     *
     * @param value The desiredState to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredState(com.google.cloud.pubsublite.proto.ExportConfig.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      desiredState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired state of this export. Setting this to values other than
     * `ACTIVE` and `PAUSED` will result in an error.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig.State desired_state = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredState() {
      bitField0_ = (bitField0_ & ~0x00000001);
      desiredState_ = 0;
      onChanged();
      return this;
    }

    private int currentState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the export, which may be different to the
     * desired state due to errors. This field is output only.
     * </pre>
     *
     * <code>
     * .google.cloud.pubsublite.v1.ExportConfig.State current_state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for currentState.
     */
    @java.lang.Override
    public int getCurrentStateValue() {
      return currentState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the export, which may be different to the
     * desired state due to errors. This field is output only.
     * </pre>
     *
     * <code>
     * .google.cloud.pubsublite.v1.ExportConfig.State current_state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for currentState to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentStateValue(int value) {
      currentState_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the export, which may be different to the
     * desired state due to errors. This field is output only.
     * </pre>
     *
     * <code>
     * .google.cloud.pubsublite.v1.ExportConfig.State current_state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The currentState.
     */
    @java.lang.Override
    public com.google.cloud.pubsublite.proto.ExportConfig.State getCurrentState() {
      com.google.cloud.pubsublite.proto.ExportConfig.State result =
          com.google.cloud.pubsublite.proto.ExportConfig.State.forNumber(currentState_);
      return result == null
          ? com.google.cloud.pubsublite.proto.ExportConfig.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the export, which may be different to the
     * desired state due to errors. This field is output only.
     * </pre>
     *
     * <code>
     * .google.cloud.pubsublite.v1.ExportConfig.State current_state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The currentState to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentState(com.google.cloud.pubsublite.proto.ExportConfig.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      currentState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the export, which may be different to the
     * desired state due to errors. This field is output only.
     * </pre>
     *
     * <code>
     * .google.cloud.pubsublite.v1.ExportConfig.State current_state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrentState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      currentState_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object deadLetterTopic_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of an optional Pub/Sub Lite topic to publish messages
     * that can not be exported to the destination. For example, the message can
     * not be published to the Pub/Sub service because it does not satisfy the
     * constraints documented at https://cloud.google.com/pubsub/docs/publisher.
     *
     * Structured like:
     * projects/{project_number}/locations/{location}/topics/{topic_id}.
     * Must be within the same project and location as the subscription. The topic
     * may be changed or removed.
     * </pre>
     *
     * <code>
     * string dead_letter_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The deadLetterTopic.
     */
    public java.lang.String getDeadLetterTopic() {
      java.lang.Object ref = deadLetterTopic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deadLetterTopic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of an optional Pub/Sub Lite topic to publish messages
     * that can not be exported to the destination. For example, the message can
     * not be published to the Pub/Sub service because it does not satisfy the
     * constraints documented at https://cloud.google.com/pubsub/docs/publisher.
     *
     * Structured like:
     * projects/{project_number}/locations/{location}/topics/{topic_id}.
     * Must be within the same project and location as the subscription. The topic
     * may be changed or removed.
     * </pre>
     *
     * <code>
     * string dead_letter_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for deadLetterTopic.
     */
    public com.google.protobuf.ByteString getDeadLetterTopicBytes() {
      java.lang.Object ref = deadLetterTopic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deadLetterTopic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of an optional Pub/Sub Lite topic to publish messages
     * that can not be exported to the destination. For example, the message can
     * not be published to the Pub/Sub service because it does not satisfy the
     * constraints documented at https://cloud.google.com/pubsub/docs/publisher.
     *
     * Structured like:
     * projects/{project_number}/locations/{location}/topics/{topic_id}.
     * Must be within the same project and location as the subscription. The topic
     * may be changed or removed.
     * </pre>
     *
     * <code>
     * string dead_letter_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The deadLetterTopic to set.
     * @return This builder for chaining.
     */
    public Builder setDeadLetterTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deadLetterTopic_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of an optional Pub/Sub Lite topic to publish messages
     * that can not be exported to the destination. For example, the message can
     * not be published to the Pub/Sub service because it does not satisfy the
     * constraints documented at https://cloud.google.com/pubsub/docs/publisher.
     *
     * Structured like:
     * projects/{project_number}/locations/{location}/topics/{topic_id}.
     * Must be within the same project and location as the subscription. The topic
     * may be changed or removed.
     * </pre>
     *
     * <code>
     * string dead_letter_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeadLetterTopic() {
      deadLetterTopic_ = getDefaultInstance().getDeadLetterTopic();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of an optional Pub/Sub Lite topic to publish messages
     * that can not be exported to the destination. For example, the message can
     * not be published to the Pub/Sub service because it does not satisfy the
     * constraints documented at https://cloud.google.com/pubsub/docs/publisher.
     *
     * Structured like:
     * projects/{project_number}/locations/{location}/topics/{topic_id}.
     * Must be within the same project and location as the subscription. The topic
     * may be changed or removed.
     * </pre>
     *
     * <code>
     * string dead_letter_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for deadLetterTopic to set.
     * @return This builder for chaining.
     */
    public Builder setDeadLetterTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deadLetterTopic_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig,
            com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.Builder,
            com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfigOrBuilder>
        pubsubConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Messages are automatically written from the Pub/Sub Lite topic associated
     * with this subscription to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig.PubSubConfig pubsub_config = 3;</code>
     *
     * @return Whether the pubsubConfig field is set.
     */
    @java.lang.Override
    public boolean hasPubsubConfig() {
      return destinationCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Messages are automatically written from the Pub/Sub Lite topic associated
     * with this subscription to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig.PubSubConfig pubsub_config = 3;</code>
     *
     * @return The pubsubConfig.
     */
    @java.lang.Override
    public com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig getPubsubConfig() {
      if (pubsubConfigBuilder_ == null) {
        if (destinationCase_ == 3) {
          return (com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig) destination_;
        }
        return com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.getDefaultInstance();
      } else {
        if (destinationCase_ == 3) {
          return pubsubConfigBuilder_.getMessage();
        }
        return com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Messages are automatically written from the Pub/Sub Lite topic associated
     * with this subscription to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig.PubSubConfig pubsub_config = 3;</code>
     */
    public Builder setPubsubConfig(
        com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig value) {
      if (pubsubConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        pubsubConfigBuilder_.setMessage(value);
      }
      destinationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Messages are automatically written from the Pub/Sub Lite topic associated
     * with this subscription to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig.PubSubConfig pubsub_config = 3;</code>
     */
    public Builder setPubsubConfig(
        com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.Builder builderForValue) {
      if (pubsubConfigBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        pubsubConfigBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Messages are automatically written from the Pub/Sub Lite topic associated
     * with this subscription to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig.PubSubConfig pubsub_config = 3;</code>
     */
    public Builder mergePubsubConfig(
        com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig value) {
      if (pubsubConfigBuilder_ == null) {
        if (destinationCase_ == 3
            && destination_
                != com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig
                    .getDefaultInstance()) {
          destination_ =
              com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.newBuilder(
                      (com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig) destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 3) {
          pubsubConfigBuilder_.mergeFrom(value);
        } else {
          pubsubConfigBuilder_.setMessage(value);
        }
      }
      destinationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Messages are automatically written from the Pub/Sub Lite topic associated
     * with this subscription to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig.PubSubConfig pubsub_config = 3;</code>
     */
    public Builder clearPubsubConfig() {
      if (pubsubConfigBuilder_ == null) {
        if (destinationCase_ == 3) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 3) {
          destinationCase_ = 0;
          destination_ = null;
        }
        pubsubConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Messages are automatically written from the Pub/Sub Lite topic associated
     * with this subscription to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig.PubSubConfig pubsub_config = 3;</code>
     */
    public com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.Builder
        getPubsubConfigBuilder() {
      return getPubsubConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Messages are automatically written from the Pub/Sub Lite topic associated
     * with this subscription to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig.PubSubConfig pubsub_config = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfigOrBuilder
        getPubsubConfigOrBuilder() {
      if ((destinationCase_ == 3) && (pubsubConfigBuilder_ != null)) {
        return pubsubConfigBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 3) {
          return (com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig) destination_;
        }
        return com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Messages are automatically written from the Pub/Sub Lite topic associated
     * with this subscription to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig.PubSubConfig pubsub_config = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig,
            com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.Builder,
            com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfigOrBuilder>
        getPubsubConfigFieldBuilder() {
      if (pubsubConfigBuilder_ == null) {
        if (!(destinationCase_ == 3)) {
          destination_ =
              com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.getDefaultInstance();
        }
        pubsubConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig,
                com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig.Builder,
                com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfigOrBuilder>(
                (com.google.cloud.pubsublite.proto.ExportConfig.PubSubConfig) destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 3;
      onChanged();
      return pubsubConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.pubsublite.v1.ExportConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.pubsublite.v1.ExportConfig)
  private static final com.google.cloud.pubsublite.proto.ExportConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.pubsublite.proto.ExportConfig();
  }

  public static com.google.cloud.pubsublite.proto.ExportConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportConfig> PARSER =
      new com.google.protobuf.AbstractParser<ExportConfig>() {
        @java.lang.Override
        public ExportConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExportConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.pubsublite.proto.ExportConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
