/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/pubsublite/v1/topic_stats.proto

package com.google.cloud.pubsublite.proto;

/**
 *
 *
 * <pre>
 * Compute statistics about a range of messages in a given topic and partition.
 * </pre>
 *
 * Protobuf type {@code google.cloud.pubsublite.v1.ComputeMessageStatsRequest}
 */
public final class ComputeMessageStatsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.pubsublite.v1.ComputeMessageStatsRequest)
    ComputeMessageStatsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ComputeMessageStatsRequest.newBuilder() to construct.
  private ComputeMessageStatsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ComputeMessageStatsRequest() {
    topic_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ComputeMessageStatsRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.pubsublite.proto.TopicStatsProto
        .internal_static_google_cloud_pubsublite_v1_ComputeMessageStatsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.pubsublite.proto.TopicStatsProto
        .internal_static_google_cloud_pubsublite_v1_ComputeMessageStatsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest.class,
            com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest.Builder.class);
  }

  public static final int TOPIC_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object topic_ = "";
  /**
   *
   *
   * <pre>
   * Required. The topic for which we should compute message stats.
   * </pre>
   *
   * <code>
   * string topic = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The topic.
   */
  @java.lang.Override
  public java.lang.String getTopic() {
    java.lang.Object ref = topic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      topic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The topic for which we should compute message stats.
   * </pre>
   *
   * <code>
   * string topic = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for topic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTopicBytes() {
    java.lang.Object ref = topic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      topic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARTITION_FIELD_NUMBER = 2;
  private long partition_ = 0L;
  /**
   *
   *
   * <pre>
   * Required. The partition for which we should compute message stats.
   * </pre>
   *
   * <code>int64 partition = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The partition.
   */
  @java.lang.Override
  public long getPartition() {
    return partition_;
  }

  public static final int START_CURSOR_FIELD_NUMBER = 3;
  private com.google.cloud.pubsublite.proto.Cursor startCursor_;
  /**
   *
   *
   * <pre>
   * The inclusive start of the range.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.Cursor start_cursor = 3;</code>
   *
   * @return Whether the startCursor field is set.
   */
  @java.lang.Override
  public boolean hasStartCursor() {
    return startCursor_ != null;
  }
  /**
   *
   *
   * <pre>
   * The inclusive start of the range.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.Cursor start_cursor = 3;</code>
   *
   * @return The startCursor.
   */
  @java.lang.Override
  public com.google.cloud.pubsublite.proto.Cursor getStartCursor() {
    return startCursor_ == null
        ? com.google.cloud.pubsublite.proto.Cursor.getDefaultInstance()
        : startCursor_;
  }
  /**
   *
   *
   * <pre>
   * The inclusive start of the range.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.Cursor start_cursor = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.pubsublite.proto.CursorOrBuilder getStartCursorOrBuilder() {
    return startCursor_ == null
        ? com.google.cloud.pubsublite.proto.Cursor.getDefaultInstance()
        : startCursor_;
  }

  public static final int END_CURSOR_FIELD_NUMBER = 4;
  private com.google.cloud.pubsublite.proto.Cursor endCursor_;
  /**
   *
   *
   * <pre>
   * The exclusive end of the range. The range is empty if end_cursor &lt;=
   * start_cursor. Specifying a start_cursor before the first message and an
   * end_cursor after the last message will retrieve all messages.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.Cursor end_cursor = 4;</code>
   *
   * @return Whether the endCursor field is set.
   */
  @java.lang.Override
  public boolean hasEndCursor() {
    return endCursor_ != null;
  }
  /**
   *
   *
   * <pre>
   * The exclusive end of the range. The range is empty if end_cursor &lt;=
   * start_cursor. Specifying a start_cursor before the first message and an
   * end_cursor after the last message will retrieve all messages.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.Cursor end_cursor = 4;</code>
   *
   * @return The endCursor.
   */
  @java.lang.Override
  public com.google.cloud.pubsublite.proto.Cursor getEndCursor() {
    return endCursor_ == null
        ? com.google.cloud.pubsublite.proto.Cursor.getDefaultInstance()
        : endCursor_;
  }
  /**
   *
   *
   * <pre>
   * The exclusive end of the range. The range is empty if end_cursor &lt;=
   * start_cursor. Specifying a start_cursor before the first message and an
   * end_cursor after the last message will retrieve all messages.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.Cursor end_cursor = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.pubsublite.proto.CursorOrBuilder getEndCursorOrBuilder() {
    return endCursor_ == null
        ? com.google.cloud.pubsublite.proto.Cursor.getDefaultInstance()
        : endCursor_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, topic_);
    }
    if (partition_ != 0L) {
      output.writeInt64(2, partition_);
    }
    if (startCursor_ != null) {
      output.writeMessage(3, getStartCursor());
    }
    if (endCursor_ != null) {
      output.writeMessage(4, getEndCursor());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, topic_);
    }
    if (partition_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, partition_);
    }
    if (startCursor_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStartCursor());
    }
    if (endCursor_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getEndCursor());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest other =
        (com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest) obj;

    if (!getTopic().equals(other.getTopic())) return false;
    if (getPartition() != other.getPartition()) return false;
    if (hasStartCursor() != other.hasStartCursor()) return false;
    if (hasStartCursor()) {
      if (!getStartCursor().equals(other.getStartCursor())) return false;
    }
    if (hasEndCursor() != other.hasEndCursor()) return false;
    if (hasEndCursor()) {
      if (!getEndCursor().equals(other.getEndCursor())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getTopic().hashCode();
    hash = (37 * hash) + PARTITION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPartition());
    if (hasStartCursor()) {
      hash = (37 * hash) + START_CURSOR_FIELD_NUMBER;
      hash = (53 * hash) + getStartCursor().hashCode();
    }
    if (hasEndCursor()) {
      hash = (37 * hash) + END_CURSOR_FIELD_NUMBER;
      hash = (53 * hash) + getEndCursor().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Compute statistics about a range of messages in a given topic and partition.
   * </pre>
   *
   * Protobuf type {@code google.cloud.pubsublite.v1.ComputeMessageStatsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.pubsublite.v1.ComputeMessageStatsRequest)
      com.google.cloud.pubsublite.proto.ComputeMessageStatsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.pubsublite.proto.TopicStatsProto
          .internal_static_google_cloud_pubsublite_v1_ComputeMessageStatsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.pubsublite.proto.TopicStatsProto
          .internal_static_google_cloud_pubsublite_v1_ComputeMessageStatsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest.class,
              com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest.Builder.class);
    }

    // Construct using com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      topic_ = "";
      partition_ = 0L;
      startCursor_ = null;
      if (startCursorBuilder_ != null) {
        startCursorBuilder_.dispose();
        startCursorBuilder_ = null;
      }
      endCursor_ = null;
      if (endCursorBuilder_ != null) {
        endCursorBuilder_.dispose();
        endCursorBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.pubsublite.proto.TopicStatsProto
          .internal_static_google_cloud_pubsublite_v1_ComputeMessageStatsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest build() {
      com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest buildPartial() {
      com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest result =
          new com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.topic_ = topic_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.partition_ = partition_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.startCursor_ =
            startCursorBuilder_ == null ? startCursor_ : startCursorBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.endCursor_ = endCursorBuilder_ == null ? endCursor_ : endCursorBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest) {
        return mergeFrom((com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest other) {
      if (other
          == com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest.getDefaultInstance())
        return this;
      if (!other.getTopic().isEmpty()) {
        topic_ = other.topic_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getPartition() != 0L) {
        setPartition(other.getPartition());
      }
      if (other.hasStartCursor()) {
        mergeStartCursor(other.getStartCursor());
      }
      if (other.hasEndCursor()) {
        mergeEndCursor(other.getEndCursor());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                topic_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                partition_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getStartCursorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getEndCursorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object topic_ = "";
    /**
     *
     *
     * <pre>
     * Required. The topic for which we should compute message stats.
     * </pre>
     *
     * <code>
     * string topic = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The topic.
     */
    public java.lang.String getTopic() {
      java.lang.Object ref = topic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        topic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The topic for which we should compute message stats.
     * </pre>
     *
     * <code>
     * string topic = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for topic.
     */
    public com.google.protobuf.ByteString getTopicBytes() {
      java.lang.Object ref = topic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        topic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The topic for which we should compute message stats.
     * </pre>
     *
     * <code>
     * string topic = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The topic to set.
     * @return This builder for chaining.
     */
    public Builder setTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      topic_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The topic for which we should compute message stats.
     * </pre>
     *
     * <code>
     * string topic = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTopic() {
      topic_ = getDefaultInstance().getTopic();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The topic for which we should compute message stats.
     * </pre>
     *
     * <code>
     * string topic = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for topic to set.
     * @return This builder for chaining.
     */
    public Builder setTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      topic_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long partition_;
    /**
     *
     *
     * <pre>
     * Required. The partition for which we should compute message stats.
     * </pre>
     *
     * <code>int64 partition = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The partition.
     */
    @java.lang.Override
    public long getPartition() {
      return partition_;
    }
    /**
     *
     *
     * <pre>
     * Required. The partition for which we should compute message stats.
     * </pre>
     *
     * <code>int64 partition = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The partition to set.
     * @return This builder for chaining.
     */
    public Builder setPartition(long value) {

      partition_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The partition for which we should compute message stats.
     * </pre>
     *
     * <code>int64 partition = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPartition() {
      bitField0_ = (bitField0_ & ~0x00000002);
      partition_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.pubsublite.proto.Cursor startCursor_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.pubsublite.proto.Cursor,
            com.google.cloud.pubsublite.proto.Cursor.Builder,
            com.google.cloud.pubsublite.proto.CursorOrBuilder>
        startCursorBuilder_;
    /**
     *
     *
     * <pre>
     * The inclusive start of the range.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor start_cursor = 3;</code>
     *
     * @return Whether the startCursor field is set.
     */
    public boolean hasStartCursor() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The inclusive start of the range.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor start_cursor = 3;</code>
     *
     * @return The startCursor.
     */
    public com.google.cloud.pubsublite.proto.Cursor getStartCursor() {
      if (startCursorBuilder_ == null) {
        return startCursor_ == null
            ? com.google.cloud.pubsublite.proto.Cursor.getDefaultInstance()
            : startCursor_;
      } else {
        return startCursorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The inclusive start of the range.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor start_cursor = 3;</code>
     */
    public Builder setStartCursor(com.google.cloud.pubsublite.proto.Cursor value) {
      if (startCursorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startCursor_ = value;
      } else {
        startCursorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The inclusive start of the range.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor start_cursor = 3;</code>
     */
    public Builder setStartCursor(
        com.google.cloud.pubsublite.proto.Cursor.Builder builderForValue) {
      if (startCursorBuilder_ == null) {
        startCursor_ = builderForValue.build();
      } else {
        startCursorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The inclusive start of the range.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor start_cursor = 3;</code>
     */
    public Builder mergeStartCursor(com.google.cloud.pubsublite.proto.Cursor value) {
      if (startCursorBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && startCursor_ != null
            && startCursor_ != com.google.cloud.pubsublite.proto.Cursor.getDefaultInstance()) {
          getStartCursorBuilder().mergeFrom(value);
        } else {
          startCursor_ = value;
        }
      } else {
        startCursorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The inclusive start of the range.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor start_cursor = 3;</code>
     */
    public Builder clearStartCursor() {
      bitField0_ = (bitField0_ & ~0x00000004);
      startCursor_ = null;
      if (startCursorBuilder_ != null) {
        startCursorBuilder_.dispose();
        startCursorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The inclusive start of the range.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor start_cursor = 3;</code>
     */
    public com.google.cloud.pubsublite.proto.Cursor.Builder getStartCursorBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getStartCursorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The inclusive start of the range.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor start_cursor = 3;</code>
     */
    public com.google.cloud.pubsublite.proto.CursorOrBuilder getStartCursorOrBuilder() {
      if (startCursorBuilder_ != null) {
        return startCursorBuilder_.getMessageOrBuilder();
      } else {
        return startCursor_ == null
            ? com.google.cloud.pubsublite.proto.Cursor.getDefaultInstance()
            : startCursor_;
      }
    }
    /**
     *
     *
     * <pre>
     * The inclusive start of the range.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor start_cursor = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.pubsublite.proto.Cursor,
            com.google.cloud.pubsublite.proto.Cursor.Builder,
            com.google.cloud.pubsublite.proto.CursorOrBuilder>
        getStartCursorFieldBuilder() {
      if (startCursorBuilder_ == null) {
        startCursorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.pubsublite.proto.Cursor,
                com.google.cloud.pubsublite.proto.Cursor.Builder,
                com.google.cloud.pubsublite.proto.CursorOrBuilder>(
                getStartCursor(), getParentForChildren(), isClean());
        startCursor_ = null;
      }
      return startCursorBuilder_;
    }

    private com.google.cloud.pubsublite.proto.Cursor endCursor_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.pubsublite.proto.Cursor,
            com.google.cloud.pubsublite.proto.Cursor.Builder,
            com.google.cloud.pubsublite.proto.CursorOrBuilder>
        endCursorBuilder_;
    /**
     *
     *
     * <pre>
     * The exclusive end of the range. The range is empty if end_cursor &lt;=
     * start_cursor. Specifying a start_cursor before the first message and an
     * end_cursor after the last message will retrieve all messages.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor end_cursor = 4;</code>
     *
     * @return Whether the endCursor field is set.
     */
    public boolean hasEndCursor() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The exclusive end of the range. The range is empty if end_cursor &lt;=
     * start_cursor. Specifying a start_cursor before the first message and an
     * end_cursor after the last message will retrieve all messages.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor end_cursor = 4;</code>
     *
     * @return The endCursor.
     */
    public com.google.cloud.pubsublite.proto.Cursor getEndCursor() {
      if (endCursorBuilder_ == null) {
        return endCursor_ == null
            ? com.google.cloud.pubsublite.proto.Cursor.getDefaultInstance()
            : endCursor_;
      } else {
        return endCursorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The exclusive end of the range. The range is empty if end_cursor &lt;=
     * start_cursor. Specifying a start_cursor before the first message and an
     * end_cursor after the last message will retrieve all messages.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor end_cursor = 4;</code>
     */
    public Builder setEndCursor(com.google.cloud.pubsublite.proto.Cursor value) {
      if (endCursorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endCursor_ = value;
      } else {
        endCursorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The exclusive end of the range. The range is empty if end_cursor &lt;=
     * start_cursor. Specifying a start_cursor before the first message and an
     * end_cursor after the last message will retrieve all messages.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor end_cursor = 4;</code>
     */
    public Builder setEndCursor(com.google.cloud.pubsublite.proto.Cursor.Builder builderForValue) {
      if (endCursorBuilder_ == null) {
        endCursor_ = builderForValue.build();
      } else {
        endCursorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The exclusive end of the range. The range is empty if end_cursor &lt;=
     * start_cursor. Specifying a start_cursor before the first message and an
     * end_cursor after the last message will retrieve all messages.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor end_cursor = 4;</code>
     */
    public Builder mergeEndCursor(com.google.cloud.pubsublite.proto.Cursor value) {
      if (endCursorBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && endCursor_ != null
            && endCursor_ != com.google.cloud.pubsublite.proto.Cursor.getDefaultInstance()) {
          getEndCursorBuilder().mergeFrom(value);
        } else {
          endCursor_ = value;
        }
      } else {
        endCursorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The exclusive end of the range. The range is empty if end_cursor &lt;=
     * start_cursor. Specifying a start_cursor before the first message and an
     * end_cursor after the last message will retrieve all messages.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor end_cursor = 4;</code>
     */
    public Builder clearEndCursor() {
      bitField0_ = (bitField0_ & ~0x00000008);
      endCursor_ = null;
      if (endCursorBuilder_ != null) {
        endCursorBuilder_.dispose();
        endCursorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The exclusive end of the range. The range is empty if end_cursor &lt;=
     * start_cursor. Specifying a start_cursor before the first message and an
     * end_cursor after the last message will retrieve all messages.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor end_cursor = 4;</code>
     */
    public com.google.cloud.pubsublite.proto.Cursor.Builder getEndCursorBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getEndCursorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The exclusive end of the range. The range is empty if end_cursor &lt;=
     * start_cursor. Specifying a start_cursor before the first message and an
     * end_cursor after the last message will retrieve all messages.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor end_cursor = 4;</code>
     */
    public com.google.cloud.pubsublite.proto.CursorOrBuilder getEndCursorOrBuilder() {
      if (endCursorBuilder_ != null) {
        return endCursorBuilder_.getMessageOrBuilder();
      } else {
        return endCursor_ == null
            ? com.google.cloud.pubsublite.proto.Cursor.getDefaultInstance()
            : endCursor_;
      }
    }
    /**
     *
     *
     * <pre>
     * The exclusive end of the range. The range is empty if end_cursor &lt;=
     * start_cursor. Specifying a start_cursor before the first message and an
     * end_cursor after the last message will retrieve all messages.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Cursor end_cursor = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.pubsublite.proto.Cursor,
            com.google.cloud.pubsublite.proto.Cursor.Builder,
            com.google.cloud.pubsublite.proto.CursorOrBuilder>
        getEndCursorFieldBuilder() {
      if (endCursorBuilder_ == null) {
        endCursorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.pubsublite.proto.Cursor,
                com.google.cloud.pubsublite.proto.Cursor.Builder,
                com.google.cloud.pubsublite.proto.CursorOrBuilder>(
                getEndCursor(), getParentForChildren(), isClean());
        endCursor_ = null;
      }
      return endCursorBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.pubsublite.v1.ComputeMessageStatsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.pubsublite.v1.ComputeMessageStatsRequest)
  private static final com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest();
  }

  public static com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ComputeMessageStatsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ComputeMessageStatsRequest>() {
        @java.lang.Override
        public ComputeMessageStatsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ComputeMessageStatsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ComputeMessageStatsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
