/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.proto;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TopicName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/topics/{topic}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String topic;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTopic() {
        return this.topic;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TopicName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.topic = (String)Preconditions.checkNotNull((Object)builder.getTopic());
    }

    public static TopicName of(String project, String location, String topic) {
        return TopicName.newBuilder().setProject(project).setLocation(location).setTopic(topic).build();
    }

    public static String format(String project, String location, String topic) {
        return TopicName.newBuilder().setProject(project).setLocation(location).setTopic(topic).build().toString();
    }

    public static TopicName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "TopicName.parse: formattedString not in valid format");
        return TopicName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("topic"));
    }

    public static List<TopicName> parseList(List<String> formattedStrings) {
        ArrayList<TopicName> list = new ArrayList<TopicName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TopicName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TopicName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TopicName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TopicName topicName = this;
            synchronized (topicName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"topic", (Object)this.topic);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "topic", this.topic});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TopicName) {
            TopicName that = (TopicName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.topic.equals(that.topic);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.topic.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String topic;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTopic() {
            return this.topic;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        private Builder() {
        }

        private Builder(TopicName topicName) {
            this.project = topicName.project;
            this.location = topicName.location;
            this.topic = topicName.topic;
        }

        public TopicName build() {
            return new TopicName(this);
        }
    }
}

