/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

// Protobuf Java Version: 3.25.3
package com.google.pubsub.v1;

/**
 *
 *
 * <pre>
 * Settings for validating messages published against a schema.
 * </pre>
 *
 * Protobuf type {@code google.pubsub.v1.SchemaSettings}
 */
public final class SchemaSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.pubsub.v1.SchemaSettings)
    SchemaSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SchemaSettings.newBuilder() to construct.
  private SchemaSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SchemaSettings() {
    schema_ = "";
    encoding_ = 0;
    firstRevisionId_ = "";
    lastRevisionId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SchemaSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_SchemaSettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_SchemaSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.pubsub.v1.SchemaSettings.class,
            com.google.pubsub.v1.SchemaSettings.Builder.class);
  }

  public static final int SCHEMA_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object schema_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the schema that messages published should be
   * validated against. Format is `projects/{project}/schemas/{schema}`. The
   * value of this field will be `_deleted-schema_` if the schema has been
   * deleted.
   * </pre>
   *
   * <code>
   * string schema = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The schema.
   */
  @java.lang.Override
  public java.lang.String getSchema() {
    java.lang.Object ref = schema_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schema_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the schema that messages published should be
   * validated against. Format is `projects/{project}/schemas/{schema}`. The
   * value of this field will be `_deleted-schema_` if the schema has been
   * deleted.
   * </pre>
   *
   * <code>
   * string schema = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for schema.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSchemaBytes() {
    java.lang.Object ref = schema_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schema_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENCODING_FIELD_NUMBER = 2;
  private int encoding_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The encoding of messages validated against `schema`.
   * </pre>
   *
   * <code>.google.pubsub.v1.Encoding encoding = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enum numeric value on the wire for encoding.
   */
  @java.lang.Override
  public int getEncodingValue() {
    return encoding_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The encoding of messages validated against `schema`.
   * </pre>
   *
   * <code>.google.pubsub.v1.Encoding encoding = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The encoding.
   */
  @java.lang.Override
  public com.google.pubsub.v1.Encoding getEncoding() {
    com.google.pubsub.v1.Encoding result = com.google.pubsub.v1.Encoding.forNumber(encoding_);
    return result == null ? com.google.pubsub.v1.Encoding.UNRECOGNIZED : result;
  }

  public static final int FIRST_REVISION_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object firstRevisionId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The minimum (inclusive) revision allowed for validating messages.
   * If empty or not present, allow any revision to be validated against
   * last_revision or any revision created before.
   * </pre>
   *
   * <code>string first_revision_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The firstRevisionId.
   */
  @java.lang.Override
  public java.lang.String getFirstRevisionId() {
    java.lang.Object ref = firstRevisionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      firstRevisionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The minimum (inclusive) revision allowed for validating messages.
   * If empty or not present, allow any revision to be validated against
   * last_revision or any revision created before.
   * </pre>
   *
   * <code>string first_revision_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for firstRevisionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFirstRevisionIdBytes() {
    java.lang.Object ref = firstRevisionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      firstRevisionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LAST_REVISION_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lastRevisionId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The maximum (inclusive) revision allowed for validating messages.
   * If empty or not present, allow any revision to be validated against
   * first_revision or any revision created after.
   * </pre>
   *
   * <code>string last_revision_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The lastRevisionId.
   */
  @java.lang.Override
  public java.lang.String getLastRevisionId() {
    java.lang.Object ref = lastRevisionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lastRevisionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The maximum (inclusive) revision allowed for validating messages.
   * If empty or not present, allow any revision to be validated against
   * first_revision or any revision created after.
   * </pre>
   *
   * <code>string last_revision_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for lastRevisionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLastRevisionIdBytes() {
    java.lang.Object ref = lastRevisionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lastRevisionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schema_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, schema_);
    }
    if (encoding_ != com.google.pubsub.v1.Encoding.ENCODING_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, encoding_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(firstRevisionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, firstRevisionId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastRevisionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, lastRevisionId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schema_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, schema_);
    }
    if (encoding_ != com.google.pubsub.v1.Encoding.ENCODING_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, encoding_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(firstRevisionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, firstRevisionId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastRevisionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, lastRevisionId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.pubsub.v1.SchemaSettings)) {
      return super.equals(obj);
    }
    com.google.pubsub.v1.SchemaSettings other = (com.google.pubsub.v1.SchemaSettings) obj;

    if (!getSchema().equals(other.getSchema())) return false;
    if (encoding_ != other.encoding_) return false;
    if (!getFirstRevisionId().equals(other.getFirstRevisionId())) return false;
    if (!getLastRevisionId().equals(other.getLastRevisionId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SCHEMA_FIELD_NUMBER;
    hash = (53 * hash) + getSchema().hashCode();
    hash = (37 * hash) + ENCODING_FIELD_NUMBER;
    hash = (53 * hash) + encoding_;
    hash = (37 * hash) + FIRST_REVISION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getFirstRevisionId().hashCode();
    hash = (37 * hash) + LAST_REVISION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getLastRevisionId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.pubsub.v1.SchemaSettings parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.SchemaSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.SchemaSettings parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.SchemaSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.SchemaSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.SchemaSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.SchemaSettings parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.SchemaSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.SchemaSettings parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.SchemaSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.SchemaSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.SchemaSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.pubsub.v1.SchemaSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Settings for validating messages published against a schema.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.SchemaSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.pubsub.v1.SchemaSettings)
      com.google.pubsub.v1.SchemaSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_SchemaSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_SchemaSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.SchemaSettings.class,
              com.google.pubsub.v1.SchemaSettings.Builder.class);
    }

    // Construct using com.google.pubsub.v1.SchemaSettings.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      schema_ = "";
      encoding_ = 0;
      firstRevisionId_ = "";
      lastRevisionId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_SchemaSettings_descriptor;
    }

    @java.lang.Override
    public com.google.pubsub.v1.SchemaSettings getDefaultInstanceForType() {
      return com.google.pubsub.v1.SchemaSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.pubsub.v1.SchemaSettings build() {
      com.google.pubsub.v1.SchemaSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.pubsub.v1.SchemaSettings buildPartial() {
      com.google.pubsub.v1.SchemaSettings result = new com.google.pubsub.v1.SchemaSettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.pubsub.v1.SchemaSettings result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.schema_ = schema_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.encoding_ = encoding_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.firstRevisionId_ = firstRevisionId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.lastRevisionId_ = lastRevisionId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.pubsub.v1.SchemaSettings) {
        return mergeFrom((com.google.pubsub.v1.SchemaSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.pubsub.v1.SchemaSettings other) {
      if (other == com.google.pubsub.v1.SchemaSettings.getDefaultInstance()) return this;
      if (!other.getSchema().isEmpty()) {
        schema_ = other.schema_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.encoding_ != 0) {
        setEncodingValue(other.getEncodingValue());
      }
      if (!other.getFirstRevisionId().isEmpty()) {
        firstRevisionId_ = other.firstRevisionId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getLastRevisionId().isEmpty()) {
        lastRevisionId_ = other.lastRevisionId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                schema_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                encoding_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                firstRevisionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                lastRevisionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object schema_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the schema that messages published should be
     * validated against. Format is `projects/{project}/schemas/{schema}`. The
     * value of this field will be `_deleted-schema_` if the schema has been
     * deleted.
     * </pre>
     *
     * <code>
     * string schema = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The schema.
     */
    public java.lang.String getSchema() {
      java.lang.Object ref = schema_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schema_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the schema that messages published should be
     * validated against. Format is `projects/{project}/schemas/{schema}`. The
     * value of this field will be `_deleted-schema_` if the schema has been
     * deleted.
     * </pre>
     *
     * <code>
     * string schema = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for schema.
     */
    public com.google.protobuf.ByteString getSchemaBytes() {
      java.lang.Object ref = schema_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schema_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the schema that messages published should be
     * validated against. Format is `projects/{project}/schemas/{schema}`. The
     * value of this field will be `_deleted-schema_` if the schema has been
     * deleted.
     * </pre>
     *
     * <code>
     * string schema = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The schema to set.
     * @return This builder for chaining.
     */
    public Builder setSchema(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      schema_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the schema that messages published should be
     * validated against. Format is `projects/{project}/schemas/{schema}`. The
     * value of this field will be `_deleted-schema_` if the schema has been
     * deleted.
     * </pre>
     *
     * <code>
     * string schema = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchema() {
      schema_ = getDefaultInstance().getSchema();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the schema that messages published should be
     * validated against. Format is `projects/{project}/schemas/{schema}`. The
     * value of this field will be `_deleted-schema_` if the schema has been
     * deleted.
     * </pre>
     *
     * <code>
     * string schema = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for schema to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      schema_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int encoding_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The encoding of messages validated against `schema`.
     * </pre>
     *
     * <code>.google.pubsub.v1.Encoding encoding = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for encoding.
     */
    @java.lang.Override
    public int getEncodingValue() {
      return encoding_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encoding of messages validated against `schema`.
     * </pre>
     *
     * <code>.google.pubsub.v1.Encoding encoding = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for encoding to set.
     * @return This builder for chaining.
     */
    public Builder setEncodingValue(int value) {
      encoding_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encoding of messages validated against `schema`.
     * </pre>
     *
     * <code>.google.pubsub.v1.Encoding encoding = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The encoding.
     */
    @java.lang.Override
    public com.google.pubsub.v1.Encoding getEncoding() {
      com.google.pubsub.v1.Encoding result = com.google.pubsub.v1.Encoding.forNumber(encoding_);
      return result == null ? com.google.pubsub.v1.Encoding.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encoding of messages validated against `schema`.
     * </pre>
     *
     * <code>.google.pubsub.v1.Encoding encoding = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The encoding to set.
     * @return This builder for chaining.
     */
    public Builder setEncoding(com.google.pubsub.v1.Encoding value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      encoding_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encoding of messages validated against `schema`.
     * </pre>
     *
     * <code>.google.pubsub.v1.Encoding encoding = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEncoding() {
      bitField0_ = (bitField0_ & ~0x00000002);
      encoding_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object firstRevisionId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The minimum (inclusive) revision allowed for validating messages.
     * If empty or not present, allow any revision to be validated against
     * last_revision or any revision created before.
     * </pre>
     *
     * <code>string first_revision_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The firstRevisionId.
     */
    public java.lang.String getFirstRevisionId() {
      java.lang.Object ref = firstRevisionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        firstRevisionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The minimum (inclusive) revision allowed for validating messages.
     * If empty or not present, allow any revision to be validated against
     * last_revision or any revision created before.
     * </pre>
     *
     * <code>string first_revision_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for firstRevisionId.
     */
    public com.google.protobuf.ByteString getFirstRevisionIdBytes() {
      java.lang.Object ref = firstRevisionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        firstRevisionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The minimum (inclusive) revision allowed for validating messages.
     * If empty or not present, allow any revision to be validated against
     * last_revision or any revision created before.
     * </pre>
     *
     * <code>string first_revision_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The firstRevisionId to set.
     * @return This builder for chaining.
     */
    public Builder setFirstRevisionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      firstRevisionId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The minimum (inclusive) revision allowed for validating messages.
     * If empty or not present, allow any revision to be validated against
     * last_revision or any revision created before.
     * </pre>
     *
     * <code>string first_revision_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFirstRevisionId() {
      firstRevisionId_ = getDefaultInstance().getFirstRevisionId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The minimum (inclusive) revision allowed for validating messages.
     * If empty or not present, allow any revision to be validated against
     * last_revision or any revision created before.
     * </pre>
     *
     * <code>string first_revision_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for firstRevisionId to set.
     * @return This builder for chaining.
     */
    public Builder setFirstRevisionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      firstRevisionId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object lastRevisionId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The maximum (inclusive) revision allowed for validating messages.
     * If empty or not present, allow any revision to be validated against
     * first_revision or any revision created after.
     * </pre>
     *
     * <code>string last_revision_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The lastRevisionId.
     */
    public java.lang.String getLastRevisionId() {
      java.lang.Object ref = lastRevisionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lastRevisionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum (inclusive) revision allowed for validating messages.
     * If empty or not present, allow any revision to be validated against
     * first_revision or any revision created after.
     * </pre>
     *
     * <code>string last_revision_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for lastRevisionId.
     */
    public com.google.protobuf.ByteString getLastRevisionIdBytes() {
      java.lang.Object ref = lastRevisionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lastRevisionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum (inclusive) revision allowed for validating messages.
     * If empty or not present, allow any revision to be validated against
     * first_revision or any revision created after.
     * </pre>
     *
     * <code>string last_revision_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The lastRevisionId to set.
     * @return This builder for chaining.
     */
    public Builder setLastRevisionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lastRevisionId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum (inclusive) revision allowed for validating messages.
     * If empty or not present, allow any revision to be validated against
     * first_revision or any revision created after.
     * </pre>
     *
     * <code>string last_revision_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLastRevisionId() {
      lastRevisionId_ = getDefaultInstance().getLastRevisionId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum (inclusive) revision allowed for validating messages.
     * If empty or not present, allow any revision to be validated against
     * first_revision or any revision created after.
     * </pre>
     *
     * <code>string last_revision_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for lastRevisionId to set.
     * @return This builder for chaining.
     */
    public Builder setLastRevisionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lastRevisionId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.pubsub.v1.SchemaSettings)
  }

  // @@protoc_insertion_point(class_scope:google.pubsub.v1.SchemaSettings)
  private static final com.google.pubsub.v1.SchemaSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.pubsub.v1.SchemaSettings();
  }

  public static com.google.pubsub.v1.SchemaSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SchemaSettings> PARSER =
      new com.google.protobuf.AbstractParser<SchemaSettings>() {
        @java.lang.Override
        public SchemaSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SchemaSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SchemaSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.pubsub.v1.SchemaSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
