/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.privilegedaccessmanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GrantName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ENTITLEMENT_GRANT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/entitlements/{entitlement}/grants/{grant}");
    private static final PathTemplate FOLDER_LOCATION_ENTITLEMENT_GRANT = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/entitlements/{entitlement}/grants/{grant}");
    private static final PathTemplate ORGANIZATION_LOCATION_ENTITLEMENT_GRANT = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/entitlements/{entitlement}/grants/{grant}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String entitlement;
    private final String grant;
    private final String folder;
    private final String organization;

    @Deprecated
    protected GrantName() {
        this.project = null;
        this.location = null;
        this.entitlement = null;
        this.grant = null;
        this.folder = null;
        this.organization = null;
    }

    private GrantName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.entitlement = (String)Preconditions.checkNotNull((Object)builder.getEntitlement());
        this.grant = (String)Preconditions.checkNotNull((Object)builder.getGrant());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_ENTITLEMENT_GRANT;
    }

    private GrantName(FolderLocationEntitlementGrantBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.entitlement = (String)Preconditions.checkNotNull((Object)builder.getEntitlement());
        this.grant = (String)Preconditions.checkNotNull((Object)builder.getGrant());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_LOCATION_ENTITLEMENT_GRANT;
    }

    private GrantName(OrganizationLocationEntitlementGrantBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.entitlement = (String)Preconditions.checkNotNull((Object)builder.getEntitlement());
        this.grant = (String)Preconditions.checkNotNull((Object)builder.getGrant());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_LOCATION_ENTITLEMENT_GRANT;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEntitlement() {
        return this.entitlement;
    }

    public String getGrant() {
        return this.grant;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationEntitlementGrantBuilder() {
        return new Builder();
    }

    public static FolderLocationEntitlementGrantBuilder newFolderLocationEntitlementGrantBuilder() {
        return new FolderLocationEntitlementGrantBuilder();
    }

    public static OrganizationLocationEntitlementGrantBuilder newOrganizationLocationEntitlementGrantBuilder() {
        return new OrganizationLocationEntitlementGrantBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GrantName of(String project, String location, String entitlement, String grant) {
        return GrantName.newBuilder().setProject(project).setLocation(location).setEntitlement(entitlement).setGrant(grant).build();
    }

    public static GrantName ofProjectLocationEntitlementGrantName(String project, String location, String entitlement, String grant) {
        return GrantName.newBuilder().setProject(project).setLocation(location).setEntitlement(entitlement).setGrant(grant).build();
    }

    public static GrantName ofFolderLocationEntitlementGrantName(String folder, String location, String entitlement, String grant) {
        return GrantName.newFolderLocationEntitlementGrantBuilder().setFolder(folder).setLocation(location).setEntitlement(entitlement).setGrant(grant).build();
    }

    public static GrantName ofOrganizationLocationEntitlementGrantName(String organization, String location, String entitlement, String grant) {
        return GrantName.newOrganizationLocationEntitlementGrantBuilder().setOrganization(organization).setLocation(location).setEntitlement(entitlement).setGrant(grant).build();
    }

    public static String format(String project, String location, String entitlement, String grant) {
        return GrantName.newBuilder().setProject(project).setLocation(location).setEntitlement(entitlement).setGrant(grant).build().toString();
    }

    public static String formatProjectLocationEntitlementGrantName(String project, String location, String entitlement, String grant) {
        return GrantName.newBuilder().setProject(project).setLocation(location).setEntitlement(entitlement).setGrant(grant).build().toString();
    }

    public static String formatFolderLocationEntitlementGrantName(String folder, String location, String entitlement, String grant) {
        return GrantName.newFolderLocationEntitlementGrantBuilder().setFolder(folder).setLocation(location).setEntitlement(entitlement).setGrant(grant).build().toString();
    }

    public static String formatOrganizationLocationEntitlementGrantName(String organization, String location, String entitlement, String grant) {
        return GrantName.newOrganizationLocationEntitlementGrantBuilder().setOrganization(organization).setLocation(location).setEntitlement(entitlement).setGrant(grant).build().toString();
    }

    public static GrantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_ENTITLEMENT_GRANT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_ENTITLEMENT_GRANT.match(formattedString);
            return GrantName.ofProjectLocationEntitlementGrantName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("entitlement"), (String)matchMap.get("grant"));
        }
        if (FOLDER_LOCATION_ENTITLEMENT_GRANT.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_ENTITLEMENT_GRANT.match(formattedString);
            return GrantName.ofFolderLocationEntitlementGrantName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("entitlement"), (String)matchMap.get("grant"));
        }
        if (ORGANIZATION_LOCATION_ENTITLEMENT_GRANT.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_ENTITLEMENT_GRANT.match(formattedString);
            return GrantName.ofOrganizationLocationEntitlementGrantName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("entitlement"), (String)matchMap.get("grant"));
        }
        throw new ValidationException("GrantName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<GrantName> parseList(List<String> formattedStrings) {
        ArrayList<GrantName> list = new ArrayList<GrantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GrantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GrantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GrantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ENTITLEMENT_GRANT.matches(formattedString) || FOLDER_LOCATION_ENTITLEMENT_GRANT.matches(formattedString) || ORGANIZATION_LOCATION_ENTITLEMENT_GRANT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GrantName grantName = this;
            synchronized (grantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.entitlement != null) {
                        fieldMapBuilder.put((Object)"entitlement", (Object)this.entitlement);
                    }
                    if (this.grant != null) {
                        fieldMapBuilder.put((Object)"grant", (Object)this.grant);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GrantName that = (GrantName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.entitlement, that.entitlement) && Objects.equals(this.grant, that.grant) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.entitlement);
        h *= 1000003;
        h ^= Objects.hashCode(this.grant);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class OrganizationLocationEntitlementGrantBuilder {
        private String organization;
        private String location;
        private String entitlement;
        private String grant;

        protected OrganizationLocationEntitlementGrantBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEntitlement() {
            return this.entitlement;
        }

        public String getGrant() {
            return this.grant;
        }

        public OrganizationLocationEntitlementGrantBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationEntitlementGrantBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationEntitlementGrantBuilder setEntitlement(String entitlement) {
            this.entitlement = entitlement;
            return this;
        }

        public OrganizationLocationEntitlementGrantBuilder setGrant(String grant) {
            this.grant = grant;
            return this;
        }

        public GrantName build() {
            return new GrantName(this);
        }
    }

    public static class FolderLocationEntitlementGrantBuilder {
        private String folder;
        private String location;
        private String entitlement;
        private String grant;

        protected FolderLocationEntitlementGrantBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEntitlement() {
            return this.entitlement;
        }

        public String getGrant() {
            return this.grant;
        }

        public FolderLocationEntitlementGrantBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationEntitlementGrantBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationEntitlementGrantBuilder setEntitlement(String entitlement) {
            this.entitlement = entitlement;
            return this;
        }

        public FolderLocationEntitlementGrantBuilder setGrant(String grant) {
            this.grant = grant;
            return this;
        }

        public GrantName build() {
            return new GrantName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String entitlement;
        private String grant;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEntitlement() {
            return this.entitlement;
        }

        public String getGrant() {
            return this.grant;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEntitlement(String entitlement) {
            this.entitlement = entitlement;
            return this;
        }

        public Builder setGrant(String grant) {
            this.grant = grant;
            return this;
        }

        private Builder(GrantName grantName) {
            Preconditions.checkArgument((boolean)Objects.equals(grantName.pathTemplate, PROJECT_LOCATION_ENTITLEMENT_GRANT), (Object)"toBuilder is only supported when GrantName has the pattern of projects/{project}/locations/{location}/entitlements/{entitlement}/grants/{grant}");
            this.project = grantName.project;
            this.location = grantName.location;
            this.entitlement = grantName.entitlement;
            this.grant = grantName.grant;
        }

        public GrantName build() {
            return new GrantName(this);
        }
    }
}

