/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.parametermanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ParameterVersionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PARAMETER_PARAMETER_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/parameters/{parameter}/versions/{parameter_version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String parameter;
    private final String parameterVersion;

    @Deprecated
    protected ParameterVersionName() {
        this.project = null;
        this.location = null;
        this.parameter = null;
        this.parameterVersion = null;
    }

    private ParameterVersionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.parameter = (String)Preconditions.checkNotNull((Object)builder.getParameter());
        this.parameterVersion = (String)Preconditions.checkNotNull((Object)builder.getParameterVersion());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String getParameterVersion() {
        return this.parameterVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ParameterVersionName of(String project, String location, String parameter, String parameterVersion) {
        return ParameterVersionName.newBuilder().setProject(project).setLocation(location).setParameter(parameter).setParameterVersion(parameterVersion).build();
    }

    public static String format(String project, String location, String parameter, String parameterVersion) {
        return ParameterVersionName.newBuilder().setProject(project).setLocation(location).setParameter(parameter).setParameterVersion(parameterVersion).build().toString();
    }

    public static ParameterVersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PARAMETER_PARAMETER_VERSION.validatedMatch(formattedString, "ParameterVersionName.parse: formattedString not in valid format");
        return ParameterVersionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("parameter"), (String)matchMap.get("parameter_version"));
    }

    public static List<ParameterVersionName> parseList(List<String> formattedStrings) {
        ArrayList<ParameterVersionName> list = new ArrayList<ParameterVersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ParameterVersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ParameterVersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ParameterVersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PARAMETER_PARAMETER_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ParameterVersionName parameterVersionName = this;
            synchronized (parameterVersionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.parameter != null) {
                        fieldMapBuilder.put((Object)"parameter", (Object)this.parameter);
                    }
                    if (this.parameterVersion != null) {
                        fieldMapBuilder.put((Object)"parameter_version", (Object)this.parameterVersion);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PARAMETER_PARAMETER_VERSION.instantiate(new String[]{"project", this.project, "location", this.location, "parameter", this.parameter, "parameter_version", this.parameterVersion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ParameterVersionName that = (ParameterVersionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.parameter, that.parameter) && Objects.equals(this.parameterVersion, that.parameterVersion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.parameter);
        h *= 1000003;
        return h ^= Objects.hashCode(this.parameterVersion);
    }

    public static class Builder {
        private String project;
        private String location;
        private String parameter;
        private String parameterVersion;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getParameter() {
            return this.parameter;
        }

        public String getParameterVersion() {
            return this.parameterVersion;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setParameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        public Builder setParameterVersion(String parameterVersion) {
            this.parameterVersion = parameterVersion;
            return this;
        }

        private Builder(ParameterVersionName parameterVersionName) {
            this.project = parameterVersionName.project;
            this.location = parameterVersionName.location;
            this.parameter = parameterVersionName.parameter;
            this.parameterVersion = parameterVersionName.parameterVersion;
        }

        public ParameterVersionName build() {
            return new ParameterVersionName(this);
        }
    }
}

