/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.osconfig.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GuestPolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_GUEST_POLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/guestPolicies/{guest_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String guestPolicy;

    @Deprecated
    protected GuestPolicyName() {
        this.project = null;
        this.guestPolicy = null;
    }

    private GuestPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.guestPolicy = (String)Preconditions.checkNotNull((Object)builder.getGuestPolicy());
    }

    public String getProject() {
        return this.project;
    }

    public String getGuestPolicy() {
        return this.guestPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GuestPolicyName of(String project, String guestPolicy) {
        return GuestPolicyName.newBuilder().setProject(project).setGuestPolicy(guestPolicy).build();
    }

    public static String format(String project, String guestPolicy) {
        return GuestPolicyName.newBuilder().setProject(project).setGuestPolicy(guestPolicy).build().toString();
    }

    public static GuestPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_GUEST_POLICY.validatedMatch(formattedString, "GuestPolicyName.parse: formattedString not in valid format");
        return GuestPolicyName.of((String)matchMap.get("project"), (String)matchMap.get("guest_policy"));
    }

    public static List<GuestPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<GuestPolicyName> list = new ArrayList<GuestPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GuestPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GuestPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GuestPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_GUEST_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GuestPolicyName guestPolicyName = this;
            synchronized (guestPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.guestPolicy != null) {
                        fieldMapBuilder.put((Object)"guest_policy", (Object)this.guestPolicy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_GUEST_POLICY.instantiate(new String[]{"project", this.project, "guest_policy", this.guestPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            GuestPolicyName that = (GuestPolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.guestPolicy, that.guestPolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.guestPolicy);
    }

    public static class Builder {
        private String project;
        private String guestPolicy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getGuestPolicy() {
            return this.guestPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setGuestPolicy(String guestPolicy) {
            this.guestPolicy = guestPolicy;
            return this;
        }

        private Builder(GuestPolicyName guestPolicyName) {
            this.project = guestPolicyName.project;
            this.guestPolicy = guestPolicyName.guestPolicy;
        }

        public GuestPolicyName build() {
            return new GuestPolicyName(this);
        }
    }
}

