/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.osconfig.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InstanceOSPoliciesComplianceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INSTANCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/instanceOSPoliciesCompliances/{instance}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String instance;

    @Deprecated
    protected InstanceOSPoliciesComplianceName() {
        this.project = null;
        this.location = null;
        this.instance = null;
    }

    private InstanceOSPoliciesComplianceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInstance() {
        return this.instance;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InstanceOSPoliciesComplianceName of(String project, String location, String instance) {
        return InstanceOSPoliciesComplianceName.newBuilder().setProject(project).setLocation(location).setInstance(instance).build();
    }

    public static String format(String project, String location, String instance) {
        return InstanceOSPoliciesComplianceName.newBuilder().setProject(project).setLocation(location).setInstance(instance).build().toString();
    }

    public static InstanceOSPoliciesComplianceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_INSTANCE.validatedMatch(formattedString, "InstanceOSPoliciesComplianceName.parse: formattedString not in valid format");
        return InstanceOSPoliciesComplianceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("instance"));
    }

    public static List<InstanceOSPoliciesComplianceName> parseList(List<String> formattedStrings) {
        ArrayList<InstanceOSPoliciesComplianceName> list = new ArrayList<InstanceOSPoliciesComplianceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InstanceOSPoliciesComplianceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InstanceOSPoliciesComplianceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InstanceOSPoliciesComplianceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INSTANCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InstanceOSPoliciesComplianceName instanceOSPoliciesComplianceName = this;
            synchronized (instanceOSPoliciesComplianceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_INSTANCE.instantiate(new String[]{"project", this.project, "location", this.location, "instance", this.instance});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            InstanceOSPoliciesComplianceName that = (InstanceOSPoliciesComplianceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.instance, that.instance);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.instance);
    }

    public static class Builder {
        private String project;
        private String location;
        private String instance;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInstance() {
            return this.instance;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        private Builder(InstanceOSPoliciesComplianceName instanceOSPoliciesComplianceName) {
            this.project = instanceOSPoliciesComplianceName.project;
            this.location = instanceOSPoliciesComplianceName.location;
            this.instance = instanceOSPoliciesComplianceName.instance;
        }

        public InstanceOSPoliciesComplianceName build() {
            return new InstanceOSPoliciesComplianceName(this);
        }
    }
}

