/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orgpolicy.v2;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_POLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/policies/{policy}");
    private static final PathTemplate FOLDER_POLICY = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/policies/{policy}");
    private static final PathTemplate ORGANIZATION_POLICY = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/policies/{policy}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String policy;
    private final String folder;
    private final String organization;

    @Deprecated
    protected PolicyName() {
        this.project = null;
        this.policy = null;
        this.folder = null;
        this.organization = null;
    }

    private PolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.policy = (String)Preconditions.checkNotNull((Object)builder.getPolicy());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_POLICY;
    }

    private PolicyName(FolderPolicyBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.policy = (String)Preconditions.checkNotNull((Object)builder.getPolicy());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_POLICY;
    }

    private PolicyName(OrganizationPolicyBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.policy = (String)Preconditions.checkNotNull((Object)builder.getPolicy());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_POLICY;
    }

    public String getProject() {
        return this.project;
    }

    public String getPolicy() {
        return this.policy;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectPolicyBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderPolicyBuilder newFolderPolicyBuilder() {
        return new FolderPolicyBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationPolicyBuilder newOrganizationPolicyBuilder() {
        return new OrganizationPolicyBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PolicyName of(String project, String policy) {
        return PolicyName.newBuilder().setProject(project).setPolicy(policy).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static PolicyName ofProjectPolicyName(String project, String policy) {
        return PolicyName.newBuilder().setProject(project).setPolicy(policy).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static PolicyName ofFolderPolicyName(String folder, String policy) {
        return PolicyName.newFolderPolicyBuilder().setFolder(folder).setPolicy(policy).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static PolicyName ofOrganizationPolicyName(String organization, String policy) {
        return PolicyName.newOrganizationPolicyBuilder().setOrganization(organization).setPolicy(policy).build();
    }

    public static String format(String project, String policy) {
        return PolicyName.newBuilder().setProject(project).setPolicy(policy).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectPolicyName(String project, String policy) {
        return PolicyName.newBuilder().setProject(project).setPolicy(policy).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderPolicyName(String folder, String policy) {
        return PolicyName.newFolderPolicyBuilder().setFolder(folder).setPolicy(policy).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationPolicyName(String organization, String policy) {
        return PolicyName.newOrganizationPolicyBuilder().setOrganization(organization).setPolicy(policy).build().toString();
    }

    public static PolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_POLICY.matches(formattedString)) {
            Map matchMap = PROJECT_POLICY.match(formattedString);
            return PolicyName.ofProjectPolicyName((String)matchMap.get("project"), (String)matchMap.get("policy"));
        }
        if (FOLDER_POLICY.matches(formattedString)) {
            Map matchMap = FOLDER_POLICY.match(formattedString);
            return PolicyName.ofFolderPolicyName((String)matchMap.get("folder"), (String)matchMap.get("policy"));
        }
        if (ORGANIZATION_POLICY.matches(formattedString)) {
            Map matchMap = ORGANIZATION_POLICY.match(formattedString);
            return PolicyName.ofOrganizationPolicyName((String)matchMap.get("organization"), (String)matchMap.get("policy"));
        }
        throw new ValidationException("PolicyName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<PolicyName> parseList(List<String> formattedStrings) {
        ArrayList<PolicyName> list = new ArrayList<PolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_POLICY.matches(formattedString) || FOLDER_POLICY.matches(formattedString) || ORGANIZATION_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PolicyName policyName = this;
            synchronized (policyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.policy != null) {
                        fieldMapBuilder.put((Object)"policy", (Object)this.policy);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PolicyName that = (PolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.policy, that.policy) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.policy);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationPolicyBuilder {
        private String organization;
        private String policy;

        protected OrganizationPolicyBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getPolicy() {
            return this.policy;
        }

        public OrganizationPolicyBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationPolicyBuilder setPolicy(String policy) {
            this.policy = policy;
            return this;
        }

        public PolicyName build() {
            return new PolicyName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderPolicyBuilder {
        private String folder;
        private String policy;

        protected FolderPolicyBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getPolicy() {
            return this.policy;
        }

        public FolderPolicyBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderPolicyBuilder setPolicy(String policy) {
            this.policy = policy;
            return this;
        }

        public PolicyName build() {
            return new PolicyName(this);
        }
    }

    public static class Builder {
        private String project;
        private String policy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getPolicy() {
            return this.policy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setPolicy(String policy) {
            this.policy = policy;
            return this;
        }

        private Builder(PolicyName policyName) {
            Preconditions.checkArgument((boolean)Objects.equals(policyName.pathTemplate, PROJECT_POLICY), (Object)"toBuilder is only supported when PolicyName has the pattern of projects/{project}/policies/{policy}");
            this.project = policyName.project;
            this.policy = policyName.policy;
        }

        public PolicyName build() {
            return new PolicyName(this);
        }
    }
}

