/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1alpha1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InterconnectAttachmentName
implements ResourceName {
    private static final PathTemplate PROJECT_REGION_RESOURCE_ID = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/interconnectAttachments/{resource_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String region;
    private final String resourceId;

    @Deprecated
    protected InterconnectAttachmentName() {
        this.project = null;
        this.region = null;
        this.resourceId = null;
    }

    private InterconnectAttachmentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.resourceId = (String)Preconditions.checkNotNull((Object)builder.getResourceId());
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InterconnectAttachmentName of(String project, String region, String resourceId) {
        return InterconnectAttachmentName.newBuilder().setProject(project).setRegion(region).setResourceId(resourceId).build();
    }

    public static String format(String project, String region, String resourceId) {
        return InterconnectAttachmentName.newBuilder().setProject(project).setRegion(region).setResourceId(resourceId).build().toString();
    }

    public static InterconnectAttachmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_REGION_RESOURCE_ID.validatedMatch(formattedString, "InterconnectAttachmentName.parse: formattedString not in valid format");
        return InterconnectAttachmentName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("resource_id"));
    }

    public static List<InterconnectAttachmentName> parseList(List<String> formattedStrings) {
        ArrayList<InterconnectAttachmentName> list = new ArrayList<InterconnectAttachmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InterconnectAttachmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InterconnectAttachmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InterconnectAttachmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_REGION_RESOURCE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InterconnectAttachmentName interconnectAttachmentName = this;
            synchronized (interconnectAttachmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.region != null) {
                        fieldMapBuilder.put((Object)"region", (Object)this.region);
                    }
                    if (this.resourceId != null) {
                        fieldMapBuilder.put((Object)"resource_id", (Object)this.resourceId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_REGION_RESOURCE_ID.instantiate(new String[]{"project", this.project, "region", this.region, "resource_id", this.resourceId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            InterconnectAttachmentName that = (InterconnectAttachmentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.region, that.region) && Objects.equals(this.resourceId, that.resourceId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.region);
        h *= 1000003;
        return h ^= Objects.hashCode(this.resourceId);
    }

    public static class Builder {
        private String project;
        private String region;
        private String resourceId;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setResourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        private Builder(InterconnectAttachmentName interconnectAttachmentName) {
            this.project = interconnectAttachmentName.project;
            this.region = interconnectAttachmentName.region;
            this.resourceId = interconnectAttachmentName.resourceId;
        }

        public InterconnectAttachmentName build() {
            return new InterconnectAttachmentName(this);
        }
    }
}

