/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceClassName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SERVICE_CLASS = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/serviceClasses/{service_class}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String serviceClass;

    @Deprecated
    protected ServiceClassName() {
        this.project = null;
        this.location = null;
        this.serviceClass = null;
    }

    private ServiceClassName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.serviceClass = (String)Preconditions.checkNotNull((Object)builder.getServiceClass());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServiceClassName of(String project, String location, String serviceClass) {
        return ServiceClassName.newBuilder().setProject(project).setLocation(location).setServiceClass(serviceClass).build();
    }

    public static String format(String project, String location, String serviceClass) {
        return ServiceClassName.newBuilder().setProject(project).setLocation(location).setServiceClass(serviceClass).build().toString();
    }

    public static ServiceClassName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SERVICE_CLASS.validatedMatch(formattedString, "ServiceClassName.parse: formattedString not in valid format");
        return ServiceClassName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("service_class"));
    }

    public static List<ServiceClassName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceClassName> list = new ArrayList<ServiceClassName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceClassName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceClassName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceClassName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SERVICE_CLASS.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceClassName serviceClassName = this;
            synchronized (serviceClassName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.serviceClass != null) {
                        fieldMapBuilder.put((Object)"service_class", (Object)this.serviceClass);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SERVICE_CLASS.instantiate(new String[]{"project", this.project, "location", this.location, "service_class", this.serviceClass});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ServiceClassName that = (ServiceClassName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.serviceClass, that.serviceClass);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.serviceClass);
    }

    public static class Builder {
        private String project;
        private String location;
        private String serviceClass;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getServiceClass() {
            return this.serviceClass;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setServiceClass(String serviceClass) {
            this.serviceClass = serviceClass;
            return this;
        }

        private Builder(ServiceClassName serviceClassName) {
            this.project = serviceClassName.project;
            this.location = serviceClassName.location;
            this.serviceClass = serviceClassName.serviceClass;
        }

        public ServiceClassName build() {
            return new ServiceClassName(this);
        }
    }
}

