/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HubRouteName
implements ResourceName {
    private static final PathTemplate PROJECT_HUB_ROUTE_TABLE_ROUTE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/global/hubs/{hub}/routeTables/{route_table}/routes/{route}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String hub;
    private final String routeTable;
    private final String route;

    @Deprecated
    protected HubRouteName() {
        this.project = null;
        this.hub = null;
        this.routeTable = null;
        this.route = null;
    }

    private HubRouteName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.hub = (String)Preconditions.checkNotNull((Object)builder.getHub());
        this.routeTable = (String)Preconditions.checkNotNull((Object)builder.getRouteTable());
        this.route = (String)Preconditions.checkNotNull((Object)builder.getRoute());
    }

    public String getProject() {
        return this.project;
    }

    public String getHub() {
        return this.hub;
    }

    public String getRouteTable() {
        return this.routeTable;
    }

    public String getRoute() {
        return this.route;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static HubRouteName of(String project, String hub, String routeTable, String route) {
        return HubRouteName.newBuilder().setProject(project).setHub(hub).setRouteTable(routeTable).setRoute(route).build();
    }

    public static String format(String project, String hub, String routeTable, String route) {
        return HubRouteName.newBuilder().setProject(project).setHub(hub).setRouteTable(routeTable).setRoute(route).build().toString();
    }

    public static HubRouteName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_HUB_ROUTE_TABLE_ROUTE.validatedMatch(formattedString, "HubRouteName.parse: formattedString not in valid format");
        return HubRouteName.of((String)matchMap.get("project"), (String)matchMap.get("hub"), (String)matchMap.get("route_table"), (String)matchMap.get("route"));
    }

    public static List<HubRouteName> parseList(List<String> formattedStrings) {
        ArrayList<HubRouteName> list = new ArrayList<HubRouteName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(HubRouteName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<HubRouteName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (HubRouteName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_HUB_ROUTE_TABLE_ROUTE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            HubRouteName hubRouteName = this;
            synchronized (hubRouteName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.hub != null) {
                        fieldMapBuilder.put((Object)"hub", (Object)this.hub);
                    }
                    if (this.routeTable != null) {
                        fieldMapBuilder.put((Object)"route_table", (Object)this.routeTable);
                    }
                    if (this.route != null) {
                        fieldMapBuilder.put((Object)"route", (Object)this.route);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_HUB_ROUTE_TABLE_ROUTE.instantiate(new String[]{"project", this.project, "hub", this.hub, "route_table", this.routeTable, "route", this.route});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            HubRouteName that = (HubRouteName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.hub, that.hub) && Objects.equals(this.routeTable, that.routeTable) && Objects.equals(this.route, that.route);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.hub);
        h *= 1000003;
        h ^= Objects.hashCode(this.routeTable);
        h *= 1000003;
        return h ^= Objects.hashCode(this.route);
    }

    public static class Builder {
        private String project;
        private String hub;
        private String routeTable;
        private String route;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getHub() {
            return this.hub;
        }

        public String getRouteTable() {
            return this.routeTable;
        }

        public String getRoute() {
            return this.route;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setHub(String hub) {
            this.hub = hub;
            return this;
        }

        public Builder setRouteTable(String routeTable) {
            this.routeTable = routeTable;
            return this;
        }

        public Builder setRoute(String route) {
            this.route = route;
            return this;
        }

        private Builder(HubRouteName hubRouteName) {
            this.project = hubRouteName.project;
            this.hub = hubRouteName.hub;
            this.routeTable = hubRouteName.routeTable;
            this.route = hubRouteName.route;
        }

        public HubRouteName build() {
            return new HubRouteName(this);
        }
    }
}

