/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GroupName
implements ResourceName {
    private static final PathTemplate PROJECT_HUB_GROUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/global/hubs/{hub}/groups/{group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String hub;
    private final String group;

    @Deprecated
    protected GroupName() {
        this.project = null;
        this.hub = null;
        this.group = null;
    }

    private GroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.hub = (String)Preconditions.checkNotNull((Object)builder.getHub());
        this.group = (String)Preconditions.checkNotNull((Object)builder.getGroup());
    }

    public String getProject() {
        return this.project;
    }

    public String getHub() {
        return this.hub;
    }

    public String getGroup() {
        return this.group;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GroupName of(String project, String hub, String group) {
        return GroupName.newBuilder().setProject(project).setHub(hub).setGroup(group).build();
    }

    public static String format(String project, String hub, String group) {
        return GroupName.newBuilder().setProject(project).setHub(hub).setGroup(group).build().toString();
    }

    public static GroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_HUB_GROUP.validatedMatch(formattedString, "GroupName.parse: formattedString not in valid format");
        return GroupName.of((String)matchMap.get("project"), (String)matchMap.get("hub"), (String)matchMap.get("group"));
    }

    public static List<GroupName> parseList(List<String> formattedStrings) {
        ArrayList<GroupName> list = new ArrayList<GroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_HUB_GROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GroupName groupName = this;
            synchronized (groupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.hub != null) {
                        fieldMapBuilder.put((Object)"hub", (Object)this.hub);
                    }
                    if (this.group != null) {
                        fieldMapBuilder.put((Object)"group", (Object)this.group);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_HUB_GROUP.instantiate(new String[]{"project", this.project, "hub", this.hub, "group", this.group});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GroupName that = (GroupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.hub, that.hub) && Objects.equals(this.group, that.group);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.hub);
        h *= 1000003;
        return h ^= Objects.hashCode(this.group);
    }

    public static class Builder {
        private String project;
        private String hub;
        private String group;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getHub() {
            return this.hub;
        }

        public String getGroup() {
            return this.group;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setHub(String hub) {
            this.hub = hub;
            return this;
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        private Builder(GroupName groupName) {
            this.project = groupName.project;
            this.hub = groupName.hub;
            this.group = groupName.group;
        }

        public GroupName build() {
            return new GroupName(this);
        }
    }
}

