/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkmanagement.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VpcFlowLogsConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_VPC_FLOW_LOGS_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/vpcFlowLogsConfigs/{vpc_flow_logs_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String vpcFlowLogsConfig;

    @Deprecated
    protected VpcFlowLogsConfigName() {
        this.project = null;
        this.location = null;
        this.vpcFlowLogsConfig = null;
    }

    private VpcFlowLogsConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.vpcFlowLogsConfig = (String)Preconditions.checkNotNull((Object)builder.getVpcFlowLogsConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVpcFlowLogsConfig() {
        return this.vpcFlowLogsConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VpcFlowLogsConfigName of(String project, String location, String vpcFlowLogsConfig) {
        return VpcFlowLogsConfigName.newBuilder().setProject(project).setLocation(location).setVpcFlowLogsConfig(vpcFlowLogsConfig).build();
    }

    public static String format(String project, String location, String vpcFlowLogsConfig) {
        return VpcFlowLogsConfigName.newBuilder().setProject(project).setLocation(location).setVpcFlowLogsConfig(vpcFlowLogsConfig).build().toString();
    }

    public static VpcFlowLogsConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_VPC_FLOW_LOGS_CONFIG.validatedMatch(formattedString, "VpcFlowLogsConfigName.parse: formattedString not in valid format");
        return VpcFlowLogsConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("vpc_flow_logs_config"));
    }

    public static List<VpcFlowLogsConfigName> parseList(List<String> formattedStrings) {
        ArrayList<VpcFlowLogsConfigName> list = new ArrayList<VpcFlowLogsConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VpcFlowLogsConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VpcFlowLogsConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VpcFlowLogsConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_VPC_FLOW_LOGS_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VpcFlowLogsConfigName vpcFlowLogsConfigName = this;
            synchronized (vpcFlowLogsConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.vpcFlowLogsConfig != null) {
                        fieldMapBuilder.put((Object)"vpc_flow_logs_config", (Object)this.vpcFlowLogsConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_VPC_FLOW_LOGS_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "vpc_flow_logs_config", this.vpcFlowLogsConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            VpcFlowLogsConfigName that = (VpcFlowLogsConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.vpcFlowLogsConfig, that.vpcFlowLogsConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.vpcFlowLogsConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String vpcFlowLogsConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getVpcFlowLogsConfig() {
            return this.vpcFlowLogsConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setVpcFlowLogsConfig(String vpcFlowLogsConfig) {
            this.vpcFlowLogsConfig = vpcFlowLogsConfig;
            return this;
        }

        private Builder(VpcFlowLogsConfigName vpcFlowLogsConfigName) {
            this.project = vpcFlowLogsConfigName.project;
            this.location = vpcFlowLogsConfigName.location;
            this.vpcFlowLogsConfig = vpcFlowLogsConfigName.vpcFlowLogsConfig;
        }

        public VpcFlowLogsConfigName build() {
            return new VpcFlowLogsConfigName(this);
        }
    }
}

