/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkmanagement.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConnectivityTestName
implements ResourceName {
    private static final PathTemplate PROJECT_TEST = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/global/connectivityTests/{test}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String test;

    @Deprecated
    protected ConnectivityTestName() {
        this.project = null;
        this.test = null;
    }

    private ConnectivityTestName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.test = (String)Preconditions.checkNotNull((Object)builder.getTest());
    }

    public String getProject() {
        return this.project;
    }

    public String getTest() {
        return this.test;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConnectivityTestName of(String project, String test) {
        return ConnectivityTestName.newBuilder().setProject(project).setTest(test).build();
    }

    public static String format(String project, String test) {
        return ConnectivityTestName.newBuilder().setProject(project).setTest(test).build().toString();
    }

    public static ConnectivityTestName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_TEST.validatedMatch(formattedString, "ConnectivityTestName.parse: formattedString not in valid format");
        return ConnectivityTestName.of((String)matchMap.get("project"), (String)matchMap.get("test"));
    }

    public static List<ConnectivityTestName> parseList(List<String> formattedStrings) {
        ArrayList<ConnectivityTestName> list = new ArrayList<ConnectivityTestName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConnectivityTestName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConnectivityTestName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConnectivityTestName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_TEST.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConnectivityTestName connectivityTestName = this;
            synchronized (connectivityTestName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.test != null) {
                        fieldMapBuilder.put((Object)"test", (Object)this.test);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_TEST.instantiate(new String[]{"project", this.project, "test", this.test});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConnectivityTestName that = (ConnectivityTestName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.test, that.test);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.test);
    }

    public static class Builder {
        private String project;
        private String test;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getTest() {
            return this.test;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTest(String test) {
            this.test = test;
            return this;
        }

        private Builder(ConnectivityTestName connectivityTestName) {
            this.project = connectivityTestName.project;
            this.test = connectivityTestName.test;
        }

        public ConnectivityTestName build() {
            return new ConnectivityTestName(this);
        }
    }
}

