/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.netapp.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VolumeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_VOLUME = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/volumes/{volume}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String volume;

    @Deprecated
    protected VolumeName() {
        this.project = null;
        this.location = null;
        this.volume = null;
    }

    private VolumeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.volume = (String)Preconditions.checkNotNull((Object)builder.getVolume());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVolume() {
        return this.volume;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VolumeName of(String project, String location, String volume) {
        return VolumeName.newBuilder().setProject(project).setLocation(location).setVolume(volume).build();
    }

    public static String format(String project, String location, String volume) {
        return VolumeName.newBuilder().setProject(project).setLocation(location).setVolume(volume).build().toString();
    }

    public static VolumeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_VOLUME.validatedMatch(formattedString, "VolumeName.parse: formattedString not in valid format");
        return VolumeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("volume"));
    }

    public static List<VolumeName> parseList(List<String> formattedStrings) {
        ArrayList<VolumeName> list = new ArrayList<VolumeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VolumeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VolumeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VolumeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_VOLUME.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VolumeName volumeName = this;
            synchronized (volumeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.volume != null) {
                        fieldMapBuilder.put((Object)"volume", (Object)this.volume);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_VOLUME.instantiate(new String[]{"project", this.project, "location", this.location, "volume", this.volume});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            VolumeName that = (VolumeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.volume, that.volume);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.volume);
    }

    public static class Builder {
        private String project;
        private String location;
        private String volume;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getVolume() {
            return this.volume;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setVolume(String volume) {
            this.volume = volume;
            return this;
        }

        private Builder(VolumeName volumeName) {
            this.project = volumeName.project;
            this.location = volumeName.location;
            this.volume = volumeName.volume;
        }

        public VolumeName build() {
            return new VolumeName(this);
        }
    }
}

