/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.netapp.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KmsConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_KMS_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/kmsConfigs/{kms_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String kmsConfig;

    @Deprecated
    protected KmsConfigName() {
        this.project = null;
        this.location = null;
        this.kmsConfig = null;
    }

    private KmsConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.kmsConfig = (String)Preconditions.checkNotNull((Object)builder.getKmsConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getKmsConfig() {
        return this.kmsConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static KmsConfigName of(String project, String location, String kmsConfig) {
        return KmsConfigName.newBuilder().setProject(project).setLocation(location).setKmsConfig(kmsConfig).build();
    }

    public static String format(String project, String location, String kmsConfig) {
        return KmsConfigName.newBuilder().setProject(project).setLocation(location).setKmsConfig(kmsConfig).build().toString();
    }

    public static KmsConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_KMS_CONFIG.validatedMatch(formattedString, "KmsConfigName.parse: formattedString not in valid format");
        return KmsConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("kms_config"));
    }

    public static List<KmsConfigName> parseList(List<String> formattedStrings) {
        ArrayList<KmsConfigName> list = new ArrayList<KmsConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KmsConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KmsConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KmsConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_KMS_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KmsConfigName kmsConfigName = this;
            synchronized (kmsConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.kmsConfig != null) {
                        fieldMapBuilder.put((Object)"kms_config", (Object)this.kmsConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_KMS_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "kms_config", this.kmsConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            KmsConfigName that = (KmsConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.kmsConfig, that.kmsConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.kmsConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String kmsConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getKmsConfig() {
            return this.kmsConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setKmsConfig(String kmsConfig) {
            this.kmsConfig = kmsConfig;
            return this;
        }

        private Builder(KmsConfigName kmsConfigName) {
            this.project = kmsConfigName.project;
            this.location = kmsConfigName.location;
            this.kmsConfig = kmsConfigName.kmsConfig;
        }

        public KmsConfigName build() {
            return new KmsConfigName(this);
        }
    }
}

