/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.netapp.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class StoragePoolName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_STORAGE_POOL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/storagePools/{storage_pool}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String storagePool;

    @Deprecated
    protected StoragePoolName() {
        this.project = null;
        this.location = null;
        this.storagePool = null;
    }

    private StoragePoolName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.storagePool = (String)Preconditions.checkNotNull((Object)builder.getStoragePool());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getStoragePool() {
        return this.storagePool;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static StoragePoolName of(String project, String location, String storagePool) {
        return StoragePoolName.newBuilder().setProject(project).setLocation(location).setStoragePool(storagePool).build();
    }

    public static String format(String project, String location, String storagePool) {
        return StoragePoolName.newBuilder().setProject(project).setLocation(location).setStoragePool(storagePool).build().toString();
    }

    public static StoragePoolName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_STORAGE_POOL.validatedMatch(formattedString, "StoragePoolName.parse: formattedString not in valid format");
        return StoragePoolName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("storage_pool"));
    }

    public static List<StoragePoolName> parseList(List<String> formattedStrings) {
        ArrayList<StoragePoolName> list = new ArrayList<StoragePoolName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(StoragePoolName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<StoragePoolName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (StoragePoolName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_STORAGE_POOL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            StoragePoolName storagePoolName = this;
            synchronized (storagePoolName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.storagePool != null) {
                        fieldMapBuilder.put((Object)"storage_pool", (Object)this.storagePool);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_STORAGE_POOL.instantiate(new String[]{"project", this.project, "location", this.location, "storage_pool", this.storagePool});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            StoragePoolName that = (StoragePoolName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.storagePool, that.storagePool);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.storagePool);
    }

    public static class Builder {
        private String project;
        private String location;
        private String storagePool;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getStoragePool() {
            return this.storagePool;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setStoragePool(String storagePool) {
            this.storagePool = storagePool;
            return this;
        }

        private Builder(StoragePoolName storagePoolName) {
            this.project = storagePoolName.project;
            this.location = storagePoolName.location;
            this.storagePool = storagePoolName.storagePool;
        }

        public StoragePoolName build() {
            return new StoragePoolName(this);
        }
    }
}

