/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.migrationcenter.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PreferenceSetName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PREFERENCE_SET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/preferenceSets/{preference_set}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String preferenceSet;

    @Deprecated
    protected PreferenceSetName() {
        this.project = null;
        this.location = null;
        this.preferenceSet = null;
    }

    private PreferenceSetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.preferenceSet = (String)Preconditions.checkNotNull((Object)builder.getPreferenceSet());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPreferenceSet() {
        return this.preferenceSet;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PreferenceSetName of(String project, String location, String preferenceSet) {
        return PreferenceSetName.newBuilder().setProject(project).setLocation(location).setPreferenceSet(preferenceSet).build();
    }

    public static String format(String project, String location, String preferenceSet) {
        return PreferenceSetName.newBuilder().setProject(project).setLocation(location).setPreferenceSet(preferenceSet).build().toString();
    }

    public static PreferenceSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PREFERENCE_SET.validatedMatch(formattedString, "PreferenceSetName.parse: formattedString not in valid format");
        return PreferenceSetName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("preference_set"));
    }

    public static List<PreferenceSetName> parseList(List<String> formattedStrings) {
        ArrayList<PreferenceSetName> list = new ArrayList<PreferenceSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PreferenceSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PreferenceSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PreferenceSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PREFERENCE_SET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PreferenceSetName preferenceSetName = this;
            synchronized (preferenceSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.preferenceSet != null) {
                        fieldMapBuilder.put((Object)"preference_set", (Object)this.preferenceSet);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PREFERENCE_SET.instantiate(new String[]{"project", this.project, "location", this.location, "preference_set", this.preferenceSet});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PreferenceSetName that = (PreferenceSetName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.preferenceSet, that.preferenceSet);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.preferenceSet);
    }

    public static class Builder {
        private String project;
        private String location;
        private String preferenceSet;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPreferenceSet() {
            return this.preferenceSet;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPreferenceSet(String preferenceSet) {
            this.preferenceSet = preferenceSet;
            return this;
        }

        private Builder(PreferenceSetName preferenceSetName) {
            this.project = preferenceSetName.project;
            this.location = preferenceSetName.location;
            this.preferenceSet = preferenceSetName.preferenceSet;
        }

        public PreferenceSetName build() {
            return new PreferenceSetName(this);
        }
    }
}

