/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.migrationcenter.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ImportDataFileName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_IMPORT_JOB_IMPORT_DATA_FILE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/importJobs/{import_job}/importDataFiles/{import_data_file}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String importJob;
    private final String importDataFile;

    @Deprecated
    protected ImportDataFileName() {
        this.project = null;
        this.location = null;
        this.importJob = null;
        this.importDataFile = null;
    }

    private ImportDataFileName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.importJob = (String)Preconditions.checkNotNull((Object)builder.getImportJob());
        this.importDataFile = (String)Preconditions.checkNotNull((Object)builder.getImportDataFile());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getImportJob() {
        return this.importJob;
    }

    public String getImportDataFile() {
        return this.importDataFile;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ImportDataFileName of(String project, String location, String importJob, String importDataFile) {
        return ImportDataFileName.newBuilder().setProject(project).setLocation(location).setImportJob(importJob).setImportDataFile(importDataFile).build();
    }

    public static String format(String project, String location, String importJob, String importDataFile) {
        return ImportDataFileName.newBuilder().setProject(project).setLocation(location).setImportJob(importJob).setImportDataFile(importDataFile).build().toString();
    }

    public static ImportDataFileName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_IMPORT_JOB_IMPORT_DATA_FILE.validatedMatch(formattedString, "ImportDataFileName.parse: formattedString not in valid format");
        return ImportDataFileName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("import_job"), (String)matchMap.get("import_data_file"));
    }

    public static List<ImportDataFileName> parseList(List<String> formattedStrings) {
        ArrayList<ImportDataFileName> list = new ArrayList<ImportDataFileName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ImportDataFileName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ImportDataFileName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ImportDataFileName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_IMPORT_JOB_IMPORT_DATA_FILE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ImportDataFileName importDataFileName = this;
            synchronized (importDataFileName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.importJob != null) {
                        fieldMapBuilder.put((Object)"import_job", (Object)this.importJob);
                    }
                    if (this.importDataFile != null) {
                        fieldMapBuilder.put((Object)"import_data_file", (Object)this.importDataFile);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_IMPORT_JOB_IMPORT_DATA_FILE.instantiate(new String[]{"project", this.project, "location", this.location, "import_job", this.importJob, "import_data_file", this.importDataFile});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ImportDataFileName that = (ImportDataFileName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.importJob, that.importJob) && Objects.equals(this.importDataFile, that.importDataFile);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.importJob);
        h *= 1000003;
        return h ^= Objects.hashCode(this.importDataFile);
    }

    public static class Builder {
        private String project;
        private String location;
        private String importJob;
        private String importDataFile;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getImportJob() {
            return this.importJob;
        }

        public String getImportDataFile() {
            return this.importDataFile;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setImportJob(String importJob) {
            this.importJob = importJob;
            return this;
        }

        public Builder setImportDataFile(String importDataFile) {
            this.importDataFile = importDataFile;
            return this;
        }

        private Builder(ImportDataFileName importDataFileName) {
            this.project = importDataFileName.project;
            this.location = importDataFileName.location;
            this.importJob = importDataFileName.importJob;
            this.importDataFile = importDataFileName.importDataFile;
        }

        public ImportDataFileName build() {
            return new ImportDataFileName(this);
        }
    }
}

