/*
 * Decompiled with CFR 0.152.
 */
package com.google.apps.meet.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RecordingName
implements ResourceName {
    private static final PathTemplate CONFERENCE_RECORD_RECORDING = PathTemplate.createWithoutUrlEncoding((String)"conferenceRecords/{conference_record}/recordings/{recording}");
    private volatile Map<String, String> fieldValuesMap;
    private final String conferenceRecord;
    private final String recording;

    @Deprecated
    protected RecordingName() {
        this.conferenceRecord = null;
        this.recording = null;
    }

    private RecordingName(Builder builder) {
        this.conferenceRecord = (String)Preconditions.checkNotNull((Object)builder.getConferenceRecord());
        this.recording = (String)Preconditions.checkNotNull((Object)builder.getRecording());
    }

    public String getConferenceRecord() {
        return this.conferenceRecord;
    }

    public String getRecording() {
        return this.recording;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RecordingName of(String conferenceRecord, String recording) {
        return RecordingName.newBuilder().setConferenceRecord(conferenceRecord).setRecording(recording).build();
    }

    public static String format(String conferenceRecord, String recording) {
        return RecordingName.newBuilder().setConferenceRecord(conferenceRecord).setRecording(recording).build().toString();
    }

    public static RecordingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CONFERENCE_RECORD_RECORDING.validatedMatch(formattedString, "RecordingName.parse: formattedString not in valid format");
        return RecordingName.of((String)matchMap.get("conference_record"), (String)matchMap.get("recording"));
    }

    public static List<RecordingName> parseList(List<String> formattedStrings) {
        ArrayList<RecordingName> list = new ArrayList<RecordingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RecordingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RecordingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RecordingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CONFERENCE_RECORD_RECORDING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RecordingName recordingName = this;
            synchronized (recordingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.conferenceRecord != null) {
                        fieldMapBuilder.put((Object)"conference_record", (Object)this.conferenceRecord);
                    }
                    if (this.recording != null) {
                        fieldMapBuilder.put((Object)"recording", (Object)this.recording);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CONFERENCE_RECORD_RECORDING.instantiate(new String[]{"conference_record", this.conferenceRecord, "recording", this.recording});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RecordingName that = (RecordingName)o;
            return Objects.equals(this.conferenceRecord, that.conferenceRecord) && Objects.equals(this.recording, that.recording);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.conferenceRecord);
        h *= 1000003;
        return h ^= Objects.hashCode(this.recording);
    }

    public static class Builder {
        private String conferenceRecord;
        private String recording;

        protected Builder() {
        }

        public String getConferenceRecord() {
            return this.conferenceRecord;
        }

        public String getRecording() {
            return this.recording;
        }

        public Builder setConferenceRecord(String conferenceRecord) {
            this.conferenceRecord = conferenceRecord;
            return this;
        }

        public Builder setRecording(String recording) {
            this.recording = recording;
            return this;
        }

        private Builder(RecordingName recordingName) {
            this.conferenceRecord = recordingName.conferenceRecord;
            this.recording = recordingName.recording;
        }

        public RecordingName build() {
            return new RecordingName(this);
        }
    }
}

