/*
 * Decompiled with CFR 0.152.
 */
package com.google.apps.meet.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TranscriptName
implements ResourceName {
    private static final PathTemplate CONFERENCE_RECORD_TRANSCRIPT = PathTemplate.createWithoutUrlEncoding((String)"conferenceRecords/{conference_record}/transcripts/{transcript}");
    private volatile Map<String, String> fieldValuesMap;
    private final String conferenceRecord;
    private final String transcript;

    @Deprecated
    protected TranscriptName() {
        this.conferenceRecord = null;
        this.transcript = null;
    }

    private TranscriptName(Builder builder) {
        this.conferenceRecord = (String)Preconditions.checkNotNull((Object)builder.getConferenceRecord());
        this.transcript = (String)Preconditions.checkNotNull((Object)builder.getTranscript());
    }

    public String getConferenceRecord() {
        return this.conferenceRecord;
    }

    public String getTranscript() {
        return this.transcript;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TranscriptName of(String conferenceRecord, String transcript) {
        return TranscriptName.newBuilder().setConferenceRecord(conferenceRecord).setTranscript(transcript).build();
    }

    public static String format(String conferenceRecord, String transcript) {
        return TranscriptName.newBuilder().setConferenceRecord(conferenceRecord).setTranscript(transcript).build().toString();
    }

    public static TranscriptName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CONFERENCE_RECORD_TRANSCRIPT.validatedMatch(formattedString, "TranscriptName.parse: formattedString not in valid format");
        return TranscriptName.of((String)matchMap.get("conference_record"), (String)matchMap.get("transcript"));
    }

    public static List<TranscriptName> parseList(List<String> formattedStrings) {
        ArrayList<TranscriptName> list = new ArrayList<TranscriptName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TranscriptName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TranscriptName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TranscriptName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CONFERENCE_RECORD_TRANSCRIPT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TranscriptName transcriptName = this;
            synchronized (transcriptName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.conferenceRecord != null) {
                        fieldMapBuilder.put((Object)"conference_record", (Object)this.conferenceRecord);
                    }
                    if (this.transcript != null) {
                        fieldMapBuilder.put((Object)"transcript", (Object)this.transcript);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CONFERENCE_RECORD_TRANSCRIPT.instantiate(new String[]{"conference_record", this.conferenceRecord, "transcript", this.transcript});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TranscriptName that = (TranscriptName)o;
            return Objects.equals(this.conferenceRecord, that.conferenceRecord) && Objects.equals(this.transcript, that.transcript);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.conferenceRecord);
        h *= 1000003;
        return h ^= Objects.hashCode(this.transcript);
    }

    public static class Builder {
        private String conferenceRecord;
        private String transcript;

        protected Builder() {
        }

        public String getConferenceRecord() {
            return this.conferenceRecord;
        }

        public String getTranscript() {
            return this.transcript;
        }

        public Builder setConferenceRecord(String conferenceRecord) {
            this.conferenceRecord = conferenceRecord;
            return this;
        }

        public Builder setTranscript(String transcript) {
            this.transcript = transcript;
            return this;
        }

        private Builder(TranscriptName transcriptName) {
            this.conferenceRecord = transcriptName.conferenceRecord;
            this.transcript = transcriptName.transcript;
        }

        public TranscriptName build() {
            return new TranscriptName(this);
        }
    }
}

