/*
 * Decompiled with CFR 0.152.
 */
package com.google.apps.meet.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TranscriptEntryName
implements ResourceName {
    private static final PathTemplate CONFERENCE_RECORD_TRANSCRIPT_ENTRY = PathTemplate.createWithoutUrlEncoding((String)"conferenceRecords/{conference_record}/transcripts/{transcript}/entries/{entry}");
    private volatile Map<String, String> fieldValuesMap;
    private final String conferenceRecord;
    private final String transcript;
    private final String entry;

    @Deprecated
    protected TranscriptEntryName() {
        this.conferenceRecord = null;
        this.transcript = null;
        this.entry = null;
    }

    private TranscriptEntryName(Builder builder) {
        this.conferenceRecord = (String)Preconditions.checkNotNull((Object)builder.getConferenceRecord());
        this.transcript = (String)Preconditions.checkNotNull((Object)builder.getTranscript());
        this.entry = (String)Preconditions.checkNotNull((Object)builder.getEntry());
    }

    public String getConferenceRecord() {
        return this.conferenceRecord;
    }

    public String getTranscript() {
        return this.transcript;
    }

    public String getEntry() {
        return this.entry;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TranscriptEntryName of(String conferenceRecord, String transcript, String entry) {
        return TranscriptEntryName.newBuilder().setConferenceRecord(conferenceRecord).setTranscript(transcript).setEntry(entry).build();
    }

    public static String format(String conferenceRecord, String transcript, String entry) {
        return TranscriptEntryName.newBuilder().setConferenceRecord(conferenceRecord).setTranscript(transcript).setEntry(entry).build().toString();
    }

    public static TranscriptEntryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CONFERENCE_RECORD_TRANSCRIPT_ENTRY.validatedMatch(formattedString, "TranscriptEntryName.parse: formattedString not in valid format");
        return TranscriptEntryName.of((String)matchMap.get("conference_record"), (String)matchMap.get("transcript"), (String)matchMap.get("entry"));
    }

    public static List<TranscriptEntryName> parseList(List<String> formattedStrings) {
        ArrayList<TranscriptEntryName> list = new ArrayList<TranscriptEntryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TranscriptEntryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TranscriptEntryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TranscriptEntryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CONFERENCE_RECORD_TRANSCRIPT_ENTRY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TranscriptEntryName transcriptEntryName = this;
            synchronized (transcriptEntryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.conferenceRecord != null) {
                        fieldMapBuilder.put((Object)"conference_record", (Object)this.conferenceRecord);
                    }
                    if (this.transcript != null) {
                        fieldMapBuilder.put((Object)"transcript", (Object)this.transcript);
                    }
                    if (this.entry != null) {
                        fieldMapBuilder.put((Object)"entry", (Object)this.entry);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CONFERENCE_RECORD_TRANSCRIPT_ENTRY.instantiate(new String[]{"conference_record", this.conferenceRecord, "transcript", this.transcript, "entry", this.entry});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TranscriptEntryName that = (TranscriptEntryName)o;
            return Objects.equals(this.conferenceRecord, that.conferenceRecord) && Objects.equals(this.transcript, that.transcript) && Objects.equals(this.entry, that.entry);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.conferenceRecord);
        h *= 1000003;
        h ^= Objects.hashCode(this.transcript);
        h *= 1000003;
        return h ^= Objects.hashCode(this.entry);
    }

    public static class Builder {
        private String conferenceRecord;
        private String transcript;
        private String entry;

        protected Builder() {
        }

        public String getConferenceRecord() {
            return this.conferenceRecord;
        }

        public String getTranscript() {
            return this.transcript;
        }

        public String getEntry() {
            return this.entry;
        }

        public Builder setConferenceRecord(String conferenceRecord) {
            this.conferenceRecord = conferenceRecord;
            return this;
        }

        public Builder setTranscript(String transcript) {
            this.transcript = transcript;
            return this;
        }

        public Builder setEntry(String entry) {
            this.entry = entry;
            return this;
        }

        private Builder(TranscriptEntryName transcriptEntryName) {
            this.conferenceRecord = transcriptEntryName.conferenceRecord;
            this.transcript = transcriptEntryName.transcript;
            this.entry = transcriptEntryName.entry;
        }

        public TranscriptEntryName build() {
            return new TranscriptEntryName(this);
        }
    }
}

