/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.maintenance.api.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ResourceMaintenanceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RESOURCE_MAINTENANCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/resourceMaintenances/{resource_maintenance}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String resourceMaintenance;

    @Deprecated
    protected ResourceMaintenanceName() {
        this.project = null;
        this.location = null;
        this.resourceMaintenance = null;
    }

    private ResourceMaintenanceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.resourceMaintenance = (String)Preconditions.checkNotNull((Object)builder.getResourceMaintenance());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getResourceMaintenance() {
        return this.resourceMaintenance;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ResourceMaintenanceName of(String project, String location, String resourceMaintenance) {
        return ResourceMaintenanceName.newBuilder().setProject(project).setLocation(location).setResourceMaintenance(resourceMaintenance).build();
    }

    public static String format(String project, String location, String resourceMaintenance) {
        return ResourceMaintenanceName.newBuilder().setProject(project).setLocation(location).setResourceMaintenance(resourceMaintenance).build().toString();
    }

    public static ResourceMaintenanceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RESOURCE_MAINTENANCE.validatedMatch(formattedString, "ResourceMaintenanceName.parse: formattedString not in valid format");
        return ResourceMaintenanceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("resource_maintenance"));
    }

    public static List<ResourceMaintenanceName> parseList(List<String> formattedStrings) {
        ArrayList<ResourceMaintenanceName> list = new ArrayList<ResourceMaintenanceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ResourceMaintenanceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ResourceMaintenanceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ResourceMaintenanceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RESOURCE_MAINTENANCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ResourceMaintenanceName resourceMaintenanceName = this;
            synchronized (resourceMaintenanceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.resourceMaintenance != null) {
                        fieldMapBuilder.put((Object)"resource_maintenance", (Object)this.resourceMaintenance);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RESOURCE_MAINTENANCE.instantiate(new String[]{"project", this.project, "location", this.location, "resource_maintenance", this.resourceMaintenance});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ResourceMaintenanceName that = (ResourceMaintenanceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.resourceMaintenance, that.resourceMaintenance);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.resourceMaintenance);
    }

    public static class Builder {
        private String project;
        private String location;
        private String resourceMaintenance;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getResourceMaintenance() {
            return this.resourceMaintenance;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setResourceMaintenance(String resourceMaintenance) {
            this.resourceMaintenance = resourceMaintenance;
            return this;
        }

        private Builder(ResourceMaintenanceName resourceMaintenanceName) {
            this.project = resourceMaintenanceName.project;
            this.location = resourceMaintenanceName.location;
            this.resourceMaintenance = resourceMaintenanceName.resourceMaintenance;
        }

        public ResourceMaintenanceName build() {
            return new ResourceMaintenanceName(this);
        }
    }
}

