/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.livestream.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DvrSessionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CHANNEL_DVR_SESSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/channels/{channel}/dvrSessions/{dvr_session}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String channel;
    private final String dvrSession;

    @Deprecated
    protected DvrSessionName() {
        this.project = null;
        this.location = null;
        this.channel = null;
        this.dvrSession = null;
    }

    private DvrSessionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.channel = (String)Preconditions.checkNotNull((Object)builder.getChannel());
        this.dvrSession = (String)Preconditions.checkNotNull((Object)builder.getDvrSession());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getDvrSession() {
        return this.dvrSession;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DvrSessionName of(String project, String location, String channel, String dvrSession) {
        return DvrSessionName.newBuilder().setProject(project).setLocation(location).setChannel(channel).setDvrSession(dvrSession).build();
    }

    public static String format(String project, String location, String channel, String dvrSession) {
        return DvrSessionName.newBuilder().setProject(project).setLocation(location).setChannel(channel).setDvrSession(dvrSession).build().toString();
    }

    public static DvrSessionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CHANNEL_DVR_SESSION.validatedMatch(formattedString, "DvrSessionName.parse: formattedString not in valid format");
        return DvrSessionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("channel"), (String)matchMap.get("dvr_session"));
    }

    public static List<DvrSessionName> parseList(List<String> formattedStrings) {
        ArrayList<DvrSessionName> list = new ArrayList<DvrSessionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DvrSessionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DvrSessionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DvrSessionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CHANNEL_DVR_SESSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DvrSessionName dvrSessionName = this;
            synchronized (dvrSessionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.channel != null) {
                        fieldMapBuilder.put((Object)"channel", (Object)this.channel);
                    }
                    if (this.dvrSession != null) {
                        fieldMapBuilder.put((Object)"dvr_session", (Object)this.dvrSession);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CHANNEL_DVR_SESSION.instantiate(new String[]{"project", this.project, "location", this.location, "channel", this.channel, "dvr_session", this.dvrSession});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DvrSessionName that = (DvrSessionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.channel, that.channel) && Objects.equals(this.dvrSession, that.dvrSession);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.channel);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dvrSession);
    }

    public static class Builder {
        private String project;
        private String location;
        private String channel;
        private String dvrSession;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getDvrSession() {
            return this.dvrSession;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setChannel(String channel) {
            this.channel = channel;
            return this;
        }

        public Builder setDvrSession(String dvrSession) {
            this.dvrSession = dvrSession;
            return this;
        }

        private Builder(DvrSessionName dvrSessionName) {
            this.project = dvrSessionName.project;
            this.location = dvrSessionName.location;
            this.channel = dvrSessionName.channel;
            this.dvrSession = dvrSessionName.dvrSession;
        }

        public DvrSessionName build() {
            return new DvrSessionName(this);
        }
    }
}

