/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.livestream.v1;

import com.google.cloud.video.livestream.v1.AudioStreamOrBuilder;
import com.google.cloud.video.livestream.v1.OutputsProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class AudioStream
extends GeneratedMessageV3
implements AudioStreamOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int TRANSMUX_FIELD_NUMBER = 8;
    private boolean transmux_;
    public static final int CODEC_FIELD_NUMBER = 1;
    private volatile Object codec_;
    public static final int BITRATE_BPS_FIELD_NUMBER = 2;
    private int bitrateBps_;
    public static final int CHANNEL_COUNT_FIELD_NUMBER = 3;
    private int channelCount_;
    public static final int CHANNEL_LAYOUT_FIELD_NUMBER = 4;
    private LazyStringList channelLayout_;
    public static final int MAPPING_FIELD_NUMBER = 5;
    private List<AudioMapping> mapping_;
    public static final int SAMPLE_RATE_HERTZ_FIELD_NUMBER = 6;
    private int sampleRateHertz_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final AudioStream DEFAULT_INSTANCE = new AudioStream();
    private static final Parser<AudioStream> PARSER = new AbstractParser<AudioStream>(){

        public AudioStream parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = AudioStream.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private AudioStream(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private AudioStream() {
        this.codec_ = "";
        this.channelLayout_ = LazyStringArrayList.EMPTY;
        this.mapping_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new AudioStream();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return OutputsProto.internal_static_google_cloud_video_livestream_v1_AudioStream_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return OutputsProto.internal_static_google_cloud_video_livestream_v1_AudioStream_fieldAccessorTable.ensureFieldAccessorsInitialized(AudioStream.class, Builder.class);
    }

    @Override
    public boolean getTransmux() {
        return this.transmux_;
    }

    @Override
    public String getCodec() {
        Object ref = this.codec_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.codec_ = s;
        return s;
    }

    @Override
    public ByteString getCodecBytes() {
        Object ref = this.codec_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.codec_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getBitrateBps() {
        return this.bitrateBps_;
    }

    @Override
    public int getChannelCount() {
        return this.channelCount_;
    }

    public ProtocolStringList getChannelLayoutList() {
        return this.channelLayout_;
    }

    @Override
    public int getChannelLayoutCount() {
        return this.channelLayout_.size();
    }

    @Override
    public String getChannelLayout(int index) {
        return (String)this.channelLayout_.get(index);
    }

    @Override
    public ByteString getChannelLayoutBytes(int index) {
        return this.channelLayout_.getByteString(index);
    }

    @Override
    public List<AudioMapping> getMappingList() {
        return this.mapping_;
    }

    @Override
    public List<? extends AudioMappingOrBuilder> getMappingOrBuilderList() {
        return this.mapping_;
    }

    @Override
    public int getMappingCount() {
        return this.mapping_.size();
    }

    @Override
    public AudioMapping getMapping(int index) {
        return this.mapping_.get(index);
    }

    @Override
    public AudioMappingOrBuilder getMappingOrBuilder(int index) {
        return this.mapping_.get(index);
    }

    @Override
    public int getSampleRateHertz() {
        return this.sampleRateHertz_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.codec_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.codec_);
        }
        if (this.bitrateBps_ != 0) {
            output.writeInt32(2, this.bitrateBps_);
        }
        if (this.channelCount_ != 0) {
            output.writeInt32(3, this.channelCount_);
        }
        for (i = 0; i < this.channelLayout_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.channelLayout_.getRaw(i));
        }
        for (i = 0; i < this.mapping_.size(); ++i) {
            output.writeMessage(5, (MessageLite)this.mapping_.get(i));
        }
        if (this.sampleRateHertz_ != 0) {
            output.writeInt32(6, this.sampleRateHertz_);
        }
        if (this.transmux_) {
            output.writeBool(8, this.transmux_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.codec_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.codec_);
        }
        if (this.bitrateBps_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)2, (int)this.bitrateBps_);
        }
        if (this.channelCount_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)3, (int)this.channelCount_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.channelLayout_.size(); ++i) {
            dataSize += AudioStream.computeStringSizeNoTag((Object)this.channelLayout_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getChannelLayoutList().size();
        for (int i = 0; i < this.mapping_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)((MessageLite)this.mapping_.get(i)));
        }
        if (this.sampleRateHertz_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)6, (int)this.sampleRateHertz_);
        }
        if (this.transmux_) {
            size += CodedOutputStream.computeBoolSize((int)8, (boolean)this.transmux_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AudioStream)) {
            return super.equals(obj);
        }
        AudioStream other = (AudioStream)obj;
        if (this.getTransmux() != other.getTransmux()) {
            return false;
        }
        if (!this.getCodec().equals(other.getCodec())) {
            return false;
        }
        if (this.getBitrateBps() != other.getBitrateBps()) {
            return false;
        }
        if (this.getChannelCount() != other.getChannelCount()) {
            return false;
        }
        if (!this.getChannelLayoutList().equals(other.getChannelLayoutList())) {
            return false;
        }
        if (!this.getMappingList().equals(other.getMappingList())) {
            return false;
        }
        if (this.getSampleRateHertz() != other.getSampleRateHertz()) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + AudioStream.getDescriptor().hashCode();
        hash = 37 * hash + 8;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getTransmux());
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getCodec().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getBitrateBps();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getChannelCount();
        if (this.getChannelLayoutCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getChannelLayoutList().hashCode();
        }
        if (this.getMappingCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getMappingList().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getSampleRateHertz();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static AudioStream parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (AudioStream)PARSER.parseFrom(data);
    }

    public static AudioStream parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AudioStream)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AudioStream parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (AudioStream)PARSER.parseFrom(data);
    }

    public static AudioStream parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AudioStream)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AudioStream parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (AudioStream)PARSER.parseFrom(data);
    }

    public static AudioStream parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AudioStream)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AudioStream parseFrom(InputStream input) throws IOException {
        return (AudioStream)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static AudioStream parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AudioStream)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AudioStream parseDelimitedFrom(InputStream input) throws IOException {
        return (AudioStream)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static AudioStream parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AudioStream)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AudioStream parseFrom(CodedInputStream input) throws IOException {
        return (AudioStream)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static AudioStream parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AudioStream)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return AudioStream.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AudioStream prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static AudioStream getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<AudioStream> parser() {
        return PARSER;
    }

    public Parser<AudioStream> getParserForType() {
        return PARSER;
    }

    public AudioStream getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements AudioStreamOrBuilder {
        private int bitField0_;
        private boolean transmux_;
        private Object codec_ = "";
        private int bitrateBps_;
        private int channelCount_;
        private LazyStringList channelLayout_ = LazyStringArrayList.EMPTY;
        private List<AudioMapping> mapping_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AudioMapping, AudioMapping.Builder, AudioMappingOrBuilder> mappingBuilder_;
        private int sampleRateHertz_;

        public static final Descriptors.Descriptor getDescriptor() {
            return OutputsProto.internal_static_google_cloud_video_livestream_v1_AudioStream_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return OutputsProto.internal_static_google_cloud_video_livestream_v1_AudioStream_fieldAccessorTable.ensureFieldAccessorsInitialized(AudioStream.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.transmux_ = false;
            this.codec_ = "";
            this.bitrateBps_ = 0;
            this.channelCount_ = 0;
            this.channelLayout_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            if (this.mappingBuilder_ == null) {
                this.mapping_ = Collections.emptyList();
            } else {
                this.mapping_ = null;
                this.mappingBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFD;
            this.sampleRateHertz_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return OutputsProto.internal_static_google_cloud_video_livestream_v1_AudioStream_descriptor;
        }

        public AudioStream getDefaultInstanceForType() {
            return AudioStream.getDefaultInstance();
        }

        public AudioStream build() {
            AudioStream result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public AudioStream buildPartial() {
            AudioStream result = new AudioStream(this);
            int from_bitField0_ = this.bitField0_;
            result.transmux_ = this.transmux_;
            result.codec_ = this.codec_;
            result.bitrateBps_ = this.bitrateBps_;
            result.channelCount_ = this.channelCount_;
            if ((this.bitField0_ & 1) != 0) {
                this.channelLayout_ = this.channelLayout_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.channelLayout_ = this.channelLayout_;
            if (this.mappingBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.mapping_ = Collections.unmodifiableList(this.mapping_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.mapping_ = this.mapping_;
            } else {
                result.mapping_ = this.mappingBuilder_.build();
            }
            result.sampleRateHertz_ = this.sampleRateHertz_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof AudioStream) {
                return this.mergeFrom((AudioStream)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(AudioStream other) {
            if (other == AudioStream.getDefaultInstance()) {
                return this;
            }
            if (other.getTransmux()) {
                this.setTransmux(other.getTransmux());
            }
            if (!other.getCodec().isEmpty()) {
                this.codec_ = other.codec_;
                this.onChanged();
            }
            if (other.getBitrateBps() != 0) {
                this.setBitrateBps(other.getBitrateBps());
            }
            if (other.getChannelCount() != 0) {
                this.setChannelCount(other.getChannelCount());
            }
            if (!other.channelLayout_.isEmpty()) {
                if (this.channelLayout_.isEmpty()) {
                    this.channelLayout_ = other.channelLayout_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureChannelLayoutIsMutable();
                    this.channelLayout_.addAll((Collection)other.channelLayout_);
                }
                this.onChanged();
            }
            if (this.mappingBuilder_ == null) {
                if (!other.mapping_.isEmpty()) {
                    if (this.mapping_.isEmpty()) {
                        this.mapping_ = other.mapping_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureMappingIsMutable();
                        this.mapping_.addAll(other.mapping_);
                    }
                    this.onChanged();
                }
            } else if (!other.mapping_.isEmpty()) {
                if (this.mappingBuilder_.isEmpty()) {
                    this.mappingBuilder_.dispose();
                    this.mappingBuilder_ = null;
                    this.mapping_ = other.mapping_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.mappingBuilder_ = alwaysUseFieldBuilders ? this.getMappingFieldBuilder() : null;
                } else {
                    this.mappingBuilder_.addAllMessages((Iterable)other.mapping_);
                }
            }
            if (other.getSampleRateHertz() != 0) {
                this.setSampleRateHertz(other.getSampleRateHertz());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block15: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block15;
                        }
                        case 10: {
                            this.codec_ = input.readStringRequireUtf8();
                            continue block15;
                        }
                        case 16: {
                            this.bitrateBps_ = input.readInt32();
                            continue block15;
                        }
                        case 24: {
                            this.channelCount_ = input.readInt32();
                            continue block15;
                        }
                        case 34: {
                            String s = input.readStringRequireUtf8();
                            this.ensureChannelLayoutIsMutable();
                            this.channelLayout_.add((Object)s);
                            continue block15;
                        }
                        case 42: {
                            AudioMapping m = (AudioMapping)input.readMessage(AudioMapping.parser(), extensionRegistry);
                            if (this.mappingBuilder_ == null) {
                                this.ensureMappingIsMutable();
                                this.mapping_.add(m);
                                continue block15;
                            }
                            this.mappingBuilder_.addMessage((AbstractMessage)m);
                            continue block15;
                        }
                        case 48: {
                            this.sampleRateHertz_ = input.readInt32();
                            continue block15;
                        }
                        case 64: {
                            this.transmux_ = input.readBool();
                            continue block15;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean getTransmux() {
            return this.transmux_;
        }

        public Builder setTransmux(boolean value) {
            this.transmux_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearTransmux() {
            this.transmux_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public String getCodec() {
            Object ref = this.codec_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.codec_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCodecBytes() {
            Object ref = this.codec_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.codec_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCodec(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.codec_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearCodec() {
            this.codec_ = AudioStream.getDefaultInstance().getCodec();
            this.onChanged();
            return this;
        }

        public Builder setCodecBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AudioStream.checkByteStringIsUtf8((ByteString)value);
            this.codec_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public int getBitrateBps() {
            return this.bitrateBps_;
        }

        public Builder setBitrateBps(int value) {
            this.bitrateBps_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearBitrateBps() {
            this.bitrateBps_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getChannelCount() {
            return this.channelCount_;
        }

        public Builder setChannelCount(int value) {
            this.channelCount_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearChannelCount() {
            this.channelCount_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureChannelLayoutIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.channelLayout_ = new LazyStringArrayList(this.channelLayout_);
                this.bitField0_ |= 1;
            }
        }

        public ProtocolStringList getChannelLayoutList() {
            return this.channelLayout_.getUnmodifiableView();
        }

        @Override
        public int getChannelLayoutCount() {
            return this.channelLayout_.size();
        }

        @Override
        public String getChannelLayout(int index) {
            return (String)this.channelLayout_.get(index);
        }

        @Override
        public ByteString getChannelLayoutBytes(int index) {
            return this.channelLayout_.getByteString(index);
        }

        public Builder setChannelLayout(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureChannelLayoutIsMutable();
            this.channelLayout_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addChannelLayout(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureChannelLayoutIsMutable();
            this.channelLayout_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllChannelLayout(Iterable<String> values) {
            this.ensureChannelLayoutIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.channelLayout_);
            this.onChanged();
            return this;
        }

        public Builder clearChannelLayout() {
            this.channelLayout_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder addChannelLayoutBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AudioStream.checkByteStringIsUtf8((ByteString)value);
            this.ensureChannelLayoutIsMutable();
            this.channelLayout_.add(value);
            this.onChanged();
            return this;
        }

        private void ensureMappingIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.mapping_ = new ArrayList<AudioMapping>(this.mapping_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<AudioMapping> getMappingList() {
            if (this.mappingBuilder_ == null) {
                return Collections.unmodifiableList(this.mapping_);
            }
            return this.mappingBuilder_.getMessageList();
        }

        @Override
        public int getMappingCount() {
            if (this.mappingBuilder_ == null) {
                return this.mapping_.size();
            }
            return this.mappingBuilder_.getCount();
        }

        @Override
        public AudioMapping getMapping(int index) {
            if (this.mappingBuilder_ == null) {
                return this.mapping_.get(index);
            }
            return (AudioMapping)this.mappingBuilder_.getMessage(index);
        }

        public Builder setMapping(int index, AudioMapping value) {
            if (this.mappingBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureMappingIsMutable();
                this.mapping_.set(index, value);
                this.onChanged();
            } else {
                this.mappingBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setMapping(int index, AudioMapping.Builder builderForValue) {
            if (this.mappingBuilder_ == null) {
                this.ensureMappingIsMutable();
                this.mapping_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.mappingBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addMapping(AudioMapping value) {
            if (this.mappingBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureMappingIsMutable();
                this.mapping_.add(value);
                this.onChanged();
            } else {
                this.mappingBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addMapping(int index, AudioMapping value) {
            if (this.mappingBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureMappingIsMutable();
                this.mapping_.add(index, value);
                this.onChanged();
            } else {
                this.mappingBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addMapping(AudioMapping.Builder builderForValue) {
            if (this.mappingBuilder_ == null) {
                this.ensureMappingIsMutable();
                this.mapping_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.mappingBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addMapping(int index, AudioMapping.Builder builderForValue) {
            if (this.mappingBuilder_ == null) {
                this.ensureMappingIsMutable();
                this.mapping_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.mappingBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllMapping(Iterable<? extends AudioMapping> values) {
            if (this.mappingBuilder_ == null) {
                this.ensureMappingIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.mapping_);
                this.onChanged();
            } else {
                this.mappingBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearMapping() {
            if (this.mappingBuilder_ == null) {
                this.mapping_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.mappingBuilder_.clear();
            }
            return this;
        }

        public Builder removeMapping(int index) {
            if (this.mappingBuilder_ == null) {
                this.ensureMappingIsMutable();
                this.mapping_.remove(index);
                this.onChanged();
            } else {
                this.mappingBuilder_.remove(index);
            }
            return this;
        }

        public AudioMapping.Builder getMappingBuilder(int index) {
            return (AudioMapping.Builder)this.getMappingFieldBuilder().getBuilder(index);
        }

        @Override
        public AudioMappingOrBuilder getMappingOrBuilder(int index) {
            if (this.mappingBuilder_ == null) {
                return this.mapping_.get(index);
            }
            return (AudioMappingOrBuilder)this.mappingBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AudioMappingOrBuilder> getMappingOrBuilderList() {
            if (this.mappingBuilder_ != null) {
                return this.mappingBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.mapping_);
        }

        public AudioMapping.Builder addMappingBuilder() {
            return (AudioMapping.Builder)this.getMappingFieldBuilder().addBuilder((AbstractMessage)AudioMapping.getDefaultInstance());
        }

        public AudioMapping.Builder addMappingBuilder(int index) {
            return (AudioMapping.Builder)this.getMappingFieldBuilder().addBuilder(index, (AbstractMessage)AudioMapping.getDefaultInstance());
        }

        public List<AudioMapping.Builder> getMappingBuilderList() {
            return this.getMappingFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AudioMapping, AudioMapping.Builder, AudioMappingOrBuilder> getMappingFieldBuilder() {
            if (this.mappingBuilder_ == null) {
                this.mappingBuilder_ = new RepeatedFieldBuilderV3(this.mapping_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.mapping_ = null;
            }
            return this.mappingBuilder_;
        }

        @Override
        public int getSampleRateHertz() {
            return this.sampleRateHertz_;
        }

        public Builder setSampleRateHertz(int value) {
            this.sampleRateHertz_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearSampleRateHertz() {
            this.sampleRateHertz_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class AudioMapping
    extends GeneratedMessageV3
    implements AudioMappingOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int INPUT_KEY_FIELD_NUMBER = 6;
        private volatile Object inputKey_;
        public static final int INPUT_TRACK_FIELD_NUMBER = 2;
        private int inputTrack_;
        public static final int INPUT_CHANNEL_FIELD_NUMBER = 3;
        private int inputChannel_;
        public static final int OUTPUT_CHANNEL_FIELD_NUMBER = 4;
        private int outputChannel_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final AudioMapping DEFAULT_INSTANCE = new AudioMapping();
        private static final Parser<AudioMapping> PARSER = new AbstractParser<AudioMapping>(){

            public AudioMapping parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = AudioMapping.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private AudioMapping(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private AudioMapping() {
            this.inputKey_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new AudioMapping();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return OutputsProto.internal_static_google_cloud_video_livestream_v1_AudioStream_AudioMapping_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return OutputsProto.internal_static_google_cloud_video_livestream_v1_AudioStream_AudioMapping_fieldAccessorTable.ensureFieldAccessorsInitialized(AudioMapping.class, Builder.class);
        }

        @Override
        public String getInputKey() {
            Object ref = this.inputKey_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.inputKey_ = s;
            return s;
        }

        @Override
        public ByteString getInputKeyBytes() {
            Object ref = this.inputKey_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.inputKey_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public int getInputTrack() {
            return this.inputTrack_;
        }

        @Override
        public int getInputChannel() {
            return this.inputChannel_;
        }

        @Override
        public int getOutputChannel() {
            return this.outputChannel_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.inputTrack_ != 0) {
                output.writeInt32(2, this.inputTrack_);
            }
            if (this.inputChannel_ != 0) {
                output.writeInt32(3, this.inputChannel_);
            }
            if (this.outputChannel_ != 0) {
                output.writeInt32(4, this.outputChannel_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.inputKey_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.inputKey_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.inputTrack_ != 0) {
                size += CodedOutputStream.computeInt32Size((int)2, (int)this.inputTrack_);
            }
            if (this.inputChannel_ != 0) {
                size += CodedOutputStream.computeInt32Size((int)3, (int)this.inputChannel_);
            }
            if (this.outputChannel_ != 0) {
                size += CodedOutputStream.computeInt32Size((int)4, (int)this.outputChannel_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.inputKey_)) {
                size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.inputKey_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AudioMapping)) {
                return super.equals(obj);
            }
            AudioMapping other = (AudioMapping)obj;
            if (!this.getInputKey().equals(other.getInputKey())) {
                return false;
            }
            if (this.getInputTrack() != other.getInputTrack()) {
                return false;
            }
            if (this.getInputChannel() != other.getInputChannel()) {
                return false;
            }
            if (this.getOutputChannel() != other.getOutputChannel()) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + AudioMapping.getDescriptor().hashCode();
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getInputKey().hashCode();
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getInputTrack();
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getInputChannel();
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getOutputChannel();
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static AudioMapping parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (AudioMapping)PARSER.parseFrom(data);
        }

        public static AudioMapping parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AudioMapping)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AudioMapping parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (AudioMapping)PARSER.parseFrom(data);
        }

        public static AudioMapping parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AudioMapping)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AudioMapping parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (AudioMapping)PARSER.parseFrom(data);
        }

        public static AudioMapping parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AudioMapping)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AudioMapping parseFrom(InputStream input) throws IOException {
            return (AudioMapping)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static AudioMapping parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AudioMapping)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AudioMapping parseDelimitedFrom(InputStream input) throws IOException {
            return (AudioMapping)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static AudioMapping parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AudioMapping)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AudioMapping parseFrom(CodedInputStream input) throws IOException {
            return (AudioMapping)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static AudioMapping parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AudioMapping)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return AudioMapping.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(AudioMapping prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static AudioMapping getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<AudioMapping> parser() {
            return PARSER;
        }

        public Parser<AudioMapping> getParserForType() {
            return PARSER;
        }

        public AudioMapping getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements AudioMappingOrBuilder {
            private Object inputKey_ = "";
            private int inputTrack_;
            private int inputChannel_;
            private int outputChannel_;

            public static final Descriptors.Descriptor getDescriptor() {
                return OutputsProto.internal_static_google_cloud_video_livestream_v1_AudioStream_AudioMapping_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return OutputsProto.internal_static_google_cloud_video_livestream_v1_AudioStream_AudioMapping_fieldAccessorTable.ensureFieldAccessorsInitialized(AudioMapping.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.inputKey_ = "";
                this.inputTrack_ = 0;
                this.inputChannel_ = 0;
                this.outputChannel_ = 0;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return OutputsProto.internal_static_google_cloud_video_livestream_v1_AudioStream_AudioMapping_descriptor;
            }

            public AudioMapping getDefaultInstanceForType() {
                return AudioMapping.getDefaultInstance();
            }

            public AudioMapping build() {
                AudioMapping result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public AudioMapping buildPartial() {
                AudioMapping result = new AudioMapping(this);
                result.inputKey_ = this.inputKey_;
                result.inputTrack_ = this.inputTrack_;
                result.inputChannel_ = this.inputChannel_;
                result.outputChannel_ = this.outputChannel_;
                this.onBuilt();
                return result;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof AudioMapping) {
                    return this.mergeFrom((AudioMapping)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(AudioMapping other) {
                if (other == AudioMapping.getDefaultInstance()) {
                    return this;
                }
                if (!other.getInputKey().isEmpty()) {
                    this.inputKey_ = other.inputKey_;
                    this.onChanged();
                }
                if (other.getInputTrack() != 0) {
                    this.setInputTrack(other.getInputTrack());
                }
                if (other.getInputChannel() != 0) {
                    this.setInputChannel(other.getInputChannel());
                }
                if (other.getOutputChannel() != 0) {
                    this.setOutputChannel(other.getOutputChannel());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block12: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block12;
                            }
                            case 16: {
                                this.inputTrack_ = input.readInt32();
                                continue block12;
                            }
                            case 24: {
                                this.inputChannel_ = input.readInt32();
                                continue block12;
                            }
                            case 32: {
                                this.outputChannel_ = input.readInt32();
                                continue block12;
                            }
                            case 50: {
                                this.inputKey_ = input.readStringRequireUtf8();
                                continue block12;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getInputKey() {
                Object ref = this.inputKey_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.inputKey_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getInputKeyBytes() {
                Object ref = this.inputKey_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.inputKey_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setInputKey(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.inputKey_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearInputKey() {
                this.inputKey_ = AudioMapping.getDefaultInstance().getInputKey();
                this.onChanged();
                return this;
            }

            public Builder setInputKeyBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                AudioMapping.checkByteStringIsUtf8((ByteString)value);
                this.inputKey_ = value;
                this.onChanged();
                return this;
            }

            @Override
            public int getInputTrack() {
                return this.inputTrack_;
            }

            public Builder setInputTrack(int value) {
                this.inputTrack_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearInputTrack() {
                this.inputTrack_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public int getInputChannel() {
                return this.inputChannel_;
            }

            public Builder setInputChannel(int value) {
                this.inputChannel_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearInputChannel() {
                this.inputChannel_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public int getOutputChannel() {
                return this.outputChannel_;
            }

            public Builder setOutputChannel(int value) {
                this.outputChannel_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearOutputChannel() {
                this.outputChannel_ = 0;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface AudioMappingOrBuilder
    extends MessageOrBuilder {
        public String getInputKey();

        public ByteString getInputKeyBytes();

        public int getInputTrack();

        public int getInputChannel();

        public int getOutputChannel();
    }
}

