/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iot.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DeviceName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/registries/{registry}/devices/{device}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String registry;
    private final String device;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getDevice() {
        return this.device;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DeviceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.registry = (String)Preconditions.checkNotNull((Object)builder.getRegistry());
        this.device = (String)Preconditions.checkNotNull((Object)builder.getDevice());
    }

    public static DeviceName of(String project, String location, String registry, String device) {
        return DeviceName.newBuilder().setProject(project).setLocation(location).setRegistry(registry).setDevice(device).build();
    }

    public static String format(String project, String location, String registry, String device) {
        return DeviceName.newBuilder().setProject(project).setLocation(location).setRegistry(registry).setDevice(device).build().toString();
    }

    public static DeviceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DeviceName.parse: formattedString not in valid format");
        return DeviceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("registry"), (String)matchMap.get("device"));
    }

    public static List<DeviceName> parseList(List<String> formattedStrings) {
        ArrayList<DeviceName> list = new ArrayList<DeviceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DeviceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DeviceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DeviceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DeviceName deviceName = this;
            synchronized (deviceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"registry", (Object)this.registry);
                    fieldMapBuilder.put((Object)"device", (Object)this.device);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("DeviceName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "registry", this.registry, "device", this.device});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DeviceName) {
            DeviceName that = (DeviceName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.registry.equals(that.registry) && this.device.equals(that.device);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.registry.hashCode();
        h *= 1000003;
        return h ^= this.device.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String registry;
        private String device;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRegistry() {
            return this.registry;
        }

        public String getDevice() {
            return this.device;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRegistry(String registry) {
            this.registry = registry;
            return this;
        }

        public Builder setDevice(String device) {
            this.device = device;
            return this;
        }

        private Builder() {
        }

        private Builder(DeviceName deviceName) {
            this.project = deviceName.project;
            this.location = deviceName.location;
            this.registry = deviceName.registry;
            this.device = deviceName.device;
        }

        public DeviceName build() {
            return new DeviceName(this);
        }
    }
}

