/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iap.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TunnelDestGroupName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DEST_GROUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/iap_tunnel/locations/{location}/destGroups/{dest_group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String destGroup;

    @Deprecated
    protected TunnelDestGroupName() {
        this.project = null;
        this.location = null;
        this.destGroup = null;
    }

    private TunnelDestGroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.destGroup = (String)Preconditions.checkNotNull((Object)builder.getDestGroup());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDestGroup() {
        return this.destGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TunnelDestGroupName of(String project, String location, String destGroup) {
        return TunnelDestGroupName.newBuilder().setProject(project).setLocation(location).setDestGroup(destGroup).build();
    }

    public static String format(String project, String location, String destGroup) {
        return TunnelDestGroupName.newBuilder().setProject(project).setLocation(location).setDestGroup(destGroup).build().toString();
    }

    public static TunnelDestGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DEST_GROUP.validatedMatch(formattedString, "TunnelDestGroupName.parse: formattedString not in valid format");
        return TunnelDestGroupName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("dest_group"));
    }

    public static List<TunnelDestGroupName> parseList(List<String> formattedStrings) {
        ArrayList<TunnelDestGroupName> list = new ArrayList<TunnelDestGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TunnelDestGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TunnelDestGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TunnelDestGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DEST_GROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TunnelDestGroupName tunnelDestGroupName = this;
            synchronized (tunnelDestGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.destGroup != null) {
                        fieldMapBuilder.put((Object)"dest_group", (Object)this.destGroup);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DEST_GROUP.instantiate(new String[]{"project", this.project, "location", this.location, "dest_group", this.destGroup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TunnelDestGroupName that = (TunnelDestGroupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.destGroup, that.destGroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.destGroup);
    }

    public static class Builder {
        private String project;
        private String location;
        private String destGroup;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDestGroup() {
            return this.destGroup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDestGroup(String destGroup) {
            this.destGroup = destGroup;
            return this;
        }

        private Builder(TunnelDestGroupName tunnelDestGroupName) {
            this.project = tunnelDestGroupName.project;
            this.location = tunnelDestGroupName.location;
            this.destGroup = tunnelDestGroupName.destGroup;
        }

        public TunnelDestGroupName build() {
            return new TunnelDestGroupName(this);
        }
    }
}

