/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkemulticloud.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AwsServerConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/awsServerConfig");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;

    @Deprecated
    protected AwsServerConfigName() {
        this.project = null;
        this.location = null;
    }

    private AwsServerConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AwsServerConfigName of(String project, String location) {
        return AwsServerConfigName.newBuilder().setProject(project).setLocation(location).build();
    }

    public static String format(String project, String location) {
        return AwsServerConfigName.newBuilder().setProject(project).setLocation(location).build().toString();
    }

    public static AwsServerConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION.validatedMatch(formattedString, "AwsServerConfigName.parse: formattedString not in valid format");
        return AwsServerConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"));
    }

    public static List<AwsServerConfigName> parseList(List<String> formattedStrings) {
        ArrayList<AwsServerConfigName> list = new ArrayList<AwsServerConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AwsServerConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AwsServerConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AwsServerConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AwsServerConfigName awsServerConfigName = this;
            synchronized (awsServerConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION.instantiate(new String[]{"project", this.project, "location", this.location});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AwsServerConfigName that = (AwsServerConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class Builder {
        private String project;
        private String location;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder(AwsServerConfigName awsServerConfigName) {
            this.project = awsServerConfigName.project;
            this.location = awsServerConfigName.location;
        }

        public AwsServerConfigName build() {
            return new AwsServerConfigName(this);
        }
    }
}

