/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.v2alpha;

import com.google.cloud.functions.v2alpha.FunctionsProto;
import com.google.cloud.functions.v2alpha.SecretEnvVar;
import com.google.cloud.functions.v2alpha.SecretEnvVarOrBuilder;
import com.google.cloud.functions.v2alpha.SecretVolume;
import com.google.cloud.functions.v2alpha.SecretVolumeOrBuilder;
import com.google.cloud.functions.v2alpha.ServiceConfigOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ServiceConfig
extends GeneratedMessageV3
implements ServiceConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int SERVICE_FIELD_NUMBER = 1;
    private volatile Object service_ = "";
    public static final int TIMEOUT_SECONDS_FIELD_NUMBER = 2;
    private int timeoutSeconds_ = 0;
    public static final int AVAILABLE_MEMORY_FIELD_NUMBER = 13;
    private volatile Object availableMemory_ = "";
    public static final int AVAILABLE_CPU_FIELD_NUMBER = 22;
    private volatile Object availableCpu_ = "";
    public static final int ENVIRONMENT_VARIABLES_FIELD_NUMBER = 4;
    private MapField<String, String> environmentVariables_;
    public static final int MAX_INSTANCE_COUNT_FIELD_NUMBER = 5;
    private int maxInstanceCount_ = 0;
    public static final int MIN_INSTANCE_COUNT_FIELD_NUMBER = 12;
    private int minInstanceCount_ = 0;
    public static final int VPC_CONNECTOR_FIELD_NUMBER = 6;
    private volatile Object vpcConnector_ = "";
    public static final int VPC_CONNECTOR_EGRESS_SETTINGS_FIELD_NUMBER = 7;
    private int vpcConnectorEgressSettings_ = 0;
    public static final int INGRESS_SETTINGS_FIELD_NUMBER = 8;
    private int ingressSettings_ = 0;
    public static final int URI_FIELD_NUMBER = 9;
    private volatile Object uri_ = "";
    public static final int SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER = 10;
    private volatile Object serviceAccountEmail_ = "";
    public static final int ALL_TRAFFIC_ON_LATEST_REVISION_FIELD_NUMBER = 16;
    private boolean allTrafficOnLatestRevision_ = false;
    public static final int SECRET_ENVIRONMENT_VARIABLES_FIELD_NUMBER = 17;
    private List<SecretEnvVar> secretEnvironmentVariables_;
    public static final int SECRET_VOLUMES_FIELD_NUMBER = 19;
    private List<SecretVolume> secretVolumes_;
    public static final int REVISION_FIELD_NUMBER = 18;
    private volatile Object revision_ = "";
    public static final int MAX_INSTANCE_REQUEST_CONCURRENCY_FIELD_NUMBER = 20;
    private int maxInstanceRequestConcurrency_ = 0;
    public static final int SECURITY_LEVEL_FIELD_NUMBER = 21;
    private int securityLevel_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final ServiceConfig DEFAULT_INSTANCE = new ServiceConfig();
    private static final Parser<ServiceConfig> PARSER = new AbstractParser<ServiceConfig>(){

        public ServiceConfig parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = ServiceConfig.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private ServiceConfig(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private ServiceConfig() {
        this.service_ = "";
        this.availableMemory_ = "";
        this.availableCpu_ = "";
        this.vpcConnector_ = "";
        this.vpcConnectorEgressSettings_ = 0;
        this.ingressSettings_ = 0;
        this.uri_ = "";
        this.serviceAccountEmail_ = "";
        this.secretEnvironmentVariables_ = Collections.emptyList();
        this.secretVolumes_ = Collections.emptyList();
        this.revision_ = "";
        this.securityLevel_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new ServiceConfig();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return FunctionsProto.internal_static_google_cloud_functions_v2alpha_ServiceConfig_descriptor;
    }

    protected MapField internalGetMapField(int number) {
        switch (number) {
            case 4: {
                return this.internalGetEnvironmentVariables();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return FunctionsProto.internal_static_google_cloud_functions_v2alpha_ServiceConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(ServiceConfig.class, Builder.class);
    }

    @Override
    public String getService() {
        Object ref = this.service_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.service_ = s;
        return s;
    }

    @Override
    public ByteString getServiceBytes() {
        Object ref = this.service_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.service_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getTimeoutSeconds() {
        return this.timeoutSeconds_;
    }

    @Override
    public String getAvailableMemory() {
        Object ref = this.availableMemory_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.availableMemory_ = s;
        return s;
    }

    @Override
    public ByteString getAvailableMemoryBytes() {
        Object ref = this.availableMemory_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.availableMemory_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getAvailableCpu() {
        Object ref = this.availableCpu_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.availableCpu_ = s;
        return s;
    }

    @Override
    public ByteString getAvailableCpuBytes() {
        Object ref = this.availableCpu_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.availableCpu_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    private MapField<String, String> internalGetEnvironmentVariables() {
        if (this.environmentVariables_ == null) {
            return MapField.emptyMapField(EnvironmentVariablesDefaultEntryHolder.defaultEntry);
        }
        return this.environmentVariables_;
    }

    @Override
    public int getEnvironmentVariablesCount() {
        return this.internalGetEnvironmentVariables().getMap().size();
    }

    @Override
    public boolean containsEnvironmentVariables(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetEnvironmentVariables().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getEnvironmentVariables() {
        return this.getEnvironmentVariablesMap();
    }

    @Override
    public Map<String, String> getEnvironmentVariablesMap() {
        return this.internalGetEnvironmentVariables().getMap();
    }

    @Override
    public String getEnvironmentVariablesOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetEnvironmentVariables().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getEnvironmentVariablesOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetEnvironmentVariables().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public int getMaxInstanceCount() {
        return this.maxInstanceCount_;
    }

    @Override
    public int getMinInstanceCount() {
        return this.minInstanceCount_;
    }

    @Override
    public String getVpcConnector() {
        Object ref = this.vpcConnector_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.vpcConnector_ = s;
        return s;
    }

    @Override
    public ByteString getVpcConnectorBytes() {
        Object ref = this.vpcConnector_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.vpcConnector_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getVpcConnectorEgressSettingsValue() {
        return this.vpcConnectorEgressSettings_;
    }

    @Override
    public VpcConnectorEgressSettings getVpcConnectorEgressSettings() {
        VpcConnectorEgressSettings result = VpcConnectorEgressSettings.forNumber(this.vpcConnectorEgressSettings_);
        return result == null ? VpcConnectorEgressSettings.UNRECOGNIZED : result;
    }

    @Override
    public int getIngressSettingsValue() {
        return this.ingressSettings_;
    }

    @Override
    public IngressSettings getIngressSettings() {
        IngressSettings result = IngressSettings.forNumber(this.ingressSettings_);
        return result == null ? IngressSettings.UNRECOGNIZED : result;
    }

    @Override
    public String getUri() {
        Object ref = this.uri_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.uri_ = s;
        return s;
    }

    @Override
    public ByteString getUriBytes() {
        Object ref = this.uri_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.uri_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getServiceAccountEmail() {
        Object ref = this.serviceAccountEmail_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.serviceAccountEmail_ = s;
        return s;
    }

    @Override
    public ByteString getServiceAccountEmailBytes() {
        Object ref = this.serviceAccountEmail_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.serviceAccountEmail_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean getAllTrafficOnLatestRevision() {
        return this.allTrafficOnLatestRevision_;
    }

    @Override
    public List<SecretEnvVar> getSecretEnvironmentVariablesList() {
        return this.secretEnvironmentVariables_;
    }

    @Override
    public List<? extends SecretEnvVarOrBuilder> getSecretEnvironmentVariablesOrBuilderList() {
        return this.secretEnvironmentVariables_;
    }

    @Override
    public int getSecretEnvironmentVariablesCount() {
        return this.secretEnvironmentVariables_.size();
    }

    @Override
    public SecretEnvVar getSecretEnvironmentVariables(int index) {
        return this.secretEnvironmentVariables_.get(index);
    }

    @Override
    public SecretEnvVarOrBuilder getSecretEnvironmentVariablesOrBuilder(int index) {
        return this.secretEnvironmentVariables_.get(index);
    }

    @Override
    public List<SecretVolume> getSecretVolumesList() {
        return this.secretVolumes_;
    }

    @Override
    public List<? extends SecretVolumeOrBuilder> getSecretVolumesOrBuilderList() {
        return this.secretVolumes_;
    }

    @Override
    public int getSecretVolumesCount() {
        return this.secretVolumes_.size();
    }

    @Override
    public SecretVolume getSecretVolumes(int index) {
        return this.secretVolumes_.get(index);
    }

    @Override
    public SecretVolumeOrBuilder getSecretVolumesOrBuilder(int index) {
        return this.secretVolumes_.get(index);
    }

    @Override
    public String getRevision() {
        Object ref = this.revision_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.revision_ = s;
        return s;
    }

    @Override
    public ByteString getRevisionBytes() {
        Object ref = this.revision_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.revision_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getMaxInstanceRequestConcurrency() {
        return this.maxInstanceRequestConcurrency_;
    }

    @Override
    public int getSecurityLevelValue() {
        return this.securityLevel_;
    }

    @Override
    public SecurityLevel getSecurityLevel() {
        SecurityLevel result = SecurityLevel.forNumber(this.securityLevel_);
        return result == null ? SecurityLevel.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.service_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.service_);
        }
        if (this.timeoutSeconds_ != 0) {
            output.writeInt32(2, this.timeoutSeconds_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetEnvironmentVariables(), EnvironmentVariablesDefaultEntryHolder.defaultEntry, (int)4);
        if (this.maxInstanceCount_ != 0) {
            output.writeInt32(5, this.maxInstanceCount_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.vpcConnector_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.vpcConnector_);
        }
        if (this.vpcConnectorEgressSettings_ != VpcConnectorEgressSettings.VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED.getNumber()) {
            output.writeEnum(7, this.vpcConnectorEgressSettings_);
        }
        if (this.ingressSettings_ != IngressSettings.INGRESS_SETTINGS_UNSPECIFIED.getNumber()) {
            output.writeEnum(8, this.ingressSettings_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.uri_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.uri_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceAccountEmail_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.serviceAccountEmail_);
        }
        if (this.minInstanceCount_ != 0) {
            output.writeInt32(12, this.minInstanceCount_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.availableMemory_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.availableMemory_);
        }
        if (this.allTrafficOnLatestRevision_) {
            output.writeBool(16, this.allTrafficOnLatestRevision_);
        }
        for (i = 0; i < this.secretEnvironmentVariables_.size(); ++i) {
            output.writeMessage(17, (MessageLite)this.secretEnvironmentVariables_.get(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.revision_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)18, (Object)this.revision_);
        }
        for (i = 0; i < this.secretVolumes_.size(); ++i) {
            output.writeMessage(19, (MessageLite)this.secretVolumes_.get(i));
        }
        if (this.maxInstanceRequestConcurrency_ != 0) {
            output.writeInt32(20, this.maxInstanceRequestConcurrency_);
        }
        if (this.securityLevel_ != SecurityLevel.SECURITY_LEVEL_UNSPECIFIED.getNumber()) {
            output.writeEnum(21, this.securityLevel_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.availableCpu_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)22, (Object)this.availableCpu_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.service_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.service_);
        }
        if (this.timeoutSeconds_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)2, (int)this.timeoutSeconds_);
        }
        for (Map.Entry entry : this.internalGetEnvironmentVariables().getMap().entrySet()) {
            MapEntry environmentVariables__ = EnvironmentVariablesDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)environmentVariables__);
        }
        if (this.maxInstanceCount_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)5, (int)this.maxInstanceCount_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.vpcConnector_)) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.vpcConnector_);
        }
        if (this.vpcConnectorEgressSettings_ != VpcConnectorEgressSettings.VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)7, (int)this.vpcConnectorEgressSettings_);
        }
        if (this.ingressSettings_ != IngressSettings.INGRESS_SETTINGS_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)8, (int)this.ingressSettings_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.uri_)) {
            size += GeneratedMessageV3.computeStringSize((int)9, (Object)this.uri_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceAccountEmail_)) {
            size += GeneratedMessageV3.computeStringSize((int)10, (Object)this.serviceAccountEmail_);
        }
        if (this.minInstanceCount_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)12, (int)this.minInstanceCount_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.availableMemory_)) {
            size += GeneratedMessageV3.computeStringSize((int)13, (Object)this.availableMemory_);
        }
        if (this.allTrafficOnLatestRevision_) {
            size += CodedOutputStream.computeBoolSize((int)16, (boolean)this.allTrafficOnLatestRevision_);
        }
        for (i = 0; i < this.secretEnvironmentVariables_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)17, (MessageLite)((MessageLite)this.secretEnvironmentVariables_.get(i)));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.revision_)) {
            size += GeneratedMessageV3.computeStringSize((int)18, (Object)this.revision_);
        }
        for (i = 0; i < this.secretVolumes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)19, (MessageLite)((MessageLite)this.secretVolumes_.get(i)));
        }
        if (this.maxInstanceRequestConcurrency_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)20, (int)this.maxInstanceRequestConcurrency_);
        }
        if (this.securityLevel_ != SecurityLevel.SECURITY_LEVEL_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)21, (int)this.securityLevel_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.availableCpu_)) {
            size += GeneratedMessageV3.computeStringSize((int)22, (Object)this.availableCpu_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServiceConfig)) {
            return super.equals(obj);
        }
        ServiceConfig other = (ServiceConfig)obj;
        if (!this.getService().equals(other.getService())) {
            return false;
        }
        if (this.getTimeoutSeconds() != other.getTimeoutSeconds()) {
            return false;
        }
        if (!this.getAvailableMemory().equals(other.getAvailableMemory())) {
            return false;
        }
        if (!this.getAvailableCpu().equals(other.getAvailableCpu())) {
            return false;
        }
        if (!this.internalGetEnvironmentVariables().equals(other.internalGetEnvironmentVariables())) {
            return false;
        }
        if (this.getMaxInstanceCount() != other.getMaxInstanceCount()) {
            return false;
        }
        if (this.getMinInstanceCount() != other.getMinInstanceCount()) {
            return false;
        }
        if (!this.getVpcConnector().equals(other.getVpcConnector())) {
            return false;
        }
        if (this.vpcConnectorEgressSettings_ != other.vpcConnectorEgressSettings_) {
            return false;
        }
        if (this.ingressSettings_ != other.ingressSettings_) {
            return false;
        }
        if (!this.getUri().equals(other.getUri())) {
            return false;
        }
        if (!this.getServiceAccountEmail().equals(other.getServiceAccountEmail())) {
            return false;
        }
        if (this.getAllTrafficOnLatestRevision() != other.getAllTrafficOnLatestRevision()) {
            return false;
        }
        if (!this.getSecretEnvironmentVariablesList().equals(other.getSecretEnvironmentVariablesList())) {
            return false;
        }
        if (!this.getSecretVolumesList().equals(other.getSecretVolumesList())) {
            return false;
        }
        if (!this.getRevision().equals(other.getRevision())) {
            return false;
        }
        if (this.getMaxInstanceRequestConcurrency() != other.getMaxInstanceRequestConcurrency()) {
            return false;
        }
        if (this.securityLevel_ != other.securityLevel_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ServiceConfig.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getService().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getTimeoutSeconds();
        hash = 37 * hash + 13;
        hash = 53 * hash + this.getAvailableMemory().hashCode();
        hash = 37 * hash + 22;
        hash = 53 * hash + this.getAvailableCpu().hashCode();
        if (!this.internalGetEnvironmentVariables().getMap().isEmpty()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.internalGetEnvironmentVariables().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getMaxInstanceCount();
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getMinInstanceCount();
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getVpcConnector().hashCode();
        hash = 37 * hash + 7;
        hash = 53 * hash + this.vpcConnectorEgressSettings_;
        hash = 37 * hash + 8;
        hash = 53 * hash + this.ingressSettings_;
        hash = 37 * hash + 9;
        hash = 53 * hash + this.getUri().hashCode();
        hash = 37 * hash + 10;
        hash = 53 * hash + this.getServiceAccountEmail().hashCode();
        hash = 37 * hash + 16;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getAllTrafficOnLatestRevision());
        if (this.getSecretEnvironmentVariablesCount() > 0) {
            hash = 37 * hash + 17;
            hash = 53 * hash + this.getSecretEnvironmentVariablesList().hashCode();
        }
        if (this.getSecretVolumesCount() > 0) {
            hash = 37 * hash + 19;
            hash = 53 * hash + this.getSecretVolumesList().hashCode();
        }
        hash = 37 * hash + 18;
        hash = 53 * hash + this.getRevision().hashCode();
        hash = 37 * hash + 20;
        hash = 53 * hash + this.getMaxInstanceRequestConcurrency();
        hash = 37 * hash + 21;
        hash = 53 * hash + this.securityLevel_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ServiceConfig parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (ServiceConfig)PARSER.parseFrom(data);
    }

    public static ServiceConfig parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ServiceConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ServiceConfig parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (ServiceConfig)PARSER.parseFrom(data);
    }

    public static ServiceConfig parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ServiceConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ServiceConfig parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (ServiceConfig)PARSER.parseFrom(data);
    }

    public static ServiceConfig parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ServiceConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ServiceConfig parseFrom(InputStream input) throws IOException {
        return (ServiceConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static ServiceConfig parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ServiceConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ServiceConfig parseDelimitedFrom(InputStream input) throws IOException {
        return (ServiceConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static ServiceConfig parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ServiceConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ServiceConfig parseFrom(CodedInputStream input) throws IOException {
        return (ServiceConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static ServiceConfig parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ServiceConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return ServiceConfig.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ServiceConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ServiceConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ServiceConfig> parser() {
        return PARSER;
    }

    public Parser<ServiceConfig> getParserForType() {
        return PARSER;
    }

    public ServiceConfig getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ServiceConfigOrBuilder {
        private int bitField0_;
        private Object service_ = "";
        private int timeoutSeconds_;
        private Object availableMemory_ = "";
        private Object availableCpu_ = "";
        private MapField<String, String> environmentVariables_;
        private int maxInstanceCount_;
        private int minInstanceCount_;
        private Object vpcConnector_ = "";
        private int vpcConnectorEgressSettings_ = 0;
        private int ingressSettings_ = 0;
        private Object uri_ = "";
        private Object serviceAccountEmail_ = "";
        private boolean allTrafficOnLatestRevision_;
        private List<SecretEnvVar> secretEnvironmentVariables_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<SecretEnvVar, SecretEnvVar.Builder, SecretEnvVarOrBuilder> secretEnvironmentVariablesBuilder_;
        private List<SecretVolume> secretVolumes_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<SecretVolume, SecretVolume.Builder, SecretVolumeOrBuilder> secretVolumesBuilder_;
        private Object revision_ = "";
        private int maxInstanceRequestConcurrency_;
        private int securityLevel_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return FunctionsProto.internal_static_google_cloud_functions_v2alpha_ServiceConfig_descriptor;
        }

        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 4: {
                    return this.internalGetEnvironmentVariables();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapField internalGetMutableMapField(int number) {
            switch (number) {
                case 4: {
                    return this.internalGetMutableEnvironmentVariables();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return FunctionsProto.internal_static_google_cloud_functions_v2alpha_ServiceConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(ServiceConfig.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.service_ = "";
            this.timeoutSeconds_ = 0;
            this.availableMemory_ = "";
            this.availableCpu_ = "";
            this.internalGetMutableEnvironmentVariables().clear();
            this.maxInstanceCount_ = 0;
            this.minInstanceCount_ = 0;
            this.vpcConnector_ = "";
            this.vpcConnectorEgressSettings_ = 0;
            this.ingressSettings_ = 0;
            this.uri_ = "";
            this.serviceAccountEmail_ = "";
            this.allTrafficOnLatestRevision_ = false;
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                this.secretEnvironmentVariables_ = Collections.emptyList();
            } else {
                this.secretEnvironmentVariables_ = null;
                this.secretEnvironmentVariablesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFDFFF;
            if (this.secretVolumesBuilder_ == null) {
                this.secretVolumes_ = Collections.emptyList();
            } else {
                this.secretVolumes_ = null;
                this.secretVolumesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFBFFF;
            this.revision_ = "";
            this.maxInstanceRequestConcurrency_ = 0;
            this.securityLevel_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return FunctionsProto.internal_static_google_cloud_functions_v2alpha_ServiceConfig_descriptor;
        }

        public ServiceConfig getDefaultInstanceForType() {
            return ServiceConfig.getDefaultInstance();
        }

        public ServiceConfig build() {
            ServiceConfig result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public ServiceConfig buildPartial() {
            ServiceConfig result = new ServiceConfig(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(ServiceConfig result) {
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                if ((this.bitField0_ & 0x2000) != 0) {
                    this.secretEnvironmentVariables_ = Collections.unmodifiableList(this.secretEnvironmentVariables_);
                    this.bitField0_ &= 0xFFFFDFFF;
                }
                result.secretEnvironmentVariables_ = this.secretEnvironmentVariables_;
            } else {
                result.secretEnvironmentVariables_ = this.secretEnvironmentVariablesBuilder_.build();
            }
            if (this.secretVolumesBuilder_ == null) {
                if ((this.bitField0_ & 0x4000) != 0) {
                    this.secretVolumes_ = Collections.unmodifiableList(this.secretVolumes_);
                    this.bitField0_ &= 0xFFFFBFFF;
                }
                result.secretVolumes_ = this.secretVolumes_;
            } else {
                result.secretVolumes_ = this.secretVolumesBuilder_.build();
            }
        }

        private void buildPartial0(ServiceConfig result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.service_ = this.service_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.timeoutSeconds_ = this.timeoutSeconds_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.availableMemory_ = this.availableMemory_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.availableCpu_ = this.availableCpu_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.environmentVariables_ = this.internalGetEnvironmentVariables();
                result.environmentVariables_.makeImmutable();
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.maxInstanceCount_ = this.maxInstanceCount_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.minInstanceCount_ = this.minInstanceCount_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.vpcConnector_ = this.vpcConnector_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.vpcConnectorEgressSettings_ = this.vpcConnectorEgressSettings_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.ingressSettings_ = this.ingressSettings_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.uri_ = this.uri_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.serviceAccountEmail_ = this.serviceAccountEmail_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.allTrafficOnLatestRevision_ = this.allTrafficOnLatestRevision_;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.revision_ = this.revision_;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.maxInstanceRequestConcurrency_ = this.maxInstanceRequestConcurrency_;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.securityLevel_ = this.securityLevel_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof ServiceConfig) {
                return this.mergeFrom((ServiceConfig)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ServiceConfig other) {
            if (other == ServiceConfig.getDefaultInstance()) {
                return this;
            }
            if (!other.getService().isEmpty()) {
                this.service_ = other.service_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.getTimeoutSeconds() != 0) {
                this.setTimeoutSeconds(other.getTimeoutSeconds());
            }
            if (!other.getAvailableMemory().isEmpty()) {
                this.availableMemory_ = other.availableMemory_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (!other.getAvailableCpu().isEmpty()) {
                this.availableCpu_ = other.availableCpu_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            this.internalGetMutableEnvironmentVariables().mergeFrom(other.internalGetEnvironmentVariables());
            this.bitField0_ |= 0x10;
            if (other.getMaxInstanceCount() != 0) {
                this.setMaxInstanceCount(other.getMaxInstanceCount());
            }
            if (other.getMinInstanceCount() != 0) {
                this.setMinInstanceCount(other.getMinInstanceCount());
            }
            if (!other.getVpcConnector().isEmpty()) {
                this.vpcConnector_ = other.vpcConnector_;
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            if (other.vpcConnectorEgressSettings_ != 0) {
                this.setVpcConnectorEgressSettingsValue(other.getVpcConnectorEgressSettingsValue());
            }
            if (other.ingressSettings_ != 0) {
                this.setIngressSettingsValue(other.getIngressSettingsValue());
            }
            if (!other.getUri().isEmpty()) {
                this.uri_ = other.uri_;
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            if (!other.getServiceAccountEmail().isEmpty()) {
                this.serviceAccountEmail_ = other.serviceAccountEmail_;
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            if (other.getAllTrafficOnLatestRevision()) {
                this.setAllTrafficOnLatestRevision(other.getAllTrafficOnLatestRevision());
            }
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                if (!other.secretEnvironmentVariables_.isEmpty()) {
                    if (this.secretEnvironmentVariables_.isEmpty()) {
                        this.secretEnvironmentVariables_ = other.secretEnvironmentVariables_;
                        this.bitField0_ &= 0xFFFFDFFF;
                    } else {
                        this.ensureSecretEnvironmentVariablesIsMutable();
                        this.secretEnvironmentVariables_.addAll(other.secretEnvironmentVariables_);
                    }
                    this.onChanged();
                }
            } else if (!other.secretEnvironmentVariables_.isEmpty()) {
                if (this.secretEnvironmentVariablesBuilder_.isEmpty()) {
                    this.secretEnvironmentVariablesBuilder_.dispose();
                    this.secretEnvironmentVariablesBuilder_ = null;
                    this.secretEnvironmentVariables_ = other.secretEnvironmentVariables_;
                    this.bitField0_ &= 0xFFFFDFFF;
                    this.secretEnvironmentVariablesBuilder_ = alwaysUseFieldBuilders ? this.getSecretEnvironmentVariablesFieldBuilder() : null;
                } else {
                    this.secretEnvironmentVariablesBuilder_.addAllMessages((Iterable)other.secretEnvironmentVariables_);
                }
            }
            if (this.secretVolumesBuilder_ == null) {
                if (!other.secretVolumes_.isEmpty()) {
                    if (this.secretVolumes_.isEmpty()) {
                        this.secretVolumes_ = other.secretVolumes_;
                        this.bitField0_ &= 0xFFFFBFFF;
                    } else {
                        this.ensureSecretVolumesIsMutable();
                        this.secretVolumes_.addAll(other.secretVolumes_);
                    }
                    this.onChanged();
                }
            } else if (!other.secretVolumes_.isEmpty()) {
                if (this.secretVolumesBuilder_.isEmpty()) {
                    this.secretVolumesBuilder_.dispose();
                    this.secretVolumesBuilder_ = null;
                    this.secretVolumes_ = other.secretVolumes_;
                    this.bitField0_ &= 0xFFFFBFFF;
                    this.secretVolumesBuilder_ = alwaysUseFieldBuilders ? this.getSecretVolumesFieldBuilder() : null;
                } else {
                    this.secretVolumesBuilder_.addAllMessages((Iterable)other.secretVolumes_);
                }
            }
            if (!other.getRevision().isEmpty()) {
                this.revision_ = other.revision_;
                this.bitField0_ |= 0x8000;
                this.onChanged();
            }
            if (other.getMaxInstanceRequestConcurrency() != 0) {
                this.setMaxInstanceRequestConcurrency(other.getMaxInstanceRequestConcurrency());
            }
            if (other.securityLevel_ != 0) {
                this.setSecurityLevelValue(other.getSecurityLevelValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block26: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block26;
                        }
                        case 10: {
                            this.service_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block26;
                        }
                        case 16: {
                            this.timeoutSeconds_ = input.readInt32();
                            this.bitField0_ |= 2;
                            continue block26;
                        }
                        case 34: {
                            MapEntry environmentVariables__ = (MapEntry)input.readMessage(EnvironmentVariablesDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableEnvironmentVariables().getMutableMap().put(environmentVariables__.getKey(), environmentVariables__.getValue());
                            this.bitField0_ |= 0x10;
                            continue block26;
                        }
                        case 40: {
                            this.maxInstanceCount_ = input.readInt32();
                            this.bitField0_ |= 0x20;
                            continue block26;
                        }
                        case 50: {
                            this.vpcConnector_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x80;
                            continue block26;
                        }
                        case 56: {
                            this.vpcConnectorEgressSettings_ = input.readEnum();
                            this.bitField0_ |= 0x100;
                            continue block26;
                        }
                        case 64: {
                            this.ingressSettings_ = input.readEnum();
                            this.bitField0_ |= 0x200;
                            continue block26;
                        }
                        case 74: {
                            this.uri_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x400;
                            continue block26;
                        }
                        case 82: {
                            this.serviceAccountEmail_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x800;
                            continue block26;
                        }
                        case 96: {
                            this.minInstanceCount_ = input.readInt32();
                            this.bitField0_ |= 0x40;
                            continue block26;
                        }
                        case 106: {
                            this.availableMemory_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block26;
                        }
                        case 128: {
                            this.allTrafficOnLatestRevision_ = input.readBool();
                            this.bitField0_ |= 0x1000;
                            continue block26;
                        }
                        case 138: {
                            GeneratedMessageV3 m = (SecretEnvVar)input.readMessage(SecretEnvVar.parser(), extensionRegistry);
                            if (this.secretEnvironmentVariablesBuilder_ == null) {
                                this.ensureSecretEnvironmentVariablesIsMutable();
                                this.secretEnvironmentVariables_.add((SecretEnvVar)m);
                                continue block26;
                            }
                            this.secretEnvironmentVariablesBuilder_.addMessage((AbstractMessage)m);
                            continue block26;
                        }
                        case 146: {
                            this.revision_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x8000;
                            continue block26;
                        }
                        case 154: {
                            GeneratedMessageV3 m = (SecretVolume)input.readMessage(SecretVolume.parser(), extensionRegistry);
                            if (this.secretVolumesBuilder_ == null) {
                                this.ensureSecretVolumesIsMutable();
                                this.secretVolumes_.add((SecretVolume)m);
                                continue block26;
                            }
                            this.secretVolumesBuilder_.addMessage((AbstractMessage)m);
                            continue block26;
                        }
                        case 160: {
                            this.maxInstanceRequestConcurrency_ = input.readInt32();
                            this.bitField0_ |= 0x10000;
                            continue block26;
                        }
                        case 168: {
                            this.securityLevel_ = input.readEnum();
                            this.bitField0_ |= 0x20000;
                            continue block26;
                        }
                        case 178: {
                            this.availableCpu_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block26;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getService() {
            Object ref = this.service_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.service_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getServiceBytes() {
            Object ref = this.service_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.service_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setService(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.service_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearService() {
            this.service_ = ServiceConfig.getDefaultInstance().getService();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setServiceBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ServiceConfig.checkByteStringIsUtf8((ByteString)value);
            this.service_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public int getTimeoutSeconds() {
            return this.timeoutSeconds_;
        }

        public Builder setTimeoutSeconds(int value) {
            this.timeoutSeconds_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearTimeoutSeconds() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.timeoutSeconds_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getAvailableMemory() {
            Object ref = this.availableMemory_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.availableMemory_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAvailableMemoryBytes() {
            Object ref = this.availableMemory_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.availableMemory_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAvailableMemory(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.availableMemory_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearAvailableMemory() {
            this.availableMemory_ = ServiceConfig.getDefaultInstance().getAvailableMemory();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setAvailableMemoryBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ServiceConfig.checkByteStringIsUtf8((ByteString)value);
            this.availableMemory_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public String getAvailableCpu() {
            Object ref = this.availableCpu_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.availableCpu_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAvailableCpuBytes() {
            Object ref = this.availableCpu_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.availableCpu_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAvailableCpu(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.availableCpu_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearAvailableCpu() {
            this.availableCpu_ = ServiceConfig.getDefaultInstance().getAvailableCpu();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setAvailableCpuBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ServiceConfig.checkByteStringIsUtf8((ByteString)value);
            this.availableCpu_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        private MapField<String, String> internalGetEnvironmentVariables() {
            if (this.environmentVariables_ == null) {
                return MapField.emptyMapField(EnvironmentVariablesDefaultEntryHolder.defaultEntry);
            }
            return this.environmentVariables_;
        }

        private MapField<String, String> internalGetMutableEnvironmentVariables() {
            if (this.environmentVariables_ == null) {
                this.environmentVariables_ = MapField.newMapField(EnvironmentVariablesDefaultEntryHolder.defaultEntry);
            }
            if (!this.environmentVariables_.isMutable()) {
                this.environmentVariables_ = this.environmentVariables_.copy();
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this.environmentVariables_;
        }

        @Override
        public int getEnvironmentVariablesCount() {
            return this.internalGetEnvironmentVariables().getMap().size();
        }

        @Override
        public boolean containsEnvironmentVariables(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetEnvironmentVariables().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getEnvironmentVariables() {
            return this.getEnvironmentVariablesMap();
        }

        @Override
        public Map<String, String> getEnvironmentVariablesMap() {
            return this.internalGetEnvironmentVariables().getMap();
        }

        @Override
        public String getEnvironmentVariablesOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetEnvironmentVariables().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getEnvironmentVariablesOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetEnvironmentVariables().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearEnvironmentVariables() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.internalGetMutableEnvironmentVariables().getMutableMap().clear();
            return this;
        }

        public Builder removeEnvironmentVariables(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableEnvironmentVariables().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableEnvironmentVariables() {
            this.bitField0_ |= 0x10;
            return this.internalGetMutableEnvironmentVariables().getMutableMap();
        }

        public Builder putEnvironmentVariables(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableEnvironmentVariables().getMutableMap().put(key, value);
            this.bitField0_ |= 0x10;
            return this;
        }

        public Builder putAllEnvironmentVariables(Map<String, String> values) {
            this.internalGetMutableEnvironmentVariables().getMutableMap().putAll(values);
            this.bitField0_ |= 0x10;
            return this;
        }

        @Override
        public int getMaxInstanceCount() {
            return this.maxInstanceCount_;
        }

        public Builder setMaxInstanceCount(int value) {
            this.maxInstanceCount_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearMaxInstanceCount() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.maxInstanceCount_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getMinInstanceCount() {
            return this.minInstanceCount_;
        }

        public Builder setMinInstanceCount(int value) {
            this.minInstanceCount_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearMinInstanceCount() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.minInstanceCount_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getVpcConnector() {
            Object ref = this.vpcConnector_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.vpcConnector_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getVpcConnectorBytes() {
            Object ref = this.vpcConnector_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.vpcConnector_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setVpcConnector(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.vpcConnector_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearVpcConnector() {
            this.vpcConnector_ = ServiceConfig.getDefaultInstance().getVpcConnector();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder setVpcConnectorBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ServiceConfig.checkByteStringIsUtf8((ByteString)value);
            this.vpcConnector_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public int getVpcConnectorEgressSettingsValue() {
            return this.vpcConnectorEgressSettings_;
        }

        public Builder setVpcConnectorEgressSettingsValue(int value) {
            this.vpcConnectorEgressSettings_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        @Override
        public VpcConnectorEgressSettings getVpcConnectorEgressSettings() {
            VpcConnectorEgressSettings result = VpcConnectorEgressSettings.forNumber(this.vpcConnectorEgressSettings_);
            return result == null ? VpcConnectorEgressSettings.UNRECOGNIZED : result;
        }

        public Builder setVpcConnectorEgressSettings(VpcConnectorEgressSettings value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x100;
            this.vpcConnectorEgressSettings_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearVpcConnectorEgressSettings() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.vpcConnectorEgressSettings_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getIngressSettingsValue() {
            return this.ingressSettings_;
        }

        public Builder setIngressSettingsValue(int value) {
            this.ingressSettings_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public IngressSettings getIngressSettings() {
            IngressSettings result = IngressSettings.forNumber(this.ingressSettings_);
            return result == null ? IngressSettings.UNRECOGNIZED : result;
        }

        public Builder setIngressSettings(IngressSettings value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x200;
            this.ingressSettings_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearIngressSettings() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.ingressSettings_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getUri() {
            Object ref = this.uri_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.uri_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getUriBytes() {
            Object ref = this.uri_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.uri_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setUri(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.uri_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearUri() {
            this.uri_ = ServiceConfig.getDefaultInstance().getUri();
            this.bitField0_ &= 0xFFFFFBFF;
            this.onChanged();
            return this;
        }

        public Builder setUriBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ServiceConfig.checkByteStringIsUtf8((ByteString)value);
            this.uri_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public String getServiceAccountEmail() {
            Object ref = this.serviceAccountEmail_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.serviceAccountEmail_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getServiceAccountEmailBytes() {
            Object ref = this.serviceAccountEmail_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.serviceAccountEmail_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setServiceAccountEmail(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.serviceAccountEmail_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearServiceAccountEmail() {
            this.serviceAccountEmail_ = ServiceConfig.getDefaultInstance().getServiceAccountEmail();
            this.bitField0_ &= 0xFFFFF7FF;
            this.onChanged();
            return this;
        }

        public Builder setServiceAccountEmailBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ServiceConfig.checkByteStringIsUtf8((ByteString)value);
            this.serviceAccountEmail_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getAllTrafficOnLatestRevision() {
            return this.allTrafficOnLatestRevision_;
        }

        public Builder setAllTrafficOnLatestRevision(boolean value) {
            this.allTrafficOnLatestRevision_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearAllTrafficOnLatestRevision() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.allTrafficOnLatestRevision_ = false;
            this.onChanged();
            return this;
        }

        private void ensureSecretEnvironmentVariablesIsMutable() {
            if ((this.bitField0_ & 0x2000) == 0) {
                this.secretEnvironmentVariables_ = new ArrayList<SecretEnvVar>(this.secretEnvironmentVariables_);
                this.bitField0_ |= 0x2000;
            }
        }

        @Override
        public List<SecretEnvVar> getSecretEnvironmentVariablesList() {
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                return Collections.unmodifiableList(this.secretEnvironmentVariables_);
            }
            return this.secretEnvironmentVariablesBuilder_.getMessageList();
        }

        @Override
        public int getSecretEnvironmentVariablesCount() {
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                return this.secretEnvironmentVariables_.size();
            }
            return this.secretEnvironmentVariablesBuilder_.getCount();
        }

        @Override
        public SecretEnvVar getSecretEnvironmentVariables(int index) {
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                return this.secretEnvironmentVariables_.get(index);
            }
            return (SecretEnvVar)this.secretEnvironmentVariablesBuilder_.getMessage(index);
        }

        public Builder setSecretEnvironmentVariables(int index, SecretEnvVar value) {
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSecretEnvironmentVariablesIsMutable();
                this.secretEnvironmentVariables_.set(index, value);
                this.onChanged();
            } else {
                this.secretEnvironmentVariablesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setSecretEnvironmentVariables(int index, SecretEnvVar.Builder builderForValue) {
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                this.ensureSecretEnvironmentVariablesIsMutable();
                this.secretEnvironmentVariables_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.secretEnvironmentVariablesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addSecretEnvironmentVariables(SecretEnvVar value) {
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSecretEnvironmentVariablesIsMutable();
                this.secretEnvironmentVariables_.add(value);
                this.onChanged();
            } else {
                this.secretEnvironmentVariablesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addSecretEnvironmentVariables(int index, SecretEnvVar value) {
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSecretEnvironmentVariablesIsMutable();
                this.secretEnvironmentVariables_.add(index, value);
                this.onChanged();
            } else {
                this.secretEnvironmentVariablesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addSecretEnvironmentVariables(SecretEnvVar.Builder builderForValue) {
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                this.ensureSecretEnvironmentVariablesIsMutable();
                this.secretEnvironmentVariables_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.secretEnvironmentVariablesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addSecretEnvironmentVariables(int index, SecretEnvVar.Builder builderForValue) {
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                this.ensureSecretEnvironmentVariablesIsMutable();
                this.secretEnvironmentVariables_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.secretEnvironmentVariablesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllSecretEnvironmentVariables(Iterable<? extends SecretEnvVar> values) {
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                this.ensureSecretEnvironmentVariablesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.secretEnvironmentVariables_);
                this.onChanged();
            } else {
                this.secretEnvironmentVariablesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearSecretEnvironmentVariables() {
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                this.secretEnvironmentVariables_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFDFFF;
                this.onChanged();
            } else {
                this.secretEnvironmentVariablesBuilder_.clear();
            }
            return this;
        }

        public Builder removeSecretEnvironmentVariables(int index) {
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                this.ensureSecretEnvironmentVariablesIsMutable();
                this.secretEnvironmentVariables_.remove(index);
                this.onChanged();
            } else {
                this.secretEnvironmentVariablesBuilder_.remove(index);
            }
            return this;
        }

        public SecretEnvVar.Builder getSecretEnvironmentVariablesBuilder(int index) {
            return (SecretEnvVar.Builder)this.getSecretEnvironmentVariablesFieldBuilder().getBuilder(index);
        }

        @Override
        public SecretEnvVarOrBuilder getSecretEnvironmentVariablesOrBuilder(int index) {
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                return this.secretEnvironmentVariables_.get(index);
            }
            return (SecretEnvVarOrBuilder)this.secretEnvironmentVariablesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends SecretEnvVarOrBuilder> getSecretEnvironmentVariablesOrBuilderList() {
            if (this.secretEnvironmentVariablesBuilder_ != null) {
                return this.secretEnvironmentVariablesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.secretEnvironmentVariables_);
        }

        public SecretEnvVar.Builder addSecretEnvironmentVariablesBuilder() {
            return (SecretEnvVar.Builder)this.getSecretEnvironmentVariablesFieldBuilder().addBuilder((AbstractMessage)SecretEnvVar.getDefaultInstance());
        }

        public SecretEnvVar.Builder addSecretEnvironmentVariablesBuilder(int index) {
            return (SecretEnvVar.Builder)this.getSecretEnvironmentVariablesFieldBuilder().addBuilder(index, (AbstractMessage)SecretEnvVar.getDefaultInstance());
        }

        public List<SecretEnvVar.Builder> getSecretEnvironmentVariablesBuilderList() {
            return this.getSecretEnvironmentVariablesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<SecretEnvVar, SecretEnvVar.Builder, SecretEnvVarOrBuilder> getSecretEnvironmentVariablesFieldBuilder() {
            if (this.secretEnvironmentVariablesBuilder_ == null) {
                this.secretEnvironmentVariablesBuilder_ = new RepeatedFieldBuilderV3(this.secretEnvironmentVariables_, (this.bitField0_ & 0x2000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.secretEnvironmentVariables_ = null;
            }
            return this.secretEnvironmentVariablesBuilder_;
        }

        private void ensureSecretVolumesIsMutable() {
            if ((this.bitField0_ & 0x4000) == 0) {
                this.secretVolumes_ = new ArrayList<SecretVolume>(this.secretVolumes_);
                this.bitField0_ |= 0x4000;
            }
        }

        @Override
        public List<SecretVolume> getSecretVolumesList() {
            if (this.secretVolumesBuilder_ == null) {
                return Collections.unmodifiableList(this.secretVolumes_);
            }
            return this.secretVolumesBuilder_.getMessageList();
        }

        @Override
        public int getSecretVolumesCount() {
            if (this.secretVolumesBuilder_ == null) {
                return this.secretVolumes_.size();
            }
            return this.secretVolumesBuilder_.getCount();
        }

        @Override
        public SecretVolume getSecretVolumes(int index) {
            if (this.secretVolumesBuilder_ == null) {
                return this.secretVolumes_.get(index);
            }
            return (SecretVolume)this.secretVolumesBuilder_.getMessage(index);
        }

        public Builder setSecretVolumes(int index, SecretVolume value) {
            if (this.secretVolumesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSecretVolumesIsMutable();
                this.secretVolumes_.set(index, value);
                this.onChanged();
            } else {
                this.secretVolumesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setSecretVolumes(int index, SecretVolume.Builder builderForValue) {
            if (this.secretVolumesBuilder_ == null) {
                this.ensureSecretVolumesIsMutable();
                this.secretVolumes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.secretVolumesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addSecretVolumes(SecretVolume value) {
            if (this.secretVolumesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSecretVolumesIsMutable();
                this.secretVolumes_.add(value);
                this.onChanged();
            } else {
                this.secretVolumesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addSecretVolumes(int index, SecretVolume value) {
            if (this.secretVolumesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSecretVolumesIsMutable();
                this.secretVolumes_.add(index, value);
                this.onChanged();
            } else {
                this.secretVolumesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addSecretVolumes(SecretVolume.Builder builderForValue) {
            if (this.secretVolumesBuilder_ == null) {
                this.ensureSecretVolumesIsMutable();
                this.secretVolumes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.secretVolumesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addSecretVolumes(int index, SecretVolume.Builder builderForValue) {
            if (this.secretVolumesBuilder_ == null) {
                this.ensureSecretVolumesIsMutable();
                this.secretVolumes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.secretVolumesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllSecretVolumes(Iterable<? extends SecretVolume> values) {
            if (this.secretVolumesBuilder_ == null) {
                this.ensureSecretVolumesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.secretVolumes_);
                this.onChanged();
            } else {
                this.secretVolumesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearSecretVolumes() {
            if (this.secretVolumesBuilder_ == null) {
                this.secretVolumes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFBFFF;
                this.onChanged();
            } else {
                this.secretVolumesBuilder_.clear();
            }
            return this;
        }

        public Builder removeSecretVolumes(int index) {
            if (this.secretVolumesBuilder_ == null) {
                this.ensureSecretVolumesIsMutable();
                this.secretVolumes_.remove(index);
                this.onChanged();
            } else {
                this.secretVolumesBuilder_.remove(index);
            }
            return this;
        }

        public SecretVolume.Builder getSecretVolumesBuilder(int index) {
            return (SecretVolume.Builder)this.getSecretVolumesFieldBuilder().getBuilder(index);
        }

        @Override
        public SecretVolumeOrBuilder getSecretVolumesOrBuilder(int index) {
            if (this.secretVolumesBuilder_ == null) {
                return this.secretVolumes_.get(index);
            }
            return (SecretVolumeOrBuilder)this.secretVolumesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends SecretVolumeOrBuilder> getSecretVolumesOrBuilderList() {
            if (this.secretVolumesBuilder_ != null) {
                return this.secretVolumesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.secretVolumes_);
        }

        public SecretVolume.Builder addSecretVolumesBuilder() {
            return (SecretVolume.Builder)this.getSecretVolumesFieldBuilder().addBuilder((AbstractMessage)SecretVolume.getDefaultInstance());
        }

        public SecretVolume.Builder addSecretVolumesBuilder(int index) {
            return (SecretVolume.Builder)this.getSecretVolumesFieldBuilder().addBuilder(index, (AbstractMessage)SecretVolume.getDefaultInstance());
        }

        public List<SecretVolume.Builder> getSecretVolumesBuilderList() {
            return this.getSecretVolumesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<SecretVolume, SecretVolume.Builder, SecretVolumeOrBuilder> getSecretVolumesFieldBuilder() {
            if (this.secretVolumesBuilder_ == null) {
                this.secretVolumesBuilder_ = new RepeatedFieldBuilderV3(this.secretVolumes_, (this.bitField0_ & 0x4000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.secretVolumes_ = null;
            }
            return this.secretVolumesBuilder_;
        }

        @Override
        public String getRevision() {
            Object ref = this.revision_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.revision_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRevisionBytes() {
            Object ref = this.revision_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.revision_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRevision(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.revision_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder clearRevision() {
            this.revision_ = ServiceConfig.getDefaultInstance().getRevision();
            this.bitField0_ &= 0xFFFF7FFF;
            this.onChanged();
            return this;
        }

        public Builder setRevisionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ServiceConfig.checkByteStringIsUtf8((ByteString)value);
            this.revision_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        @Override
        public int getMaxInstanceRequestConcurrency() {
            return this.maxInstanceRequestConcurrency_;
        }

        public Builder setMaxInstanceRequestConcurrency(int value) {
            this.maxInstanceRequestConcurrency_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder clearMaxInstanceRequestConcurrency() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.maxInstanceRequestConcurrency_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getSecurityLevelValue() {
            return this.securityLevel_;
        }

        public Builder setSecurityLevelValue(int value) {
            this.securityLevel_ = value;
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        @Override
        public SecurityLevel getSecurityLevel() {
            SecurityLevel result = SecurityLevel.forNumber(this.securityLevel_);
            return result == null ? SecurityLevel.UNRECOGNIZED : result;
        }

        public Builder setSecurityLevel(SecurityLevel value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20000;
            this.securityLevel_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearSecurityLevel() {
            this.bitField0_ &= 0xFFFDFFFF;
            this.securityLevel_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class EnvironmentVariablesDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)FunctionsProto.internal_static_google_cloud_functions_v2alpha_ServiceConfig_EnvironmentVariablesEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private EnvironmentVariablesDefaultEntryHolder() {
        }
    }

    public static enum SecurityLevel implements ProtocolMessageEnum
    {
        SECURITY_LEVEL_UNSPECIFIED(0),
        SECURE_ALWAYS(1),
        SECURE_OPTIONAL(2),
        UNRECOGNIZED(-1);

        public static final int SECURITY_LEVEL_UNSPECIFIED_VALUE = 0;
        public static final int SECURE_ALWAYS_VALUE = 1;
        public static final int SECURE_OPTIONAL_VALUE = 2;
        private static final Internal.EnumLiteMap<SecurityLevel> internalValueMap;
        private static final SecurityLevel[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static SecurityLevel valueOf(int value) {
            return SecurityLevel.forNumber(value);
        }

        public static SecurityLevel forNumber(int value) {
            switch (value) {
                case 0: {
                    return SECURITY_LEVEL_UNSPECIFIED;
                }
                case 1: {
                    return SECURE_ALWAYS;
                }
                case 2: {
                    return SECURE_OPTIONAL;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<SecurityLevel> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)SecurityLevel.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return SecurityLevel.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)ServiceConfig.getDescriptor().getEnumTypes().get(2);
        }

        public static SecurityLevel valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != SecurityLevel.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private SecurityLevel(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<SecurityLevel>(){

                public SecurityLevel findValueByNumber(int number) {
                    return SecurityLevel.forNumber(number);
                }
            };
            VALUES = SecurityLevel.values();
        }
    }

    public static enum IngressSettings implements ProtocolMessageEnum
    {
        INGRESS_SETTINGS_UNSPECIFIED(0),
        ALLOW_ALL(1),
        ALLOW_INTERNAL_ONLY(2),
        ALLOW_INTERNAL_AND_GCLB(3),
        UNRECOGNIZED(-1);

        public static final int INGRESS_SETTINGS_UNSPECIFIED_VALUE = 0;
        public static final int ALLOW_ALL_VALUE = 1;
        public static final int ALLOW_INTERNAL_ONLY_VALUE = 2;
        public static final int ALLOW_INTERNAL_AND_GCLB_VALUE = 3;
        private static final Internal.EnumLiteMap<IngressSettings> internalValueMap;
        private static final IngressSettings[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static IngressSettings valueOf(int value) {
            return IngressSettings.forNumber(value);
        }

        public static IngressSettings forNumber(int value) {
            switch (value) {
                case 0: {
                    return INGRESS_SETTINGS_UNSPECIFIED;
                }
                case 1: {
                    return ALLOW_ALL;
                }
                case 2: {
                    return ALLOW_INTERNAL_ONLY;
                }
                case 3: {
                    return ALLOW_INTERNAL_AND_GCLB;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<IngressSettings> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)IngressSettings.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return IngressSettings.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)ServiceConfig.getDescriptor().getEnumTypes().get(1);
        }

        public static IngressSettings valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != IngressSettings.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private IngressSettings(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<IngressSettings>(){

                public IngressSettings findValueByNumber(int number) {
                    return IngressSettings.forNumber(number);
                }
            };
            VALUES = IngressSettings.values();
        }
    }

    public static enum VpcConnectorEgressSettings implements ProtocolMessageEnum
    {
        VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED(0),
        PRIVATE_RANGES_ONLY(1),
        ALL_TRAFFIC(2),
        UNRECOGNIZED(-1);

        public static final int VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED_VALUE = 0;
        public static final int PRIVATE_RANGES_ONLY_VALUE = 1;
        public static final int ALL_TRAFFIC_VALUE = 2;
        private static final Internal.EnumLiteMap<VpcConnectorEgressSettings> internalValueMap;
        private static final VpcConnectorEgressSettings[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static VpcConnectorEgressSettings valueOf(int value) {
            return VpcConnectorEgressSettings.forNumber(value);
        }

        public static VpcConnectorEgressSettings forNumber(int value) {
            switch (value) {
                case 0: {
                    return VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED;
                }
                case 1: {
                    return PRIVATE_RANGES_ONLY;
                }
                case 2: {
                    return ALL_TRAFFIC;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<VpcConnectorEgressSettings> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)VpcConnectorEgressSettings.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return VpcConnectorEgressSettings.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)ServiceConfig.getDescriptor().getEnumTypes().get(0);
        }

        public static VpcConnectorEgressSettings valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != VpcConnectorEgressSettings.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private VpcConnectorEgressSettings(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<VpcConnectorEgressSettings>(){

                public VpcConnectorEgressSettings findValueByNumber(int number) {
                    return VpcConnectorEgressSettings.forNumber(number);
                }
            };
            VALUES = VpcConnectorEgressSettings.values();
        }
    }
}

