/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/functions/v2/functions.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.functions.v2;

/**
 *
 *
 * <pre>
 * Describes the Build step of the function that builds a container from the
 * given source.
 * </pre>
 *
 * Protobuf type {@code google.cloud.functions.v2.BuildConfig}
 */
public final class BuildConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.functions.v2.BuildConfig)
    BuildConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BuildConfig.newBuilder() to construct.
  private BuildConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BuildConfig() {
    build_ = "";
    runtime_ = "";
    entryPoint_ = "";
    workerPool_ = "";
    dockerRegistry_ = 0;
    dockerRepository_ = "";
    serviceAccount_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BuildConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.functions.v2.FunctionsProto
        .internal_static_google_cloud_functions_v2_BuildConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 6:
        return internalGetEnvironmentVariables();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.functions.v2.FunctionsProto
        .internal_static_google_cloud_functions_v2_BuildConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.functions.v2.BuildConfig.class,
            com.google.cloud.functions.v2.BuildConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Docker Registry to use for storing function Docker images.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.functions.v2.BuildConfig.DockerRegistry}
   */
  public enum DockerRegistry implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>DOCKER_REGISTRY_UNSPECIFIED = 0;</code>
     */
    DOCKER_REGISTRY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Docker images will be stored in multi-regional Container Registry
     * repositories named `gcf`.
     * </pre>
     *
     * <code>CONTAINER_REGISTRY = 1;</code>
     */
    CONTAINER_REGISTRY(1),
    /**
     *
     *
     * <pre>
     * Docker images will be stored in regional Artifact Registry repositories.
     * By default, GCF will create and use repositories named `gcf-artifacts`
     * in every region in which a function is deployed. But the repository to
     * use can also be specified by the user using the `docker_repository`
     * field.
     * </pre>
     *
     * <code>ARTIFACT_REGISTRY = 2;</code>
     */
    ARTIFACT_REGISTRY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>DOCKER_REGISTRY_UNSPECIFIED = 0;</code>
     */
    public static final int DOCKER_REGISTRY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Docker images will be stored in multi-regional Container Registry
     * repositories named `gcf`.
     * </pre>
     *
     * <code>CONTAINER_REGISTRY = 1;</code>
     */
    public static final int CONTAINER_REGISTRY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Docker images will be stored in regional Artifact Registry repositories.
     * By default, GCF will create and use repositories named `gcf-artifacts`
     * in every region in which a function is deployed. But the repository to
     * use can also be specified by the user using the `docker_repository`
     * field.
     * </pre>
     *
     * <code>ARTIFACT_REGISTRY = 2;</code>
     */
    public static final int ARTIFACT_REGISTRY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DockerRegistry valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DockerRegistry forNumber(int value) {
      switch (value) {
        case 0:
          return DOCKER_REGISTRY_UNSPECIFIED;
        case 1:
          return CONTAINER_REGISTRY;
        case 2:
          return ARTIFACT_REGISTRY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DockerRegistry> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DockerRegistry> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DockerRegistry>() {
          public DockerRegistry findValueByNumber(int number) {
            return DockerRegistry.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.functions.v2.BuildConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final DockerRegistry[] VALUES = values();

    public static DockerRegistry valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DockerRegistry(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.functions.v2.BuildConfig.DockerRegistry)
  }

  private int bitField0_;
  private int runtimeUpdatePolicyCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object runtimeUpdatePolicy_;

  public enum RuntimeUpdatePolicyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AUTOMATIC_UPDATE_POLICY(40),
    ON_DEPLOY_UPDATE_POLICY(41),
    RUNTIMEUPDATEPOLICY_NOT_SET(0);
    private final int value;

    private RuntimeUpdatePolicyCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RuntimeUpdatePolicyCase valueOf(int value) {
      return forNumber(value);
    }

    public static RuntimeUpdatePolicyCase forNumber(int value) {
      switch (value) {
        case 40:
          return AUTOMATIC_UPDATE_POLICY;
        case 41:
          return ON_DEPLOY_UPDATE_POLICY;
        case 0:
          return RUNTIMEUPDATEPOLICY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RuntimeUpdatePolicyCase getRuntimeUpdatePolicyCase() {
    return RuntimeUpdatePolicyCase.forNumber(runtimeUpdatePolicyCase_);
  }

  public static final int AUTOMATIC_UPDATE_POLICY_FIELD_NUMBER = 40;
  /**
   * <code>.google.cloud.functions.v2.AutomaticUpdatePolicy automatic_update_policy = 40;</code>
   *
   * @return Whether the automaticUpdatePolicy field is set.
   */
  @java.lang.Override
  public boolean hasAutomaticUpdatePolicy() {
    return runtimeUpdatePolicyCase_ == 40;
  }
  /**
   * <code>.google.cloud.functions.v2.AutomaticUpdatePolicy automatic_update_policy = 40;</code>
   *
   * @return The automaticUpdatePolicy.
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.AutomaticUpdatePolicy getAutomaticUpdatePolicy() {
    if (runtimeUpdatePolicyCase_ == 40) {
      return (com.google.cloud.functions.v2.AutomaticUpdatePolicy) runtimeUpdatePolicy_;
    }
    return com.google.cloud.functions.v2.AutomaticUpdatePolicy.getDefaultInstance();
  }
  /** <code>.google.cloud.functions.v2.AutomaticUpdatePolicy automatic_update_policy = 40;</code> */
  @java.lang.Override
  public com.google.cloud.functions.v2.AutomaticUpdatePolicyOrBuilder
      getAutomaticUpdatePolicyOrBuilder() {
    if (runtimeUpdatePolicyCase_ == 40) {
      return (com.google.cloud.functions.v2.AutomaticUpdatePolicy) runtimeUpdatePolicy_;
    }
    return com.google.cloud.functions.v2.AutomaticUpdatePolicy.getDefaultInstance();
  }

  public static final int ON_DEPLOY_UPDATE_POLICY_FIELD_NUMBER = 41;
  /**
   * <code>.google.cloud.functions.v2.OnDeployUpdatePolicy on_deploy_update_policy = 41;</code>
   *
   * @return Whether the onDeployUpdatePolicy field is set.
   */
  @java.lang.Override
  public boolean hasOnDeployUpdatePolicy() {
    return runtimeUpdatePolicyCase_ == 41;
  }
  /**
   * <code>.google.cloud.functions.v2.OnDeployUpdatePolicy on_deploy_update_policy = 41;</code>
   *
   * @return The onDeployUpdatePolicy.
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.OnDeployUpdatePolicy getOnDeployUpdatePolicy() {
    if (runtimeUpdatePolicyCase_ == 41) {
      return (com.google.cloud.functions.v2.OnDeployUpdatePolicy) runtimeUpdatePolicy_;
    }
    return com.google.cloud.functions.v2.OnDeployUpdatePolicy.getDefaultInstance();
  }
  /** <code>.google.cloud.functions.v2.OnDeployUpdatePolicy on_deploy_update_policy = 41;</code> */
  @java.lang.Override
  public com.google.cloud.functions.v2.OnDeployUpdatePolicyOrBuilder
      getOnDeployUpdatePolicyOrBuilder() {
    if (runtimeUpdatePolicyCase_ == 41) {
      return (com.google.cloud.functions.v2.OnDeployUpdatePolicy) runtimeUpdatePolicy_;
    }
    return com.google.cloud.functions.v2.OnDeployUpdatePolicy.getDefaultInstance();
  }

  public static final int BUILD_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object build_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The Cloud Build name of the latest successful deployment of
   * the function.
   * </pre>
   *
   * <code>
   * string build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The build.
   */
  @java.lang.Override
  public java.lang.String getBuild() {
    java.lang.Object ref = build_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      build_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The Cloud Build name of the latest successful deployment of
   * the function.
   * </pre>
   *
   * <code>
   * string build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for build.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBuildBytes() {
    java.lang.Object ref = build_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      build_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RUNTIME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object runtime_ = "";
  /**
   *
   *
   * <pre>
   * The runtime in which to run the function. Required when deploying a new
   * function, optional when updating an existing function. For a complete
   * list of possible choices, see the
   * [`gcloud` command
   * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
   * </pre>
   *
   * <code>string runtime = 2;</code>
   *
   * @return The runtime.
   */
  @java.lang.Override
  public java.lang.String getRuntime() {
    java.lang.Object ref = runtime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      runtime_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The runtime in which to run the function. Required when deploying a new
   * function, optional when updating an existing function. For a complete
   * list of possible choices, see the
   * [`gcloud` command
   * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
   * </pre>
   *
   * <code>string runtime = 2;</code>
   *
   * @return The bytes for runtime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRuntimeBytes() {
    java.lang.Object ref = runtime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      runtime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTRY_POINT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object entryPoint_ = "";
  /**
   *
   *
   * <pre>
   * The name of the function (as defined in source code) that will be
   * executed. Defaults to the resource name suffix, if not specified. For
   * backward compatibility, if function with given name is not found, then the
   * system will try to use function named "function".
   * For Node.js this is name of a function exported by the module specified
   * in `source_location`.
   * </pre>
   *
   * <code>string entry_point = 3;</code>
   *
   * @return The entryPoint.
   */
  @java.lang.Override
  public java.lang.String getEntryPoint() {
    java.lang.Object ref = entryPoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entryPoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the function (as defined in source code) that will be
   * executed. Defaults to the resource name suffix, if not specified. For
   * backward compatibility, if function with given name is not found, then the
   * system will try to use function named "function".
   * For Node.js this is name of a function exported by the module specified
   * in `source_location`.
   * </pre>
   *
   * <code>string entry_point = 3;</code>
   *
   * @return The bytes for entryPoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntryPointBytes() {
    java.lang.Object ref = entryPoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entryPoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_FIELD_NUMBER = 4;
  private com.google.cloud.functions.v2.Source source_;
  /**
   *
   *
   * <pre>
   * The location of the function source code.
   * </pre>
   *
   * <code>.google.cloud.functions.v2.Source source = 4;</code>
   *
   * @return Whether the source field is set.
   */
  @java.lang.Override
  public boolean hasSource() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The location of the function source code.
   * </pre>
   *
   * <code>.google.cloud.functions.v2.Source source = 4;</code>
   *
   * @return The source.
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.Source getSource() {
    return source_ == null ? com.google.cloud.functions.v2.Source.getDefaultInstance() : source_;
  }
  /**
   *
   *
   * <pre>
   * The location of the function source code.
   * </pre>
   *
   * <code>.google.cloud.functions.v2.Source source = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.SourceOrBuilder getSourceOrBuilder() {
    return source_ == null ? com.google.cloud.functions.v2.Source.getDefaultInstance() : source_;
  }

  public static final int SOURCE_PROVENANCE_FIELD_NUMBER = 8;
  private com.google.cloud.functions.v2.SourceProvenance sourceProvenance_;
  /**
   *
   *
   * <pre>
   * Output only. A permanent fixed identifier for source.
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v2.SourceProvenance source_provenance = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the sourceProvenance field is set.
   */
  @java.lang.Override
  public boolean hasSourceProvenance() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. A permanent fixed identifier for source.
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v2.SourceProvenance source_provenance = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The sourceProvenance.
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.SourceProvenance getSourceProvenance() {
    return sourceProvenance_ == null
        ? com.google.cloud.functions.v2.SourceProvenance.getDefaultInstance()
        : sourceProvenance_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A permanent fixed identifier for source.
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v2.SourceProvenance source_provenance = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.SourceProvenanceOrBuilder getSourceProvenanceOrBuilder() {
    return sourceProvenance_ == null
        ? com.google.cloud.functions.v2.SourceProvenance.getDefaultInstance()
        : sourceProvenance_;
  }

  public static final int WORKER_POOL_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object workerPool_ = "";
  /**
   *
   *
   * <pre>
   * Name of the Cloud Build Custom Worker Pool that should be used to build the
   * function. The format of this field is
   * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
   * {project} and {region} are the project id and region respectively where the
   * worker pool is defined and {workerPool} is the short name of the worker
   * pool.
   *
   * If the project id is not the same as the function, then the Cloud
   * Functions Service Agent
   * (service-&lt;project_number&gt;&#64;gcf-admin-robot.iam.gserviceaccount.com) must be
   * granted the role Cloud Build Custom Workers Builder
   * (roles/cloudbuild.customworkers.builder) in the project.
   * </pre>
   *
   * <code>string worker_pool = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The workerPool.
   */
  @java.lang.Override
  public java.lang.String getWorkerPool() {
    java.lang.Object ref = workerPool_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      workerPool_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the Cloud Build Custom Worker Pool that should be used to build the
   * function. The format of this field is
   * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
   * {project} and {region} are the project id and region respectively where the
   * worker pool is defined and {workerPool} is the short name of the worker
   * pool.
   *
   * If the project id is not the same as the function, then the Cloud
   * Functions Service Agent
   * (service-&lt;project_number&gt;&#64;gcf-admin-robot.iam.gserviceaccount.com) must be
   * granted the role Cloud Build Custom Workers Builder
   * (roles/cloudbuild.customworkers.builder) in the project.
   * </pre>
   *
   * <code>string worker_pool = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for workerPool.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWorkerPoolBytes() {
    java.lang.Object ref = workerPool_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      workerPool_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENVIRONMENT_VARIABLES_FIELD_NUMBER = 6;

  private static final class EnvironmentVariablesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.functions.v2.FunctionsProto
                .internal_static_google_cloud_functions_v2_BuildConfig_EnvironmentVariablesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> environmentVariables_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetEnvironmentVariables() {
    if (environmentVariables_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          EnvironmentVariablesDefaultEntryHolder.defaultEntry);
    }
    return environmentVariables_;
  }

  public int getEnvironmentVariablesCount() {
    return internalGetEnvironmentVariables().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * User-provided build-time environment variables for the function
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment_variables = 6;</code>
   */
  @java.lang.Override
  public boolean containsEnvironmentVariables(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetEnvironmentVariables().getMap().containsKey(key);
  }
  /** Use {@link #getEnvironmentVariablesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
    return getEnvironmentVariablesMap();
  }
  /**
   *
   *
   * <pre>
   * User-provided build-time environment variables for the function
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment_variables = 6;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariablesMap() {
    return internalGetEnvironmentVariables().getMap();
  }
  /**
   *
   *
   * <pre>
   * User-provided build-time environment variables for the function
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment_variables = 6;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getEnvironmentVariablesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetEnvironmentVariables().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * User-provided build-time environment variables for the function
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment_variables = 6;</code>
   */
  @java.lang.Override
  public java.lang.String getEnvironmentVariablesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetEnvironmentVariables().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DOCKER_REGISTRY_FIELD_NUMBER = 10;
  private int dockerRegistry_ = 0;
  /**
   *
   *
   * <pre>
   * Docker Registry to use for this deployment. This configuration is only
   * applicable to 1st Gen functions, 2nd Gen functions can only use Artifact
   * Registry.
   *
   * If unspecified, it defaults to `ARTIFACT_REGISTRY`.
   * If `docker_repository` field is specified, this field should either be left
   * unspecified or set to `ARTIFACT_REGISTRY`.
   * </pre>
   *
   * <code>.google.cloud.functions.v2.BuildConfig.DockerRegistry docker_registry = 10;</code>
   *
   * @return The enum numeric value on the wire for dockerRegistry.
   */
  @java.lang.Override
  public int getDockerRegistryValue() {
    return dockerRegistry_;
  }
  /**
   *
   *
   * <pre>
   * Docker Registry to use for this deployment. This configuration is only
   * applicable to 1st Gen functions, 2nd Gen functions can only use Artifact
   * Registry.
   *
   * If unspecified, it defaults to `ARTIFACT_REGISTRY`.
   * If `docker_repository` field is specified, this field should either be left
   * unspecified or set to `ARTIFACT_REGISTRY`.
   * </pre>
   *
   * <code>.google.cloud.functions.v2.BuildConfig.DockerRegistry docker_registry = 10;</code>
   *
   * @return The dockerRegistry.
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.BuildConfig.DockerRegistry getDockerRegistry() {
    com.google.cloud.functions.v2.BuildConfig.DockerRegistry result =
        com.google.cloud.functions.v2.BuildConfig.DockerRegistry.forNumber(dockerRegistry_);
    return result == null
        ? com.google.cloud.functions.v2.BuildConfig.DockerRegistry.UNRECOGNIZED
        : result;
  }

  public static final int DOCKER_REPOSITORY_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dockerRepository_ = "";
  /**
   *
   *
   * <pre>
   * Repository in Artifact Registry to which the function docker image will be
   * pushed after it is built by Cloud Build. If specified by user, it is
   * created and managed by user with a customer managed encryption key.
   * Otherwise, GCF will create and use a repository named 'gcf-artifacts'
   * for every deployed region.
   *
   * It must match the pattern
   * `projects/{project}/locations/{location}/repositories/{repository}`.
   *
   * Cross-project repositories are not supported.
   * Cross-location repositories are not supported.
   * Repository format must be 'DOCKER'.
   * </pre>
   *
   * <code>string docker_repository = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The dockerRepository.
   */
  @java.lang.Override
  public java.lang.String getDockerRepository() {
    java.lang.Object ref = dockerRepository_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dockerRepository_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Repository in Artifact Registry to which the function docker image will be
   * pushed after it is built by Cloud Build. If specified by user, it is
   * created and managed by user with a customer managed encryption key.
   * Otherwise, GCF will create and use a repository named 'gcf-artifacts'
   * for every deployed region.
   *
   * It must match the pattern
   * `projects/{project}/locations/{location}/repositories/{repository}`.
   *
   * Cross-project repositories are not supported.
   * Cross-location repositories are not supported.
   * Repository format must be 'DOCKER'.
   * </pre>
   *
   * <code>string docker_repository = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for dockerRepository.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDockerRepositoryBytes() {
    java.lang.Object ref = dockerRepository_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dockerRepository_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 27;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Service account to be used for building the container. The format of this
   * field is `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
   * </pre>
   *
   * <code>string service_account = 27;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Service account to be used for building the container. The format of this
   * field is `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
   * </pre>
   *
   * <code>string service_account = 27;</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(build_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, build_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(runtime_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, runtime_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entryPoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, entryPoint_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getSource());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workerPool_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, workerPool_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetEnvironmentVariables(),
        EnvironmentVariablesDefaultEntryHolder.defaultEntry,
        6);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dockerRepository_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, dockerRepository_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getSourceProvenance());
    }
    if (dockerRegistry_
        != com.google.cloud.functions.v2.BuildConfig.DockerRegistry.DOCKER_REGISTRY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, dockerRegistry_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 27, serviceAccount_);
    }
    if (runtimeUpdatePolicyCase_ == 40) {
      output.writeMessage(
          40, (com.google.cloud.functions.v2.AutomaticUpdatePolicy) runtimeUpdatePolicy_);
    }
    if (runtimeUpdatePolicyCase_ == 41) {
      output.writeMessage(
          41, (com.google.cloud.functions.v2.OnDeployUpdatePolicy) runtimeUpdatePolicy_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(build_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, build_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(runtime_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, runtime_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entryPoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, entryPoint_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSource());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workerPool_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, workerPool_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetEnvironmentVariables().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> environmentVariables__ =
          EnvironmentVariablesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, environmentVariables__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dockerRepository_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, dockerRepository_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSourceProvenance());
    }
    if (dockerRegistry_
        != com.google.cloud.functions.v2.BuildConfig.DockerRegistry.DOCKER_REGISTRY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, dockerRegistry_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(27, serviceAccount_);
    }
    if (runtimeUpdatePolicyCase_ == 40) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              40, (com.google.cloud.functions.v2.AutomaticUpdatePolicy) runtimeUpdatePolicy_);
    }
    if (runtimeUpdatePolicyCase_ == 41) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              41, (com.google.cloud.functions.v2.OnDeployUpdatePolicy) runtimeUpdatePolicy_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.functions.v2.BuildConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.functions.v2.BuildConfig other =
        (com.google.cloud.functions.v2.BuildConfig) obj;

    if (!getBuild().equals(other.getBuild())) return false;
    if (!getRuntime().equals(other.getRuntime())) return false;
    if (!getEntryPoint().equals(other.getEntryPoint())) return false;
    if (hasSource() != other.hasSource()) return false;
    if (hasSource()) {
      if (!getSource().equals(other.getSource())) return false;
    }
    if (hasSourceProvenance() != other.hasSourceProvenance()) return false;
    if (hasSourceProvenance()) {
      if (!getSourceProvenance().equals(other.getSourceProvenance())) return false;
    }
    if (!getWorkerPool().equals(other.getWorkerPool())) return false;
    if (!internalGetEnvironmentVariables().equals(other.internalGetEnvironmentVariables()))
      return false;
    if (dockerRegistry_ != other.dockerRegistry_) return false;
    if (!getDockerRepository().equals(other.getDockerRepository())) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getRuntimeUpdatePolicyCase().equals(other.getRuntimeUpdatePolicyCase())) return false;
    switch (runtimeUpdatePolicyCase_) {
      case 40:
        if (!getAutomaticUpdatePolicy().equals(other.getAutomaticUpdatePolicy())) return false;
        break;
      case 41:
        if (!getOnDeployUpdatePolicy().equals(other.getOnDeployUpdatePolicy())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + BUILD_FIELD_NUMBER;
    hash = (53 * hash) + getBuild().hashCode();
    hash = (37 * hash) + RUNTIME_FIELD_NUMBER;
    hash = (53 * hash) + getRuntime().hashCode();
    hash = (37 * hash) + ENTRY_POINT_FIELD_NUMBER;
    hash = (53 * hash) + getEntryPoint().hashCode();
    if (hasSource()) {
      hash = (37 * hash) + SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getSource().hashCode();
    }
    if (hasSourceProvenance()) {
      hash = (37 * hash) + SOURCE_PROVENANCE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceProvenance().hashCode();
    }
    hash = (37 * hash) + WORKER_POOL_FIELD_NUMBER;
    hash = (53 * hash) + getWorkerPool().hashCode();
    if (!internalGetEnvironmentVariables().getMap().isEmpty()) {
      hash = (37 * hash) + ENVIRONMENT_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetEnvironmentVariables().hashCode();
    }
    hash = (37 * hash) + DOCKER_REGISTRY_FIELD_NUMBER;
    hash = (53 * hash) + dockerRegistry_;
    hash = (37 * hash) + DOCKER_REPOSITORY_FIELD_NUMBER;
    hash = (53 * hash) + getDockerRepository().hashCode();
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    switch (runtimeUpdatePolicyCase_) {
      case 40:
        hash = (37 * hash) + AUTOMATIC_UPDATE_POLICY_FIELD_NUMBER;
        hash = (53 * hash) + getAutomaticUpdatePolicy().hashCode();
        break;
      case 41:
        hash = (37 * hash) + ON_DEPLOY_UPDATE_POLICY_FIELD_NUMBER;
        hash = (53 * hash) + getOnDeployUpdatePolicy().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.functions.v2.BuildConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2.BuildConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.BuildConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2.BuildConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.BuildConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2.BuildConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.BuildConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2.BuildConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.BuildConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2.BuildConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.BuildConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2.BuildConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.functions.v2.BuildConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes the Build step of the function that builds a container from the
   * given source.
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v2.BuildConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.functions.v2.BuildConfig)
      com.google.cloud.functions.v2.BuildConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v2.FunctionsProto
          .internal_static_google_cloud_functions_v2_BuildConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetEnvironmentVariables();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetMutableEnvironmentVariables();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v2.FunctionsProto
          .internal_static_google_cloud_functions_v2_BuildConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v2.BuildConfig.class,
              com.google.cloud.functions.v2.BuildConfig.Builder.class);
    }

    // Construct using com.google.cloud.functions.v2.BuildConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSourceFieldBuilder();
        getSourceProvenanceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (automaticUpdatePolicyBuilder_ != null) {
        automaticUpdatePolicyBuilder_.clear();
      }
      if (onDeployUpdatePolicyBuilder_ != null) {
        onDeployUpdatePolicyBuilder_.clear();
      }
      build_ = "";
      runtime_ = "";
      entryPoint_ = "";
      source_ = null;
      if (sourceBuilder_ != null) {
        sourceBuilder_.dispose();
        sourceBuilder_ = null;
      }
      sourceProvenance_ = null;
      if (sourceProvenanceBuilder_ != null) {
        sourceProvenanceBuilder_.dispose();
        sourceProvenanceBuilder_ = null;
      }
      workerPool_ = "";
      internalGetMutableEnvironmentVariables().clear();
      dockerRegistry_ = 0;
      dockerRepository_ = "";
      serviceAccount_ = "";
      runtimeUpdatePolicyCase_ = 0;
      runtimeUpdatePolicy_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.functions.v2.FunctionsProto
          .internal_static_google_cloud_functions_v2_BuildConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2.BuildConfig getDefaultInstanceForType() {
      return com.google.cloud.functions.v2.BuildConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.functions.v2.BuildConfig build() {
      com.google.cloud.functions.v2.BuildConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2.BuildConfig buildPartial() {
      com.google.cloud.functions.v2.BuildConfig result =
          new com.google.cloud.functions.v2.BuildConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.functions.v2.BuildConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.build_ = build_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.runtime_ = runtime_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.entryPoint_ = entryPoint_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.source_ = sourceBuilder_ == null ? source_ : sourceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.sourceProvenance_ =
            sourceProvenanceBuilder_ == null ? sourceProvenance_ : sourceProvenanceBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.workerPool_ = workerPool_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.environmentVariables_ = internalGetEnvironmentVariables();
        result.environmentVariables_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.dockerRegistry_ = dockerRegistry_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.dockerRepository_ = dockerRepository_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.functions.v2.BuildConfig result) {
      result.runtimeUpdatePolicyCase_ = runtimeUpdatePolicyCase_;
      result.runtimeUpdatePolicy_ = this.runtimeUpdatePolicy_;
      if (runtimeUpdatePolicyCase_ == 40 && automaticUpdatePolicyBuilder_ != null) {
        result.runtimeUpdatePolicy_ = automaticUpdatePolicyBuilder_.build();
      }
      if (runtimeUpdatePolicyCase_ == 41 && onDeployUpdatePolicyBuilder_ != null) {
        result.runtimeUpdatePolicy_ = onDeployUpdatePolicyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.functions.v2.BuildConfig) {
        return mergeFrom((com.google.cloud.functions.v2.BuildConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.functions.v2.BuildConfig other) {
      if (other == com.google.cloud.functions.v2.BuildConfig.getDefaultInstance()) return this;
      if (!other.getBuild().isEmpty()) {
        build_ = other.build_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getRuntime().isEmpty()) {
        runtime_ = other.runtime_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getEntryPoint().isEmpty()) {
        entryPoint_ = other.entryPoint_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasSource()) {
        mergeSource(other.getSource());
      }
      if (other.hasSourceProvenance()) {
        mergeSourceProvenance(other.getSourceProvenance());
      }
      if (!other.getWorkerPool().isEmpty()) {
        workerPool_ = other.workerPool_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      internalGetMutableEnvironmentVariables().mergeFrom(other.internalGetEnvironmentVariables());
      bitField0_ |= 0x00000100;
      if (other.dockerRegistry_ != 0) {
        setDockerRegistryValue(other.getDockerRegistryValue());
      }
      if (!other.getDockerRepository().isEmpty()) {
        dockerRepository_ = other.dockerRepository_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      switch (other.getRuntimeUpdatePolicyCase()) {
        case AUTOMATIC_UPDATE_POLICY:
          {
            mergeAutomaticUpdatePolicy(other.getAutomaticUpdatePolicy());
            break;
          }
        case ON_DEPLOY_UPDATE_POLICY:
          {
            mergeOnDeployUpdatePolicy(other.getOnDeployUpdatePolicy());
            break;
          }
        case RUNTIMEUPDATEPOLICY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                build_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                runtime_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                entryPoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getSourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                workerPool_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    environmentVariables__ =
                        input.readMessage(
                            EnvironmentVariablesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableEnvironmentVariables()
                    .getMutableMap()
                    .put(environmentVariables__.getKey(), environmentVariables__.getValue());
                bitField0_ |= 0x00000100;
                break;
              } // case 50
            case 58:
              {
                dockerRepository_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getSourceProvenanceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 80:
              {
                dockerRegistry_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 218:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 218
            case 322:
              {
                input.readMessage(
                    getAutomaticUpdatePolicyFieldBuilder().getBuilder(), extensionRegistry);
                runtimeUpdatePolicyCase_ = 40;
                break;
              } // case 322
            case 330:
              {
                input.readMessage(
                    getOnDeployUpdatePolicyFieldBuilder().getBuilder(), extensionRegistry);
                runtimeUpdatePolicyCase_ = 41;
                break;
              } // case 330
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int runtimeUpdatePolicyCase_ = 0;
    private java.lang.Object runtimeUpdatePolicy_;

    public RuntimeUpdatePolicyCase getRuntimeUpdatePolicyCase() {
      return RuntimeUpdatePolicyCase.forNumber(runtimeUpdatePolicyCase_);
    }

    public Builder clearRuntimeUpdatePolicy() {
      runtimeUpdatePolicyCase_ = 0;
      runtimeUpdatePolicy_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v2.AutomaticUpdatePolicy,
            com.google.cloud.functions.v2.AutomaticUpdatePolicy.Builder,
            com.google.cloud.functions.v2.AutomaticUpdatePolicyOrBuilder>
        automaticUpdatePolicyBuilder_;
    /**
     * <code>.google.cloud.functions.v2.AutomaticUpdatePolicy automatic_update_policy = 40;</code>
     *
     * @return Whether the automaticUpdatePolicy field is set.
     */
    @java.lang.Override
    public boolean hasAutomaticUpdatePolicy() {
      return runtimeUpdatePolicyCase_ == 40;
    }
    /**
     * <code>.google.cloud.functions.v2.AutomaticUpdatePolicy automatic_update_policy = 40;</code>
     *
     * @return The automaticUpdatePolicy.
     */
    @java.lang.Override
    public com.google.cloud.functions.v2.AutomaticUpdatePolicy getAutomaticUpdatePolicy() {
      if (automaticUpdatePolicyBuilder_ == null) {
        if (runtimeUpdatePolicyCase_ == 40) {
          return (com.google.cloud.functions.v2.AutomaticUpdatePolicy) runtimeUpdatePolicy_;
        }
        return com.google.cloud.functions.v2.AutomaticUpdatePolicy.getDefaultInstance();
      } else {
        if (runtimeUpdatePolicyCase_ == 40) {
          return automaticUpdatePolicyBuilder_.getMessage();
        }
        return com.google.cloud.functions.v2.AutomaticUpdatePolicy.getDefaultInstance();
      }
    }
    /**
     * <code>.google.cloud.functions.v2.AutomaticUpdatePolicy automatic_update_policy = 40;</code>
     */
    public Builder setAutomaticUpdatePolicy(
        com.google.cloud.functions.v2.AutomaticUpdatePolicy value) {
      if (automaticUpdatePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runtimeUpdatePolicy_ = value;
        onChanged();
      } else {
        automaticUpdatePolicyBuilder_.setMessage(value);
      }
      runtimeUpdatePolicyCase_ = 40;
      return this;
    }
    /**
     * <code>.google.cloud.functions.v2.AutomaticUpdatePolicy automatic_update_policy = 40;</code>
     */
    public Builder setAutomaticUpdatePolicy(
        com.google.cloud.functions.v2.AutomaticUpdatePolicy.Builder builderForValue) {
      if (automaticUpdatePolicyBuilder_ == null) {
        runtimeUpdatePolicy_ = builderForValue.build();
        onChanged();
      } else {
        automaticUpdatePolicyBuilder_.setMessage(builderForValue.build());
      }
      runtimeUpdatePolicyCase_ = 40;
      return this;
    }
    /**
     * <code>.google.cloud.functions.v2.AutomaticUpdatePolicy automatic_update_policy = 40;</code>
     */
    public Builder mergeAutomaticUpdatePolicy(
        com.google.cloud.functions.v2.AutomaticUpdatePolicy value) {
      if (automaticUpdatePolicyBuilder_ == null) {
        if (runtimeUpdatePolicyCase_ == 40
            && runtimeUpdatePolicy_
                != com.google.cloud.functions.v2.AutomaticUpdatePolicy.getDefaultInstance()) {
          runtimeUpdatePolicy_ =
              com.google.cloud.functions.v2.AutomaticUpdatePolicy.newBuilder(
                      (com.google.cloud.functions.v2.AutomaticUpdatePolicy) runtimeUpdatePolicy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          runtimeUpdatePolicy_ = value;
        }
        onChanged();
      } else {
        if (runtimeUpdatePolicyCase_ == 40) {
          automaticUpdatePolicyBuilder_.mergeFrom(value);
        } else {
          automaticUpdatePolicyBuilder_.setMessage(value);
        }
      }
      runtimeUpdatePolicyCase_ = 40;
      return this;
    }
    /**
     * <code>.google.cloud.functions.v2.AutomaticUpdatePolicy automatic_update_policy = 40;</code>
     */
    public Builder clearAutomaticUpdatePolicy() {
      if (automaticUpdatePolicyBuilder_ == null) {
        if (runtimeUpdatePolicyCase_ == 40) {
          runtimeUpdatePolicyCase_ = 0;
          runtimeUpdatePolicy_ = null;
          onChanged();
        }
      } else {
        if (runtimeUpdatePolicyCase_ == 40) {
          runtimeUpdatePolicyCase_ = 0;
          runtimeUpdatePolicy_ = null;
        }
        automaticUpdatePolicyBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>.google.cloud.functions.v2.AutomaticUpdatePolicy automatic_update_policy = 40;</code>
     */
    public com.google.cloud.functions.v2.AutomaticUpdatePolicy.Builder
        getAutomaticUpdatePolicyBuilder() {
      return getAutomaticUpdatePolicyFieldBuilder().getBuilder();
    }
    /**
     * <code>.google.cloud.functions.v2.AutomaticUpdatePolicy automatic_update_policy = 40;</code>
     */
    @java.lang.Override
    public com.google.cloud.functions.v2.AutomaticUpdatePolicyOrBuilder
        getAutomaticUpdatePolicyOrBuilder() {
      if ((runtimeUpdatePolicyCase_ == 40) && (automaticUpdatePolicyBuilder_ != null)) {
        return automaticUpdatePolicyBuilder_.getMessageOrBuilder();
      } else {
        if (runtimeUpdatePolicyCase_ == 40) {
          return (com.google.cloud.functions.v2.AutomaticUpdatePolicy) runtimeUpdatePolicy_;
        }
        return com.google.cloud.functions.v2.AutomaticUpdatePolicy.getDefaultInstance();
      }
    }
    /**
     * <code>.google.cloud.functions.v2.AutomaticUpdatePolicy automatic_update_policy = 40;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v2.AutomaticUpdatePolicy,
            com.google.cloud.functions.v2.AutomaticUpdatePolicy.Builder,
            com.google.cloud.functions.v2.AutomaticUpdatePolicyOrBuilder>
        getAutomaticUpdatePolicyFieldBuilder() {
      if (automaticUpdatePolicyBuilder_ == null) {
        if (!(runtimeUpdatePolicyCase_ == 40)) {
          runtimeUpdatePolicy_ =
              com.google.cloud.functions.v2.AutomaticUpdatePolicy.getDefaultInstance();
        }
        automaticUpdatePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v2.AutomaticUpdatePolicy,
                com.google.cloud.functions.v2.AutomaticUpdatePolicy.Builder,
                com.google.cloud.functions.v2.AutomaticUpdatePolicyOrBuilder>(
                (com.google.cloud.functions.v2.AutomaticUpdatePolicy) runtimeUpdatePolicy_,
                getParentForChildren(),
                isClean());
        runtimeUpdatePolicy_ = null;
      }
      runtimeUpdatePolicyCase_ = 40;
      onChanged();
      return automaticUpdatePolicyBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v2.OnDeployUpdatePolicy,
            com.google.cloud.functions.v2.OnDeployUpdatePolicy.Builder,
            com.google.cloud.functions.v2.OnDeployUpdatePolicyOrBuilder>
        onDeployUpdatePolicyBuilder_;
    /**
     * <code>.google.cloud.functions.v2.OnDeployUpdatePolicy on_deploy_update_policy = 41;</code>
     *
     * @return Whether the onDeployUpdatePolicy field is set.
     */
    @java.lang.Override
    public boolean hasOnDeployUpdatePolicy() {
      return runtimeUpdatePolicyCase_ == 41;
    }
    /**
     * <code>.google.cloud.functions.v2.OnDeployUpdatePolicy on_deploy_update_policy = 41;</code>
     *
     * @return The onDeployUpdatePolicy.
     */
    @java.lang.Override
    public com.google.cloud.functions.v2.OnDeployUpdatePolicy getOnDeployUpdatePolicy() {
      if (onDeployUpdatePolicyBuilder_ == null) {
        if (runtimeUpdatePolicyCase_ == 41) {
          return (com.google.cloud.functions.v2.OnDeployUpdatePolicy) runtimeUpdatePolicy_;
        }
        return com.google.cloud.functions.v2.OnDeployUpdatePolicy.getDefaultInstance();
      } else {
        if (runtimeUpdatePolicyCase_ == 41) {
          return onDeployUpdatePolicyBuilder_.getMessage();
        }
        return com.google.cloud.functions.v2.OnDeployUpdatePolicy.getDefaultInstance();
      }
    }
    /**
     * <code>.google.cloud.functions.v2.OnDeployUpdatePolicy on_deploy_update_policy = 41;</code>
     */
    public Builder setOnDeployUpdatePolicy(
        com.google.cloud.functions.v2.OnDeployUpdatePolicy value) {
      if (onDeployUpdatePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runtimeUpdatePolicy_ = value;
        onChanged();
      } else {
        onDeployUpdatePolicyBuilder_.setMessage(value);
      }
      runtimeUpdatePolicyCase_ = 41;
      return this;
    }
    /**
     * <code>.google.cloud.functions.v2.OnDeployUpdatePolicy on_deploy_update_policy = 41;</code>
     */
    public Builder setOnDeployUpdatePolicy(
        com.google.cloud.functions.v2.OnDeployUpdatePolicy.Builder builderForValue) {
      if (onDeployUpdatePolicyBuilder_ == null) {
        runtimeUpdatePolicy_ = builderForValue.build();
        onChanged();
      } else {
        onDeployUpdatePolicyBuilder_.setMessage(builderForValue.build());
      }
      runtimeUpdatePolicyCase_ = 41;
      return this;
    }
    /**
     * <code>.google.cloud.functions.v2.OnDeployUpdatePolicy on_deploy_update_policy = 41;</code>
     */
    public Builder mergeOnDeployUpdatePolicy(
        com.google.cloud.functions.v2.OnDeployUpdatePolicy value) {
      if (onDeployUpdatePolicyBuilder_ == null) {
        if (runtimeUpdatePolicyCase_ == 41
            && runtimeUpdatePolicy_
                != com.google.cloud.functions.v2.OnDeployUpdatePolicy.getDefaultInstance()) {
          runtimeUpdatePolicy_ =
              com.google.cloud.functions.v2.OnDeployUpdatePolicy.newBuilder(
                      (com.google.cloud.functions.v2.OnDeployUpdatePolicy) runtimeUpdatePolicy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          runtimeUpdatePolicy_ = value;
        }
        onChanged();
      } else {
        if (runtimeUpdatePolicyCase_ == 41) {
          onDeployUpdatePolicyBuilder_.mergeFrom(value);
        } else {
          onDeployUpdatePolicyBuilder_.setMessage(value);
        }
      }
      runtimeUpdatePolicyCase_ = 41;
      return this;
    }
    /**
     * <code>.google.cloud.functions.v2.OnDeployUpdatePolicy on_deploy_update_policy = 41;</code>
     */
    public Builder clearOnDeployUpdatePolicy() {
      if (onDeployUpdatePolicyBuilder_ == null) {
        if (runtimeUpdatePolicyCase_ == 41) {
          runtimeUpdatePolicyCase_ = 0;
          runtimeUpdatePolicy_ = null;
          onChanged();
        }
      } else {
        if (runtimeUpdatePolicyCase_ == 41) {
          runtimeUpdatePolicyCase_ = 0;
          runtimeUpdatePolicy_ = null;
        }
        onDeployUpdatePolicyBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>.google.cloud.functions.v2.OnDeployUpdatePolicy on_deploy_update_policy = 41;</code>
     */
    public com.google.cloud.functions.v2.OnDeployUpdatePolicy.Builder
        getOnDeployUpdatePolicyBuilder() {
      return getOnDeployUpdatePolicyFieldBuilder().getBuilder();
    }
    /**
     * <code>.google.cloud.functions.v2.OnDeployUpdatePolicy on_deploy_update_policy = 41;</code>
     */
    @java.lang.Override
    public com.google.cloud.functions.v2.OnDeployUpdatePolicyOrBuilder
        getOnDeployUpdatePolicyOrBuilder() {
      if ((runtimeUpdatePolicyCase_ == 41) && (onDeployUpdatePolicyBuilder_ != null)) {
        return onDeployUpdatePolicyBuilder_.getMessageOrBuilder();
      } else {
        if (runtimeUpdatePolicyCase_ == 41) {
          return (com.google.cloud.functions.v2.OnDeployUpdatePolicy) runtimeUpdatePolicy_;
        }
        return com.google.cloud.functions.v2.OnDeployUpdatePolicy.getDefaultInstance();
      }
    }
    /**
     * <code>.google.cloud.functions.v2.OnDeployUpdatePolicy on_deploy_update_policy = 41;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v2.OnDeployUpdatePolicy,
            com.google.cloud.functions.v2.OnDeployUpdatePolicy.Builder,
            com.google.cloud.functions.v2.OnDeployUpdatePolicyOrBuilder>
        getOnDeployUpdatePolicyFieldBuilder() {
      if (onDeployUpdatePolicyBuilder_ == null) {
        if (!(runtimeUpdatePolicyCase_ == 41)) {
          runtimeUpdatePolicy_ =
              com.google.cloud.functions.v2.OnDeployUpdatePolicy.getDefaultInstance();
        }
        onDeployUpdatePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v2.OnDeployUpdatePolicy,
                com.google.cloud.functions.v2.OnDeployUpdatePolicy.Builder,
                com.google.cloud.functions.v2.OnDeployUpdatePolicyOrBuilder>(
                (com.google.cloud.functions.v2.OnDeployUpdatePolicy) runtimeUpdatePolicy_,
                getParentForChildren(),
                isClean());
        runtimeUpdatePolicy_ = null;
      }
      runtimeUpdatePolicyCase_ = 41;
      onChanged();
      return onDeployUpdatePolicyBuilder_;
    }

    private java.lang.Object build_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build name of the latest successful deployment of
     * the function.
     * </pre>
     *
     * <code>
     * string build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The build.
     */
    public java.lang.String getBuild() {
      java.lang.Object ref = build_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        build_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build name of the latest successful deployment of
     * the function.
     * </pre>
     *
     * <code>
     * string build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for build.
     */
    public com.google.protobuf.ByteString getBuildBytes() {
      java.lang.Object ref = build_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        build_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build name of the latest successful deployment of
     * the function.
     * </pre>
     *
     * <code>
     * string build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The build to set.
     * @return This builder for chaining.
     */
    public Builder setBuild(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      build_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build name of the latest successful deployment of
     * the function.
     * </pre>
     *
     * <code>
     * string build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuild() {
      build_ = getDefaultInstance().getBuild();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build name of the latest successful deployment of
     * the function.
     * </pre>
     *
     * <code>
     * string build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for build to set.
     * @return This builder for chaining.
     */
    public Builder setBuildBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      build_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object runtime_ = "";
    /**
     *
     *
     * <pre>
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     * </pre>
     *
     * <code>string runtime = 2;</code>
     *
     * @return The runtime.
     */
    public java.lang.String getRuntime() {
      java.lang.Object ref = runtime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        runtime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     * </pre>
     *
     * <code>string runtime = 2;</code>
     *
     * @return The bytes for runtime.
     */
    public com.google.protobuf.ByteString getRuntimeBytes() {
      java.lang.Object ref = runtime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        runtime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     * </pre>
     *
     * <code>string runtime = 2;</code>
     *
     * @param value The runtime to set.
     * @return This builder for chaining.
     */
    public Builder setRuntime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      runtime_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     * </pre>
     *
     * <code>string runtime = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRuntime() {
      runtime_ = getDefaultInstance().getRuntime();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     * </pre>
     *
     * <code>string runtime = 2;</code>
     *
     * @param value The bytes for runtime to set.
     * @return This builder for chaining.
     */
    public Builder setRuntimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      runtime_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object entryPoint_ = "";
    /**
     *
     *
     * <pre>
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * For Node.js this is name of a function exported by the module specified
     * in `source_location`.
     * </pre>
     *
     * <code>string entry_point = 3;</code>
     *
     * @return The entryPoint.
     */
    public java.lang.String getEntryPoint() {
      java.lang.Object ref = entryPoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entryPoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * For Node.js this is name of a function exported by the module specified
     * in `source_location`.
     * </pre>
     *
     * <code>string entry_point = 3;</code>
     *
     * @return The bytes for entryPoint.
     */
    public com.google.protobuf.ByteString getEntryPointBytes() {
      java.lang.Object ref = entryPoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entryPoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * For Node.js this is name of a function exported by the module specified
     * in `source_location`.
     * </pre>
     *
     * <code>string entry_point = 3;</code>
     *
     * @param value The entryPoint to set.
     * @return This builder for chaining.
     */
    public Builder setEntryPoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entryPoint_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * For Node.js this is name of a function exported by the module specified
     * in `source_location`.
     * </pre>
     *
     * <code>string entry_point = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntryPoint() {
      entryPoint_ = getDefaultInstance().getEntryPoint();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * For Node.js this is name of a function exported by the module specified
     * in `source_location`.
     * </pre>
     *
     * <code>string entry_point = 3;</code>
     *
     * @param value The bytes for entryPoint to set.
     * @return This builder for chaining.
     */
    public Builder setEntryPointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entryPoint_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloud.functions.v2.Source source_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v2.Source,
            com.google.cloud.functions.v2.Source.Builder,
            com.google.cloud.functions.v2.SourceOrBuilder>
        sourceBuilder_;
    /**
     *
     *
     * <pre>
     * The location of the function source code.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Source source = 4;</code>
     *
     * @return Whether the source field is set.
     */
    public boolean hasSource() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The location of the function source code.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Source source = 4;</code>
     *
     * @return The source.
     */
    public com.google.cloud.functions.v2.Source getSource() {
      if (sourceBuilder_ == null) {
        return source_ == null
            ? com.google.cloud.functions.v2.Source.getDefaultInstance()
            : source_;
      } else {
        return sourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The location of the function source code.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Source source = 4;</code>
     */
    public Builder setSource(com.google.cloud.functions.v2.Source value) {
      if (sourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
      } else {
        sourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the function source code.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Source source = 4;</code>
     */
    public Builder setSource(com.google.cloud.functions.v2.Source.Builder builderForValue) {
      if (sourceBuilder_ == null) {
        source_ = builderForValue.build();
      } else {
        sourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the function source code.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Source source = 4;</code>
     */
    public Builder mergeSource(com.google.cloud.functions.v2.Source value) {
      if (sourceBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && source_ != null
            && source_ != com.google.cloud.functions.v2.Source.getDefaultInstance()) {
          getSourceBuilder().mergeFrom(value);
        } else {
          source_ = value;
        }
      } else {
        sourceBuilder_.mergeFrom(value);
      }
      if (source_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the function source code.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Source source = 4;</code>
     */
    public Builder clearSource() {
      bitField0_ = (bitField0_ & ~0x00000020);
      source_ = null;
      if (sourceBuilder_ != null) {
        sourceBuilder_.dispose();
        sourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the function source code.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Source source = 4;</code>
     */
    public com.google.cloud.functions.v2.Source.Builder getSourceBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The location of the function source code.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Source source = 4;</code>
     */
    public com.google.cloud.functions.v2.SourceOrBuilder getSourceOrBuilder() {
      if (sourceBuilder_ != null) {
        return sourceBuilder_.getMessageOrBuilder();
      } else {
        return source_ == null
            ? com.google.cloud.functions.v2.Source.getDefaultInstance()
            : source_;
      }
    }
    /**
     *
     *
     * <pre>
     * The location of the function source code.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Source source = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v2.Source,
            com.google.cloud.functions.v2.Source.Builder,
            com.google.cloud.functions.v2.SourceOrBuilder>
        getSourceFieldBuilder() {
      if (sourceBuilder_ == null) {
        sourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v2.Source,
                com.google.cloud.functions.v2.Source.Builder,
                com.google.cloud.functions.v2.SourceOrBuilder>(
                getSource(), getParentForChildren(), isClean());
        source_ = null;
      }
      return sourceBuilder_;
    }

    private com.google.cloud.functions.v2.SourceProvenance sourceProvenance_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v2.SourceProvenance,
            com.google.cloud.functions.v2.SourceProvenance.Builder,
            com.google.cloud.functions.v2.SourceProvenanceOrBuilder>
        sourceProvenanceBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2.SourceProvenance source_provenance = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the sourceProvenance field is set.
     */
    public boolean hasSourceProvenance() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2.SourceProvenance source_provenance = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The sourceProvenance.
     */
    public com.google.cloud.functions.v2.SourceProvenance getSourceProvenance() {
      if (sourceProvenanceBuilder_ == null) {
        return sourceProvenance_ == null
            ? com.google.cloud.functions.v2.SourceProvenance.getDefaultInstance()
            : sourceProvenance_;
      } else {
        return sourceProvenanceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2.SourceProvenance source_provenance = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSourceProvenance(com.google.cloud.functions.v2.SourceProvenance value) {
      if (sourceProvenanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceProvenance_ = value;
      } else {
        sourceProvenanceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2.SourceProvenance source_provenance = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSourceProvenance(
        com.google.cloud.functions.v2.SourceProvenance.Builder builderForValue) {
      if (sourceProvenanceBuilder_ == null) {
        sourceProvenance_ = builderForValue.build();
      } else {
        sourceProvenanceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2.SourceProvenance source_provenance = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSourceProvenance(com.google.cloud.functions.v2.SourceProvenance value) {
      if (sourceProvenanceBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && sourceProvenance_ != null
            && sourceProvenance_
                != com.google.cloud.functions.v2.SourceProvenance.getDefaultInstance()) {
          getSourceProvenanceBuilder().mergeFrom(value);
        } else {
          sourceProvenance_ = value;
        }
      } else {
        sourceProvenanceBuilder_.mergeFrom(value);
      }
      if (sourceProvenance_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2.SourceProvenance source_provenance = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSourceProvenance() {
      bitField0_ = (bitField0_ & ~0x00000040);
      sourceProvenance_ = null;
      if (sourceProvenanceBuilder_ != null) {
        sourceProvenanceBuilder_.dispose();
        sourceProvenanceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2.SourceProvenance source_provenance = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.functions.v2.SourceProvenance.Builder getSourceProvenanceBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getSourceProvenanceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2.SourceProvenance source_provenance = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.functions.v2.SourceProvenanceOrBuilder getSourceProvenanceOrBuilder() {
      if (sourceProvenanceBuilder_ != null) {
        return sourceProvenanceBuilder_.getMessageOrBuilder();
      } else {
        return sourceProvenance_ == null
            ? com.google.cloud.functions.v2.SourceProvenance.getDefaultInstance()
            : sourceProvenance_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2.SourceProvenance source_provenance = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v2.SourceProvenance,
            com.google.cloud.functions.v2.SourceProvenance.Builder,
            com.google.cloud.functions.v2.SourceProvenanceOrBuilder>
        getSourceProvenanceFieldBuilder() {
      if (sourceProvenanceBuilder_ == null) {
        sourceProvenanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v2.SourceProvenance,
                com.google.cloud.functions.v2.SourceProvenance.Builder,
                com.google.cloud.functions.v2.SourceProvenanceOrBuilder>(
                getSourceProvenance(), getParentForChildren(), isClean());
        sourceProvenance_ = null;
      }
      return sourceProvenanceBuilder_;
    }

    private java.lang.Object workerPool_ = "";
    /**
     *
     *
     * <pre>
     * Name of the Cloud Build Custom Worker Pool that should be used to build the
     * function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * {project} and {region} are the project id and region respectively where the
     * worker pool is defined and {workerPool} is the short name of the worker
     * pool.
     *
     * If the project id is not the same as the function, then the Cloud
     * Functions Service Agent
     * (service-&lt;project_number&gt;&#64;gcf-admin-robot.iam.gserviceaccount.com) must be
     * granted the role Cloud Build Custom Workers Builder
     * (roles/cloudbuild.customworkers.builder) in the project.
     * </pre>
     *
     * <code>string worker_pool = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The workerPool.
     */
    public java.lang.String getWorkerPool() {
      java.lang.Object ref = workerPool_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        workerPool_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the Cloud Build Custom Worker Pool that should be used to build the
     * function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * {project} and {region} are the project id and region respectively where the
     * worker pool is defined and {workerPool} is the short name of the worker
     * pool.
     *
     * If the project id is not the same as the function, then the Cloud
     * Functions Service Agent
     * (service-&lt;project_number&gt;&#64;gcf-admin-robot.iam.gserviceaccount.com) must be
     * granted the role Cloud Build Custom Workers Builder
     * (roles/cloudbuild.customworkers.builder) in the project.
     * </pre>
     *
     * <code>string worker_pool = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for workerPool.
     */
    public com.google.protobuf.ByteString getWorkerPoolBytes() {
      java.lang.Object ref = workerPool_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        workerPool_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the Cloud Build Custom Worker Pool that should be used to build the
     * function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * {project} and {region} are the project id and region respectively where the
     * worker pool is defined and {workerPool} is the short name of the worker
     * pool.
     *
     * If the project id is not the same as the function, then the Cloud
     * Functions Service Agent
     * (service-&lt;project_number&gt;&#64;gcf-admin-robot.iam.gserviceaccount.com) must be
     * granted the role Cloud Build Custom Workers Builder
     * (roles/cloudbuild.customworkers.builder) in the project.
     * </pre>
     *
     * <code>string worker_pool = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The workerPool to set.
     * @return This builder for chaining.
     */
    public Builder setWorkerPool(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      workerPool_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the Cloud Build Custom Worker Pool that should be used to build the
     * function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * {project} and {region} are the project id and region respectively where the
     * worker pool is defined and {workerPool} is the short name of the worker
     * pool.
     *
     * If the project id is not the same as the function, then the Cloud
     * Functions Service Agent
     * (service-&lt;project_number&gt;&#64;gcf-admin-robot.iam.gserviceaccount.com) must be
     * granted the role Cloud Build Custom Workers Builder
     * (roles/cloudbuild.customworkers.builder) in the project.
     * </pre>
     *
     * <code>string worker_pool = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWorkerPool() {
      workerPool_ = getDefaultInstance().getWorkerPool();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the Cloud Build Custom Worker Pool that should be used to build the
     * function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * {project} and {region} are the project id and region respectively where the
     * worker pool is defined and {workerPool} is the short name of the worker
     * pool.
     *
     * If the project id is not the same as the function, then the Cloud
     * Functions Service Agent
     * (service-&lt;project_number&gt;&#64;gcf-admin-robot.iam.gserviceaccount.com) must be
     * granted the role Cloud Build Custom Workers Builder
     * (roles/cloudbuild.customworkers.builder) in the project.
     * </pre>
     *
     * <code>string worker_pool = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for workerPool to set.
     * @return This builder for chaining.
     */
    public Builder setWorkerPoolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      workerPool_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> environmentVariables_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetEnvironmentVariables() {
      if (environmentVariables_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            EnvironmentVariablesDefaultEntryHolder.defaultEntry);
      }
      return environmentVariables_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableEnvironmentVariables() {
      if (environmentVariables_ == null) {
        environmentVariables_ =
            com.google.protobuf.MapField.newMapField(
                EnvironmentVariablesDefaultEntryHolder.defaultEntry);
      }
      if (!environmentVariables_.isMutable()) {
        environmentVariables_ = environmentVariables_.copy();
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return environmentVariables_;
    }

    public int getEnvironmentVariablesCount() {
      return internalGetEnvironmentVariables().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * User-provided build-time environment variables for the function
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 6;</code>
     */
    @java.lang.Override
    public boolean containsEnvironmentVariables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetEnvironmentVariables().getMap().containsKey(key);
    }
    /** Use {@link #getEnvironmentVariablesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
      return getEnvironmentVariablesMap();
    }
    /**
     *
     *
     * <pre>
     * User-provided build-time environment variables for the function
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariablesMap() {
      return internalGetEnvironmentVariables().getMap();
    }
    /**
     *
     *
     * <pre>
     * User-provided build-time environment variables for the function
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 6;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getEnvironmentVariablesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetEnvironmentVariables().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * User-provided build-time environment variables for the function
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getEnvironmentVariablesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetEnvironmentVariables().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearEnvironmentVariables() {
      bitField0_ = (bitField0_ & ~0x00000100);
      internalGetMutableEnvironmentVariables().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided build-time environment variables for the function
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 6;</code>
     */
    public Builder removeEnvironmentVariables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableEnvironmentVariables().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableEnvironmentVariables() {
      bitField0_ |= 0x00000100;
      return internalGetMutableEnvironmentVariables().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * User-provided build-time environment variables for the function
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 6;</code>
     */
    public Builder putEnvironmentVariables(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableEnvironmentVariables().getMutableMap().put(key, value);
      bitField0_ |= 0x00000100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided build-time environment variables for the function
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 6;</code>
     */
    public Builder putAllEnvironmentVariables(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableEnvironmentVariables().getMutableMap().putAll(values);
      bitField0_ |= 0x00000100;
      return this;
    }

    private int dockerRegistry_ = 0;
    /**
     *
     *
     * <pre>
     * Docker Registry to use for this deployment. This configuration is only
     * applicable to 1st Gen functions, 2nd Gen functions can only use Artifact
     * Registry.
     *
     * If unspecified, it defaults to `ARTIFACT_REGISTRY`.
     * If `docker_repository` field is specified, this field should either be left
     * unspecified or set to `ARTIFACT_REGISTRY`.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.BuildConfig.DockerRegistry docker_registry = 10;</code>
     *
     * @return The enum numeric value on the wire for dockerRegistry.
     */
    @java.lang.Override
    public int getDockerRegistryValue() {
      return dockerRegistry_;
    }
    /**
     *
     *
     * <pre>
     * Docker Registry to use for this deployment. This configuration is only
     * applicable to 1st Gen functions, 2nd Gen functions can only use Artifact
     * Registry.
     *
     * If unspecified, it defaults to `ARTIFACT_REGISTRY`.
     * If `docker_repository` field is specified, this field should either be left
     * unspecified or set to `ARTIFACT_REGISTRY`.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.BuildConfig.DockerRegistry docker_registry = 10;</code>
     *
     * @param value The enum numeric value on the wire for dockerRegistry to set.
     * @return This builder for chaining.
     */
    public Builder setDockerRegistryValue(int value) {
      dockerRegistry_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Docker Registry to use for this deployment. This configuration is only
     * applicable to 1st Gen functions, 2nd Gen functions can only use Artifact
     * Registry.
     *
     * If unspecified, it defaults to `ARTIFACT_REGISTRY`.
     * If `docker_repository` field is specified, this field should either be left
     * unspecified or set to `ARTIFACT_REGISTRY`.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.BuildConfig.DockerRegistry docker_registry = 10;</code>
     *
     * @return The dockerRegistry.
     */
    @java.lang.Override
    public com.google.cloud.functions.v2.BuildConfig.DockerRegistry getDockerRegistry() {
      com.google.cloud.functions.v2.BuildConfig.DockerRegistry result =
          com.google.cloud.functions.v2.BuildConfig.DockerRegistry.forNumber(dockerRegistry_);
      return result == null
          ? com.google.cloud.functions.v2.BuildConfig.DockerRegistry.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Docker Registry to use for this deployment. This configuration is only
     * applicable to 1st Gen functions, 2nd Gen functions can only use Artifact
     * Registry.
     *
     * If unspecified, it defaults to `ARTIFACT_REGISTRY`.
     * If `docker_repository` field is specified, this field should either be left
     * unspecified or set to `ARTIFACT_REGISTRY`.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.BuildConfig.DockerRegistry docker_registry = 10;</code>
     *
     * @param value The dockerRegistry to set.
     * @return This builder for chaining.
     */
    public Builder setDockerRegistry(
        com.google.cloud.functions.v2.BuildConfig.DockerRegistry value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      dockerRegistry_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Docker Registry to use for this deployment. This configuration is only
     * applicable to 1st Gen functions, 2nd Gen functions can only use Artifact
     * Registry.
     *
     * If unspecified, it defaults to `ARTIFACT_REGISTRY`.
     * If `docker_repository` field is specified, this field should either be left
     * unspecified or set to `ARTIFACT_REGISTRY`.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.BuildConfig.DockerRegistry docker_registry = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDockerRegistry() {
      bitField0_ = (bitField0_ & ~0x00000200);
      dockerRegistry_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object dockerRepository_ = "";
    /**
     *
     *
     * <pre>
     * Repository in Artifact Registry to which the function docker image will be
     * pushed after it is built by Cloud Build. If specified by user, it is
     * created and managed by user with a customer managed encryption key.
     * Otherwise, GCF will create and use a repository named 'gcf-artifacts'
     * for every deployed region.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/repositories/{repository}`.
     *
     * Cross-project repositories are not supported.
     * Cross-location repositories are not supported.
     * Repository format must be 'DOCKER'.
     * </pre>
     *
     * <code>string docker_repository = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The dockerRepository.
     */
    public java.lang.String getDockerRepository() {
      java.lang.Object ref = dockerRepository_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dockerRepository_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Repository in Artifact Registry to which the function docker image will be
     * pushed after it is built by Cloud Build. If specified by user, it is
     * created and managed by user with a customer managed encryption key.
     * Otherwise, GCF will create and use a repository named 'gcf-artifacts'
     * for every deployed region.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/repositories/{repository}`.
     *
     * Cross-project repositories are not supported.
     * Cross-location repositories are not supported.
     * Repository format must be 'DOCKER'.
     * </pre>
     *
     * <code>string docker_repository = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for dockerRepository.
     */
    public com.google.protobuf.ByteString getDockerRepositoryBytes() {
      java.lang.Object ref = dockerRepository_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dockerRepository_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Repository in Artifact Registry to which the function docker image will be
     * pushed after it is built by Cloud Build. If specified by user, it is
     * created and managed by user with a customer managed encryption key.
     * Otherwise, GCF will create and use a repository named 'gcf-artifacts'
     * for every deployed region.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/repositories/{repository}`.
     *
     * Cross-project repositories are not supported.
     * Cross-location repositories are not supported.
     * Repository format must be 'DOCKER'.
     * </pre>
     *
     * <code>string docker_repository = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The dockerRepository to set.
     * @return This builder for chaining.
     */
    public Builder setDockerRepository(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dockerRepository_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Repository in Artifact Registry to which the function docker image will be
     * pushed after it is built by Cloud Build. If specified by user, it is
     * created and managed by user with a customer managed encryption key.
     * Otherwise, GCF will create and use a repository named 'gcf-artifacts'
     * for every deployed region.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/repositories/{repository}`.
     *
     * Cross-project repositories are not supported.
     * Cross-location repositories are not supported.
     * Repository format must be 'DOCKER'.
     * </pre>
     *
     * <code>string docker_repository = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDockerRepository() {
      dockerRepository_ = getDefaultInstance().getDockerRepository();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Repository in Artifact Registry to which the function docker image will be
     * pushed after it is built by Cloud Build. If specified by user, it is
     * created and managed by user with a customer managed encryption key.
     * Otherwise, GCF will create and use a repository named 'gcf-artifacts'
     * for every deployed region.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/repositories/{repository}`.
     *
     * Cross-project repositories are not supported.
     * Cross-location repositories are not supported.
     * Repository format must be 'DOCKER'.
     * </pre>
     *
     * <code>string docker_repository = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for dockerRepository to set.
     * @return This builder for chaining.
     */
    public Builder setDockerRepositoryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dockerRepository_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Service account to be used for building the container. The format of this
     * field is `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     * </pre>
     *
     * <code>string service_account = 27;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Service account to be used for building the container. The format of this
     * field is `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     * </pre>
     *
     * <code>string service_account = 27;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Service account to be used for building the container. The format of this
     * field is `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     * </pre>
     *
     * <code>string service_account = 27;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service account to be used for building the container. The format of this
     * field is `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     * </pre>
     *
     * <code>string service_account = 27;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service account to be used for building the container. The format of this
     * field is `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     * </pre>
     *
     * <code>string service_account = 27;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.functions.v2.BuildConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.functions.v2.BuildConfig)
  private static final com.google.cloud.functions.v2.BuildConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.functions.v2.BuildConfig();
  }

  public static com.google.cloud.functions.v2.BuildConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BuildConfig> PARSER =
      new com.google.protobuf.AbstractParser<BuildConfig>() {
        @java.lang.Override
        public BuildConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BuildConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BuildConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.functions.v2.BuildConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
