/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/functions/v2/functions.proto

package com.google.cloud.functions.v2;

/**
 *
 *
 * <pre>
 * Represents the metadata of the long-running operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.functions.v2.OperationMetadata}
 */
public final class OperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.functions.v2.OperationMetadata)
    OperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OperationMetadata.newBuilder() to construct.
  private OperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OperationMetadata() {
    target_ = "";
    verb_ = "";
    statusDetail_ = "";
    apiVersion_ = "";
    stages_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OperationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.functions.v2.FunctionsProto
        .internal_static_google_cloud_functions_v2_OperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.functions.v2.FunctionsProto
        .internal_static_google_cloud_functions_v2_OperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.functions.v2.OperationMetadata.class,
            com.google.cloud.functions.v2.OperationMetadata.Builder.class);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int TARGET_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object target_ = "";
  /**
   *
   *
   * <pre>
   * Server-defined resource path for the target of the operation.
   * </pre>
   *
   * <code>string target = 3;</code>
   *
   * @return The target.
   */
  @java.lang.Override
  public java.lang.String getTarget() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      target_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Server-defined resource path for the target of the operation.
   * </pre>
   *
   * <code>string target = 3;</code>
   *
   * @return The bytes for target.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetBytes() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      target_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERB_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object verb_ = "";
  /**
   *
   *
   * <pre>
   * Name of the verb executed by the operation.
   * </pre>
   *
   * <code>string verb = 4;</code>
   *
   * @return The verb.
   */
  @java.lang.Override
  public java.lang.String getVerb() {
    java.lang.Object ref = verb_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      verb_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the verb executed by the operation.
   * </pre>
   *
   * <code>string verb = 4;</code>
   *
   * @return The bytes for verb.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVerbBytes() {
    java.lang.Object ref = verb_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      verb_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_DETAIL_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statusDetail_ = "";
  /**
   *
   *
   * <pre>
   * Human-readable status of the operation, if any.
   * </pre>
   *
   * <code>string status_detail = 5;</code>
   *
   * @return The statusDetail.
   */
  @java.lang.Override
  public java.lang.String getStatusDetail() {
    java.lang.Object ref = statusDetail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusDetail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Human-readable status of the operation, if any.
   * </pre>
   *
   * <code>string status_detail = 5;</code>
   *
   * @return The bytes for statusDetail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusDetailBytes() {
    java.lang.Object ref = statusDetail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusDetail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CANCEL_REQUESTED_FIELD_NUMBER = 6;
  private boolean cancelRequested_ = false;
  /**
   *
   *
   * <pre>
   * Identifies whether the user has requested cancellation
   * of the operation. Operations that have successfully been cancelled
   * have [Operation.error][] value with a
   * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
   * `Code.CANCELLED`.
   * </pre>
   *
   * <code>bool cancel_requested = 6;</code>
   *
   * @return The cancelRequested.
   */
  @java.lang.Override
  public boolean getCancelRequested() {
    return cancelRequested_;
  }

  public static final int API_VERSION_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object apiVersion_ = "";
  /**
   *
   *
   * <pre>
   * API version used to start the operation.
   * </pre>
   *
   * <code>string api_version = 7;</code>
   *
   * @return The apiVersion.
   */
  @java.lang.Override
  public java.lang.String getApiVersion() {
    java.lang.Object ref = apiVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      apiVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * API version used to start the operation.
   * </pre>
   *
   * <code>string api_version = 7;</code>
   *
   * @return The bytes for apiVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getApiVersionBytes() {
    java.lang.Object ref = apiVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      apiVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_RESOURCE_FIELD_NUMBER = 8;
  private com.google.protobuf.Any requestResource_;
  /**
   *
   *
   * <pre>
   * The original request that started the operation.
   * </pre>
   *
   * <code>.google.protobuf.Any request_resource = 8;</code>
   *
   * @return Whether the requestResource field is set.
   */
  @java.lang.Override
  public boolean hasRequestResource() {
    return requestResource_ != null;
  }
  /**
   *
   *
   * <pre>
   * The original request that started the operation.
   * </pre>
   *
   * <code>.google.protobuf.Any request_resource = 8;</code>
   *
   * @return The requestResource.
   */
  @java.lang.Override
  public com.google.protobuf.Any getRequestResource() {
    return requestResource_ == null
        ? com.google.protobuf.Any.getDefaultInstance()
        : requestResource_;
  }
  /**
   *
   *
   * <pre>
   * The original request that started the operation.
   * </pre>
   *
   * <code>.google.protobuf.Any request_resource = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.AnyOrBuilder getRequestResourceOrBuilder() {
    return requestResource_ == null
        ? com.google.protobuf.Any.getDefaultInstance()
        : requestResource_;
  }

  public static final int STAGES_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.functions.v2.Stage> stages_;
  /**
   *
   *
   * <pre>
   * Mechanism for reporting in-progress stages
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.functions.v2.Stage> getStagesList() {
    return stages_;
  }
  /**
   *
   *
   * <pre>
   * Mechanism for reporting in-progress stages
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.functions.v2.StageOrBuilder>
      getStagesOrBuilderList() {
    return stages_;
  }
  /**
   *
   *
   * <pre>
   * Mechanism for reporting in-progress stages
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
   */
  @java.lang.Override
  public int getStagesCount() {
    return stages_.size();
  }
  /**
   *
   *
   * <pre>
   * Mechanism for reporting in-progress stages
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.Stage getStages(int index) {
    return stages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Mechanism for reporting in-progress stages
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.StageOrBuilder getStagesOrBuilder(int index) {
    return stages_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (createTime_ != null) {
      output.writeMessage(1, getCreateTime());
    }
    if (endTime_ != null) {
      output.writeMessage(2, getEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, target_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(verb_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, verb_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusDetail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, statusDetail_);
    }
    if (cancelRequested_ != false) {
      output.writeBool(6, cancelRequested_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(apiVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, apiVersion_);
    }
    if (requestResource_ != null) {
      output.writeMessage(8, getRequestResource());
    }
    for (int i = 0; i < stages_.size(); i++) {
      output.writeMessage(9, stages_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCreateTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, target_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(verb_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, verb_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusDetail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, statusDetail_);
    }
    if (cancelRequested_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, cancelRequested_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(apiVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, apiVersion_);
    }
    if (requestResource_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getRequestResource());
    }
    for (int i = 0; i < stages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, stages_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.functions.v2.OperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.functions.v2.OperationMetadata other =
        (com.google.cloud.functions.v2.OperationMetadata) obj;

    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getTarget().equals(other.getTarget())) return false;
    if (!getVerb().equals(other.getVerb())) return false;
    if (!getStatusDetail().equals(other.getStatusDetail())) return false;
    if (getCancelRequested() != other.getCancelRequested()) return false;
    if (!getApiVersion().equals(other.getApiVersion())) return false;
    if (hasRequestResource() != other.hasRequestResource()) return false;
    if (hasRequestResource()) {
      if (!getRequestResource().equals(other.getRequestResource())) return false;
    }
    if (!getStagesList().equals(other.getStagesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + TARGET_FIELD_NUMBER;
    hash = (53 * hash) + getTarget().hashCode();
    hash = (37 * hash) + VERB_FIELD_NUMBER;
    hash = (53 * hash) + getVerb().hashCode();
    hash = (37 * hash) + STATUS_DETAIL_FIELD_NUMBER;
    hash = (53 * hash) + getStatusDetail().hashCode();
    hash = (37 * hash) + CANCEL_REQUESTED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCancelRequested());
    hash = (37 * hash) + API_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getApiVersion().hashCode();
    if (hasRequestResource()) {
      hash = (37 * hash) + REQUEST_RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getRequestResource().hashCode();
    }
    if (getStagesCount() > 0) {
      hash = (37 * hash) + STAGES_FIELD_NUMBER;
      hash = (53 * hash) + getStagesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.functions.v2.OperationMetadata parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2.OperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.OperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2.OperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.OperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2.OperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.OperationMetadata parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2.OperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.OperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2.OperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.OperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2.OperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.functions.v2.OperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the metadata of the long-running operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v2.OperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.functions.v2.OperationMetadata)
      com.google.cloud.functions.v2.OperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v2.FunctionsProto
          .internal_static_google_cloud_functions_v2_OperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v2.FunctionsProto
          .internal_static_google_cloud_functions_v2_OperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v2.OperationMetadata.class,
              com.google.cloud.functions.v2.OperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.functions.v2.OperationMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      target_ = "";
      verb_ = "";
      statusDetail_ = "";
      cancelRequested_ = false;
      apiVersion_ = "";
      requestResource_ = null;
      if (requestResourceBuilder_ != null) {
        requestResourceBuilder_.dispose();
        requestResourceBuilder_ = null;
      }
      if (stagesBuilder_ == null) {
        stages_ = java.util.Collections.emptyList();
      } else {
        stages_ = null;
        stagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.functions.v2.FunctionsProto
          .internal_static_google_cloud_functions_v2_OperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2.OperationMetadata getDefaultInstanceForType() {
      return com.google.cloud.functions.v2.OperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.functions.v2.OperationMetadata build() {
      com.google.cloud.functions.v2.OperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2.OperationMetadata buildPartial() {
      com.google.cloud.functions.v2.OperationMetadata result =
          new com.google.cloud.functions.v2.OperationMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.functions.v2.OperationMetadata result) {
      if (stagesBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          stages_ = java.util.Collections.unmodifiableList(stages_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.stages_ = stages_;
      } else {
        result.stages_ = stagesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.functions.v2.OperationMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.target_ = target_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.verb_ = verb_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.statusDetail_ = statusDetail_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.cancelRequested_ = cancelRequested_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.apiVersion_ = apiVersion_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.requestResource_ =
            requestResourceBuilder_ == null ? requestResource_ : requestResourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.functions.v2.OperationMetadata) {
        return mergeFrom((com.google.cloud.functions.v2.OperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.functions.v2.OperationMetadata other) {
      if (other == com.google.cloud.functions.v2.OperationMetadata.getDefaultInstance())
        return this;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (!other.getTarget().isEmpty()) {
        target_ = other.target_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getVerb().isEmpty()) {
        verb_ = other.verb_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getStatusDetail().isEmpty()) {
        statusDetail_ = other.statusDetail_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getCancelRequested() != false) {
        setCancelRequested(other.getCancelRequested());
      }
      if (!other.getApiVersion().isEmpty()) {
        apiVersion_ = other.apiVersion_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasRequestResource()) {
        mergeRequestResource(other.getRequestResource());
      }
      if (stagesBuilder_ == null) {
        if (!other.stages_.isEmpty()) {
          if (stages_.isEmpty()) {
            stages_ = other.stages_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureStagesIsMutable();
            stages_.addAll(other.stages_);
          }
          onChanged();
        }
      } else {
        if (!other.stages_.isEmpty()) {
          if (stagesBuilder_.isEmpty()) {
            stagesBuilder_.dispose();
            stagesBuilder_ = null;
            stages_ = other.stages_;
            bitField0_ = (bitField0_ & ~0x00000100);
            stagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStagesFieldBuilder()
                    : null;
          } else {
            stagesBuilder_.addAllMessages(other.stages_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                target_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                verb_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                statusDetail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                cancelRequested_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                apiVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getRequestResourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                com.google.cloud.functions.v2.Stage m =
                    input.readMessage(
                        com.google.cloud.functions.v2.Stage.parser(), extensionRegistry);
                if (stagesBuilder_ == null) {
                  ensureStagesIsMutable();
                  stages_.add(m);
                } else {
                  stagesBuilder_.addMessage(m);
                }
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private java.lang.Object target_ = "";
    /**
     *
     *
     * <pre>
     * Server-defined resource path for the target of the operation.
     * </pre>
     *
     * <code>string target = 3;</code>
     *
     * @return The target.
     */
    public java.lang.String getTarget() {
      java.lang.Object ref = target_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        target_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Server-defined resource path for the target of the operation.
     * </pre>
     *
     * <code>string target = 3;</code>
     *
     * @return The bytes for target.
     */
    public com.google.protobuf.ByteString getTargetBytes() {
      java.lang.Object ref = target_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        target_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Server-defined resource path for the target of the operation.
     * </pre>
     *
     * <code>string target = 3;</code>
     *
     * @param value The target to set.
     * @return This builder for chaining.
     */
    public Builder setTarget(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      target_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Server-defined resource path for the target of the operation.
     * </pre>
     *
     * <code>string target = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTarget() {
      target_ = getDefaultInstance().getTarget();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Server-defined resource path for the target of the operation.
     * </pre>
     *
     * <code>string target = 3;</code>
     *
     * @param value The bytes for target to set.
     * @return This builder for chaining.
     */
    public Builder setTargetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      target_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object verb_ = "";
    /**
     *
     *
     * <pre>
     * Name of the verb executed by the operation.
     * </pre>
     *
     * <code>string verb = 4;</code>
     *
     * @return The verb.
     */
    public java.lang.String getVerb() {
      java.lang.Object ref = verb_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        verb_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the verb executed by the operation.
     * </pre>
     *
     * <code>string verb = 4;</code>
     *
     * @return The bytes for verb.
     */
    public com.google.protobuf.ByteString getVerbBytes() {
      java.lang.Object ref = verb_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        verb_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the verb executed by the operation.
     * </pre>
     *
     * <code>string verb = 4;</code>
     *
     * @param value The verb to set.
     * @return This builder for chaining.
     */
    public Builder setVerb(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      verb_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the verb executed by the operation.
     * </pre>
     *
     * <code>string verb = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerb() {
      verb_ = getDefaultInstance().getVerb();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the verb executed by the operation.
     * </pre>
     *
     * <code>string verb = 4;</code>
     *
     * @param value The bytes for verb to set.
     * @return This builder for chaining.
     */
    public Builder setVerbBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      verb_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object statusDetail_ = "";
    /**
     *
     *
     * <pre>
     * Human-readable status of the operation, if any.
     * </pre>
     *
     * <code>string status_detail = 5;</code>
     *
     * @return The statusDetail.
     */
    public java.lang.String getStatusDetail() {
      java.lang.Object ref = statusDetail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusDetail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human-readable status of the operation, if any.
     * </pre>
     *
     * <code>string status_detail = 5;</code>
     *
     * @return The bytes for statusDetail.
     */
    public com.google.protobuf.ByteString getStatusDetailBytes() {
      java.lang.Object ref = statusDetail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusDetail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human-readable status of the operation, if any.
     * </pre>
     *
     * <code>string status_detail = 5;</code>
     *
     * @param value The statusDetail to set.
     * @return This builder for chaining.
     */
    public Builder setStatusDetail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statusDetail_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human-readable status of the operation, if any.
     * </pre>
     *
     * <code>string status_detail = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatusDetail() {
      statusDetail_ = getDefaultInstance().getStatusDetail();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human-readable status of the operation, if any.
     * </pre>
     *
     * <code>string status_detail = 5;</code>
     *
     * @param value The bytes for statusDetail to set.
     * @return This builder for chaining.
     */
    public Builder setStatusDetailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statusDetail_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean cancelRequested_;
    /**
     *
     *
     * <pre>
     * Identifies whether the user has requested cancellation
     * of the operation. Operations that have successfully been cancelled
     * have [Operation.error][] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
     * `Code.CANCELLED`.
     * </pre>
     *
     * <code>bool cancel_requested = 6;</code>
     *
     * @return The cancelRequested.
     */
    @java.lang.Override
    public boolean getCancelRequested() {
      return cancelRequested_;
    }
    /**
     *
     *
     * <pre>
     * Identifies whether the user has requested cancellation
     * of the operation. Operations that have successfully been cancelled
     * have [Operation.error][] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
     * `Code.CANCELLED`.
     * </pre>
     *
     * <code>bool cancel_requested = 6;</code>
     *
     * @param value The cancelRequested to set.
     * @return This builder for chaining.
     */
    public Builder setCancelRequested(boolean value) {

      cancelRequested_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifies whether the user has requested cancellation
     * of the operation. Operations that have successfully been cancelled
     * have [Operation.error][] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
     * `Code.CANCELLED`.
     * </pre>
     *
     * <code>bool cancel_requested = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCancelRequested() {
      bitField0_ = (bitField0_ & ~0x00000020);
      cancelRequested_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object apiVersion_ = "";
    /**
     *
     *
     * <pre>
     * API version used to start the operation.
     * </pre>
     *
     * <code>string api_version = 7;</code>
     *
     * @return The apiVersion.
     */
    public java.lang.String getApiVersion() {
      java.lang.Object ref = apiVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        apiVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * API version used to start the operation.
     * </pre>
     *
     * <code>string api_version = 7;</code>
     *
     * @return The bytes for apiVersion.
     */
    public com.google.protobuf.ByteString getApiVersionBytes() {
      java.lang.Object ref = apiVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        apiVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * API version used to start the operation.
     * </pre>
     *
     * <code>string api_version = 7;</code>
     *
     * @param value The apiVersion to set.
     * @return This builder for chaining.
     */
    public Builder setApiVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      apiVersion_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * API version used to start the operation.
     * </pre>
     *
     * <code>string api_version = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApiVersion() {
      apiVersion_ = getDefaultInstance().getApiVersion();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * API version used to start the operation.
     * </pre>
     *
     * <code>string api_version = 7;</code>
     *
     * @param value The bytes for apiVersion to set.
     * @return This builder for chaining.
     */
    public Builder setApiVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      apiVersion_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.Any requestResource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Any,
            com.google.protobuf.Any.Builder,
            com.google.protobuf.AnyOrBuilder>
        requestResourceBuilder_;
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request_resource = 8;</code>
     *
     * @return Whether the requestResource field is set.
     */
    public boolean hasRequestResource() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request_resource = 8;</code>
     *
     * @return The requestResource.
     */
    public com.google.protobuf.Any getRequestResource() {
      if (requestResourceBuilder_ == null) {
        return requestResource_ == null
            ? com.google.protobuf.Any.getDefaultInstance()
            : requestResource_;
      } else {
        return requestResourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request_resource = 8;</code>
     */
    public Builder setRequestResource(com.google.protobuf.Any value) {
      if (requestResourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestResource_ = value;
      } else {
        requestResourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request_resource = 8;</code>
     */
    public Builder setRequestResource(com.google.protobuf.Any.Builder builderForValue) {
      if (requestResourceBuilder_ == null) {
        requestResource_ = builderForValue.build();
      } else {
        requestResourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request_resource = 8;</code>
     */
    public Builder mergeRequestResource(com.google.protobuf.Any value) {
      if (requestResourceBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && requestResource_ != null
            && requestResource_ != com.google.protobuf.Any.getDefaultInstance()) {
          getRequestResourceBuilder().mergeFrom(value);
        } else {
          requestResource_ = value;
        }
      } else {
        requestResourceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request_resource = 8;</code>
     */
    public Builder clearRequestResource() {
      bitField0_ = (bitField0_ & ~0x00000080);
      requestResource_ = null;
      if (requestResourceBuilder_ != null) {
        requestResourceBuilder_.dispose();
        requestResourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request_resource = 8;</code>
     */
    public com.google.protobuf.Any.Builder getRequestResourceBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getRequestResourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request_resource = 8;</code>
     */
    public com.google.protobuf.AnyOrBuilder getRequestResourceOrBuilder() {
      if (requestResourceBuilder_ != null) {
        return requestResourceBuilder_.getMessageOrBuilder();
      } else {
        return requestResource_ == null
            ? com.google.protobuf.Any.getDefaultInstance()
            : requestResource_;
      }
    }
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request_resource = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Any,
            com.google.protobuf.Any.Builder,
            com.google.protobuf.AnyOrBuilder>
        getRequestResourceFieldBuilder() {
      if (requestResourceBuilder_ == null) {
        requestResourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Any,
                com.google.protobuf.Any.Builder,
                com.google.protobuf.AnyOrBuilder>(
                getRequestResource(), getParentForChildren(), isClean());
        requestResource_ = null;
      }
      return requestResourceBuilder_;
    }

    private java.util.List<com.google.cloud.functions.v2.Stage> stages_ =
        java.util.Collections.emptyList();

    private void ensureStagesIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        stages_ = new java.util.ArrayList<com.google.cloud.functions.v2.Stage>(stages_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v2.Stage,
            com.google.cloud.functions.v2.Stage.Builder,
            com.google.cloud.functions.v2.StageOrBuilder>
        stagesBuilder_;

    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public java.util.List<com.google.cloud.functions.v2.Stage> getStagesList() {
      if (stagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(stages_);
      } else {
        return stagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public int getStagesCount() {
      if (stagesBuilder_ == null) {
        return stages_.size();
      } else {
        return stagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public com.google.cloud.functions.v2.Stage getStages(int index) {
      if (stagesBuilder_ == null) {
        return stages_.get(index);
      } else {
        return stagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public Builder setStages(int index, com.google.cloud.functions.v2.Stage value) {
      if (stagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStagesIsMutable();
        stages_.set(index, value);
        onChanged();
      } else {
        stagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public Builder setStages(
        int index, com.google.cloud.functions.v2.Stage.Builder builderForValue) {
      if (stagesBuilder_ == null) {
        ensureStagesIsMutable();
        stages_.set(index, builderForValue.build());
        onChanged();
      } else {
        stagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public Builder addStages(com.google.cloud.functions.v2.Stage value) {
      if (stagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStagesIsMutable();
        stages_.add(value);
        onChanged();
      } else {
        stagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public Builder addStages(int index, com.google.cloud.functions.v2.Stage value) {
      if (stagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStagesIsMutable();
        stages_.add(index, value);
        onChanged();
      } else {
        stagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public Builder addStages(com.google.cloud.functions.v2.Stage.Builder builderForValue) {
      if (stagesBuilder_ == null) {
        ensureStagesIsMutable();
        stages_.add(builderForValue.build());
        onChanged();
      } else {
        stagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public Builder addStages(
        int index, com.google.cloud.functions.v2.Stage.Builder builderForValue) {
      if (stagesBuilder_ == null) {
        ensureStagesIsMutable();
        stages_.add(index, builderForValue.build());
        onChanged();
      } else {
        stagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public Builder addAllStages(
        java.lang.Iterable<? extends com.google.cloud.functions.v2.Stage> values) {
      if (stagesBuilder_ == null) {
        ensureStagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, stages_);
        onChanged();
      } else {
        stagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public Builder clearStages() {
      if (stagesBuilder_ == null) {
        stages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        stagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public Builder removeStages(int index) {
      if (stagesBuilder_ == null) {
        ensureStagesIsMutable();
        stages_.remove(index);
        onChanged();
      } else {
        stagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public com.google.cloud.functions.v2.Stage.Builder getStagesBuilder(int index) {
      return getStagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public com.google.cloud.functions.v2.StageOrBuilder getStagesOrBuilder(int index) {
      if (stagesBuilder_ == null) {
        return stages_.get(index);
      } else {
        return stagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public java.util.List<? extends com.google.cloud.functions.v2.StageOrBuilder>
        getStagesOrBuilderList() {
      if (stagesBuilder_ != null) {
        return stagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(stages_);
      }
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public com.google.cloud.functions.v2.Stage.Builder addStagesBuilder() {
      return getStagesFieldBuilder()
          .addBuilder(com.google.cloud.functions.v2.Stage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public com.google.cloud.functions.v2.Stage.Builder addStagesBuilder(int index) {
      return getStagesFieldBuilder()
          .addBuilder(index, com.google.cloud.functions.v2.Stage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Mechanism for reporting in-progress stages
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2.Stage stages = 9;</code>
     */
    public java.util.List<com.google.cloud.functions.v2.Stage.Builder> getStagesBuilderList() {
      return getStagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v2.Stage,
            com.google.cloud.functions.v2.Stage.Builder,
            com.google.cloud.functions.v2.StageOrBuilder>
        getStagesFieldBuilder() {
      if (stagesBuilder_ == null) {
        stagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.functions.v2.Stage,
                com.google.cloud.functions.v2.Stage.Builder,
                com.google.cloud.functions.v2.StageOrBuilder>(
                stages_, ((bitField0_ & 0x00000100) != 0), getParentForChildren(), isClean());
        stages_ = null;
      }
      return stagesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.functions.v2.OperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.functions.v2.OperationMetadata)
  private static final com.google.cloud.functions.v2.OperationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.functions.v2.OperationMetadata();
  }

  public static com.google.cloud.functions.v2.OperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<OperationMetadata>() {
        @java.lang.Override
        public OperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.functions.v2.OperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
