/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/functions/v1/functions.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.functions.v1;

/**
 *
 *
 * <pre>
 * Describes a Cloud Function that contains user computation executed in
 * response to an event. It encapsulate function and triggers configurations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.functions.v1.CloudFunction}
 */
public final class CloudFunction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.functions.v1.CloudFunction)
    CloudFunctionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CloudFunction.newBuilder() to construct.
  private CloudFunction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudFunction() {
    name_ = "";
    description_ = "";
    status_ = 0;
    entryPoint_ = "";
    runtime_ = "";
    serviceAccountEmail_ = "";
    network_ = "";
    vpcConnector_ = "";
    vpcConnectorEgressSettings_ = 0;
    ingressSettings_ = 0;
    kmsKeyName_ = "";
    buildWorkerPool_ = "";
    buildId_ = "";
    buildName_ = "";
    secretEnvironmentVariables_ = java.util.Collections.emptyList();
    secretVolumes_ = java.util.Collections.emptyList();
    sourceToken_ = "";
    dockerRepository_ = "";
    dockerRegistry_ = 0;
    buildServiceAccount_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudFunction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.functions.v1.FunctionsProto
        .internal_static_google_cloud_functions_v1_CloudFunction_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 15:
        return internalGetLabels();
      case 17:
        return internalGetEnvironmentVariables();
      case 28:
        return internalGetBuildEnvironmentVariables();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.functions.v1.FunctionsProto
        .internal_static_google_cloud_functions_v1_CloudFunction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.functions.v1.CloudFunction.class,
            com.google.cloud.functions.v1.CloudFunction.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Available egress settings.
   *
   * This controls what traffic is diverted through the VPC Access Connector
   * resource. By default PRIVATE_RANGES_ONLY will be used.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings}
   */
  public enum VpcConnectorEgressSettings implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED = 0;</code>
     */
    VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Use the VPC Access Connector only for private IP space from RFC1918.
     * </pre>
     *
     * <code>PRIVATE_RANGES_ONLY = 1;</code>
     */
    PRIVATE_RANGES_ONLY(1),
    /**
     *
     *
     * <pre>
     * Force the use of VPC Access Connector for all egress traffic from the
     * function.
     * </pre>
     *
     * <code>ALL_TRAFFIC = 2;</code>
     */
    ALL_TRAFFIC(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED = 0;</code>
     */
    public static final int VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Use the VPC Access Connector only for private IP space from RFC1918.
     * </pre>
     *
     * <code>PRIVATE_RANGES_ONLY = 1;</code>
     */
    public static final int PRIVATE_RANGES_ONLY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Force the use of VPC Access Connector for all egress traffic from the
     * function.
     * </pre>
     *
     * <code>ALL_TRAFFIC = 2;</code>
     */
    public static final int ALL_TRAFFIC_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VpcConnectorEgressSettings valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VpcConnectorEgressSettings forNumber(int value) {
      switch (value) {
        case 0:
          return VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED;
        case 1:
          return PRIVATE_RANGES_ONLY;
        case 2:
          return ALL_TRAFFIC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VpcConnectorEgressSettings>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<VpcConnectorEgressSettings>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<VpcConnectorEgressSettings>() {
              public VpcConnectorEgressSettings findValueByNumber(int number) {
                return VpcConnectorEgressSettings.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.functions.v1.CloudFunction.getDescriptor().getEnumTypes().get(0);
    }

    private static final VpcConnectorEgressSettings[] VALUES = values();

    public static VpcConnectorEgressSettings valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VpcConnectorEgressSettings(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings)
  }

  /**
   *
   *
   * <pre>
   * Available ingress settings.
   *
   * This controls what traffic can reach the function.
   *
   * If unspecified, ALLOW_ALL will be used.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.functions.v1.CloudFunction.IngressSettings}
   */
  public enum IngressSettings implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>INGRESS_SETTINGS_UNSPECIFIED = 0;</code>
     */
    INGRESS_SETTINGS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from public and private sources.
     * </pre>
     *
     * <code>ALLOW_ALL = 1;</code>
     */
    ALLOW_ALL(1),
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from only private VPC sources.
     * </pre>
     *
     * <code>ALLOW_INTERNAL_ONLY = 2;</code>
     */
    ALLOW_INTERNAL_ONLY(2),
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from private VPC sources and through GCLB.
     * </pre>
     *
     * <code>ALLOW_INTERNAL_AND_GCLB = 3;</code>
     */
    ALLOW_INTERNAL_AND_GCLB(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>INGRESS_SETTINGS_UNSPECIFIED = 0;</code>
     */
    public static final int INGRESS_SETTINGS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from public and private sources.
     * </pre>
     *
     * <code>ALLOW_ALL = 1;</code>
     */
    public static final int ALLOW_ALL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from only private VPC sources.
     * </pre>
     *
     * <code>ALLOW_INTERNAL_ONLY = 2;</code>
     */
    public static final int ALLOW_INTERNAL_ONLY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from private VPC sources and through GCLB.
     * </pre>
     *
     * <code>ALLOW_INTERNAL_AND_GCLB = 3;</code>
     */
    public static final int ALLOW_INTERNAL_AND_GCLB_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IngressSettings valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IngressSettings forNumber(int value) {
      switch (value) {
        case 0:
          return INGRESS_SETTINGS_UNSPECIFIED;
        case 1:
          return ALLOW_ALL;
        case 2:
          return ALLOW_INTERNAL_ONLY;
        case 3:
          return ALLOW_INTERNAL_AND_GCLB;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IngressSettings> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IngressSettings>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<IngressSettings>() {
              public IngressSettings findValueByNumber(int number) {
                return IngressSettings.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.functions.v1.CloudFunction.getDescriptor().getEnumTypes().get(1);
    }

    private static final IngressSettings[] VALUES = values();

    public static IngressSettings valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IngressSettings(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.functions.v1.CloudFunction.IngressSettings)
  }

  /**
   *
   *
   * <pre>
   * Docker Registry to use for storing function Docker images.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.functions.v1.CloudFunction.DockerRegistry}
   */
  public enum DockerRegistry implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>DOCKER_REGISTRY_UNSPECIFIED = 0;</code>
     */
    DOCKER_REGISTRY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Docker images will be stored in multi-regional Container Registry
     * repositories named `gcf`.
     * </pre>
     *
     * <code>CONTAINER_REGISTRY = 1;</code>
     */
    CONTAINER_REGISTRY(1),
    /**
     *
     *
     * <pre>
     * Docker images will be stored in regional Artifact Registry repositories.
     * By default, GCF will create and use repositories named `gcf-artifacts`
     * in every region in which a function is deployed. But the repository to
     * use can also be specified by the user using the `docker_repository`
     * field.
     * </pre>
     *
     * <code>ARTIFACT_REGISTRY = 2;</code>
     */
    ARTIFACT_REGISTRY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>DOCKER_REGISTRY_UNSPECIFIED = 0;</code>
     */
    public static final int DOCKER_REGISTRY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Docker images will be stored in multi-regional Container Registry
     * repositories named `gcf`.
     * </pre>
     *
     * <code>CONTAINER_REGISTRY = 1;</code>
     */
    public static final int CONTAINER_REGISTRY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Docker images will be stored in regional Artifact Registry repositories.
     * By default, GCF will create and use repositories named `gcf-artifacts`
     * in every region in which a function is deployed. But the repository to
     * use can also be specified by the user using the `docker_repository`
     * field.
     * </pre>
     *
     * <code>ARTIFACT_REGISTRY = 2;</code>
     */
    public static final int ARTIFACT_REGISTRY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DockerRegistry valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DockerRegistry forNumber(int value) {
      switch (value) {
        case 0:
          return DOCKER_REGISTRY_UNSPECIFIED;
        case 1:
          return CONTAINER_REGISTRY;
        case 2:
          return ARTIFACT_REGISTRY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DockerRegistry> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DockerRegistry> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DockerRegistry>() {
          public DockerRegistry findValueByNumber(int number) {
            return DockerRegistry.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.functions.v1.CloudFunction.getDescriptor().getEnumTypes().get(2);
    }

    private static final DockerRegistry[] VALUES = values();

    public static DockerRegistry valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DockerRegistry(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.functions.v1.CloudFunction.DockerRegistry)
  }

  public interface AutomaticUpdatePolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Security patches are applied automatically to the runtime without requiring
   * the function to be redeployed.
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy}
   */
  public static final class AutomaticUpdatePolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy)
      AutomaticUpdatePolicyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AutomaticUpdatePolicy.newBuilder() to construct.
    private AutomaticUpdatePolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AutomaticUpdatePolicy() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AutomaticUpdatePolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_CloudFunction_AutomaticUpdatePolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_CloudFunction_AutomaticUpdatePolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy.class,
              com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy)) {
        return super.equals(obj);
      }
      com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy other =
          (com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Security patches are applied automatically to the runtime without requiring
     * the function to be redeployed.
     * </pre>
     *
     * Protobuf type {@code google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy)
        com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.functions.v1.FunctionsProto
            .internal_static_google_cloud_functions_v1_CloudFunction_AutomaticUpdatePolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.functions.v1.FunctionsProto
            .internal_static_google_cloud_functions_v1_CloudFunction_AutomaticUpdatePolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy.class,
                com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy.Builder.class);
      }

      // Construct using
      // com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.functions.v1.FunctionsProto
            .internal_static_google_cloud_functions_v1_CloudFunction_AutomaticUpdatePolicy_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
          getDefaultInstanceForType() {
        return com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy build() {
        com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy buildPartial() {
        com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy result =
            new com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy) {
          return mergeFrom(
              (com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy other) {
        if (other
            == com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
                .getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy)
    private static final com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy();
    }

    public static com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AutomaticUpdatePolicy> PARSER =
        new com.google.protobuf.AbstractParser<AutomaticUpdatePolicy>() {
          @java.lang.Override
          public AutomaticUpdatePolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AutomaticUpdatePolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AutomaticUpdatePolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OnDeployUpdatePolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Contains the runtime version which was used during latest
     * function deployment.
     * </pre>
     *
     * <code>string runtime_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The runtimeVersion.
     */
    java.lang.String getRuntimeVersion();
    /**
     *
     *
     * <pre>
     * Output only. Contains the runtime version which was used during latest
     * function deployment.
     * </pre>
     *
     * <code>string runtime_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for runtimeVersion.
     */
    com.google.protobuf.ByteString getRuntimeVersionBytes();
  }
  /**
   *
   *
   * <pre>
   * Security patches are only applied when a function is redeployed.
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy}
   */
  public static final class OnDeployUpdatePolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy)
      OnDeployUpdatePolicyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OnDeployUpdatePolicy.newBuilder() to construct.
    private OnDeployUpdatePolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OnDeployUpdatePolicy() {
      runtimeVersion_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OnDeployUpdatePolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_CloudFunction_OnDeployUpdatePolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_CloudFunction_OnDeployUpdatePolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy.class,
              com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy.Builder.class);
    }

    public static final int RUNTIME_VERSION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object runtimeVersion_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Contains the runtime version which was used during latest
     * function deployment.
     * </pre>
     *
     * <code>string runtime_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The runtimeVersion.
     */
    @java.lang.Override
    public java.lang.String getRuntimeVersion() {
      java.lang.Object ref = runtimeVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        runtimeVersion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains the runtime version which was used during latest
     * function deployment.
     * </pre>
     *
     * <code>string runtime_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for runtimeVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRuntimeVersionBytes() {
      java.lang.Object ref = runtimeVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        runtimeVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(runtimeVersion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, runtimeVersion_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(runtimeVersion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, runtimeVersion_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy)) {
        return super.equals(obj);
      }
      com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy other =
          (com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy) obj;

      if (!getRuntimeVersion().equals(other.getRuntimeVersion())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RUNTIME_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getRuntimeVersion().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Security patches are only applied when a function is redeployed.
     * </pre>
     *
     * Protobuf type {@code google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy)
        com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.functions.v1.FunctionsProto
            .internal_static_google_cloud_functions_v1_CloudFunction_OnDeployUpdatePolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.functions.v1.FunctionsProto
            .internal_static_google_cloud_functions_v1_CloudFunction_OnDeployUpdatePolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy.class,
                com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy.Builder.class);
      }

      // Construct using
      // com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        runtimeVersion_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.functions.v1.FunctionsProto
            .internal_static_google_cloud_functions_v1_CloudFunction_OnDeployUpdatePolicy_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy
          getDefaultInstanceForType() {
        return com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy build() {
        com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy buildPartial() {
        com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy result =
            new com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.runtimeVersion_ = runtimeVersion_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy) {
          return mergeFrom(
              (com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy other) {
        if (other
            == com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy
                .getDefaultInstance()) return this;
        if (!other.getRuntimeVersion().isEmpty()) {
          runtimeVersion_ = other.runtimeVersion_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  runtimeVersion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object runtimeVersion_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Contains the runtime version which was used during latest
       * function deployment.
       * </pre>
       *
       * <code>string runtime_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The runtimeVersion.
       */
      public java.lang.String getRuntimeVersion() {
        java.lang.Object ref = runtimeVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          runtimeVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Contains the runtime version which was used during latest
       * function deployment.
       * </pre>
       *
       * <code>string runtime_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for runtimeVersion.
       */
      public com.google.protobuf.ByteString getRuntimeVersionBytes() {
        java.lang.Object ref = runtimeVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          runtimeVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Contains the runtime version which was used during latest
       * function deployment.
       * </pre>
       *
       * <code>string runtime_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The runtimeVersion to set.
       * @return This builder for chaining.
       */
      public Builder setRuntimeVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        runtimeVersion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Contains the runtime version which was used during latest
       * function deployment.
       * </pre>
       *
       * <code>string runtime_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRuntimeVersion() {
        runtimeVersion_ = getDefaultInstance().getRuntimeVersion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Contains the runtime version which was used during latest
       * function deployment.
       * </pre>
       *
       * <code>string runtime_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for runtimeVersion to set.
       * @return This builder for chaining.
       */
      public Builder setRuntimeVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        runtimeVersion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy)
    private static final com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy();
    }

    public static com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OnDeployUpdatePolicy> PARSER =
        new com.google.protobuf.AbstractParser<OnDeployUpdatePolicy>() {
          @java.lang.Override
          public OnDeployUpdatePolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OnDeployUpdatePolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OnDeployUpdatePolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int sourceCodeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object sourceCode_;

  public enum SourceCodeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SOURCE_ARCHIVE_URL(3),
    SOURCE_REPOSITORY(4),
    SOURCE_UPLOAD_URL(16),
    SOURCECODE_NOT_SET(0);
    private final int value;

    private SourceCodeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCodeCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCodeCase forNumber(int value) {
      switch (value) {
        case 3:
          return SOURCE_ARCHIVE_URL;
        case 4:
          return SOURCE_REPOSITORY;
        case 16:
          return SOURCE_UPLOAD_URL;
        case 0:
          return SOURCECODE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCodeCase getSourceCodeCase() {
    return SourceCodeCase.forNumber(sourceCodeCase_);
  }

  private int triggerCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object trigger_;

  public enum TriggerCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    HTTPS_TRIGGER(5),
    EVENT_TRIGGER(6),
    TRIGGER_NOT_SET(0);
    private final int value;

    private TriggerCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TriggerCase valueOf(int value) {
      return forNumber(value);
    }

    public static TriggerCase forNumber(int value) {
      switch (value) {
        case 5:
          return HTTPS_TRIGGER;
        case 6:
          return EVENT_TRIGGER;
        case 0:
          return TRIGGER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TriggerCase getTriggerCase() {
    return TriggerCase.forNumber(triggerCase_);
  }

  private int runtimeUpdatePolicyCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object runtimeUpdatePolicy_;

  public enum RuntimeUpdatePolicyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AUTOMATIC_UPDATE_POLICY(40),
    ON_DEPLOY_UPDATE_POLICY(41),
    RUNTIMEUPDATEPOLICY_NOT_SET(0);
    private final int value;

    private RuntimeUpdatePolicyCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RuntimeUpdatePolicyCase valueOf(int value) {
      return forNumber(value);
    }

    public static RuntimeUpdatePolicyCase forNumber(int value) {
      switch (value) {
        case 40:
          return AUTOMATIC_UPDATE_POLICY;
        case 41:
          return ON_DEPLOY_UPDATE_POLICY;
        case 0:
          return RUNTIMEUPDATEPOLICY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RuntimeUpdatePolicyCase getRuntimeUpdatePolicyCase() {
    return RuntimeUpdatePolicyCase.forNumber(runtimeUpdatePolicyCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * A user-defined name of the function. Function names must be unique
   * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A user-defined name of the function. Function names must be unique
   * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * User-provided description of a function.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-provided description of a function.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_ARCHIVE_URL_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
   * archive which contains the function.
   * </pre>
   *
   * <code>string source_archive_url = 3;</code>
   *
   * @return Whether the sourceArchiveUrl field is set.
   */
  public boolean hasSourceArchiveUrl() {
    return sourceCodeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
   * archive which contains the function.
   * </pre>
   *
   * <code>string source_archive_url = 3;</code>
   *
   * @return The sourceArchiveUrl.
   */
  public java.lang.String getSourceArchiveUrl() {
    java.lang.Object ref = "";
    if (sourceCodeCase_ == 3) {
      ref = sourceCode_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceCodeCase_ == 3) {
        sourceCode_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
   * archive which contains the function.
   * </pre>
   *
   * <code>string source_archive_url = 3;</code>
   *
   * @return The bytes for sourceArchiveUrl.
   */
  public com.google.protobuf.ByteString getSourceArchiveUrlBytes() {
    java.lang.Object ref = "";
    if (sourceCodeCase_ == 3) {
      ref = sourceCode_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceCodeCase_ == 3) {
        sourceCode_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_REPOSITORY_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * **Beta Feature**
   *
   * The source repository where a function is hosted.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
   *
   * @return Whether the sourceRepository field is set.
   */
  @java.lang.Override
  public boolean hasSourceRepository() {
    return sourceCodeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * **Beta Feature**
   *
   * The source repository where a function is hosted.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
   *
   * @return The sourceRepository.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.SourceRepository getSourceRepository() {
    if (sourceCodeCase_ == 4) {
      return (com.google.cloud.functions.v1.SourceRepository) sourceCode_;
    }
    return com.google.cloud.functions.v1.SourceRepository.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * **Beta Feature**
   *
   * The source repository where a function is hosted.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.SourceRepositoryOrBuilder getSourceRepositoryOrBuilder() {
    if (sourceCodeCase_ == 4) {
      return (com.google.cloud.functions.v1.SourceRepository) sourceCode_;
    }
    return com.google.cloud.functions.v1.SourceRepository.getDefaultInstance();
  }

  public static final int SOURCE_UPLOAD_URL_FIELD_NUMBER = 16;
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage signed URL used for source uploading, generated
   * by calling [google.cloud.functions.v1.GenerateUploadUrl].
   *
   * The signature is validated on write methods (Create, Update)
   * The signature is stripped from the Function object on read methods (Get,
   * List)
   * </pre>
   *
   * <code>string source_upload_url = 16;</code>
   *
   * @return Whether the sourceUploadUrl field is set.
   */
  public boolean hasSourceUploadUrl() {
    return sourceCodeCase_ == 16;
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage signed URL used for source uploading, generated
   * by calling [google.cloud.functions.v1.GenerateUploadUrl].
   *
   * The signature is validated on write methods (Create, Update)
   * The signature is stripped from the Function object on read methods (Get,
   * List)
   * </pre>
   *
   * <code>string source_upload_url = 16;</code>
   *
   * @return The sourceUploadUrl.
   */
  public java.lang.String getSourceUploadUrl() {
    java.lang.Object ref = "";
    if (sourceCodeCase_ == 16) {
      ref = sourceCode_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceCodeCase_ == 16) {
        sourceCode_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage signed URL used for source uploading, generated
   * by calling [google.cloud.functions.v1.GenerateUploadUrl].
   *
   * The signature is validated on write methods (Create, Update)
   * The signature is stripped from the Function object on read methods (Get,
   * List)
   * </pre>
   *
   * <code>string source_upload_url = 16;</code>
   *
   * @return The bytes for sourceUploadUrl.
   */
  public com.google.protobuf.ByteString getSourceUploadUrlBytes() {
    java.lang.Object ref = "";
    if (sourceCodeCase_ == 16) {
      ref = sourceCode_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceCodeCase_ == 16) {
        sourceCode_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HTTPS_TRIGGER_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * An HTTPS endpoint type of source that can be triggered via URL.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
   *
   * @return Whether the httpsTrigger field is set.
   */
  @java.lang.Override
  public boolean hasHttpsTrigger() {
    return triggerCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * An HTTPS endpoint type of source that can be triggered via URL.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
   *
   * @return The httpsTrigger.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.HttpsTrigger getHttpsTrigger() {
    if (triggerCase_ == 5) {
      return (com.google.cloud.functions.v1.HttpsTrigger) trigger_;
    }
    return com.google.cloud.functions.v1.HttpsTrigger.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An HTTPS endpoint type of source that can be triggered via URL.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.HttpsTriggerOrBuilder getHttpsTriggerOrBuilder() {
    if (triggerCase_ == 5) {
      return (com.google.cloud.functions.v1.HttpsTrigger) trigger_;
    }
    return com.google.cloud.functions.v1.HttpsTrigger.getDefaultInstance();
  }

  public static final int EVENT_TRIGGER_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * A source that fires events in response to a condition in another service.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
   *
   * @return Whether the eventTrigger field is set.
   */
  @java.lang.Override
  public boolean hasEventTrigger() {
    return triggerCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * A source that fires events in response to a condition in another service.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
   *
   * @return The eventTrigger.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.EventTrigger getEventTrigger() {
    if (triggerCase_ == 6) {
      return (com.google.cloud.functions.v1.EventTrigger) trigger_;
    }
    return com.google.cloud.functions.v1.EventTrigger.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A source that fires events in response to a condition in another service.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.EventTriggerOrBuilder getEventTriggerOrBuilder() {
    if (triggerCase_ == 6) {
      return (com.google.cloud.functions.v1.EventTrigger) trigger_;
    }
    return com.google.cloud.functions.v1.EventTrigger.getDefaultInstance();
  }

  public static final int STATUS_FIELD_NUMBER = 7;
  private int status_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Status of the function deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override
  public int getStatusValue() {
    return status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Status of the function deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.CloudFunctionStatus getStatus() {
    com.google.cloud.functions.v1.CloudFunctionStatus result =
        com.google.cloud.functions.v1.CloudFunctionStatus.forNumber(status_);
    return result == null ? com.google.cloud.functions.v1.CloudFunctionStatus.UNRECOGNIZED : result;
  }

  public static final int ENTRY_POINT_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object entryPoint_ = "";
  /**
   *
   *
   * <pre>
   * The name of the function (as defined in source code) that will be
   * executed. Defaults to the resource name suffix (ID of the function), if not
   * specified.
   * </pre>
   *
   * <code>string entry_point = 8;</code>
   *
   * @return The entryPoint.
   */
  @java.lang.Override
  public java.lang.String getEntryPoint() {
    java.lang.Object ref = entryPoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entryPoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the function (as defined in source code) that will be
   * executed. Defaults to the resource name suffix (ID of the function), if not
   * specified.
   * </pre>
   *
   * <code>string entry_point = 8;</code>
   *
   * @return The bytes for entryPoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntryPointBytes() {
    java.lang.Object ref = entryPoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entryPoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RUNTIME_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private volatile java.lang.Object runtime_ = "";
  /**
   *
   *
   * <pre>
   * The runtime in which to run the function. Required when deploying a new
   * function, optional when updating an existing function. For a complete
   * list of possible choices, see the
   * [`gcloud` command
   * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
   * </pre>
   *
   * <code>string runtime = 19;</code>
   *
   * @return The runtime.
   */
  @java.lang.Override
  public java.lang.String getRuntime() {
    java.lang.Object ref = runtime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      runtime_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The runtime in which to run the function. Required when deploying a new
   * function, optional when updating an existing function. For a complete
   * list of possible choices, see the
   * [`gcloud` command
   * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
   * </pre>
   *
   * <code>string runtime = 19;</code>
   *
   * @return The bytes for runtime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRuntimeBytes() {
    java.lang.Object ref = runtime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      runtime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIMEOUT_FIELD_NUMBER = 9;
  private com.google.protobuf.Duration timeout_;
  /**
   *
   *
   * <pre>
   * The function execution timeout. Execution is considered failed and
   * can be terminated if the function is not completed at the end of the
   * timeout period. Defaults to 60 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 9;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The function execution timeout. Execution is considered failed and
   * can be terminated if the function is not completed at the end of the
   * timeout period. Defaults to 60 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 9;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   *
   *
   * <pre>
   * The function execution timeout. Execution is considered failed and
   * can be terminated if the function is not completed at the end of the
   * timeout period. Defaults to 60 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }

  public static final int AVAILABLE_MEMORY_MB_FIELD_NUMBER = 10;
  private int availableMemoryMb_ = 0;
  /**
   *
   *
   * <pre>
   * The amount of memory in MB available for a function.
   * Defaults to 256MB.
   * </pre>
   *
   * <code>int32 available_memory_mb = 10;</code>
   *
   * @return The availableMemoryMb.
   */
  @java.lang.Override
  public int getAvailableMemoryMb() {
    return availableMemoryMb_;
  }

  public static final int SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccountEmail_ = "";
  /**
   *
   *
   * <pre>
   * The email of the function's service account. If empty, defaults to
   * `{project_id}&#64;appspot.gserviceaccount.com`.
   * </pre>
   *
   * <code>string service_account_email = 11;</code>
   *
   * @return The serviceAccountEmail.
   */
  @java.lang.Override
  public java.lang.String getServiceAccountEmail() {
    java.lang.Object ref = serviceAccountEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccountEmail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The email of the function's service account. If empty, defaults to
   * `{project_id}&#64;appspot.gserviceaccount.com`.
   * </pre>
   *
   * <code>string service_account_email = 11;</code>
   *
   * @return The bytes for serviceAccountEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
    java.lang.Object ref = serviceAccountEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccountEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a Cloud Function.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a Cloud Function.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a Cloud Function.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int VERSION_ID_FIELD_NUMBER = 14;
  private long versionId_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The version identifier of the Cloud Function. Each deployment
   * attempt results in a new version of a function being created.
   * </pre>
   *
   * <code>int64 version_id = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The versionId.
   */
  @java.lang.Override
  public long getVersionId() {
    return versionId_;
  }

  public static final int LABELS_FIELD_NUMBER = 15;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.functions.v1.FunctionsProto
                .internal_static_google_cloud_functions_v1_CloudFunction_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this Cloud Function.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this Cloud Function.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this Cloud Function.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this Cloud Function.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ENVIRONMENT_VARIABLES_FIELD_NUMBER = 17;

  private static final class EnvironmentVariablesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.functions.v1.FunctionsProto
                .internal_static_google_cloud_functions_v1_CloudFunction_EnvironmentVariablesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> environmentVariables_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetEnvironmentVariables() {
    if (environmentVariables_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          EnvironmentVariablesDefaultEntryHolder.defaultEntry);
    }
    return environmentVariables_;
  }

  public int getEnvironmentVariablesCount() {
    return internalGetEnvironmentVariables().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Environment variables that shall be available during function execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment_variables = 17;</code>
   */
  @java.lang.Override
  public boolean containsEnvironmentVariables(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetEnvironmentVariables().getMap().containsKey(key);
  }
  /** Use {@link #getEnvironmentVariablesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
    return getEnvironmentVariablesMap();
  }
  /**
   *
   *
   * <pre>
   * Environment variables that shall be available during function execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment_variables = 17;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariablesMap() {
    return internalGetEnvironmentVariables().getMap();
  }
  /**
   *
   *
   * <pre>
   * Environment variables that shall be available during function execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment_variables = 17;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getEnvironmentVariablesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetEnvironmentVariables().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Environment variables that shall be available during function execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment_variables = 17;</code>
   */
  @java.lang.Override
  public java.lang.String getEnvironmentVariablesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetEnvironmentVariables().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int BUILD_ENVIRONMENT_VARIABLES_FIELD_NUMBER = 28;

  private static final class BuildEnvironmentVariablesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.functions.v1.FunctionsProto
                .internal_static_google_cloud_functions_v1_CloudFunction_BuildEnvironmentVariablesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      buildEnvironmentVariables_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetBuildEnvironmentVariables() {
    if (buildEnvironmentVariables_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          BuildEnvironmentVariablesDefaultEntryHolder.defaultEntry);
    }
    return buildEnvironmentVariables_;
  }

  public int getBuildEnvironmentVariablesCount() {
    return internalGetBuildEnvironmentVariables().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Build environment variables that shall be available during build time.
   * </pre>
   *
   * <code>map&lt;string, string&gt; build_environment_variables = 28;</code>
   */
  @java.lang.Override
  public boolean containsBuildEnvironmentVariables(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetBuildEnvironmentVariables().getMap().containsKey(key);
  }
  /** Use {@link #getBuildEnvironmentVariablesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getBuildEnvironmentVariables() {
    return getBuildEnvironmentVariablesMap();
  }
  /**
   *
   *
   * <pre>
   * Build environment variables that shall be available during build time.
   * </pre>
   *
   * <code>map&lt;string, string&gt; build_environment_variables = 28;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getBuildEnvironmentVariablesMap() {
    return internalGetBuildEnvironmentVariables().getMap();
  }
  /**
   *
   *
   * <pre>
   * Build environment variables that shall be available during build time.
   * </pre>
   *
   * <code>map&lt;string, string&gt; build_environment_variables = 28;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getBuildEnvironmentVariablesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetBuildEnvironmentVariables().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Build environment variables that shall be available during build time.
   * </pre>
   *
   * <code>map&lt;string, string&gt; build_environment_variables = 28;</code>
   */
  @java.lang.Override
  public java.lang.String getBuildEnvironmentVariablesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetBuildEnvironmentVariables().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int NETWORK_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated: use vpc_connector
   * </pre>
   *
   * <code>string network = 18 [deprecated = true];</code>
   *
   * @deprecated google.cloud.functions.v1.CloudFunction.network is deprecated. See
   *     google/cloud/functions/v1/functions.proto;l=355
   * @return The network.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated: use vpc_connector
   * </pre>
   *
   * <code>string network = 18 [deprecated = true];</code>
   *
   * @deprecated google.cloud.functions.v1.CloudFunction.network is deprecated. See
   *     google/cloud/functions/v1/functions.proto;l=355
   * @return The bytes for network.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_INSTANCES_FIELD_NUMBER = 20;
  private int maxInstances_ = 0;
  /**
   *
   *
   * <pre>
   * The limit on the maximum number of function instances that may coexist at a
   * given time.
   *
   * In some cases, such as rapid traffic surges, Cloud Functions may, for a
   * short period of time, create more instances than the specified max
   * instances limit. If your function cannot tolerate this temporary behavior,
   * you may want to factor in a safety margin and set a lower max instances
   * value than your function can tolerate.
   *
   * See the [Max
   * Instances](https://cloud.google.com/functions/docs/max-instances) Guide for
   * more details.
   * </pre>
   *
   * <code>int32 max_instances = 20;</code>
   *
   * @return The maxInstances.
   */
  @java.lang.Override
  public int getMaxInstances() {
    return maxInstances_;
  }

  public static final int MIN_INSTANCES_FIELD_NUMBER = 32;
  private int minInstances_ = 0;
  /**
   *
   *
   * <pre>
   * A lower bound for the number function instances that may coexist at a
   * given time.
   * </pre>
   *
   * <code>int32 min_instances = 32;</code>
   *
   * @return The minInstances.
   */
  @java.lang.Override
  public int getMinInstances() {
    return minInstances_;
  }

  public static final int VPC_CONNECTOR_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private volatile java.lang.Object vpcConnector_ = "";
  /**
   *
   *
   * <pre>
   * The VPC Network Connector that this cloud function can connect to. It can
   * be either the fully-qualified URI, or the short name of the network
   * connector resource. The format of this field is
   * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
   *
   * This field is mutually exclusive with `network` field and will eventually
   * replace it.
   *
   * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
   * more information on connecting Cloud projects.
   * </pre>
   *
   * <code>string vpc_connector = 22;</code>
   *
   * @return The vpcConnector.
   */
  @java.lang.Override
  public java.lang.String getVpcConnector() {
    java.lang.Object ref = vpcConnector_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      vpcConnector_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The VPC Network Connector that this cloud function can connect to. It can
   * be either the fully-qualified URI, or the short name of the network
   * connector resource. The format of this field is
   * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
   *
   * This field is mutually exclusive with `network` field and will eventually
   * replace it.
   *
   * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
   * more information on connecting Cloud projects.
   * </pre>
   *
   * <code>string vpc_connector = 22;</code>
   *
   * @return The bytes for vpcConnector.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVpcConnectorBytes() {
    java.lang.Object ref = vpcConnector_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      vpcConnector_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VPC_CONNECTOR_EGRESS_SETTINGS_FIELD_NUMBER = 23;
  private int vpcConnectorEgressSettings_ = 0;
  /**
   *
   *
   * <pre>
   * The egress settings for the connector, controlling what traffic is diverted
   * through it.
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;
   * </code>
   *
   * @return The enum numeric value on the wire for vpcConnectorEgressSettings.
   */
  @java.lang.Override
  public int getVpcConnectorEgressSettingsValue() {
    return vpcConnectorEgressSettings_;
  }
  /**
   *
   *
   * <pre>
   * The egress settings for the connector, controlling what traffic is diverted
   * through it.
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;
   * </code>
   *
   * @return The vpcConnectorEgressSettings.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings
      getVpcConnectorEgressSettings() {
    com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings result =
        com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings.forNumber(
            vpcConnectorEgressSettings_);
    return result == null
        ? com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings.UNRECOGNIZED
        : result;
  }

  public static final int INGRESS_SETTINGS_FIELD_NUMBER = 24;
  private int ingressSettings_ = 0;
  /**
   *
   *
   * <pre>
   * The ingress settings for the function, controlling what traffic can reach
   * it.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
   *
   * @return The enum numeric value on the wire for ingressSettings.
   */
  @java.lang.Override
  public int getIngressSettingsValue() {
    return ingressSettings_;
  }
  /**
   *
   *
   * <pre>
   * The ingress settings for the function, controlling what traffic can reach
   * it.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
   *
   * @return The ingressSettings.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.CloudFunction.IngressSettings getIngressSettings() {
    com.google.cloud.functions.v1.CloudFunction.IngressSettings result =
        com.google.cloud.functions.v1.CloudFunction.IngressSettings.forNumber(ingressSettings_);
    return result == null
        ? com.google.cloud.functions.v1.CloudFunction.IngressSettings.UNRECOGNIZED
        : result;
  }

  public static final int KMS_KEY_NAME_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyName_ = "";
  /**
   *
   *
   * <pre>
   * Resource name of a KMS crypto key (managed by the user) used to
   * encrypt/decrypt function resources.
   *
   * It must match the pattern
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
   *
   * If specified, you must also provide an artifact registry repository using
   * the `docker_repository` field that was created with the same KMS crypto
   * key.
   *
   * The following service accounts need to be granted the role 'Cloud KMS
   * CryptoKey Encrypter/Decrypter (roles/cloudkms.cryptoKeyEncrypterDecrypter)'
   * on the Key/KeyRing/Project/Organization (least access preferred).
   *
   * 1. Google Cloud Functions service account
   *    (service-{project_number}&#64;gcf-admin-robot.iam.gserviceaccount.com) -
   *    Required to protect the function's image.
   * 2. Google Storage service account
   *    (service-{project_number}&#64;gs-project-accounts.iam.gserviceaccount.com) -
   *    Required to protect the function's source code.
   *    If this service account does not exist, deploying a function without a
   *    KMS key or retrieving the service agent name provisions it. For more
   *    information, see
   *    https://cloud.google.com/storage/docs/projects#service-agents and
   *    https://cloud.google.com/storage/docs/getting-service-agent#gsutil.
   *
   * Google Cloud Functions delegates access to service agents to protect
   * function resources in internal projects that are not accessible by the
   * end user.
   * </pre>
   *
   * <code>string kms_key_name = 25 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The kmsKeyName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyName() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource name of a KMS crypto key (managed by the user) used to
   * encrypt/decrypt function resources.
   *
   * It must match the pattern
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
   *
   * If specified, you must also provide an artifact registry repository using
   * the `docker_repository` field that was created with the same KMS crypto
   * key.
   *
   * The following service accounts need to be granted the role 'Cloud KMS
   * CryptoKey Encrypter/Decrypter (roles/cloudkms.cryptoKeyEncrypterDecrypter)'
   * on the Key/KeyRing/Project/Organization (least access preferred).
   *
   * 1. Google Cloud Functions service account
   *    (service-{project_number}&#64;gcf-admin-robot.iam.gserviceaccount.com) -
   *    Required to protect the function's image.
   * 2. Google Storage service account
   *    (service-{project_number}&#64;gs-project-accounts.iam.gserviceaccount.com) -
   *    Required to protect the function's source code.
   *    If this service account does not exist, deploying a function without a
   *    KMS key or retrieving the service agent name provisions it. For more
   *    information, see
   *    https://cloud.google.com/storage/docs/projects#service-agents and
   *    https://cloud.google.com/storage/docs/getting-service-agent#gsutil.
   *
   * Google Cloud Functions delegates access to service agents to protect
   * function resources in internal projects that are not accessible by the
   * end user.
   * </pre>
   *
   * <code>string kms_key_name = 25 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for kmsKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyNameBytes() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUILD_WORKER_POOL_FIELD_NUMBER = 26;

  @SuppressWarnings("serial")
  private volatile java.lang.Object buildWorkerPool_ = "";
  /**
   *
   *
   * <pre>
   * Name of the Cloud Build Custom Worker Pool that should be used to build the
   * function. The format of this field is
   * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
   * `{project}` and `{region}` are the project id and region respectively where
   * the worker pool is defined and `{workerPool}` is the short name of the
   * worker pool.
   *
   * If the project id is not the same as the function, then the Cloud
   * Functions Service Agent
   * (`service-&lt;project_number&gt;&#64;gcf-admin-robot.iam.gserviceaccount.com`) must
   * be granted the role Cloud Build Custom Workers Builder
   * (`roles/cloudbuild.customworkers.builder`) in the project.
   * </pre>
   *
   * <code>string build_worker_pool = 26;</code>
   *
   * @return The buildWorkerPool.
   */
  @java.lang.Override
  public java.lang.String getBuildWorkerPool() {
    java.lang.Object ref = buildWorkerPool_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      buildWorkerPool_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the Cloud Build Custom Worker Pool that should be used to build the
   * function. The format of this field is
   * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
   * `{project}` and `{region}` are the project id and region respectively where
   * the worker pool is defined and `{workerPool}` is the short name of the
   * worker pool.
   *
   * If the project id is not the same as the function, then the Cloud
   * Functions Service Agent
   * (`service-&lt;project_number&gt;&#64;gcf-admin-robot.iam.gserviceaccount.com`) must
   * be granted the role Cloud Build Custom Workers Builder
   * (`roles/cloudbuild.customworkers.builder`) in the project.
   * </pre>
   *
   * <code>string build_worker_pool = 26;</code>
   *
   * @return The bytes for buildWorkerPool.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBuildWorkerPoolBytes() {
    java.lang.Object ref = buildWorkerPool_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      buildWorkerPool_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUILD_ID_FIELD_NUMBER = 27;

  @SuppressWarnings("serial")
  private volatile java.lang.Object buildId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The Cloud Build ID of the latest successful deployment of the
   * function.
   * </pre>
   *
   * <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The buildId.
   */
  @java.lang.Override
  public java.lang.String getBuildId() {
    java.lang.Object ref = buildId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      buildId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The Cloud Build ID of the latest successful deployment of the
   * function.
   * </pre>
   *
   * <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for buildId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBuildIdBytes() {
    java.lang.Object ref = buildId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      buildId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUILD_NAME_FIELD_NUMBER = 33;

  @SuppressWarnings("serial")
  private volatile java.lang.Object buildName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The Cloud Build Name of the function deployment.
   * `projects/&lt;project-number&gt;/locations/&lt;region&gt;/builds/&lt;build-id&gt;`.
   * </pre>
   *
   * <code>string build_name = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The buildName.
   */
  @java.lang.Override
  public java.lang.String getBuildName() {
    java.lang.Object ref = buildName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      buildName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The Cloud Build Name of the function deployment.
   * `projects/&lt;project-number&gt;/locations/&lt;region&gt;/builds/&lt;build-id&gt;`.
   * </pre>
   *
   * <code>string build_name = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for buildName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBuildNameBytes() {
    java.lang.Object ref = buildName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      buildName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECRET_ENVIRONMENT_VARIABLES_FIELD_NUMBER = 29;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.functions.v1.SecretEnvVar> secretEnvironmentVariables_;
  /**
   *
   *
   * <pre>
   * Secret environment variables configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.functions.v1.SecretEnvVar>
      getSecretEnvironmentVariablesList() {
    return secretEnvironmentVariables_;
  }
  /**
   *
   *
   * <pre>
   * Secret environment variables configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.functions.v1.SecretEnvVarOrBuilder>
      getSecretEnvironmentVariablesOrBuilderList() {
    return secretEnvironmentVariables_;
  }
  /**
   *
   *
   * <pre>
   * Secret environment variables configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
   * </code>
   */
  @java.lang.Override
  public int getSecretEnvironmentVariablesCount() {
    return secretEnvironmentVariables_.size();
  }
  /**
   *
   *
   * <pre>
   * Secret environment variables configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.SecretEnvVar getSecretEnvironmentVariables(int index) {
    return secretEnvironmentVariables_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Secret environment variables configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.SecretEnvVarOrBuilder getSecretEnvironmentVariablesOrBuilder(
      int index) {
    return secretEnvironmentVariables_.get(index);
  }

  public static final int SECRET_VOLUMES_FIELD_NUMBER = 30;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.functions.v1.SecretVolume> secretVolumes_;
  /**
   *
   *
   * <pre>
   * Secret volumes configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.functions.v1.SecretVolume> getSecretVolumesList() {
    return secretVolumes_;
  }
  /**
   *
   *
   * <pre>
   * Secret volumes configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.functions.v1.SecretVolumeOrBuilder>
      getSecretVolumesOrBuilderList() {
    return secretVolumes_;
  }
  /**
   *
   *
   * <pre>
   * Secret volumes configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
   */
  @java.lang.Override
  public int getSecretVolumesCount() {
    return secretVolumes_.size();
  }
  /**
   *
   *
   * <pre>
   * Secret volumes configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.SecretVolume getSecretVolumes(int index) {
    return secretVolumes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Secret volumes configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.SecretVolumeOrBuilder getSecretVolumesOrBuilder(int index) {
    return secretVolumes_.get(index);
  }

  public static final int SOURCE_TOKEN_FIELD_NUMBER = 31;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceToken_ = "";
  /**
   *
   *
   * <pre>
   * Input only. An identifier for Firebase function sources. Disclaimer: This
   * field is only supported for Firebase function deployments.
   * </pre>
   *
   * <code>string source_token = 31 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The sourceToken.
   */
  @java.lang.Override
  public java.lang.String getSourceToken() {
    java.lang.Object ref = sourceToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Input only. An identifier for Firebase function sources. Disclaimer: This
   * field is only supported for Firebase function deployments.
   * </pre>
   *
   * <code>string source_token = 31 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The bytes for sourceToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceTokenBytes() {
    java.lang.Object ref = sourceToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCKER_REPOSITORY_FIELD_NUMBER = 34;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dockerRepository_ = "";
  /**
   *
   *
   * <pre>
   * User-managed repository created in Artifact Registry to which the
   * function's Docker image will be pushed after it is built by Cloud Build.
   * May optionally be encrypted with a customer-managed encryption key (CMEK).
   * If unspecified and `docker_registry` is not explicitly set to
   * `CONTAINER_REGISTRY`, GCF will create and use a default Artifact Registry
   * repository named 'gcf-artifacts' in the region.
   *
   * It must match the pattern
   * `projects/{project}/locations/{location}/repositories/{repository}`.
   *
   * Cross-project repositories are not supported.
   * Cross-location repositories are not supported.
   * Repository format must be 'DOCKER'.
   * </pre>
   *
   * <code>string docker_repository = 34 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The dockerRepository.
   */
  @java.lang.Override
  public java.lang.String getDockerRepository() {
    java.lang.Object ref = dockerRepository_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dockerRepository_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-managed repository created in Artifact Registry to which the
   * function's Docker image will be pushed after it is built by Cloud Build.
   * May optionally be encrypted with a customer-managed encryption key (CMEK).
   * If unspecified and `docker_registry` is not explicitly set to
   * `CONTAINER_REGISTRY`, GCF will create and use a default Artifact Registry
   * repository named 'gcf-artifacts' in the region.
   *
   * It must match the pattern
   * `projects/{project}/locations/{location}/repositories/{repository}`.
   *
   * Cross-project repositories are not supported.
   * Cross-location repositories are not supported.
   * Repository format must be 'DOCKER'.
   * </pre>
   *
   * <code>string docker_repository = 34 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for dockerRepository.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDockerRepositoryBytes() {
    java.lang.Object ref = dockerRepository_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dockerRepository_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCKER_REGISTRY_FIELD_NUMBER = 35;
  private int dockerRegistry_ = 0;
  /**
   *
   *
   * <pre>
   * Docker Registry to use for this deployment.
   *
   * If unspecified, it defaults to `ARTIFACT_REGISTRY`.
   * If `docker_repository` field is specified, this field should either be left
   * unspecified or set to `ARTIFACT_REGISTRY`.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.CloudFunction.DockerRegistry docker_registry = 35;</code>
   *
   * @return The enum numeric value on the wire for dockerRegistry.
   */
  @java.lang.Override
  public int getDockerRegistryValue() {
    return dockerRegistry_;
  }
  /**
   *
   *
   * <pre>
   * Docker Registry to use for this deployment.
   *
   * If unspecified, it defaults to `ARTIFACT_REGISTRY`.
   * If `docker_repository` field is specified, this field should either be left
   * unspecified or set to `ARTIFACT_REGISTRY`.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.CloudFunction.DockerRegistry docker_registry = 35;</code>
   *
   * @return The dockerRegistry.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.CloudFunction.DockerRegistry getDockerRegistry() {
    com.google.cloud.functions.v1.CloudFunction.DockerRegistry result =
        com.google.cloud.functions.v1.CloudFunction.DockerRegistry.forNumber(dockerRegistry_);
    return result == null
        ? com.google.cloud.functions.v1.CloudFunction.DockerRegistry.UNRECOGNIZED
        : result;
  }

  public static final int AUTOMATIC_UPDATE_POLICY_FIELD_NUMBER = 40;
  /**
   * <code>
   * .google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy automatic_update_policy = 40;
   * </code>
   *
   * @return Whether the automaticUpdatePolicy field is set.
   */
  @java.lang.Override
  public boolean hasAutomaticUpdatePolicy() {
    return runtimeUpdatePolicyCase_ == 40;
  }
  /**
   * <code>
   * .google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy automatic_update_policy = 40;
   * </code>
   *
   * @return The automaticUpdatePolicy.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
      getAutomaticUpdatePolicy() {
    if (runtimeUpdatePolicyCase_ == 40) {
      return (com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy)
          runtimeUpdatePolicy_;
    }
    return com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy.getDefaultInstance();
  }
  /**
   * <code>
   * .google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy automatic_update_policy = 40;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicyOrBuilder
      getAutomaticUpdatePolicyOrBuilder() {
    if (runtimeUpdatePolicyCase_ == 40) {
      return (com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy)
          runtimeUpdatePolicy_;
    }
    return com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy.getDefaultInstance();
  }

  public static final int ON_DEPLOY_UPDATE_POLICY_FIELD_NUMBER = 41;
  /**
   * <code>
   * .google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy on_deploy_update_policy = 41;
   * </code>
   *
   * @return Whether the onDeployUpdatePolicy field is set.
   */
  @java.lang.Override
  public boolean hasOnDeployUpdatePolicy() {
    return runtimeUpdatePolicyCase_ == 41;
  }
  /**
   * <code>
   * .google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy on_deploy_update_policy = 41;
   * </code>
   *
   * @return The onDeployUpdatePolicy.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy
      getOnDeployUpdatePolicy() {
    if (runtimeUpdatePolicyCase_ == 41) {
      return (com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy)
          runtimeUpdatePolicy_;
    }
    return com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy.getDefaultInstance();
  }
  /**
   * <code>
   * .google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy on_deploy_update_policy = 41;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicyOrBuilder
      getOnDeployUpdatePolicyOrBuilder() {
    if (runtimeUpdatePolicyCase_ == 41) {
      return (com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy)
          runtimeUpdatePolicy_;
    }
    return com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy.getDefaultInstance();
  }

  public static final int BUILD_SERVICE_ACCOUNT_FIELD_NUMBER = 43;

  @SuppressWarnings("serial")
  private volatile java.lang.Object buildServiceAccount_ = "";
  /**
   *
   *
   * <pre>
   * A service account the user provides for use with Cloud Build. The format of
   * this field is
   * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
   * </pre>
   *
   * <code>string build_service_account = 43;</code>
   *
   * @return The buildServiceAccount.
   */
  @java.lang.Override
  public java.lang.String getBuildServiceAccount() {
    java.lang.Object ref = buildServiceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      buildServiceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A service account the user provides for use with Cloud Build. The format of
   * this field is
   * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
   * </pre>
   *
   * <code>string build_service_account = 43;</code>
   *
   * @return The bytes for buildServiceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBuildServiceAccountBytes() {
    java.lang.Object ref = buildServiceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      buildServiceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (sourceCodeCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, sourceCode_);
    }
    if (sourceCodeCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.functions.v1.SourceRepository) sourceCode_);
    }
    if (triggerCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.functions.v1.HttpsTrigger) trigger_);
    }
    if (triggerCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.functions.v1.EventTrigger) trigger_);
    }
    if (status_
        != com.google.cloud.functions.v1.CloudFunctionStatus.CLOUD_FUNCTION_STATUS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entryPoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, entryPoint_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(9, getTimeout());
    }
    if (availableMemoryMb_ != 0) {
      output.writeInt32(10, availableMemoryMb_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountEmail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, serviceAccountEmail_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(12, getUpdateTime());
    }
    if (versionId_ != 0L) {
      output.writeInt64(14, versionId_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 15);
    if (sourceCodeCase_ == 16) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, sourceCode_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetEnvironmentVariables(),
        EnvironmentVariablesDefaultEntryHolder.defaultEntry,
        17);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(runtime_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, runtime_);
    }
    if (maxInstances_ != 0) {
      output.writeInt32(20, maxInstances_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vpcConnector_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, vpcConnector_);
    }
    if (vpcConnectorEgressSettings_
        != com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings
            .VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(23, vpcConnectorEgressSettings_);
    }
    if (ingressSettings_
        != com.google.cloud.functions.v1.CloudFunction.IngressSettings.INGRESS_SETTINGS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(24, ingressSettings_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, kmsKeyName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(buildWorkerPool_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 26, buildWorkerPool_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(buildId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 27, buildId_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetBuildEnvironmentVariables(),
        BuildEnvironmentVariablesDefaultEntryHolder.defaultEntry,
        28);
    for (int i = 0; i < secretEnvironmentVariables_.size(); i++) {
      output.writeMessage(29, secretEnvironmentVariables_.get(i));
    }
    for (int i = 0; i < secretVolumes_.size(); i++) {
      output.writeMessage(30, secretVolumes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 31, sourceToken_);
    }
    if (minInstances_ != 0) {
      output.writeInt32(32, minInstances_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(buildName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 33, buildName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dockerRepository_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 34, dockerRepository_);
    }
    if (dockerRegistry_
        != com.google.cloud.functions.v1.CloudFunction.DockerRegistry.DOCKER_REGISTRY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(35, dockerRegistry_);
    }
    if (runtimeUpdatePolicyCase_ == 40) {
      output.writeMessage(
          40,
          (com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy) runtimeUpdatePolicy_);
    }
    if (runtimeUpdatePolicyCase_ == 41) {
      output.writeMessage(
          41,
          (com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy) runtimeUpdatePolicy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(buildServiceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 43, buildServiceAccount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (sourceCodeCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, sourceCode_);
    }
    if (sourceCodeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.functions.v1.SourceRepository) sourceCode_);
    }
    if (triggerCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.functions.v1.HttpsTrigger) trigger_);
    }
    if (triggerCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.functions.v1.EventTrigger) trigger_);
    }
    if (status_
        != com.google.cloud.functions.v1.CloudFunctionStatus.CLOUD_FUNCTION_STATUS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entryPoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, entryPoint_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getTimeout());
    }
    if (availableMemoryMb_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(10, availableMemoryMb_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountEmail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, serviceAccountEmail_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getUpdateTime());
    }
    if (versionId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(14, versionId_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, labels__);
    }
    if (sourceCodeCase_ == 16) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, sourceCode_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetEnvironmentVariables().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> environmentVariables__ =
          EnvironmentVariablesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, environmentVariables__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(runtime_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, runtime_);
    }
    if (maxInstances_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(20, maxInstances_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vpcConnector_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, vpcConnector_);
    }
    if (vpcConnectorEgressSettings_
        != com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings
            .VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED
            .getNumber()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(23, vpcConnectorEgressSettings_);
    }
    if (ingressSettings_
        != com.google.cloud.functions.v1.CloudFunction.IngressSettings.INGRESS_SETTINGS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(24, ingressSettings_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(25, kmsKeyName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(buildWorkerPool_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(26, buildWorkerPool_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(buildId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(27, buildId_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetBuildEnvironmentVariables().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> buildEnvironmentVariables__ =
          BuildEnvironmentVariablesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(28, buildEnvironmentVariables__);
    }
    for (int i = 0; i < secretEnvironmentVariables_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              29, secretEnvironmentVariables_.get(i));
    }
    for (int i = 0; i < secretVolumes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(30, secretVolumes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(31, sourceToken_);
    }
    if (minInstances_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(32, minInstances_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(buildName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(33, buildName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dockerRepository_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(34, dockerRepository_);
    }
    if (dockerRegistry_
        != com.google.cloud.functions.v1.CloudFunction.DockerRegistry.DOCKER_REGISTRY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(35, dockerRegistry_);
    }
    if (runtimeUpdatePolicyCase_ == 40) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              40,
              (com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy)
                  runtimeUpdatePolicy_);
    }
    if (runtimeUpdatePolicyCase_ == 41) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              41,
              (com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy)
                  runtimeUpdatePolicy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(buildServiceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(43, buildServiceAccount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.functions.v1.CloudFunction)) {
      return super.equals(obj);
    }
    com.google.cloud.functions.v1.CloudFunction other =
        (com.google.cloud.functions.v1.CloudFunction) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (status_ != other.status_) return false;
    if (!getEntryPoint().equals(other.getEntryPoint())) return false;
    if (!getRuntime().equals(other.getRuntime())) return false;
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (getAvailableMemoryMb() != other.getAvailableMemoryMb()) return false;
    if (!getServiceAccountEmail().equals(other.getServiceAccountEmail())) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (getVersionId() != other.getVersionId()) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!internalGetEnvironmentVariables().equals(other.internalGetEnvironmentVariables()))
      return false;
    if (!internalGetBuildEnvironmentVariables()
        .equals(other.internalGetBuildEnvironmentVariables())) return false;
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (getMaxInstances() != other.getMaxInstances()) return false;
    if (getMinInstances() != other.getMinInstances()) return false;
    if (!getVpcConnector().equals(other.getVpcConnector())) return false;
    if (vpcConnectorEgressSettings_ != other.vpcConnectorEgressSettings_) return false;
    if (ingressSettings_ != other.ingressSettings_) return false;
    if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
    if (!getBuildWorkerPool().equals(other.getBuildWorkerPool())) return false;
    if (!getBuildId().equals(other.getBuildId())) return false;
    if (!getBuildName().equals(other.getBuildName())) return false;
    if (!getSecretEnvironmentVariablesList().equals(other.getSecretEnvironmentVariablesList()))
      return false;
    if (!getSecretVolumesList().equals(other.getSecretVolumesList())) return false;
    if (!getSourceToken().equals(other.getSourceToken())) return false;
    if (!getDockerRepository().equals(other.getDockerRepository())) return false;
    if (dockerRegistry_ != other.dockerRegistry_) return false;
    if (!getBuildServiceAccount().equals(other.getBuildServiceAccount())) return false;
    if (!getSourceCodeCase().equals(other.getSourceCodeCase())) return false;
    switch (sourceCodeCase_) {
      case 3:
        if (!getSourceArchiveUrl().equals(other.getSourceArchiveUrl())) return false;
        break;
      case 4:
        if (!getSourceRepository().equals(other.getSourceRepository())) return false;
        break;
      case 16:
        if (!getSourceUploadUrl().equals(other.getSourceUploadUrl())) return false;
        break;
      case 0:
      default:
    }
    if (!getTriggerCase().equals(other.getTriggerCase())) return false;
    switch (triggerCase_) {
      case 5:
        if (!getHttpsTrigger().equals(other.getHttpsTrigger())) return false;
        break;
      case 6:
        if (!getEventTrigger().equals(other.getEventTrigger())) return false;
        break;
      case 0:
      default:
    }
    if (!getRuntimeUpdatePolicyCase().equals(other.getRuntimeUpdatePolicyCase())) return false;
    switch (runtimeUpdatePolicyCase_) {
      case 40:
        if (!getAutomaticUpdatePolicy().equals(other.getAutomaticUpdatePolicy())) return false;
        break;
      case 41:
        if (!getOnDeployUpdatePolicy().equals(other.getOnDeployUpdatePolicy())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (37 * hash) + ENTRY_POINT_FIELD_NUMBER;
    hash = (53 * hash) + getEntryPoint().hashCode();
    hash = (37 * hash) + RUNTIME_FIELD_NUMBER;
    hash = (53 * hash) + getRuntime().hashCode();
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    hash = (37 * hash) + AVAILABLE_MEMORY_MB_FIELD_NUMBER;
    hash = (53 * hash) + getAvailableMemoryMb();
    hash = (37 * hash) + SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccountEmail().hashCode();
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + VERSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getVersionId());
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (!internalGetEnvironmentVariables().getMap().isEmpty()) {
      hash = (37 * hash) + ENVIRONMENT_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetEnvironmentVariables().hashCode();
    }
    if (!internalGetBuildEnvironmentVariables().getMap().isEmpty()) {
      hash = (37 * hash) + BUILD_ENVIRONMENT_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetBuildEnvironmentVariables().hashCode();
    }
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    hash = (37 * hash) + MAX_INSTANCES_FIELD_NUMBER;
    hash = (53 * hash) + getMaxInstances();
    hash = (37 * hash) + MIN_INSTANCES_FIELD_NUMBER;
    hash = (53 * hash) + getMinInstances();
    hash = (37 * hash) + VPC_CONNECTOR_FIELD_NUMBER;
    hash = (53 * hash) + getVpcConnector().hashCode();
    hash = (37 * hash) + VPC_CONNECTOR_EGRESS_SETTINGS_FIELD_NUMBER;
    hash = (53 * hash) + vpcConnectorEgressSettings_;
    hash = (37 * hash) + INGRESS_SETTINGS_FIELD_NUMBER;
    hash = (53 * hash) + ingressSettings_;
    hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyName().hashCode();
    hash = (37 * hash) + BUILD_WORKER_POOL_FIELD_NUMBER;
    hash = (53 * hash) + getBuildWorkerPool().hashCode();
    hash = (37 * hash) + BUILD_ID_FIELD_NUMBER;
    hash = (53 * hash) + getBuildId().hashCode();
    hash = (37 * hash) + BUILD_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getBuildName().hashCode();
    if (getSecretEnvironmentVariablesCount() > 0) {
      hash = (37 * hash) + SECRET_ENVIRONMENT_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + getSecretEnvironmentVariablesList().hashCode();
    }
    if (getSecretVolumesCount() > 0) {
      hash = (37 * hash) + SECRET_VOLUMES_FIELD_NUMBER;
      hash = (53 * hash) + getSecretVolumesList().hashCode();
    }
    hash = (37 * hash) + SOURCE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getSourceToken().hashCode();
    hash = (37 * hash) + DOCKER_REPOSITORY_FIELD_NUMBER;
    hash = (53 * hash) + getDockerRepository().hashCode();
    hash = (37 * hash) + DOCKER_REGISTRY_FIELD_NUMBER;
    hash = (53 * hash) + dockerRegistry_;
    hash = (37 * hash) + BUILD_SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getBuildServiceAccount().hashCode();
    switch (sourceCodeCase_) {
      case 3:
        hash = (37 * hash) + SOURCE_ARCHIVE_URL_FIELD_NUMBER;
        hash = (53 * hash) + getSourceArchiveUrl().hashCode();
        break;
      case 4:
        hash = (37 * hash) + SOURCE_REPOSITORY_FIELD_NUMBER;
        hash = (53 * hash) + getSourceRepository().hashCode();
        break;
      case 16:
        hash = (37 * hash) + SOURCE_UPLOAD_URL_FIELD_NUMBER;
        hash = (53 * hash) + getSourceUploadUrl().hashCode();
        break;
      case 0:
      default:
    }
    switch (triggerCase_) {
      case 5:
        hash = (37 * hash) + HTTPS_TRIGGER_FIELD_NUMBER;
        hash = (53 * hash) + getHttpsTrigger().hashCode();
        break;
      case 6:
        hash = (37 * hash) + EVENT_TRIGGER_FIELD_NUMBER;
        hash = (53 * hash) + getEventTrigger().hashCode();
        break;
      case 0:
      default:
    }
    switch (runtimeUpdatePolicyCase_) {
      case 40:
        hash = (37 * hash) + AUTOMATIC_UPDATE_POLICY_FIELD_NUMBER;
        hash = (53 * hash) + getAutomaticUpdatePolicy().hashCode();
        break;
      case 41:
        hash = (37 * hash) + ON_DEPLOY_UPDATE_POLICY_FIELD_NUMBER;
        hash = (53 * hash) + getOnDeployUpdatePolicy().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.CloudFunction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.functions.v1.CloudFunction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes a Cloud Function that contains user computation executed in
   * response to an event. It encapsulate function and triggers configurations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v1.CloudFunction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.functions.v1.CloudFunction)
      com.google.cloud.functions.v1.CloudFunctionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_CloudFunction_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 15:
          return internalGetLabels();
        case 17:
          return internalGetEnvironmentVariables();
        case 28:
          return internalGetBuildEnvironmentVariables();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 15:
          return internalGetMutableLabels();
        case 17:
          return internalGetMutableEnvironmentVariables();
        case 28:
          return internalGetMutableBuildEnvironmentVariables();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_CloudFunction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v1.CloudFunction.class,
              com.google.cloud.functions.v1.CloudFunction.Builder.class);
    }

    // Construct using com.google.cloud.functions.v1.CloudFunction.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTimeoutFieldBuilder();
        getUpdateTimeFieldBuilder();
        getSecretEnvironmentVariablesFieldBuilder();
        getSecretVolumesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bitField1_ = 0;
      name_ = "";
      description_ = "";
      if (sourceRepositoryBuilder_ != null) {
        sourceRepositoryBuilder_.clear();
      }
      if (httpsTriggerBuilder_ != null) {
        httpsTriggerBuilder_.clear();
      }
      if (eventTriggerBuilder_ != null) {
        eventTriggerBuilder_.clear();
      }
      status_ = 0;
      entryPoint_ = "";
      runtime_ = "";
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      availableMemoryMb_ = 0;
      serviceAccountEmail_ = "";
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      versionId_ = 0L;
      internalGetMutableLabels().clear();
      internalGetMutableEnvironmentVariables().clear();
      internalGetMutableBuildEnvironmentVariables().clear();
      network_ = "";
      maxInstances_ = 0;
      minInstances_ = 0;
      vpcConnector_ = "";
      vpcConnectorEgressSettings_ = 0;
      ingressSettings_ = 0;
      kmsKeyName_ = "";
      buildWorkerPool_ = "";
      buildId_ = "";
      buildName_ = "";
      if (secretEnvironmentVariablesBuilder_ == null) {
        secretEnvironmentVariables_ = java.util.Collections.emptyList();
      } else {
        secretEnvironmentVariables_ = null;
        secretEnvironmentVariablesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x10000000);
      if (secretVolumesBuilder_ == null) {
        secretVolumes_ = java.util.Collections.emptyList();
      } else {
        secretVolumes_ = null;
        secretVolumesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x20000000);
      sourceToken_ = "";
      dockerRepository_ = "";
      dockerRegistry_ = 0;
      if (automaticUpdatePolicyBuilder_ != null) {
        automaticUpdatePolicyBuilder_.clear();
      }
      if (onDeployUpdatePolicyBuilder_ != null) {
        onDeployUpdatePolicyBuilder_.clear();
      }
      buildServiceAccount_ = "";
      sourceCodeCase_ = 0;
      sourceCode_ = null;
      triggerCase_ = 0;
      trigger_ = null;
      runtimeUpdatePolicyCase_ = 0;
      runtimeUpdatePolicy_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_CloudFunction_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction getDefaultInstanceForType() {
      return com.google.cloud.functions.v1.CloudFunction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction build() {
      com.google.cloud.functions.v1.CloudFunction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction buildPartial() {
      com.google.cloud.functions.v1.CloudFunction result =
          new com.google.cloud.functions.v1.CloudFunction(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      if (bitField1_ != 0) {
        buildPartial1(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.functions.v1.CloudFunction result) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        if (((bitField0_ & 0x10000000) != 0)) {
          secretEnvironmentVariables_ =
              java.util.Collections.unmodifiableList(secretEnvironmentVariables_);
          bitField0_ = (bitField0_ & ~0x10000000);
        }
        result.secretEnvironmentVariables_ = secretEnvironmentVariables_;
      } else {
        result.secretEnvironmentVariables_ = secretEnvironmentVariablesBuilder_.build();
      }
      if (secretVolumesBuilder_ == null) {
        if (((bitField0_ & 0x20000000) != 0)) {
          secretVolumes_ = java.util.Collections.unmodifiableList(secretVolumes_);
          bitField0_ = (bitField0_ & ~0x20000000);
        }
        result.secretVolumes_ = secretVolumes_;
      } else {
        result.secretVolumes_ = secretVolumesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.functions.v1.CloudFunction result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.status_ = status_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.entryPoint_ = entryPoint_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.runtime_ = runtime_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.timeout_ = timeoutBuilder_ == null ? timeout_ : timeoutBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.availableMemoryMb_ = availableMemoryMb_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.serviceAccountEmail_ = serviceAccountEmail_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.versionId_ = versionId_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.environmentVariables_ = internalGetEnvironmentVariables();
        result.environmentVariables_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.buildEnvironmentVariables_ = internalGetBuildEnvironmentVariables();
        result.buildEnvironmentVariables_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.network_ = network_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.maxInstances_ = maxInstances_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.minInstances_ = minInstances_;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.vpcConnector_ = vpcConnector_;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.vpcConnectorEgressSettings_ = vpcConnectorEgressSettings_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.ingressSettings_ = ingressSettings_;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.kmsKeyName_ = kmsKeyName_;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.buildWorkerPool_ = buildWorkerPool_;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.buildId_ = buildId_;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.buildName_ = buildName_;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.sourceToken_ = sourceToken_;
      }
      if (((from_bitField0_ & 0x80000000) != 0)) {
        result.dockerRepository_ = dockerRepository_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartial1(com.google.cloud.functions.v1.CloudFunction result) {
      int from_bitField1_ = bitField1_;
      if (((from_bitField1_ & 0x00000001) != 0)) {
        result.dockerRegistry_ = dockerRegistry_;
      }
      if (((from_bitField1_ & 0x00000008) != 0)) {
        result.buildServiceAccount_ = buildServiceAccount_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.functions.v1.CloudFunction result) {
      result.sourceCodeCase_ = sourceCodeCase_;
      result.sourceCode_ = this.sourceCode_;
      if (sourceCodeCase_ == 4 && sourceRepositoryBuilder_ != null) {
        result.sourceCode_ = sourceRepositoryBuilder_.build();
      }
      result.triggerCase_ = triggerCase_;
      result.trigger_ = this.trigger_;
      if (triggerCase_ == 5 && httpsTriggerBuilder_ != null) {
        result.trigger_ = httpsTriggerBuilder_.build();
      }
      if (triggerCase_ == 6 && eventTriggerBuilder_ != null) {
        result.trigger_ = eventTriggerBuilder_.build();
      }
      result.runtimeUpdatePolicyCase_ = runtimeUpdatePolicyCase_;
      result.runtimeUpdatePolicy_ = this.runtimeUpdatePolicy_;
      if (runtimeUpdatePolicyCase_ == 40 && automaticUpdatePolicyBuilder_ != null) {
        result.runtimeUpdatePolicy_ = automaticUpdatePolicyBuilder_.build();
      }
      if (runtimeUpdatePolicyCase_ == 41 && onDeployUpdatePolicyBuilder_ != null) {
        result.runtimeUpdatePolicy_ = onDeployUpdatePolicyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.functions.v1.CloudFunction) {
        return mergeFrom((com.google.cloud.functions.v1.CloudFunction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.functions.v1.CloudFunction other) {
      if (other == com.google.cloud.functions.v1.CloudFunction.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (!other.getEntryPoint().isEmpty()) {
        entryPoint_ = other.entryPoint_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getRuntime().isEmpty()) {
        runtime_ = other.runtime_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (other.getAvailableMemoryMb() != 0) {
        setAvailableMemoryMb(other.getAvailableMemoryMb());
      }
      if (!other.getServiceAccountEmail().isEmpty()) {
        serviceAccountEmail_ = other.serviceAccountEmail_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.getVersionId() != 0L) {
        setVersionId(other.getVersionId());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00008000;
      internalGetMutableEnvironmentVariables().mergeFrom(other.internalGetEnvironmentVariables());
      bitField0_ |= 0x00010000;
      internalGetMutableBuildEnvironmentVariables()
          .mergeFrom(other.internalGetBuildEnvironmentVariables());
      bitField0_ |= 0x00020000;
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.getMaxInstances() != 0) {
        setMaxInstances(other.getMaxInstances());
      }
      if (other.getMinInstances() != 0) {
        setMinInstances(other.getMinInstances());
      }
      if (!other.getVpcConnector().isEmpty()) {
        vpcConnector_ = other.vpcConnector_;
        bitField0_ |= 0x00200000;
        onChanged();
      }
      if (other.vpcConnectorEgressSettings_ != 0) {
        setVpcConnectorEgressSettingsValue(other.getVpcConnectorEgressSettingsValue());
      }
      if (other.ingressSettings_ != 0) {
        setIngressSettingsValue(other.getIngressSettingsValue());
      }
      if (!other.getKmsKeyName().isEmpty()) {
        kmsKeyName_ = other.kmsKeyName_;
        bitField0_ |= 0x01000000;
        onChanged();
      }
      if (!other.getBuildWorkerPool().isEmpty()) {
        buildWorkerPool_ = other.buildWorkerPool_;
        bitField0_ |= 0x02000000;
        onChanged();
      }
      if (!other.getBuildId().isEmpty()) {
        buildId_ = other.buildId_;
        bitField0_ |= 0x04000000;
        onChanged();
      }
      if (!other.getBuildName().isEmpty()) {
        buildName_ = other.buildName_;
        bitField0_ |= 0x08000000;
        onChanged();
      }
      if (secretEnvironmentVariablesBuilder_ == null) {
        if (!other.secretEnvironmentVariables_.isEmpty()) {
          if (secretEnvironmentVariables_.isEmpty()) {
            secretEnvironmentVariables_ = other.secretEnvironmentVariables_;
            bitField0_ = (bitField0_ & ~0x10000000);
          } else {
            ensureSecretEnvironmentVariablesIsMutable();
            secretEnvironmentVariables_.addAll(other.secretEnvironmentVariables_);
          }
          onChanged();
        }
      } else {
        if (!other.secretEnvironmentVariables_.isEmpty()) {
          if (secretEnvironmentVariablesBuilder_.isEmpty()) {
            secretEnvironmentVariablesBuilder_.dispose();
            secretEnvironmentVariablesBuilder_ = null;
            secretEnvironmentVariables_ = other.secretEnvironmentVariables_;
            bitField0_ = (bitField0_ & ~0x10000000);
            secretEnvironmentVariablesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSecretEnvironmentVariablesFieldBuilder()
                    : null;
          } else {
            secretEnvironmentVariablesBuilder_.addAllMessages(other.secretEnvironmentVariables_);
          }
        }
      }
      if (secretVolumesBuilder_ == null) {
        if (!other.secretVolumes_.isEmpty()) {
          if (secretVolumes_.isEmpty()) {
            secretVolumes_ = other.secretVolumes_;
            bitField0_ = (bitField0_ & ~0x20000000);
          } else {
            ensureSecretVolumesIsMutable();
            secretVolumes_.addAll(other.secretVolumes_);
          }
          onChanged();
        }
      } else {
        if (!other.secretVolumes_.isEmpty()) {
          if (secretVolumesBuilder_.isEmpty()) {
            secretVolumesBuilder_.dispose();
            secretVolumesBuilder_ = null;
            secretVolumes_ = other.secretVolumes_;
            bitField0_ = (bitField0_ & ~0x20000000);
            secretVolumesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSecretVolumesFieldBuilder()
                    : null;
          } else {
            secretVolumesBuilder_.addAllMessages(other.secretVolumes_);
          }
        }
      }
      if (!other.getSourceToken().isEmpty()) {
        sourceToken_ = other.sourceToken_;
        bitField0_ |= 0x40000000;
        onChanged();
      }
      if (!other.getDockerRepository().isEmpty()) {
        dockerRepository_ = other.dockerRepository_;
        bitField0_ |= 0x80000000;
        onChanged();
      }
      if (other.dockerRegistry_ != 0) {
        setDockerRegistryValue(other.getDockerRegistryValue());
      }
      if (!other.getBuildServiceAccount().isEmpty()) {
        buildServiceAccount_ = other.buildServiceAccount_;
        bitField1_ |= 0x00000008;
        onChanged();
      }
      switch (other.getSourceCodeCase()) {
        case SOURCE_ARCHIVE_URL:
          {
            sourceCodeCase_ = 3;
            sourceCode_ = other.sourceCode_;
            onChanged();
            break;
          }
        case SOURCE_REPOSITORY:
          {
            mergeSourceRepository(other.getSourceRepository());
            break;
          }
        case SOURCE_UPLOAD_URL:
          {
            sourceCodeCase_ = 16;
            sourceCode_ = other.sourceCode_;
            onChanged();
            break;
          }
        case SOURCECODE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getTriggerCase()) {
        case HTTPS_TRIGGER:
          {
            mergeHttpsTrigger(other.getHttpsTrigger());
            break;
          }
        case EVENT_TRIGGER:
          {
            mergeEventTrigger(other.getEventTrigger());
            break;
          }
        case TRIGGER_NOT_SET:
          {
            break;
          }
      }
      switch (other.getRuntimeUpdatePolicyCase()) {
        case AUTOMATIC_UPDATE_POLICY:
          {
            mergeAutomaticUpdatePolicy(other.getAutomaticUpdatePolicy());
            break;
          }
        case ON_DEPLOY_UPDATE_POLICY:
          {
            mergeOnDeployUpdatePolicy(other.getOnDeployUpdatePolicy());
            break;
          }
        case RUNTIMEUPDATEPOLICY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                sourceCodeCase_ = 3;
                sourceCode_ = s;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getSourceRepositoryFieldBuilder().getBuilder(), extensionRegistry);
                sourceCodeCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getHttpsTriggerFieldBuilder().getBuilder(), extensionRegistry);
                triggerCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getEventTriggerFieldBuilder().getBuilder(), extensionRegistry);
                triggerCase_ = 6;
                break;
              } // case 50
            case 56:
              {
                status_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 56
            case 66:
              {
                entryPoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 74
            case 80:
              {
                availableMemoryMb_ = input.readInt32();
                bitField0_ |= 0x00000800;
                break;
              } // case 80
            case 90:
              {
                serviceAccountEmail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 98
            case 112:
              {
                versionId_ = input.readInt64();
                bitField0_ |= 0x00004000;
                break;
              } // case 112
            case 122:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00008000;
                break;
              } // case 122
            case 130:
              {
                java.lang.String s = input.readStringRequireUtf8();
                sourceCodeCase_ = 16;
                sourceCode_ = s;
                break;
              } // case 130
            case 138:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    environmentVariables__ =
                        input.readMessage(
                            EnvironmentVariablesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableEnvironmentVariables()
                    .getMutableMap()
                    .put(environmentVariables__.getKey(), environmentVariables__.getValue());
                bitField0_ |= 0x00010000;
                break;
              } // case 138
            case 146:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 146
            case 154:
              {
                runtime_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 154
            case 160:
              {
                maxInstances_ = input.readInt32();
                bitField0_ |= 0x00080000;
                break;
              } // case 160
            case 178:
              {
                vpcConnector_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00200000;
                break;
              } // case 178
            case 184:
              {
                vpcConnectorEgressSettings_ = input.readEnum();
                bitField0_ |= 0x00400000;
                break;
              } // case 184
            case 192:
              {
                ingressSettings_ = input.readEnum();
                bitField0_ |= 0x00800000;
                break;
              } // case 192
            case 202:
              {
                kmsKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x01000000;
                break;
              } // case 202
            case 210:
              {
                buildWorkerPool_ = input.readStringRequireUtf8();
                bitField0_ |= 0x02000000;
                break;
              } // case 210
            case 218:
              {
                buildId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x04000000;
                break;
              } // case 218
            case 226:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    buildEnvironmentVariables__ =
                        input.readMessage(
                            BuildEnvironmentVariablesDefaultEntryHolder.defaultEntry
                                .getParserForType(),
                            extensionRegistry);
                internalGetMutableBuildEnvironmentVariables()
                    .getMutableMap()
                    .put(
                        buildEnvironmentVariables__.getKey(),
                        buildEnvironmentVariables__.getValue());
                bitField0_ |= 0x00020000;
                break;
              } // case 226
            case 234:
              {
                com.google.cloud.functions.v1.SecretEnvVar m =
                    input.readMessage(
                        com.google.cloud.functions.v1.SecretEnvVar.parser(), extensionRegistry);
                if (secretEnvironmentVariablesBuilder_ == null) {
                  ensureSecretEnvironmentVariablesIsMutable();
                  secretEnvironmentVariables_.add(m);
                } else {
                  secretEnvironmentVariablesBuilder_.addMessage(m);
                }
                break;
              } // case 234
            case 242:
              {
                com.google.cloud.functions.v1.SecretVolume m =
                    input.readMessage(
                        com.google.cloud.functions.v1.SecretVolume.parser(), extensionRegistry);
                if (secretVolumesBuilder_ == null) {
                  ensureSecretVolumesIsMutable();
                  secretVolumes_.add(m);
                } else {
                  secretVolumesBuilder_.addMessage(m);
                }
                break;
              } // case 242
            case 250:
              {
                sourceToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x40000000;
                break;
              } // case 250
            case 256:
              {
                minInstances_ = input.readInt32();
                bitField0_ |= 0x00100000;
                break;
              } // case 256
            case 266:
              {
                buildName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x08000000;
                break;
              } // case 266
            case 274:
              {
                dockerRepository_ = input.readStringRequireUtf8();
                bitField0_ |= 0x80000000;
                break;
              } // case 274
            case 280:
              {
                dockerRegistry_ = input.readEnum();
                bitField1_ |= 0x00000001;
                break;
              } // case 280
            case 322:
              {
                input.readMessage(
                    getAutomaticUpdatePolicyFieldBuilder().getBuilder(), extensionRegistry);
                runtimeUpdatePolicyCase_ = 40;
                break;
              } // case 322
            case 330:
              {
                input.readMessage(
                    getOnDeployUpdatePolicyFieldBuilder().getBuilder(), extensionRegistry);
                runtimeUpdatePolicyCase_ = 41;
                break;
              } // case 330
            case 346:
              {
                buildServiceAccount_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000008;
                break;
              } // case 346
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCodeCase_ = 0;
    private java.lang.Object sourceCode_;

    public SourceCodeCase getSourceCodeCase() {
      return SourceCodeCase.forNumber(sourceCodeCase_);
    }

    public Builder clearSourceCode() {
      sourceCodeCase_ = 0;
      sourceCode_ = null;
      onChanged();
      return this;
    }

    private int triggerCase_ = 0;
    private java.lang.Object trigger_;

    public TriggerCase getTriggerCase() {
      return TriggerCase.forNumber(triggerCase_);
    }

    public Builder clearTrigger() {
      triggerCase_ = 0;
      trigger_ = null;
      onChanged();
      return this;
    }

    private int runtimeUpdatePolicyCase_ = 0;
    private java.lang.Object runtimeUpdatePolicy_;

    public RuntimeUpdatePolicyCase getRuntimeUpdatePolicyCase() {
      return RuntimeUpdatePolicyCase.forNumber(runtimeUpdatePolicyCase_);
    }

    public Builder clearRuntimeUpdatePolicy() {
      runtimeUpdatePolicyCase_ = 0;
      runtimeUpdatePolicy_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;
    private int bitField1_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * User-provided description of a function.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-provided description of a function.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-provided description of a function.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided description of a function.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided description of a function.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
     * archive which contains the function.
     * </pre>
     *
     * <code>string source_archive_url = 3;</code>
     *
     * @return Whether the sourceArchiveUrl field is set.
     */
    @java.lang.Override
    public boolean hasSourceArchiveUrl() {
      return sourceCodeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
     * archive which contains the function.
     * </pre>
     *
     * <code>string source_archive_url = 3;</code>
     *
     * @return The sourceArchiveUrl.
     */
    @java.lang.Override
    public java.lang.String getSourceArchiveUrl() {
      java.lang.Object ref = "";
      if (sourceCodeCase_ == 3) {
        ref = sourceCode_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCodeCase_ == 3) {
          sourceCode_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
     * archive which contains the function.
     * </pre>
     *
     * <code>string source_archive_url = 3;</code>
     *
     * @return The bytes for sourceArchiveUrl.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceArchiveUrlBytes() {
      java.lang.Object ref = "";
      if (sourceCodeCase_ == 3) {
        ref = sourceCode_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCodeCase_ == 3) {
          sourceCode_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
     * archive which contains the function.
     * </pre>
     *
     * <code>string source_archive_url = 3;</code>
     *
     * @param value The sourceArchiveUrl to set.
     * @return This builder for chaining.
     */
    public Builder setSourceArchiveUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceCodeCase_ = 3;
      sourceCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
     * archive which contains the function.
     * </pre>
     *
     * <code>string source_archive_url = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceArchiveUrl() {
      if (sourceCodeCase_ == 3) {
        sourceCodeCase_ = 0;
        sourceCode_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
     * archive which contains the function.
     * </pre>
     *
     * <code>string source_archive_url = 3;</code>
     *
     * @param value The bytes for sourceArchiveUrl to set.
     * @return This builder for chaining.
     */
    public Builder setSourceArchiveUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceCodeCase_ = 3;
      sourceCode_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.SourceRepository,
            com.google.cloud.functions.v1.SourceRepository.Builder,
            com.google.cloud.functions.v1.SourceRepositoryOrBuilder>
        sourceRepositoryBuilder_;
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     *
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     *
     * @return Whether the sourceRepository field is set.
     */
    @java.lang.Override
    public boolean hasSourceRepository() {
      return sourceCodeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     *
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     *
     * @return The sourceRepository.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.SourceRepository getSourceRepository() {
      if (sourceRepositoryBuilder_ == null) {
        if (sourceCodeCase_ == 4) {
          return (com.google.cloud.functions.v1.SourceRepository) sourceCode_;
        }
        return com.google.cloud.functions.v1.SourceRepository.getDefaultInstance();
      } else {
        if (sourceCodeCase_ == 4) {
          return sourceRepositoryBuilder_.getMessage();
        }
        return com.google.cloud.functions.v1.SourceRepository.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     *
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     */
    public Builder setSourceRepository(com.google.cloud.functions.v1.SourceRepository value) {
      if (sourceRepositoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceCode_ = value;
        onChanged();
      } else {
        sourceRepositoryBuilder_.setMessage(value);
      }
      sourceCodeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     *
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     */
    public Builder setSourceRepository(
        com.google.cloud.functions.v1.SourceRepository.Builder builderForValue) {
      if (sourceRepositoryBuilder_ == null) {
        sourceCode_ = builderForValue.build();
        onChanged();
      } else {
        sourceRepositoryBuilder_.setMessage(builderForValue.build());
      }
      sourceCodeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     *
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     */
    public Builder mergeSourceRepository(com.google.cloud.functions.v1.SourceRepository value) {
      if (sourceRepositoryBuilder_ == null) {
        if (sourceCodeCase_ == 4
            && sourceCode_ != com.google.cloud.functions.v1.SourceRepository.getDefaultInstance()) {
          sourceCode_ =
              com.google.cloud.functions.v1.SourceRepository.newBuilder(
                      (com.google.cloud.functions.v1.SourceRepository) sourceCode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceCode_ = value;
        }
        onChanged();
      } else {
        if (sourceCodeCase_ == 4) {
          sourceRepositoryBuilder_.mergeFrom(value);
        } else {
          sourceRepositoryBuilder_.setMessage(value);
        }
      }
      sourceCodeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     *
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     */
    public Builder clearSourceRepository() {
      if (sourceRepositoryBuilder_ == null) {
        if (sourceCodeCase_ == 4) {
          sourceCodeCase_ = 0;
          sourceCode_ = null;
          onChanged();
        }
      } else {
        if (sourceCodeCase_ == 4) {
          sourceCodeCase_ = 0;
          sourceCode_ = null;
        }
        sourceRepositoryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     *
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     */
    public com.google.cloud.functions.v1.SourceRepository.Builder getSourceRepositoryBuilder() {
      return getSourceRepositoryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     *
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.SourceRepositoryOrBuilder getSourceRepositoryOrBuilder() {
      if ((sourceCodeCase_ == 4) && (sourceRepositoryBuilder_ != null)) {
        return sourceRepositoryBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCodeCase_ == 4) {
          return (com.google.cloud.functions.v1.SourceRepository) sourceCode_;
        }
        return com.google.cloud.functions.v1.SourceRepository.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * **Beta Feature**
     *
     * The source repository where a function is hosted.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.SourceRepository,
            com.google.cloud.functions.v1.SourceRepository.Builder,
            com.google.cloud.functions.v1.SourceRepositoryOrBuilder>
        getSourceRepositoryFieldBuilder() {
      if (sourceRepositoryBuilder_ == null) {
        if (!(sourceCodeCase_ == 4)) {
          sourceCode_ = com.google.cloud.functions.v1.SourceRepository.getDefaultInstance();
        }
        sourceRepositoryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v1.SourceRepository,
                com.google.cloud.functions.v1.SourceRepository.Builder,
                com.google.cloud.functions.v1.SourceRepositoryOrBuilder>(
                (com.google.cloud.functions.v1.SourceRepository) sourceCode_,
                getParentForChildren(),
                isClean());
        sourceCode_ = null;
      }
      sourceCodeCase_ = 4;
      onChanged();
      return sourceRepositoryBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The Google Cloud Storage signed URL used for source uploading, generated
     * by calling [google.cloud.functions.v1.GenerateUploadUrl].
     *
     * The signature is validated on write methods (Create, Update)
     * The signature is stripped from the Function object on read methods (Get,
     * List)
     * </pre>
     *
     * <code>string source_upload_url = 16;</code>
     *
     * @return Whether the sourceUploadUrl field is set.
     */
    @java.lang.Override
    public boolean hasSourceUploadUrl() {
      return sourceCodeCase_ == 16;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage signed URL used for source uploading, generated
     * by calling [google.cloud.functions.v1.GenerateUploadUrl].
     *
     * The signature is validated on write methods (Create, Update)
     * The signature is stripped from the Function object on read methods (Get,
     * List)
     * </pre>
     *
     * <code>string source_upload_url = 16;</code>
     *
     * @return The sourceUploadUrl.
     */
    @java.lang.Override
    public java.lang.String getSourceUploadUrl() {
      java.lang.Object ref = "";
      if (sourceCodeCase_ == 16) {
        ref = sourceCode_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCodeCase_ == 16) {
          sourceCode_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage signed URL used for source uploading, generated
     * by calling [google.cloud.functions.v1.GenerateUploadUrl].
     *
     * The signature is validated on write methods (Create, Update)
     * The signature is stripped from the Function object on read methods (Get,
     * List)
     * </pre>
     *
     * <code>string source_upload_url = 16;</code>
     *
     * @return The bytes for sourceUploadUrl.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceUploadUrlBytes() {
      java.lang.Object ref = "";
      if (sourceCodeCase_ == 16) {
        ref = sourceCode_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCodeCase_ == 16) {
          sourceCode_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage signed URL used for source uploading, generated
     * by calling [google.cloud.functions.v1.GenerateUploadUrl].
     *
     * The signature is validated on write methods (Create, Update)
     * The signature is stripped from the Function object on read methods (Get,
     * List)
     * </pre>
     *
     * <code>string source_upload_url = 16;</code>
     *
     * @param value The sourceUploadUrl to set.
     * @return This builder for chaining.
     */
    public Builder setSourceUploadUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceCodeCase_ = 16;
      sourceCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage signed URL used for source uploading, generated
     * by calling [google.cloud.functions.v1.GenerateUploadUrl].
     *
     * The signature is validated on write methods (Create, Update)
     * The signature is stripped from the Function object on read methods (Get,
     * List)
     * </pre>
     *
     * <code>string source_upload_url = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceUploadUrl() {
      if (sourceCodeCase_ == 16) {
        sourceCodeCase_ = 0;
        sourceCode_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage signed URL used for source uploading, generated
     * by calling [google.cloud.functions.v1.GenerateUploadUrl].
     *
     * The signature is validated on write methods (Create, Update)
     * The signature is stripped from the Function object on read methods (Get,
     * List)
     * </pre>
     *
     * <code>string source_upload_url = 16;</code>
     *
     * @param value The bytes for sourceUploadUrl to set.
     * @return This builder for chaining.
     */
    public Builder setSourceUploadUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceCodeCase_ = 16;
      sourceCode_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.HttpsTrigger,
            com.google.cloud.functions.v1.HttpsTrigger.Builder,
            com.google.cloud.functions.v1.HttpsTriggerOrBuilder>
        httpsTriggerBuilder_;
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     *
     * @return Whether the httpsTrigger field is set.
     */
    @java.lang.Override
    public boolean hasHttpsTrigger() {
      return triggerCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     *
     * @return The httpsTrigger.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.HttpsTrigger getHttpsTrigger() {
      if (httpsTriggerBuilder_ == null) {
        if (triggerCase_ == 5) {
          return (com.google.cloud.functions.v1.HttpsTrigger) trigger_;
        }
        return com.google.cloud.functions.v1.HttpsTrigger.getDefaultInstance();
      } else {
        if (triggerCase_ == 5) {
          return httpsTriggerBuilder_.getMessage();
        }
        return com.google.cloud.functions.v1.HttpsTrigger.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     */
    public Builder setHttpsTrigger(com.google.cloud.functions.v1.HttpsTrigger value) {
      if (httpsTriggerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trigger_ = value;
        onChanged();
      } else {
        httpsTriggerBuilder_.setMessage(value);
      }
      triggerCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     */
    public Builder setHttpsTrigger(
        com.google.cloud.functions.v1.HttpsTrigger.Builder builderForValue) {
      if (httpsTriggerBuilder_ == null) {
        trigger_ = builderForValue.build();
        onChanged();
      } else {
        httpsTriggerBuilder_.setMessage(builderForValue.build());
      }
      triggerCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     */
    public Builder mergeHttpsTrigger(com.google.cloud.functions.v1.HttpsTrigger value) {
      if (httpsTriggerBuilder_ == null) {
        if (triggerCase_ == 5
            && trigger_ != com.google.cloud.functions.v1.HttpsTrigger.getDefaultInstance()) {
          trigger_ =
              com.google.cloud.functions.v1.HttpsTrigger.newBuilder(
                      (com.google.cloud.functions.v1.HttpsTrigger) trigger_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          trigger_ = value;
        }
        onChanged();
      } else {
        if (triggerCase_ == 5) {
          httpsTriggerBuilder_.mergeFrom(value);
        } else {
          httpsTriggerBuilder_.setMessage(value);
        }
      }
      triggerCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     */
    public Builder clearHttpsTrigger() {
      if (httpsTriggerBuilder_ == null) {
        if (triggerCase_ == 5) {
          triggerCase_ = 0;
          trigger_ = null;
          onChanged();
        }
      } else {
        if (triggerCase_ == 5) {
          triggerCase_ = 0;
          trigger_ = null;
        }
        httpsTriggerBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     */
    public com.google.cloud.functions.v1.HttpsTrigger.Builder getHttpsTriggerBuilder() {
      return getHttpsTriggerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.HttpsTriggerOrBuilder getHttpsTriggerOrBuilder() {
      if ((triggerCase_ == 5) && (httpsTriggerBuilder_ != null)) {
        return httpsTriggerBuilder_.getMessageOrBuilder();
      } else {
        if (triggerCase_ == 5) {
          return (com.google.cloud.functions.v1.HttpsTrigger) trigger_;
        }
        return com.google.cloud.functions.v1.HttpsTrigger.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An HTTPS endpoint type of source that can be triggered via URL.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.HttpsTrigger,
            com.google.cloud.functions.v1.HttpsTrigger.Builder,
            com.google.cloud.functions.v1.HttpsTriggerOrBuilder>
        getHttpsTriggerFieldBuilder() {
      if (httpsTriggerBuilder_ == null) {
        if (!(triggerCase_ == 5)) {
          trigger_ = com.google.cloud.functions.v1.HttpsTrigger.getDefaultInstance();
        }
        httpsTriggerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v1.HttpsTrigger,
                com.google.cloud.functions.v1.HttpsTrigger.Builder,
                com.google.cloud.functions.v1.HttpsTriggerOrBuilder>(
                (com.google.cloud.functions.v1.HttpsTrigger) trigger_,
                getParentForChildren(),
                isClean());
        trigger_ = null;
      }
      triggerCase_ = 5;
      onChanged();
      return httpsTriggerBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.EventTrigger,
            com.google.cloud.functions.v1.EventTrigger.Builder,
            com.google.cloud.functions.v1.EventTriggerOrBuilder>
        eventTriggerBuilder_;
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     *
     * @return Whether the eventTrigger field is set.
     */
    @java.lang.Override
    public boolean hasEventTrigger() {
      return triggerCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     *
     * @return The eventTrigger.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.EventTrigger getEventTrigger() {
      if (eventTriggerBuilder_ == null) {
        if (triggerCase_ == 6) {
          return (com.google.cloud.functions.v1.EventTrigger) trigger_;
        }
        return com.google.cloud.functions.v1.EventTrigger.getDefaultInstance();
      } else {
        if (triggerCase_ == 6) {
          return eventTriggerBuilder_.getMessage();
        }
        return com.google.cloud.functions.v1.EventTrigger.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     */
    public Builder setEventTrigger(com.google.cloud.functions.v1.EventTrigger value) {
      if (eventTriggerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trigger_ = value;
        onChanged();
      } else {
        eventTriggerBuilder_.setMessage(value);
      }
      triggerCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     */
    public Builder setEventTrigger(
        com.google.cloud.functions.v1.EventTrigger.Builder builderForValue) {
      if (eventTriggerBuilder_ == null) {
        trigger_ = builderForValue.build();
        onChanged();
      } else {
        eventTriggerBuilder_.setMessage(builderForValue.build());
      }
      triggerCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     */
    public Builder mergeEventTrigger(com.google.cloud.functions.v1.EventTrigger value) {
      if (eventTriggerBuilder_ == null) {
        if (triggerCase_ == 6
            && trigger_ != com.google.cloud.functions.v1.EventTrigger.getDefaultInstance()) {
          trigger_ =
              com.google.cloud.functions.v1.EventTrigger.newBuilder(
                      (com.google.cloud.functions.v1.EventTrigger) trigger_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          trigger_ = value;
        }
        onChanged();
      } else {
        if (triggerCase_ == 6) {
          eventTriggerBuilder_.mergeFrom(value);
        } else {
          eventTriggerBuilder_.setMessage(value);
        }
      }
      triggerCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     */
    public Builder clearEventTrigger() {
      if (eventTriggerBuilder_ == null) {
        if (triggerCase_ == 6) {
          triggerCase_ = 0;
          trigger_ = null;
          onChanged();
        }
      } else {
        if (triggerCase_ == 6) {
          triggerCase_ = 0;
          trigger_ = null;
        }
        eventTriggerBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     */
    public com.google.cloud.functions.v1.EventTrigger.Builder getEventTriggerBuilder() {
      return getEventTriggerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.EventTriggerOrBuilder getEventTriggerOrBuilder() {
      if ((triggerCase_ == 6) && (eventTriggerBuilder_ != null)) {
        return eventTriggerBuilder_.getMessageOrBuilder();
      } else {
        if (triggerCase_ == 6) {
          return (com.google.cloud.functions.v1.EventTrigger) trigger_;
        }
        return com.google.cloud.functions.v1.EventTrigger.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A source that fires events in response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.EventTrigger,
            com.google.cloud.functions.v1.EventTrigger.Builder,
            com.google.cloud.functions.v1.EventTriggerOrBuilder>
        getEventTriggerFieldBuilder() {
      if (eventTriggerBuilder_ == null) {
        if (!(triggerCase_ == 6)) {
          trigger_ = com.google.cloud.functions.v1.EventTrigger.getDefaultInstance();
        }
        eventTriggerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v1.EventTrigger,
                com.google.cloud.functions.v1.EventTrigger.Builder,
                com.google.cloud.functions.v1.EventTriggerOrBuilder>(
                (com.google.cloud.functions.v1.EventTrigger) trigger_,
                getParentForChildren(),
                isClean());
        trigger_ = null;
      }
      triggerCase_ = 6;
      onChanged();
      return eventTriggerBuilder_;
    }

    private int status_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Status of the function deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override
    public int getStatusValue() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the function deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the function deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunctionStatus getStatus() {
      com.google.cloud.functions.v1.CloudFunctionStatus result =
          com.google.cloud.functions.v1.CloudFunctionStatus.forNumber(status_);
      return result == null
          ? com.google.cloud.functions.v1.CloudFunctionStatus.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the function deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.cloud.functions.v1.CloudFunctionStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the function deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000080);
      status_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object entryPoint_ = "";
    /**
     *
     *
     * <pre>
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix (ID of the function), if not
     * specified.
     * </pre>
     *
     * <code>string entry_point = 8;</code>
     *
     * @return The entryPoint.
     */
    public java.lang.String getEntryPoint() {
      java.lang.Object ref = entryPoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entryPoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix (ID of the function), if not
     * specified.
     * </pre>
     *
     * <code>string entry_point = 8;</code>
     *
     * @return The bytes for entryPoint.
     */
    public com.google.protobuf.ByteString getEntryPointBytes() {
      java.lang.Object ref = entryPoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entryPoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix (ID of the function), if not
     * specified.
     * </pre>
     *
     * <code>string entry_point = 8;</code>
     *
     * @param value The entryPoint to set.
     * @return This builder for chaining.
     */
    public Builder setEntryPoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entryPoint_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix (ID of the function), if not
     * specified.
     * </pre>
     *
     * <code>string entry_point = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntryPoint() {
      entryPoint_ = getDefaultInstance().getEntryPoint();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix (ID of the function), if not
     * specified.
     * </pre>
     *
     * <code>string entry_point = 8;</code>
     *
     * @param value The bytes for entryPoint to set.
     * @return This builder for chaining.
     */
    public Builder setEntryPointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entryPoint_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object runtime_ = "";
    /**
     *
     *
     * <pre>
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     * </pre>
     *
     * <code>string runtime = 19;</code>
     *
     * @return The runtime.
     */
    public java.lang.String getRuntime() {
      java.lang.Object ref = runtime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        runtime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     * </pre>
     *
     * <code>string runtime = 19;</code>
     *
     * @return The bytes for runtime.
     */
    public com.google.protobuf.ByteString getRuntimeBytes() {
      java.lang.Object ref = runtime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        runtime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     * </pre>
     *
     * <code>string runtime = 19;</code>
     *
     * @param value The runtime to set.
     * @return This builder for chaining.
     */
    public Builder setRuntime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      runtime_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     * </pre>
     *
     * <code>string runtime = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRuntime() {
      runtime_ = getDefaultInstance().getRuntime();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     * </pre>
     *
     * <code>string runtime = 19;</code>
     *
     * @param value The bytes for runtime to set.
     * @return This builder for chaining.
     */
    public Builder setRuntimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      runtime_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
      } else {
        timeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && timeout_ != null
            && timeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTimeoutBuilder().mergeFrom(value);
        } else {
          timeout_ = value;
        }
      } else {
        timeoutBuilder_.mergeFrom(value);
      }
      if (timeout_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     */
    public Builder clearTimeout() {
      bitField0_ = (bitField0_ & ~0x00000400);
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private int availableMemoryMb_;
    /**
     *
     *
     * <pre>
     * The amount of memory in MB available for a function.
     * Defaults to 256MB.
     * </pre>
     *
     * <code>int32 available_memory_mb = 10;</code>
     *
     * @return The availableMemoryMb.
     */
    @java.lang.Override
    public int getAvailableMemoryMb() {
      return availableMemoryMb_;
    }
    /**
     *
     *
     * <pre>
     * The amount of memory in MB available for a function.
     * Defaults to 256MB.
     * </pre>
     *
     * <code>int32 available_memory_mb = 10;</code>
     *
     * @param value The availableMemoryMb to set.
     * @return This builder for chaining.
     */
    public Builder setAvailableMemoryMb(int value) {

      availableMemoryMb_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The amount of memory in MB available for a function.
     * Defaults to 256MB.
     * </pre>
     *
     * <code>int32 available_memory_mb = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvailableMemoryMb() {
      bitField0_ = (bitField0_ & ~0x00000800);
      availableMemoryMb_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccountEmail_ = "";
    /**
     *
     *
     * <pre>
     * The email of the function's service account. If empty, defaults to
     * `{project_id}&#64;appspot.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 11;</code>
     *
     * @return The serviceAccountEmail.
     */
    public java.lang.String getServiceAccountEmail() {
      java.lang.Object ref = serviceAccountEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccountEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The email of the function's service account. If empty, defaults to
     * `{project_id}&#64;appspot.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 11;</code>
     *
     * @return The bytes for serviceAccountEmail.
     */
    public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
      java.lang.Object ref = serviceAccountEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccountEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The email of the function's service account. If empty, defaults to
     * `{project_id}&#64;appspot.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 11;</code>
     *
     * @param value The serviceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccountEmail_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The email of the function's service account. If empty, defaults to
     * `{project_id}&#64;appspot.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccountEmail() {
      serviceAccountEmail_ = getDefaultInstance().getServiceAccountEmail();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The email of the function's service account. If empty, defaults to
     * `{project_id}&#64;appspot.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 11;</code>
     *
     * @param value The bytes for serviceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccountEmail_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00002000);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private long versionId_;
    /**
     *
     *
     * <pre>
     * Output only. The version identifier of the Cloud Function. Each deployment
     * attempt results in a new version of a function being created.
     * </pre>
     *
     * <code>int64 version_id = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The versionId.
     */
    @java.lang.Override
    public long getVersionId() {
      return versionId_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version identifier of the Cloud Function. Each deployment
     * attempt results in a new version of a function being created.
     * </pre>
     *
     * <code>int64 version_id = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The versionId to set.
     * @return This builder for chaining.
     */
    public Builder setVersionId(long value) {

      versionId_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version identifier of the Cloud Function. Each deployment
     * attempt results in a new version of a function being created.
     * </pre>
     *
     * <code>int64 version_id = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionId() {
      bitField0_ = (bitField0_ & ~0x00004000);
      versionId_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00008000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00008000;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00008000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00008000;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> environmentVariables_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetEnvironmentVariables() {
      if (environmentVariables_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            EnvironmentVariablesDefaultEntryHolder.defaultEntry);
      }
      return environmentVariables_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableEnvironmentVariables() {
      if (environmentVariables_ == null) {
        environmentVariables_ =
            com.google.protobuf.MapField.newMapField(
                EnvironmentVariablesDefaultEntryHolder.defaultEntry);
      }
      if (!environmentVariables_.isMutable()) {
        environmentVariables_ = environmentVariables_.copy();
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return environmentVariables_;
    }

    public int getEnvironmentVariablesCount() {
      return internalGetEnvironmentVariables().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 17;</code>
     */
    @java.lang.Override
    public boolean containsEnvironmentVariables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetEnvironmentVariables().getMap().containsKey(key);
    }
    /** Use {@link #getEnvironmentVariablesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
      return getEnvironmentVariablesMap();
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 17;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariablesMap() {
      return internalGetEnvironmentVariables().getMap();
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 17;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getEnvironmentVariablesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetEnvironmentVariables().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 17;</code>
     */
    @java.lang.Override
    public java.lang.String getEnvironmentVariablesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetEnvironmentVariables().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearEnvironmentVariables() {
      bitField0_ = (bitField0_ & ~0x00010000);
      internalGetMutableEnvironmentVariables().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 17;</code>
     */
    public Builder removeEnvironmentVariables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableEnvironmentVariables().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableEnvironmentVariables() {
      bitField0_ |= 0x00010000;
      return internalGetMutableEnvironmentVariables().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 17;</code>
     */
    public Builder putEnvironmentVariables(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableEnvironmentVariables().getMutableMap().put(key, value);
      bitField0_ |= 0x00010000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 17;</code>
     */
    public Builder putAllEnvironmentVariables(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableEnvironmentVariables().getMutableMap().putAll(values);
      bitField0_ |= 0x00010000;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        buildEnvironmentVariables_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetBuildEnvironmentVariables() {
      if (buildEnvironmentVariables_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            BuildEnvironmentVariablesDefaultEntryHolder.defaultEntry);
      }
      return buildEnvironmentVariables_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableBuildEnvironmentVariables() {
      if (buildEnvironmentVariables_ == null) {
        buildEnvironmentVariables_ =
            com.google.protobuf.MapField.newMapField(
                BuildEnvironmentVariablesDefaultEntryHolder.defaultEntry);
      }
      if (!buildEnvironmentVariables_.isMutable()) {
        buildEnvironmentVariables_ = buildEnvironmentVariables_.copy();
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return buildEnvironmentVariables_;
    }

    public int getBuildEnvironmentVariablesCount() {
      return internalGetBuildEnvironmentVariables().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Build environment variables that shall be available during build time.
     * </pre>
     *
     * <code>map&lt;string, string&gt; build_environment_variables = 28;</code>
     */
    @java.lang.Override
    public boolean containsBuildEnvironmentVariables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetBuildEnvironmentVariables().getMap().containsKey(key);
    }
    /** Use {@link #getBuildEnvironmentVariablesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getBuildEnvironmentVariables() {
      return getBuildEnvironmentVariablesMap();
    }
    /**
     *
     *
     * <pre>
     * Build environment variables that shall be available during build time.
     * </pre>
     *
     * <code>map&lt;string, string&gt; build_environment_variables = 28;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getBuildEnvironmentVariablesMap() {
      return internalGetBuildEnvironmentVariables().getMap();
    }
    /**
     *
     *
     * <pre>
     * Build environment variables that shall be available during build time.
     * </pre>
     *
     * <code>map&lt;string, string&gt; build_environment_variables = 28;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getBuildEnvironmentVariablesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetBuildEnvironmentVariables().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Build environment variables that shall be available during build time.
     * </pre>
     *
     * <code>map&lt;string, string&gt; build_environment_variables = 28;</code>
     */
    @java.lang.Override
    public java.lang.String getBuildEnvironmentVariablesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetBuildEnvironmentVariables().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearBuildEnvironmentVariables() {
      bitField0_ = (bitField0_ & ~0x00020000);
      internalGetMutableBuildEnvironmentVariables().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Build environment variables that shall be available during build time.
     * </pre>
     *
     * <code>map&lt;string, string&gt; build_environment_variables = 28;</code>
     */
    public Builder removeBuildEnvironmentVariables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableBuildEnvironmentVariables().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableBuildEnvironmentVariables() {
      bitField0_ |= 0x00020000;
      return internalGetMutableBuildEnvironmentVariables().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Build environment variables that shall be available during build time.
     * </pre>
     *
     * <code>map&lt;string, string&gt; build_environment_variables = 28;</code>
     */
    public Builder putBuildEnvironmentVariables(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableBuildEnvironmentVariables().getMutableMap().put(key, value);
      bitField0_ |= 0x00020000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Build environment variables that shall be available during build time.
     * </pre>
     *
     * <code>map&lt;string, string&gt; build_environment_variables = 28;</code>
     */
    public Builder putAllBuildEnvironmentVariables(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableBuildEnvironmentVariables().getMutableMap().putAll(values);
      bitField0_ |= 0x00020000;
      return this;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated: use vpc_connector
     * </pre>
     *
     * <code>string network = 18 [deprecated = true];</code>
     *
     * @deprecated google.cloud.functions.v1.CloudFunction.network is deprecated. See
     *     google/cloud/functions/v1/functions.proto;l=355
     * @return The network.
     */
    @java.lang.Deprecated
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: use vpc_connector
     * </pre>
     *
     * <code>string network = 18 [deprecated = true];</code>
     *
     * @deprecated google.cloud.functions.v1.CloudFunction.network is deprecated. See
     *     google/cloud/functions/v1/functions.proto;l=355
     * @return The bytes for network.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: use vpc_connector
     * </pre>
     *
     * <code>string network = 18 [deprecated = true];</code>
     *
     * @deprecated google.cloud.functions.v1.CloudFunction.network is deprecated. See
     *     google/cloud/functions/v1/functions.proto;l=355
     * @param value The network to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: use vpc_connector
     * </pre>
     *
     * <code>string network = 18 [deprecated = true];</code>
     *
     * @deprecated google.cloud.functions.v1.CloudFunction.network is deprecated. See
     *     google/cloud/functions/v1/functions.proto;l=355
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: use vpc_connector
     * </pre>
     *
     * <code>string network = 18 [deprecated = true];</code>
     *
     * @deprecated google.cloud.functions.v1.CloudFunction.network is deprecated. See
     *     google/cloud/functions/v1/functions.proto;l=355
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private int maxInstances_;
    /**
     *
     *
     * <pre>
     * The limit on the maximum number of function instances that may coexist at a
     * given time.
     *
     * In some cases, such as rapid traffic surges, Cloud Functions may, for a
     * short period of time, create more instances than the specified max
     * instances limit. If your function cannot tolerate this temporary behavior,
     * you may want to factor in a safety margin and set a lower max instances
     * value than your function can tolerate.
     *
     * See the [Max
     * Instances](https://cloud.google.com/functions/docs/max-instances) Guide for
     * more details.
     * </pre>
     *
     * <code>int32 max_instances = 20;</code>
     *
     * @return The maxInstances.
     */
    @java.lang.Override
    public int getMaxInstances() {
      return maxInstances_;
    }
    /**
     *
     *
     * <pre>
     * The limit on the maximum number of function instances that may coexist at a
     * given time.
     *
     * In some cases, such as rapid traffic surges, Cloud Functions may, for a
     * short period of time, create more instances than the specified max
     * instances limit. If your function cannot tolerate this temporary behavior,
     * you may want to factor in a safety margin and set a lower max instances
     * value than your function can tolerate.
     *
     * See the [Max
     * Instances](https://cloud.google.com/functions/docs/max-instances) Guide for
     * more details.
     * </pre>
     *
     * <code>int32 max_instances = 20;</code>
     *
     * @param value The maxInstances to set.
     * @return This builder for chaining.
     */
    public Builder setMaxInstances(int value) {

      maxInstances_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The limit on the maximum number of function instances that may coexist at a
     * given time.
     *
     * In some cases, such as rapid traffic surges, Cloud Functions may, for a
     * short period of time, create more instances than the specified max
     * instances limit. If your function cannot tolerate this temporary behavior,
     * you may want to factor in a safety margin and set a lower max instances
     * value than your function can tolerate.
     *
     * See the [Max
     * Instances](https://cloud.google.com/functions/docs/max-instances) Guide for
     * more details.
     * </pre>
     *
     * <code>int32 max_instances = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxInstances() {
      bitField0_ = (bitField0_ & ~0x00080000);
      maxInstances_ = 0;
      onChanged();
      return this;
    }

    private int minInstances_;
    /**
     *
     *
     * <pre>
     * A lower bound for the number function instances that may coexist at a
     * given time.
     * </pre>
     *
     * <code>int32 min_instances = 32;</code>
     *
     * @return The minInstances.
     */
    @java.lang.Override
    public int getMinInstances() {
      return minInstances_;
    }
    /**
     *
     *
     * <pre>
     * A lower bound for the number function instances that may coexist at a
     * given time.
     * </pre>
     *
     * <code>int32 min_instances = 32;</code>
     *
     * @param value The minInstances to set.
     * @return This builder for chaining.
     */
    public Builder setMinInstances(int value) {

      minInstances_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A lower bound for the number function instances that may coexist at a
     * given time.
     * </pre>
     *
     * <code>int32 min_instances = 32;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinInstances() {
      bitField0_ = (bitField0_ & ~0x00100000);
      minInstances_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object vpcConnector_ = "";
    /**
     *
     *
     * <pre>
     * The VPC Network Connector that this cloud function can connect to. It can
     * be either the fully-qualified URI, or the short name of the network
     * connector resource. The format of this field is
     * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
     *
     * This field is mutually exclusive with `network` field and will eventually
     * replace it.
     *
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     * </pre>
     *
     * <code>string vpc_connector = 22;</code>
     *
     * @return The vpcConnector.
     */
    public java.lang.String getVpcConnector() {
      java.lang.Object ref = vpcConnector_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vpcConnector_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The VPC Network Connector that this cloud function can connect to. It can
     * be either the fully-qualified URI, or the short name of the network
     * connector resource. The format of this field is
     * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
     *
     * This field is mutually exclusive with `network` field and will eventually
     * replace it.
     *
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     * </pre>
     *
     * <code>string vpc_connector = 22;</code>
     *
     * @return The bytes for vpcConnector.
     */
    public com.google.protobuf.ByteString getVpcConnectorBytes() {
      java.lang.Object ref = vpcConnector_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vpcConnector_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The VPC Network Connector that this cloud function can connect to. It can
     * be either the fully-qualified URI, or the short name of the network
     * connector resource. The format of this field is
     * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
     *
     * This field is mutually exclusive with `network` field and will eventually
     * replace it.
     *
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     * </pre>
     *
     * <code>string vpc_connector = 22;</code>
     *
     * @param value The vpcConnector to set.
     * @return This builder for chaining.
     */
    public Builder setVpcConnector(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      vpcConnector_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The VPC Network Connector that this cloud function can connect to. It can
     * be either the fully-qualified URI, or the short name of the network
     * connector resource. The format of this field is
     * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
     *
     * This field is mutually exclusive with `network` field and will eventually
     * replace it.
     *
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     * </pre>
     *
     * <code>string vpc_connector = 22;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVpcConnector() {
      vpcConnector_ = getDefaultInstance().getVpcConnector();
      bitField0_ = (bitField0_ & ~0x00200000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The VPC Network Connector that this cloud function can connect to. It can
     * be either the fully-qualified URI, or the short name of the network
     * connector resource. The format of this field is
     * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
     *
     * This field is mutually exclusive with `network` field and will eventually
     * replace it.
     *
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     * </pre>
     *
     * <code>string vpc_connector = 22;</code>
     *
     * @param value The bytes for vpcConnector to set.
     * @return This builder for chaining.
     */
    public Builder setVpcConnectorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      vpcConnector_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    private int vpcConnectorEgressSettings_ = 0;
    /**
     *
     *
     * <pre>
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;
     * </code>
     *
     * @return The enum numeric value on the wire for vpcConnectorEgressSettings.
     */
    @java.lang.Override
    public int getVpcConnectorEgressSettingsValue() {
      return vpcConnectorEgressSettings_;
    }
    /**
     *
     *
     * <pre>
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;
     * </code>
     *
     * @param value The enum numeric value on the wire for vpcConnectorEgressSettings to set.
     * @return This builder for chaining.
     */
    public Builder setVpcConnectorEgressSettingsValue(int value) {
      vpcConnectorEgressSettings_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;
     * </code>
     *
     * @return The vpcConnectorEgressSettings.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings
        getVpcConnectorEgressSettings() {
      com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings result =
          com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings.forNumber(
              vpcConnectorEgressSettings_);
      return result == null
          ? com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;
     * </code>
     *
     * @param value The vpcConnectorEgressSettings to set.
     * @return This builder for chaining.
     */
    public Builder setVpcConnectorEgressSettings(
        com.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00400000;
      vpcConnectorEgressSettings_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVpcConnectorEgressSettings() {
      bitField0_ = (bitField0_ & ~0x00400000);
      vpcConnectorEgressSettings_ = 0;
      onChanged();
      return this;
    }

    private int ingressSettings_ = 0;
    /**
     *
     *
     * <pre>
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
     *
     * @return The enum numeric value on the wire for ingressSettings.
     */
    @java.lang.Override
    public int getIngressSettingsValue() {
      return ingressSettings_;
    }
    /**
     *
     *
     * <pre>
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
     *
     * @param value The enum numeric value on the wire for ingressSettings to set.
     * @return This builder for chaining.
     */
    public Builder setIngressSettingsValue(int value) {
      ingressSettings_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
     *
     * @return The ingressSettings.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction.IngressSettings getIngressSettings() {
      com.google.cloud.functions.v1.CloudFunction.IngressSettings result =
          com.google.cloud.functions.v1.CloudFunction.IngressSettings.forNumber(ingressSettings_);
      return result == null
          ? com.google.cloud.functions.v1.CloudFunction.IngressSettings.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
     *
     * @param value The ingressSettings to set.
     * @return This builder for chaining.
     */
    public Builder setIngressSettings(
        com.google.cloud.functions.v1.CloudFunction.IngressSettings value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00800000;
      ingressSettings_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIngressSettings() {
      bitField0_ = (bitField0_ & ~0x00800000);
      ingressSettings_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKeyName_ = "";
    /**
     *
     *
     * <pre>
     * Resource name of a KMS crypto key (managed by the user) used to
     * encrypt/decrypt function resources.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     *
     * If specified, you must also provide an artifact registry repository using
     * the `docker_repository` field that was created with the same KMS crypto
     * key.
     *
     * The following service accounts need to be granted the role 'Cloud KMS
     * CryptoKey Encrypter/Decrypter (roles/cloudkms.cryptoKeyEncrypterDecrypter)'
     * on the Key/KeyRing/Project/Organization (least access preferred).
     *
     * 1. Google Cloud Functions service account
     *    (service-{project_number}&#64;gcf-admin-robot.iam.gserviceaccount.com) -
     *    Required to protect the function's image.
     * 2. Google Storage service account
     *    (service-{project_number}&#64;gs-project-accounts.iam.gserviceaccount.com) -
     *    Required to protect the function's source code.
     *    If this service account does not exist, deploying a function without a
     *    KMS key or retrieving the service agent name provisions it. For more
     *    information, see
     *    https://cloud.google.com/storage/docs/projects#service-agents and
     *    https://cloud.google.com/storage/docs/getting-service-agent#gsutil.
     *
     * Google Cloud Functions delegates access to service agents to protect
     * function resources in internal projects that are not accessible by the
     * end user.
     * </pre>
     *
     * <code>string kms_key_name = 25 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The kmsKeyName.
     */
    public java.lang.String getKmsKeyName() {
      java.lang.Object ref = kmsKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of a KMS crypto key (managed by the user) used to
     * encrypt/decrypt function resources.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     *
     * If specified, you must also provide an artifact registry repository using
     * the `docker_repository` field that was created with the same KMS crypto
     * key.
     *
     * The following service accounts need to be granted the role 'Cloud KMS
     * CryptoKey Encrypter/Decrypter (roles/cloudkms.cryptoKeyEncrypterDecrypter)'
     * on the Key/KeyRing/Project/Organization (least access preferred).
     *
     * 1. Google Cloud Functions service account
     *    (service-{project_number}&#64;gcf-admin-robot.iam.gserviceaccount.com) -
     *    Required to protect the function's image.
     * 2. Google Storage service account
     *    (service-{project_number}&#64;gs-project-accounts.iam.gserviceaccount.com) -
     *    Required to protect the function's source code.
     *    If this service account does not exist, deploying a function without a
     *    KMS key or retrieving the service agent name provisions it. For more
     *    information, see
     *    https://cloud.google.com/storage/docs/projects#service-agents and
     *    https://cloud.google.com/storage/docs/getting-service-agent#gsutil.
     *
     * Google Cloud Functions delegates access to service agents to protect
     * function resources in internal projects that are not accessible by the
     * end user.
     * </pre>
     *
     * <code>string kms_key_name = 25 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for kmsKeyName.
     */
    public com.google.protobuf.ByteString getKmsKeyNameBytes() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of a KMS crypto key (managed by the user) used to
     * encrypt/decrypt function resources.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     *
     * If specified, you must also provide an artifact registry repository using
     * the `docker_repository` field that was created with the same KMS crypto
     * key.
     *
     * The following service accounts need to be granted the role 'Cloud KMS
     * CryptoKey Encrypter/Decrypter (roles/cloudkms.cryptoKeyEncrypterDecrypter)'
     * on the Key/KeyRing/Project/Organization (least access preferred).
     *
     * 1. Google Cloud Functions service account
     *    (service-{project_number}&#64;gcf-admin-robot.iam.gserviceaccount.com) -
     *    Required to protect the function's image.
     * 2. Google Storage service account
     *    (service-{project_number}&#64;gs-project-accounts.iam.gserviceaccount.com) -
     *    Required to protect the function's source code.
     *    If this service account does not exist, deploying a function without a
     *    KMS key or retrieving the service agent name provisions it. For more
     *    information, see
     *    https://cloud.google.com/storage/docs/projects#service-agents and
     *    https://cloud.google.com/storage/docs/getting-service-agent#gsutil.
     *
     * Google Cloud Functions delegates access to service agents to protect
     * function resources in internal projects that are not accessible by the
     * end user.
     * </pre>
     *
     * <code>string kms_key_name = 25 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyName_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of a KMS crypto key (managed by the user) used to
     * encrypt/decrypt function resources.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     *
     * If specified, you must also provide an artifact registry repository using
     * the `docker_repository` field that was created with the same KMS crypto
     * key.
     *
     * The following service accounts need to be granted the role 'Cloud KMS
     * CryptoKey Encrypter/Decrypter (roles/cloudkms.cryptoKeyEncrypterDecrypter)'
     * on the Key/KeyRing/Project/Organization (least access preferred).
     *
     * 1. Google Cloud Functions service account
     *    (service-{project_number}&#64;gcf-admin-robot.iam.gserviceaccount.com) -
     *    Required to protect the function's image.
     * 2. Google Storage service account
     *    (service-{project_number}&#64;gs-project-accounts.iam.gserviceaccount.com) -
     *    Required to protect the function's source code.
     *    If this service account does not exist, deploying a function without a
     *    KMS key or retrieving the service agent name provisions it. For more
     *    information, see
     *    https://cloud.google.com/storage/docs/projects#service-agents and
     *    https://cloud.google.com/storage/docs/getting-service-agent#gsutil.
     *
     * Google Cloud Functions delegates access to service agents to protect
     * function resources in internal projects that are not accessible by the
     * end user.
     * </pre>
     *
     * <code>string kms_key_name = 25 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyName() {
      kmsKeyName_ = getDefaultInstance().getKmsKeyName();
      bitField0_ = (bitField0_ & ~0x01000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of a KMS crypto key (managed by the user) used to
     * encrypt/decrypt function resources.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     *
     * If specified, you must also provide an artifact registry repository using
     * the `docker_repository` field that was created with the same KMS crypto
     * key.
     *
     * The following service accounts need to be granted the role 'Cloud KMS
     * CryptoKey Encrypter/Decrypter (roles/cloudkms.cryptoKeyEncrypterDecrypter)'
     * on the Key/KeyRing/Project/Organization (least access preferred).
     *
     * 1. Google Cloud Functions service account
     *    (service-{project_number}&#64;gcf-admin-robot.iam.gserviceaccount.com) -
     *    Required to protect the function's image.
     * 2. Google Storage service account
     *    (service-{project_number}&#64;gs-project-accounts.iam.gserviceaccount.com) -
     *    Required to protect the function's source code.
     *    If this service account does not exist, deploying a function without a
     *    KMS key or retrieving the service agent name provisions it. For more
     *    information, see
     *    https://cloud.google.com/storage/docs/projects#service-agents and
     *    https://cloud.google.com/storage/docs/getting-service-agent#gsutil.
     *
     * Google Cloud Functions delegates access to service agents to protect
     * function resources in internal projects that are not accessible by the
     * end user.
     * </pre>
     *
     * <code>string kms_key_name = 25 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyName_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }

    private java.lang.Object buildWorkerPool_ = "";
    /**
     *
     *
     * <pre>
     * Name of the Cloud Build Custom Worker Pool that should be used to build the
     * function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     *
     * If the project id is not the same as the function, then the Cloud
     * Functions Service Agent
     * (`service-&lt;project_number&gt;&#64;gcf-admin-robot.iam.gserviceaccount.com`) must
     * be granted the role Cloud Build Custom Workers Builder
     * (`roles/cloudbuild.customworkers.builder`) in the project.
     * </pre>
     *
     * <code>string build_worker_pool = 26;</code>
     *
     * @return The buildWorkerPool.
     */
    public java.lang.String getBuildWorkerPool() {
      java.lang.Object ref = buildWorkerPool_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        buildWorkerPool_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the Cloud Build Custom Worker Pool that should be used to build the
     * function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     *
     * If the project id is not the same as the function, then the Cloud
     * Functions Service Agent
     * (`service-&lt;project_number&gt;&#64;gcf-admin-robot.iam.gserviceaccount.com`) must
     * be granted the role Cloud Build Custom Workers Builder
     * (`roles/cloudbuild.customworkers.builder`) in the project.
     * </pre>
     *
     * <code>string build_worker_pool = 26;</code>
     *
     * @return The bytes for buildWorkerPool.
     */
    public com.google.protobuf.ByteString getBuildWorkerPoolBytes() {
      java.lang.Object ref = buildWorkerPool_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        buildWorkerPool_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the Cloud Build Custom Worker Pool that should be used to build the
     * function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     *
     * If the project id is not the same as the function, then the Cloud
     * Functions Service Agent
     * (`service-&lt;project_number&gt;&#64;gcf-admin-robot.iam.gserviceaccount.com`) must
     * be granted the role Cloud Build Custom Workers Builder
     * (`roles/cloudbuild.customworkers.builder`) in the project.
     * </pre>
     *
     * <code>string build_worker_pool = 26;</code>
     *
     * @param value The buildWorkerPool to set.
     * @return This builder for chaining.
     */
    public Builder setBuildWorkerPool(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      buildWorkerPool_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the Cloud Build Custom Worker Pool that should be used to build the
     * function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     *
     * If the project id is not the same as the function, then the Cloud
     * Functions Service Agent
     * (`service-&lt;project_number&gt;&#64;gcf-admin-robot.iam.gserviceaccount.com`) must
     * be granted the role Cloud Build Custom Workers Builder
     * (`roles/cloudbuild.customworkers.builder`) in the project.
     * </pre>
     *
     * <code>string build_worker_pool = 26;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuildWorkerPool() {
      buildWorkerPool_ = getDefaultInstance().getBuildWorkerPool();
      bitField0_ = (bitField0_ & ~0x02000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the Cloud Build Custom Worker Pool that should be used to build the
     * function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     *
     * If the project id is not the same as the function, then the Cloud
     * Functions Service Agent
     * (`service-&lt;project_number&gt;&#64;gcf-admin-robot.iam.gserviceaccount.com`) must
     * be granted the role Cloud Build Custom Workers Builder
     * (`roles/cloudbuild.customworkers.builder`) in the project.
     * </pre>
     *
     * <code>string build_worker_pool = 26;</code>
     *
     * @param value The bytes for buildWorkerPool to set.
     * @return This builder for chaining.
     */
    public Builder setBuildWorkerPoolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      buildWorkerPool_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    private java.lang.Object buildId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build ID of the latest successful deployment of the
     * function.
     * </pre>
     *
     * <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The buildId.
     */
    public java.lang.String getBuildId() {
      java.lang.Object ref = buildId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        buildId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build ID of the latest successful deployment of the
     * function.
     * </pre>
     *
     * <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for buildId.
     */
    public com.google.protobuf.ByteString getBuildIdBytes() {
      java.lang.Object ref = buildId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        buildId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build ID of the latest successful deployment of the
     * function.
     * </pre>
     *
     * <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The buildId to set.
     * @return This builder for chaining.
     */
    public Builder setBuildId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      buildId_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build ID of the latest successful deployment of the
     * function.
     * </pre>
     *
     * <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuildId() {
      buildId_ = getDefaultInstance().getBuildId();
      bitField0_ = (bitField0_ & ~0x04000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build ID of the latest successful deployment of the
     * function.
     * </pre>
     *
     * <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for buildId to set.
     * @return This builder for chaining.
     */
    public Builder setBuildIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      buildId_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }

    private java.lang.Object buildName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build Name of the function deployment.
     * `projects/&lt;project-number&gt;/locations/&lt;region&gt;/builds/&lt;build-id&gt;`.
     * </pre>
     *
     * <code>string build_name = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The buildName.
     */
    public java.lang.String getBuildName() {
      java.lang.Object ref = buildName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        buildName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build Name of the function deployment.
     * `projects/&lt;project-number&gt;/locations/&lt;region&gt;/builds/&lt;build-id&gt;`.
     * </pre>
     *
     * <code>string build_name = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for buildName.
     */
    public com.google.protobuf.ByteString getBuildNameBytes() {
      java.lang.Object ref = buildName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        buildName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build Name of the function deployment.
     * `projects/&lt;project-number&gt;/locations/&lt;region&gt;/builds/&lt;build-id&gt;`.
     * </pre>
     *
     * <code>string build_name = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The buildName to set.
     * @return This builder for chaining.
     */
    public Builder setBuildName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      buildName_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build Name of the function deployment.
     * `projects/&lt;project-number&gt;/locations/&lt;region&gt;/builds/&lt;build-id&gt;`.
     * </pre>
     *
     * <code>string build_name = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuildName() {
      buildName_ = getDefaultInstance().getBuildName();
      bitField0_ = (bitField0_ & ~0x08000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build Name of the function deployment.
     * `projects/&lt;project-number&gt;/locations/&lt;region&gt;/builds/&lt;build-id&gt;`.
     * </pre>
     *
     * <code>string build_name = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for buildName to set.
     * @return This builder for chaining.
     */
    public Builder setBuildNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      buildName_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.functions.v1.SecretEnvVar> secretEnvironmentVariables_ =
        java.util.Collections.emptyList();

    private void ensureSecretEnvironmentVariablesIsMutable() {
      if (!((bitField0_ & 0x10000000) != 0)) {
        secretEnvironmentVariables_ =
            new java.util.ArrayList<com.google.cloud.functions.v1.SecretEnvVar>(
                secretEnvironmentVariables_);
        bitField0_ |= 0x10000000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v1.SecretEnvVar,
            com.google.cloud.functions.v1.SecretEnvVar.Builder,
            com.google.cloud.functions.v1.SecretEnvVarOrBuilder>
        secretEnvironmentVariablesBuilder_;

    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public java.util.List<com.google.cloud.functions.v1.SecretEnvVar>
        getSecretEnvironmentVariablesList() {
      if (secretEnvironmentVariablesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(secretEnvironmentVariables_);
      } else {
        return secretEnvironmentVariablesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public int getSecretEnvironmentVariablesCount() {
      if (secretEnvironmentVariablesBuilder_ == null) {
        return secretEnvironmentVariables_.size();
      } else {
        return secretEnvironmentVariablesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public com.google.cloud.functions.v1.SecretEnvVar getSecretEnvironmentVariables(int index) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        return secretEnvironmentVariables_.get(index);
      } else {
        return secretEnvironmentVariablesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public Builder setSecretEnvironmentVariables(
        int index, com.google.cloud.functions.v1.SecretEnvVar value) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretEnvironmentVariablesIsMutable();
        secretEnvironmentVariables_.set(index, value);
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public Builder setSecretEnvironmentVariables(
        int index, com.google.cloud.functions.v1.SecretEnvVar.Builder builderForValue) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        ensureSecretEnvironmentVariablesIsMutable();
        secretEnvironmentVariables_.set(index, builderForValue.build());
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public Builder addSecretEnvironmentVariables(com.google.cloud.functions.v1.SecretEnvVar value) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretEnvironmentVariablesIsMutable();
        secretEnvironmentVariables_.add(value);
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public Builder addSecretEnvironmentVariables(
        int index, com.google.cloud.functions.v1.SecretEnvVar value) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretEnvironmentVariablesIsMutable();
        secretEnvironmentVariables_.add(index, value);
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public Builder addSecretEnvironmentVariables(
        com.google.cloud.functions.v1.SecretEnvVar.Builder builderForValue) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        ensureSecretEnvironmentVariablesIsMutable();
        secretEnvironmentVariables_.add(builderForValue.build());
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public Builder addSecretEnvironmentVariables(
        int index, com.google.cloud.functions.v1.SecretEnvVar.Builder builderForValue) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        ensureSecretEnvironmentVariablesIsMutable();
        secretEnvironmentVariables_.add(index, builderForValue.build());
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public Builder addAllSecretEnvironmentVariables(
        java.lang.Iterable<? extends com.google.cloud.functions.v1.SecretEnvVar> values) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        ensureSecretEnvironmentVariablesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, secretEnvironmentVariables_);
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public Builder clearSecretEnvironmentVariables() {
      if (secretEnvironmentVariablesBuilder_ == null) {
        secretEnvironmentVariables_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x10000000);
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public Builder removeSecretEnvironmentVariables(int index) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        ensureSecretEnvironmentVariablesIsMutable();
        secretEnvironmentVariables_.remove(index);
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public com.google.cloud.functions.v1.SecretEnvVar.Builder getSecretEnvironmentVariablesBuilder(
        int index) {
      return getSecretEnvironmentVariablesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public com.google.cloud.functions.v1.SecretEnvVarOrBuilder
        getSecretEnvironmentVariablesOrBuilder(int index) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        return secretEnvironmentVariables_.get(index);
      } else {
        return secretEnvironmentVariablesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.functions.v1.SecretEnvVarOrBuilder>
        getSecretEnvironmentVariablesOrBuilderList() {
      if (secretEnvironmentVariablesBuilder_ != null) {
        return secretEnvironmentVariablesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(secretEnvironmentVariables_);
      }
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public com.google.cloud.functions.v1.SecretEnvVar.Builder
        addSecretEnvironmentVariablesBuilder() {
      return getSecretEnvironmentVariablesFieldBuilder()
          .addBuilder(com.google.cloud.functions.v1.SecretEnvVar.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public com.google.cloud.functions.v1.SecretEnvVar.Builder addSecretEnvironmentVariablesBuilder(
        int index) {
      return getSecretEnvironmentVariablesFieldBuilder()
          .addBuilder(index, com.google.cloud.functions.v1.SecretEnvVar.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;
     * </code>
     */
    public java.util.List<com.google.cloud.functions.v1.SecretEnvVar.Builder>
        getSecretEnvironmentVariablesBuilderList() {
      return getSecretEnvironmentVariablesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v1.SecretEnvVar,
            com.google.cloud.functions.v1.SecretEnvVar.Builder,
            com.google.cloud.functions.v1.SecretEnvVarOrBuilder>
        getSecretEnvironmentVariablesFieldBuilder() {
      if (secretEnvironmentVariablesBuilder_ == null) {
        secretEnvironmentVariablesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.functions.v1.SecretEnvVar,
                com.google.cloud.functions.v1.SecretEnvVar.Builder,
                com.google.cloud.functions.v1.SecretEnvVarOrBuilder>(
                secretEnvironmentVariables_,
                ((bitField0_ & 0x10000000) != 0),
                getParentForChildren(),
                isClean());
        secretEnvironmentVariables_ = null;
      }
      return secretEnvironmentVariablesBuilder_;
    }

    private java.util.List<com.google.cloud.functions.v1.SecretVolume> secretVolumes_ =
        java.util.Collections.emptyList();

    private void ensureSecretVolumesIsMutable() {
      if (!((bitField0_ & 0x20000000) != 0)) {
        secretVolumes_ =
            new java.util.ArrayList<com.google.cloud.functions.v1.SecretVolume>(secretVolumes_);
        bitField0_ |= 0x20000000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v1.SecretVolume,
            com.google.cloud.functions.v1.SecretVolume.Builder,
            com.google.cloud.functions.v1.SecretVolumeOrBuilder>
        secretVolumesBuilder_;

    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public java.util.List<com.google.cloud.functions.v1.SecretVolume> getSecretVolumesList() {
      if (secretVolumesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(secretVolumes_);
      } else {
        return secretVolumesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public int getSecretVolumesCount() {
      if (secretVolumesBuilder_ == null) {
        return secretVolumes_.size();
      } else {
        return secretVolumesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public com.google.cloud.functions.v1.SecretVolume getSecretVolumes(int index) {
      if (secretVolumesBuilder_ == null) {
        return secretVolumes_.get(index);
      } else {
        return secretVolumesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public Builder setSecretVolumes(int index, com.google.cloud.functions.v1.SecretVolume value) {
      if (secretVolumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretVolumesIsMutable();
        secretVolumes_.set(index, value);
        onChanged();
      } else {
        secretVolumesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public Builder setSecretVolumes(
        int index, com.google.cloud.functions.v1.SecretVolume.Builder builderForValue) {
      if (secretVolumesBuilder_ == null) {
        ensureSecretVolumesIsMutable();
        secretVolumes_.set(index, builderForValue.build());
        onChanged();
      } else {
        secretVolumesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public Builder addSecretVolumes(com.google.cloud.functions.v1.SecretVolume value) {
      if (secretVolumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretVolumesIsMutable();
        secretVolumes_.add(value);
        onChanged();
      } else {
        secretVolumesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public Builder addSecretVolumes(int index, com.google.cloud.functions.v1.SecretVolume value) {
      if (secretVolumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretVolumesIsMutable();
        secretVolumes_.add(index, value);
        onChanged();
      } else {
        secretVolumesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public Builder addSecretVolumes(
        com.google.cloud.functions.v1.SecretVolume.Builder builderForValue) {
      if (secretVolumesBuilder_ == null) {
        ensureSecretVolumesIsMutable();
        secretVolumes_.add(builderForValue.build());
        onChanged();
      } else {
        secretVolumesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public Builder addSecretVolumes(
        int index, com.google.cloud.functions.v1.SecretVolume.Builder builderForValue) {
      if (secretVolumesBuilder_ == null) {
        ensureSecretVolumesIsMutable();
        secretVolumes_.add(index, builderForValue.build());
        onChanged();
      } else {
        secretVolumesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public Builder addAllSecretVolumes(
        java.lang.Iterable<? extends com.google.cloud.functions.v1.SecretVolume> values) {
      if (secretVolumesBuilder_ == null) {
        ensureSecretVolumesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, secretVolumes_);
        onChanged();
      } else {
        secretVolumesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public Builder clearSecretVolumes() {
      if (secretVolumesBuilder_ == null) {
        secretVolumes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x20000000);
        onChanged();
      } else {
        secretVolumesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public Builder removeSecretVolumes(int index) {
      if (secretVolumesBuilder_ == null) {
        ensureSecretVolumesIsMutable();
        secretVolumes_.remove(index);
        onChanged();
      } else {
        secretVolumesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public com.google.cloud.functions.v1.SecretVolume.Builder getSecretVolumesBuilder(int index) {
      return getSecretVolumesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public com.google.cloud.functions.v1.SecretVolumeOrBuilder getSecretVolumesOrBuilder(
        int index) {
      if (secretVolumesBuilder_ == null) {
        return secretVolumes_.get(index);
      } else {
        return secretVolumesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public java.util.List<? extends com.google.cloud.functions.v1.SecretVolumeOrBuilder>
        getSecretVolumesOrBuilderList() {
      if (secretVolumesBuilder_ != null) {
        return secretVolumesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(secretVolumes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public com.google.cloud.functions.v1.SecretVolume.Builder addSecretVolumesBuilder() {
      return getSecretVolumesFieldBuilder()
          .addBuilder(com.google.cloud.functions.v1.SecretVolume.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public com.google.cloud.functions.v1.SecretVolume.Builder addSecretVolumesBuilder(int index) {
      return getSecretVolumesFieldBuilder()
          .addBuilder(index, com.google.cloud.functions.v1.SecretVolume.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    public java.util.List<com.google.cloud.functions.v1.SecretVolume.Builder>
        getSecretVolumesBuilderList() {
      return getSecretVolumesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v1.SecretVolume,
            com.google.cloud.functions.v1.SecretVolume.Builder,
            com.google.cloud.functions.v1.SecretVolumeOrBuilder>
        getSecretVolumesFieldBuilder() {
      if (secretVolumesBuilder_ == null) {
        secretVolumesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.functions.v1.SecretVolume,
                com.google.cloud.functions.v1.SecretVolume.Builder,
                com.google.cloud.functions.v1.SecretVolumeOrBuilder>(
                secretVolumes_,
                ((bitField0_ & 0x20000000) != 0),
                getParentForChildren(),
                isClean());
        secretVolumes_ = null;
      }
      return secretVolumesBuilder_;
    }

    private java.lang.Object sourceToken_ = "";
    /**
     *
     *
     * <pre>
     * Input only. An identifier for Firebase function sources. Disclaimer: This
     * field is only supported for Firebase function deployments.
     * </pre>
     *
     * <code>string source_token = 31 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The sourceToken.
     */
    public java.lang.String getSourceToken() {
      java.lang.Object ref = sourceToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. An identifier for Firebase function sources. Disclaimer: This
     * field is only supported for Firebase function deployments.
     * </pre>
     *
     * <code>string source_token = 31 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for sourceToken.
     */
    public com.google.protobuf.ByteString getSourceTokenBytes() {
      java.lang.Object ref = sourceToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. An identifier for Firebase function sources. Disclaimer: This
     * field is only supported for Firebase function deployments.
     * </pre>
     *
     * <code>string source_token = 31 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The sourceToken to set.
     * @return This builder for chaining.
     */
    public Builder setSourceToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceToken_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. An identifier for Firebase function sources. Disclaimer: This
     * field is only supported for Firebase function deployments.
     * </pre>
     *
     * <code>string source_token = 31 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceToken() {
      sourceToken_ = getDefaultInstance().getSourceToken();
      bitField0_ = (bitField0_ & ~0x40000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. An identifier for Firebase function sources. Disclaimer: This
     * field is only supported for Firebase function deployments.
     * </pre>
     *
     * <code>string source_token = 31 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The bytes for sourceToken to set.
     * @return This builder for chaining.
     */
    public Builder setSourceTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceToken_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }

    private java.lang.Object dockerRepository_ = "";
    /**
     *
     *
     * <pre>
     * User-managed repository created in Artifact Registry to which the
     * function's Docker image will be pushed after it is built by Cloud Build.
     * May optionally be encrypted with a customer-managed encryption key (CMEK).
     * If unspecified and `docker_registry` is not explicitly set to
     * `CONTAINER_REGISTRY`, GCF will create and use a default Artifact Registry
     * repository named 'gcf-artifacts' in the region.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/repositories/{repository}`.
     *
     * Cross-project repositories are not supported.
     * Cross-location repositories are not supported.
     * Repository format must be 'DOCKER'.
     * </pre>
     *
     * <code>string docker_repository = 34 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The dockerRepository.
     */
    public java.lang.String getDockerRepository() {
      java.lang.Object ref = dockerRepository_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dockerRepository_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-managed repository created in Artifact Registry to which the
     * function's Docker image will be pushed after it is built by Cloud Build.
     * May optionally be encrypted with a customer-managed encryption key (CMEK).
     * If unspecified and `docker_registry` is not explicitly set to
     * `CONTAINER_REGISTRY`, GCF will create and use a default Artifact Registry
     * repository named 'gcf-artifacts' in the region.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/repositories/{repository}`.
     *
     * Cross-project repositories are not supported.
     * Cross-location repositories are not supported.
     * Repository format must be 'DOCKER'.
     * </pre>
     *
     * <code>string docker_repository = 34 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for dockerRepository.
     */
    public com.google.protobuf.ByteString getDockerRepositoryBytes() {
      java.lang.Object ref = dockerRepository_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dockerRepository_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-managed repository created in Artifact Registry to which the
     * function's Docker image will be pushed after it is built by Cloud Build.
     * May optionally be encrypted with a customer-managed encryption key (CMEK).
     * If unspecified and `docker_registry` is not explicitly set to
     * `CONTAINER_REGISTRY`, GCF will create and use a default Artifact Registry
     * repository named 'gcf-artifacts' in the region.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/repositories/{repository}`.
     *
     * Cross-project repositories are not supported.
     * Cross-location repositories are not supported.
     * Repository format must be 'DOCKER'.
     * </pre>
     *
     * <code>string docker_repository = 34 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The dockerRepository to set.
     * @return This builder for chaining.
     */
    public Builder setDockerRepository(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dockerRepository_ = value;
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-managed repository created in Artifact Registry to which the
     * function's Docker image will be pushed after it is built by Cloud Build.
     * May optionally be encrypted with a customer-managed encryption key (CMEK).
     * If unspecified and `docker_registry` is not explicitly set to
     * `CONTAINER_REGISTRY`, GCF will create and use a default Artifact Registry
     * repository named 'gcf-artifacts' in the region.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/repositories/{repository}`.
     *
     * Cross-project repositories are not supported.
     * Cross-location repositories are not supported.
     * Repository format must be 'DOCKER'.
     * </pre>
     *
     * <code>string docker_repository = 34 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDockerRepository() {
      dockerRepository_ = getDefaultInstance().getDockerRepository();
      bitField0_ = (bitField0_ & ~0x80000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-managed repository created in Artifact Registry to which the
     * function's Docker image will be pushed after it is built by Cloud Build.
     * May optionally be encrypted with a customer-managed encryption key (CMEK).
     * If unspecified and `docker_registry` is not explicitly set to
     * `CONTAINER_REGISTRY`, GCF will create and use a default Artifact Registry
     * repository named 'gcf-artifacts' in the region.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/repositories/{repository}`.
     *
     * Cross-project repositories are not supported.
     * Cross-location repositories are not supported.
     * Repository format must be 'DOCKER'.
     * </pre>
     *
     * <code>string docker_repository = 34 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for dockerRepository to set.
     * @return This builder for chaining.
     */
    public Builder setDockerRepositoryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dockerRepository_ = value;
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }

    private int dockerRegistry_ = 0;
    /**
     *
     *
     * <pre>
     * Docker Registry to use for this deployment.
     *
     * If unspecified, it defaults to `ARTIFACT_REGISTRY`.
     * If `docker_repository` field is specified, this field should either be left
     * unspecified or set to `ARTIFACT_REGISTRY`.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.CloudFunction.DockerRegistry docker_registry = 35;</code>
     *
     * @return The enum numeric value on the wire for dockerRegistry.
     */
    @java.lang.Override
    public int getDockerRegistryValue() {
      return dockerRegistry_;
    }
    /**
     *
     *
     * <pre>
     * Docker Registry to use for this deployment.
     *
     * If unspecified, it defaults to `ARTIFACT_REGISTRY`.
     * If `docker_repository` field is specified, this field should either be left
     * unspecified or set to `ARTIFACT_REGISTRY`.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.CloudFunction.DockerRegistry docker_registry = 35;</code>
     *
     * @param value The enum numeric value on the wire for dockerRegistry to set.
     * @return This builder for chaining.
     */
    public Builder setDockerRegistryValue(int value) {
      dockerRegistry_ = value;
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Docker Registry to use for this deployment.
     *
     * If unspecified, it defaults to `ARTIFACT_REGISTRY`.
     * If `docker_repository` field is specified, this field should either be left
     * unspecified or set to `ARTIFACT_REGISTRY`.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.CloudFunction.DockerRegistry docker_registry = 35;</code>
     *
     * @return The dockerRegistry.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction.DockerRegistry getDockerRegistry() {
      com.google.cloud.functions.v1.CloudFunction.DockerRegistry result =
          com.google.cloud.functions.v1.CloudFunction.DockerRegistry.forNumber(dockerRegistry_);
      return result == null
          ? com.google.cloud.functions.v1.CloudFunction.DockerRegistry.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Docker Registry to use for this deployment.
     *
     * If unspecified, it defaults to `ARTIFACT_REGISTRY`.
     * If `docker_repository` field is specified, this field should either be left
     * unspecified or set to `ARTIFACT_REGISTRY`.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.CloudFunction.DockerRegistry docker_registry = 35;</code>
     *
     * @param value The dockerRegistry to set.
     * @return This builder for chaining.
     */
    public Builder setDockerRegistry(
        com.google.cloud.functions.v1.CloudFunction.DockerRegistry value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField1_ |= 0x00000001;
      dockerRegistry_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Docker Registry to use for this deployment.
     *
     * If unspecified, it defaults to `ARTIFACT_REGISTRY`.
     * If `docker_repository` field is specified, this field should either be left
     * unspecified or set to `ARTIFACT_REGISTRY`.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.CloudFunction.DockerRegistry docker_registry = 35;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDockerRegistry() {
      bitField1_ = (bitField1_ & ~0x00000001);
      dockerRegistry_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy,
            com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy.Builder,
            com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicyOrBuilder>
        automaticUpdatePolicyBuilder_;
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy automatic_update_policy = 40;
     * </code>
     *
     * @return Whether the automaticUpdatePolicy field is set.
     */
    @java.lang.Override
    public boolean hasAutomaticUpdatePolicy() {
      return runtimeUpdatePolicyCase_ == 40;
    }
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy automatic_update_policy = 40;
     * </code>
     *
     * @return The automaticUpdatePolicy.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
        getAutomaticUpdatePolicy() {
      if (automaticUpdatePolicyBuilder_ == null) {
        if (runtimeUpdatePolicyCase_ == 40) {
          return (com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy)
              runtimeUpdatePolicy_;
        }
        return com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
            .getDefaultInstance();
      } else {
        if (runtimeUpdatePolicyCase_ == 40) {
          return automaticUpdatePolicyBuilder_.getMessage();
        }
        return com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
            .getDefaultInstance();
      }
    }
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy automatic_update_policy = 40;
     * </code>
     */
    public Builder setAutomaticUpdatePolicy(
        com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy value) {
      if (automaticUpdatePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runtimeUpdatePolicy_ = value;
        onChanged();
      } else {
        automaticUpdatePolicyBuilder_.setMessage(value);
      }
      runtimeUpdatePolicyCase_ = 40;
      return this;
    }
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy automatic_update_policy = 40;
     * </code>
     */
    public Builder setAutomaticUpdatePolicy(
        com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy.Builder builderForValue) {
      if (automaticUpdatePolicyBuilder_ == null) {
        runtimeUpdatePolicy_ = builderForValue.build();
        onChanged();
      } else {
        automaticUpdatePolicyBuilder_.setMessage(builderForValue.build());
      }
      runtimeUpdatePolicyCase_ = 40;
      return this;
    }
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy automatic_update_policy = 40;
     * </code>
     */
    public Builder mergeAutomaticUpdatePolicy(
        com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy value) {
      if (automaticUpdatePolicyBuilder_ == null) {
        if (runtimeUpdatePolicyCase_ == 40
            && runtimeUpdatePolicy_
                != com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
                    .getDefaultInstance()) {
          runtimeUpdatePolicy_ =
              com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy.newBuilder(
                      (com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy)
                          runtimeUpdatePolicy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          runtimeUpdatePolicy_ = value;
        }
        onChanged();
      } else {
        if (runtimeUpdatePolicyCase_ == 40) {
          automaticUpdatePolicyBuilder_.mergeFrom(value);
        } else {
          automaticUpdatePolicyBuilder_.setMessage(value);
        }
      }
      runtimeUpdatePolicyCase_ = 40;
      return this;
    }
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy automatic_update_policy = 40;
     * </code>
     */
    public Builder clearAutomaticUpdatePolicy() {
      if (automaticUpdatePolicyBuilder_ == null) {
        if (runtimeUpdatePolicyCase_ == 40) {
          runtimeUpdatePolicyCase_ = 0;
          runtimeUpdatePolicy_ = null;
          onChanged();
        }
      } else {
        if (runtimeUpdatePolicyCase_ == 40) {
          runtimeUpdatePolicyCase_ = 0;
          runtimeUpdatePolicy_ = null;
        }
        automaticUpdatePolicyBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy automatic_update_policy = 40;
     * </code>
     */
    public com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy.Builder
        getAutomaticUpdatePolicyBuilder() {
      return getAutomaticUpdatePolicyFieldBuilder().getBuilder();
    }
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy automatic_update_policy = 40;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicyOrBuilder
        getAutomaticUpdatePolicyOrBuilder() {
      if ((runtimeUpdatePolicyCase_ == 40) && (automaticUpdatePolicyBuilder_ != null)) {
        return automaticUpdatePolicyBuilder_.getMessageOrBuilder();
      } else {
        if (runtimeUpdatePolicyCase_ == 40) {
          return (com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy)
              runtimeUpdatePolicy_;
        }
        return com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
            .getDefaultInstance();
      }
    }
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy automatic_update_policy = 40;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy,
            com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy.Builder,
            com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicyOrBuilder>
        getAutomaticUpdatePolicyFieldBuilder() {
      if (automaticUpdatePolicyBuilder_ == null) {
        if (!(runtimeUpdatePolicyCase_ == 40)) {
          runtimeUpdatePolicy_ =
              com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
                  .getDefaultInstance();
        }
        automaticUpdatePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy,
                com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy.Builder,
                com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicyOrBuilder>(
                (com.google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy)
                    runtimeUpdatePolicy_,
                getParentForChildren(),
                isClean());
        runtimeUpdatePolicy_ = null;
      }
      runtimeUpdatePolicyCase_ = 40;
      onChanged();
      return automaticUpdatePolicyBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy,
            com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy.Builder,
            com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicyOrBuilder>
        onDeployUpdatePolicyBuilder_;
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy on_deploy_update_policy = 41;
     * </code>
     *
     * @return Whether the onDeployUpdatePolicy field is set.
     */
    @java.lang.Override
    public boolean hasOnDeployUpdatePolicy() {
      return runtimeUpdatePolicyCase_ == 41;
    }
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy on_deploy_update_policy = 41;
     * </code>
     *
     * @return The onDeployUpdatePolicy.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy
        getOnDeployUpdatePolicy() {
      if (onDeployUpdatePolicyBuilder_ == null) {
        if (runtimeUpdatePolicyCase_ == 41) {
          return (com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy)
              runtimeUpdatePolicy_;
        }
        return com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy
            .getDefaultInstance();
      } else {
        if (runtimeUpdatePolicyCase_ == 41) {
          return onDeployUpdatePolicyBuilder_.getMessage();
        }
        return com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy
            .getDefaultInstance();
      }
    }
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy on_deploy_update_policy = 41;
     * </code>
     */
    public Builder setOnDeployUpdatePolicy(
        com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy value) {
      if (onDeployUpdatePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runtimeUpdatePolicy_ = value;
        onChanged();
      } else {
        onDeployUpdatePolicyBuilder_.setMessage(value);
      }
      runtimeUpdatePolicyCase_ = 41;
      return this;
    }
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy on_deploy_update_policy = 41;
     * </code>
     */
    public Builder setOnDeployUpdatePolicy(
        com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy.Builder builderForValue) {
      if (onDeployUpdatePolicyBuilder_ == null) {
        runtimeUpdatePolicy_ = builderForValue.build();
        onChanged();
      } else {
        onDeployUpdatePolicyBuilder_.setMessage(builderForValue.build());
      }
      runtimeUpdatePolicyCase_ = 41;
      return this;
    }
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy on_deploy_update_policy = 41;
     * </code>
     */
    public Builder mergeOnDeployUpdatePolicy(
        com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy value) {
      if (onDeployUpdatePolicyBuilder_ == null) {
        if (runtimeUpdatePolicyCase_ == 41
            && runtimeUpdatePolicy_
                != com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy
                    .getDefaultInstance()) {
          runtimeUpdatePolicy_ =
              com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy.newBuilder(
                      (com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy)
                          runtimeUpdatePolicy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          runtimeUpdatePolicy_ = value;
        }
        onChanged();
      } else {
        if (runtimeUpdatePolicyCase_ == 41) {
          onDeployUpdatePolicyBuilder_.mergeFrom(value);
        } else {
          onDeployUpdatePolicyBuilder_.setMessage(value);
        }
      }
      runtimeUpdatePolicyCase_ = 41;
      return this;
    }
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy on_deploy_update_policy = 41;
     * </code>
     */
    public Builder clearOnDeployUpdatePolicy() {
      if (onDeployUpdatePolicyBuilder_ == null) {
        if (runtimeUpdatePolicyCase_ == 41) {
          runtimeUpdatePolicyCase_ = 0;
          runtimeUpdatePolicy_ = null;
          onChanged();
        }
      } else {
        if (runtimeUpdatePolicyCase_ == 41) {
          runtimeUpdatePolicyCase_ = 0;
          runtimeUpdatePolicy_ = null;
        }
        onDeployUpdatePolicyBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy on_deploy_update_policy = 41;
     * </code>
     */
    public com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy.Builder
        getOnDeployUpdatePolicyBuilder() {
      return getOnDeployUpdatePolicyFieldBuilder().getBuilder();
    }
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy on_deploy_update_policy = 41;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicyOrBuilder
        getOnDeployUpdatePolicyOrBuilder() {
      if ((runtimeUpdatePolicyCase_ == 41) && (onDeployUpdatePolicyBuilder_ != null)) {
        return onDeployUpdatePolicyBuilder_.getMessageOrBuilder();
      } else {
        if (runtimeUpdatePolicyCase_ == 41) {
          return (com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy)
              runtimeUpdatePolicy_;
        }
        return com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy
            .getDefaultInstance();
      }
    }
    /**
     * <code>
     * .google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy on_deploy_update_policy = 41;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy,
            com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy.Builder,
            com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicyOrBuilder>
        getOnDeployUpdatePolicyFieldBuilder() {
      if (onDeployUpdatePolicyBuilder_ == null) {
        if (!(runtimeUpdatePolicyCase_ == 41)) {
          runtimeUpdatePolicy_ =
              com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy.getDefaultInstance();
        }
        onDeployUpdatePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy,
                com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy.Builder,
                com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicyOrBuilder>(
                (com.google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy)
                    runtimeUpdatePolicy_,
                getParentForChildren(),
                isClean());
        runtimeUpdatePolicy_ = null;
      }
      runtimeUpdatePolicyCase_ = 41;
      onChanged();
      return onDeployUpdatePolicyBuilder_;
    }

    private java.lang.Object buildServiceAccount_ = "";
    /**
     *
     *
     * <pre>
     * A service account the user provides for use with Cloud Build. The format of
     * this field is
     * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     * </pre>
     *
     * <code>string build_service_account = 43;</code>
     *
     * @return The buildServiceAccount.
     */
    public java.lang.String getBuildServiceAccount() {
      java.lang.Object ref = buildServiceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        buildServiceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A service account the user provides for use with Cloud Build. The format of
     * this field is
     * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     * </pre>
     *
     * <code>string build_service_account = 43;</code>
     *
     * @return The bytes for buildServiceAccount.
     */
    public com.google.protobuf.ByteString getBuildServiceAccountBytes() {
      java.lang.Object ref = buildServiceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        buildServiceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A service account the user provides for use with Cloud Build. The format of
     * this field is
     * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     * </pre>
     *
     * <code>string build_service_account = 43;</code>
     *
     * @param value The buildServiceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setBuildServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      buildServiceAccount_ = value;
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A service account the user provides for use with Cloud Build. The format of
     * this field is
     * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     * </pre>
     *
     * <code>string build_service_account = 43;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuildServiceAccount() {
      buildServiceAccount_ = getDefaultInstance().getBuildServiceAccount();
      bitField1_ = (bitField1_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A service account the user provides for use with Cloud Build. The format of
     * this field is
     * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     * </pre>
     *
     * <code>string build_service_account = 43;</code>
     *
     * @param value The bytes for buildServiceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setBuildServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      buildServiceAccount_ = value;
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.functions.v1.CloudFunction)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.functions.v1.CloudFunction)
  private static final com.google.cloud.functions.v1.CloudFunction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.functions.v1.CloudFunction();
  }

  public static com.google.cloud.functions.v1.CloudFunction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudFunction> PARSER =
      new com.google.protobuf.AbstractParser<CloudFunction>() {
        @java.lang.Override
        public CloudFunction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudFunction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudFunction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.functions.v1.CloudFunction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
