/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.v1;

import com.google.cloud.functions.v1.CloudFunctionOrBuilder;
import com.google.cloud.functions.v1.CloudFunctionStatus;
import com.google.cloud.functions.v1.EventTrigger;
import com.google.cloud.functions.v1.EventTriggerOrBuilder;
import com.google.cloud.functions.v1.FunctionsProto;
import com.google.cloud.functions.v1.HttpsTrigger;
import com.google.cloud.functions.v1.HttpsTriggerOrBuilder;
import com.google.cloud.functions.v1.SourceRepository;
import com.google.cloud.functions.v1.SourceRepositoryOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DurationOrBuilder;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public final class CloudFunction
extends GeneratedMessageV3
implements CloudFunctionOrBuilder {
    private static final long serialVersionUID = 0L;
    private int sourceCodeCase_ = 0;
    private Object sourceCode_;
    private int triggerCase_ = 0;
    private Object trigger_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_;
    public static final int DESCRIPTION_FIELD_NUMBER = 2;
    private volatile Object description_;
    public static final int SOURCE_ARCHIVE_URL_FIELD_NUMBER = 3;
    public static final int SOURCE_REPOSITORY_FIELD_NUMBER = 4;
    public static final int SOURCE_UPLOAD_URL_FIELD_NUMBER = 16;
    public static final int HTTPS_TRIGGER_FIELD_NUMBER = 5;
    public static final int EVENT_TRIGGER_FIELD_NUMBER = 6;
    public static final int STATUS_FIELD_NUMBER = 7;
    private int status_;
    public static final int ENTRY_POINT_FIELD_NUMBER = 8;
    private volatile Object entryPoint_;
    public static final int RUNTIME_FIELD_NUMBER = 19;
    private volatile Object runtime_;
    public static final int TIMEOUT_FIELD_NUMBER = 9;
    private Duration timeout_;
    public static final int AVAILABLE_MEMORY_MB_FIELD_NUMBER = 10;
    private int availableMemoryMb_;
    public static final int SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER = 11;
    private volatile Object serviceAccountEmail_;
    public static final int UPDATE_TIME_FIELD_NUMBER = 12;
    private Timestamp updateTime_;
    public static final int VERSION_ID_FIELD_NUMBER = 14;
    private long versionId_;
    public static final int LABELS_FIELD_NUMBER = 15;
    private MapField<String, String> labels_;
    public static final int ENVIRONMENT_VARIABLES_FIELD_NUMBER = 17;
    private MapField<String, String> environmentVariables_;
    public static final int NETWORK_FIELD_NUMBER = 18;
    private volatile Object network_;
    public static final int MAX_INSTANCES_FIELD_NUMBER = 20;
    private int maxInstances_;
    public static final int VPC_CONNECTOR_FIELD_NUMBER = 22;
    private volatile Object vpcConnector_;
    public static final int VPC_CONNECTOR_EGRESS_SETTINGS_FIELD_NUMBER = 23;
    private int vpcConnectorEgressSettings_;
    public static final int INGRESS_SETTINGS_FIELD_NUMBER = 24;
    private int ingressSettings_;
    public static final int BUILD_ID_FIELD_NUMBER = 27;
    private volatile Object buildId_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final CloudFunction DEFAULT_INSTANCE = new CloudFunction();
    private static final Parser<CloudFunction> PARSER = new AbstractParser<CloudFunction>(){

        public CloudFunction parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new CloudFunction(input, extensionRegistry);
        }
    };

    private CloudFunction(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private CloudFunction() {
        this.name_ = "";
        this.description_ = "";
        this.status_ = 0;
        this.entryPoint_ = "";
        this.runtime_ = "";
        this.serviceAccountEmail_ = "";
        this.network_ = "";
        this.vpcConnector_ = "";
        this.vpcConnectorEgressSettings_ = 0;
        this.ingressSettings_ = 0;
        this.buildId_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new CloudFunction();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private CloudFunction(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block32: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block32;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.name_ = s;
                        continue block32;
                    }
                    case 18: {
                        String s = input.readStringRequireUtf8();
                        this.description_ = s;
                        continue block32;
                    }
                    case 26: {
                        String s = input.readStringRequireUtf8();
                        this.sourceCodeCase_ = 3;
                        this.sourceCode_ = s;
                        continue block32;
                    }
                    case 34: {
                        SourceRepository.Builder subBuilder = null;
                        if (this.sourceCodeCase_ == 4) {
                            subBuilder = ((SourceRepository)this.sourceCode_).toBuilder();
                        }
                        this.sourceCode_ = input.readMessage(SourceRepository.parser(), extensionRegistry);
                        if (subBuilder != null) {
                            subBuilder.mergeFrom((SourceRepository)this.sourceCode_);
                            this.sourceCode_ = subBuilder.buildPartial();
                        }
                        this.sourceCodeCase_ = 4;
                        continue block32;
                    }
                    case 42: {
                        HttpsTrigger.Builder subBuilder = null;
                        if (this.triggerCase_ == 5) {
                            subBuilder = ((HttpsTrigger)this.trigger_).toBuilder();
                        }
                        this.trigger_ = input.readMessage(HttpsTrigger.parser(), extensionRegistry);
                        if (subBuilder != null) {
                            subBuilder.mergeFrom((HttpsTrigger)this.trigger_);
                            this.trigger_ = subBuilder.buildPartial();
                        }
                        this.triggerCase_ = 5;
                        continue block32;
                    }
                    case 50: {
                        EventTrigger.Builder subBuilder = null;
                        if (this.triggerCase_ == 6) {
                            subBuilder = ((EventTrigger)this.trigger_).toBuilder();
                        }
                        this.trigger_ = input.readMessage(EventTrigger.parser(), extensionRegistry);
                        if (subBuilder != null) {
                            subBuilder.mergeFrom((EventTrigger)this.trigger_);
                            this.trigger_ = subBuilder.buildPartial();
                        }
                        this.triggerCase_ = 6;
                        continue block32;
                    }
                    case 56: {
                        int rawValue;
                        this.status_ = rawValue = input.readEnum();
                        continue block32;
                    }
                    case 66: {
                        String s = input.readStringRequireUtf8();
                        this.entryPoint_ = s;
                        continue block32;
                    }
                    case 74: {
                        Duration.Builder subBuilder = null;
                        if (this.timeout_ != null) {
                            subBuilder = this.timeout_.toBuilder();
                        }
                        this.timeout_ = (Duration)input.readMessage(Duration.parser(), extensionRegistry);
                        if (subBuilder == null) continue block32;
                        subBuilder.mergeFrom(this.timeout_);
                        this.timeout_ = subBuilder.buildPartial();
                        continue block32;
                    }
                    case 80: {
                        this.availableMemoryMb_ = input.readInt32();
                        continue block32;
                    }
                    case 90: {
                        String s = input.readStringRequireUtf8();
                        this.serviceAccountEmail_ = s;
                        continue block32;
                    }
                    case 98: {
                        Timestamp.Builder subBuilder = null;
                        if (this.updateTime_ != null) {
                            subBuilder = this.updateTime_.toBuilder();
                        }
                        this.updateTime_ = (Timestamp)input.readMessage(Timestamp.parser(), extensionRegistry);
                        if (subBuilder == null) continue block32;
                        subBuilder.mergeFrom(this.updateTime_);
                        this.updateTime_ = subBuilder.buildPartial();
                        continue block32;
                    }
                    case 112: {
                        this.versionId_ = input.readInt64();
                        continue block32;
                    }
                    case 122: {
                        if (!(mutable_bitField0_ & true)) {
                            this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                            mutable_bitField0_ |= 1;
                        }
                        MapEntry labels__ = (MapEntry)input.readMessage(LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                        this.labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
                        continue block32;
                    }
                    case 130: {
                        String s = input.readStringRequireUtf8();
                        this.sourceCodeCase_ = 16;
                        this.sourceCode_ = s;
                        continue block32;
                    }
                    case 138: {
                        if ((mutable_bitField0_ & 2) == 0) {
                            this.environmentVariables_ = MapField.newMapField(EnvironmentVariablesDefaultEntryHolder.defaultEntry);
                            mutable_bitField0_ |= 2;
                        }
                        MapEntry environmentVariables__ = (MapEntry)input.readMessage(EnvironmentVariablesDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                        this.environmentVariables_.getMutableMap().put(environmentVariables__.getKey(), environmentVariables__.getValue());
                        continue block32;
                    }
                    case 146: {
                        String s = input.readStringRequireUtf8();
                        this.network_ = s;
                        continue block32;
                    }
                    case 154: {
                        String s = input.readStringRequireUtf8();
                        this.runtime_ = s;
                        continue block32;
                    }
                    case 160: {
                        this.maxInstances_ = input.readInt32();
                        continue block32;
                    }
                    case 178: {
                        String s = input.readStringRequireUtf8();
                        this.vpcConnector_ = s;
                        continue block32;
                    }
                    case 184: {
                        int rawValue;
                        this.vpcConnectorEgressSettings_ = rawValue = input.readEnum();
                        continue block32;
                    }
                    case 192: {
                        int rawValue;
                        this.ingressSettings_ = rawValue = input.readEnum();
                        continue block32;
                    }
                    case 218: {
                        String s = input.readStringRequireUtf8();
                        this.buildId_ = s;
                        continue block32;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return FunctionsProto.internal_static_google_cloud_functions_v1_CloudFunction_descriptor;
    }

    protected MapField internalGetMapField(int number) {
        switch (number) {
            case 15: {
                return this.internalGetLabels();
            }
            case 17: {
                return this.internalGetEnvironmentVariables();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return FunctionsProto.internal_static_google_cloud_functions_v1_CloudFunction_fieldAccessorTable.ensureFieldAccessorsInitialized(CloudFunction.class, Builder.class);
    }

    @Override
    public SourceCodeCase getSourceCodeCase() {
        return SourceCodeCase.forNumber(this.sourceCodeCase_);
    }

    @Override
    public TriggerCase getTriggerCase() {
        return TriggerCase.forNumber(this.triggerCase_);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDescription() {
        Object ref = this.description_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.description_ = s;
        return s;
    }

    @Override
    public ByteString getDescriptionBytes() {
        Object ref = this.description_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.description_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasSourceArchiveUrl() {
        return this.sourceCodeCase_ == 3;
    }

    @Override
    public String getSourceArchiveUrl() {
        Object ref = "";
        if (this.sourceCodeCase_ == 3) {
            ref = this.sourceCode_;
        }
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        if (this.sourceCodeCase_ == 3) {
            this.sourceCode_ = s;
        }
        return s;
    }

    @Override
    public ByteString getSourceArchiveUrlBytes() {
        Object ref = "";
        if (this.sourceCodeCase_ == 3) {
            ref = this.sourceCode_;
        }
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            if (this.sourceCodeCase_ == 3) {
                this.sourceCode_ = b;
            }
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasSourceRepository() {
        return this.sourceCodeCase_ == 4;
    }

    @Override
    public SourceRepository getSourceRepository() {
        if (this.sourceCodeCase_ == 4) {
            return (SourceRepository)this.sourceCode_;
        }
        return SourceRepository.getDefaultInstance();
    }

    @Override
    public SourceRepositoryOrBuilder getSourceRepositoryOrBuilder() {
        if (this.sourceCodeCase_ == 4) {
            return (SourceRepository)this.sourceCode_;
        }
        return SourceRepository.getDefaultInstance();
    }

    @Override
    public boolean hasSourceUploadUrl() {
        return this.sourceCodeCase_ == 16;
    }

    @Override
    public String getSourceUploadUrl() {
        Object ref = "";
        if (this.sourceCodeCase_ == 16) {
            ref = this.sourceCode_;
        }
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        if (this.sourceCodeCase_ == 16) {
            this.sourceCode_ = s;
        }
        return s;
    }

    @Override
    public ByteString getSourceUploadUrlBytes() {
        Object ref = "";
        if (this.sourceCodeCase_ == 16) {
            ref = this.sourceCode_;
        }
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            if (this.sourceCodeCase_ == 16) {
                this.sourceCode_ = b;
            }
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasHttpsTrigger() {
        return this.triggerCase_ == 5;
    }

    @Override
    public HttpsTrigger getHttpsTrigger() {
        if (this.triggerCase_ == 5) {
            return (HttpsTrigger)this.trigger_;
        }
        return HttpsTrigger.getDefaultInstance();
    }

    @Override
    public HttpsTriggerOrBuilder getHttpsTriggerOrBuilder() {
        if (this.triggerCase_ == 5) {
            return (HttpsTrigger)this.trigger_;
        }
        return HttpsTrigger.getDefaultInstance();
    }

    @Override
    public boolean hasEventTrigger() {
        return this.triggerCase_ == 6;
    }

    @Override
    public EventTrigger getEventTrigger() {
        if (this.triggerCase_ == 6) {
            return (EventTrigger)this.trigger_;
        }
        return EventTrigger.getDefaultInstance();
    }

    @Override
    public EventTriggerOrBuilder getEventTriggerOrBuilder() {
        if (this.triggerCase_ == 6) {
            return (EventTrigger)this.trigger_;
        }
        return EventTrigger.getDefaultInstance();
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public CloudFunctionStatus getStatus() {
        CloudFunctionStatus result = CloudFunctionStatus.valueOf(this.status_);
        return result == null ? CloudFunctionStatus.UNRECOGNIZED : result;
    }

    @Override
    public String getEntryPoint() {
        Object ref = this.entryPoint_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.entryPoint_ = s;
        return s;
    }

    @Override
    public ByteString getEntryPointBytes() {
        Object ref = this.entryPoint_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.entryPoint_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getRuntime() {
        Object ref = this.runtime_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.runtime_ = s;
        return s;
    }

    @Override
    public ByteString getRuntimeBytes() {
        Object ref = this.runtime_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.runtime_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasTimeout() {
        return this.timeout_ != null;
    }

    @Override
    public Duration getTimeout() {
        return this.timeout_ == null ? Duration.getDefaultInstance() : this.timeout_;
    }

    @Override
    public DurationOrBuilder getTimeoutOrBuilder() {
        return this.getTimeout();
    }

    @Override
    public int getAvailableMemoryMb() {
        return this.availableMemoryMb_;
    }

    @Override
    public String getServiceAccountEmail() {
        Object ref = this.serviceAccountEmail_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.serviceAccountEmail_ = s;
        return s;
    }

    @Override
    public ByteString getServiceAccountEmailBytes() {
        Object ref = this.serviceAccountEmail_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.serviceAccountEmail_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasUpdateTime() {
        return this.updateTime_ != null;
    }

    @Override
    public Timestamp getUpdateTime() {
        return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
    }

    @Override
    public TimestampOrBuilder getUpdateTimeOrBuilder() {
        return this.getUpdateTime();
    }

    @Override
    public long getVersionId() {
        return this.versionId_;
    }

    private MapField<String, String> internalGetLabels() {
        if (this.labels_ == null) {
            return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return this.labels_;
    }

    @Override
    public int getLabelsCount() {
        return this.internalGetLabels().getMap().size();
    }

    @Override
    public boolean containsLabels(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.internalGetLabels().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getLabels() {
        return this.getLabelsMap();
    }

    @Override
    public Map<String, String> getLabelsMap() {
        return this.internalGetLabels().getMap();
    }

    @Override
    public String getLabelsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map map = this.internalGetLabels().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getLabelsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map map = this.internalGetLabels().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    private MapField<String, String> internalGetEnvironmentVariables() {
        if (this.environmentVariables_ == null) {
            return MapField.emptyMapField(EnvironmentVariablesDefaultEntryHolder.defaultEntry);
        }
        return this.environmentVariables_;
    }

    @Override
    public int getEnvironmentVariablesCount() {
        return this.internalGetEnvironmentVariables().getMap().size();
    }

    @Override
    public boolean containsEnvironmentVariables(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.internalGetEnvironmentVariables().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getEnvironmentVariables() {
        return this.getEnvironmentVariablesMap();
    }

    @Override
    public Map<String, String> getEnvironmentVariablesMap() {
        return this.internalGetEnvironmentVariables().getMap();
    }

    @Override
    public String getEnvironmentVariablesOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map map = this.internalGetEnvironmentVariables().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getEnvironmentVariablesOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map map = this.internalGetEnvironmentVariables().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public String getNetwork() {
        Object ref = this.network_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.network_ = s;
        return s;
    }

    @Override
    public ByteString getNetworkBytes() {
        Object ref = this.network_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.network_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getMaxInstances() {
        return this.maxInstances_;
    }

    @Override
    public String getVpcConnector() {
        Object ref = this.vpcConnector_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.vpcConnector_ = s;
        return s;
    }

    @Override
    public ByteString getVpcConnectorBytes() {
        Object ref = this.vpcConnector_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.vpcConnector_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getVpcConnectorEgressSettingsValue() {
        return this.vpcConnectorEgressSettings_;
    }

    @Override
    public VpcConnectorEgressSettings getVpcConnectorEgressSettings() {
        VpcConnectorEgressSettings result = VpcConnectorEgressSettings.valueOf(this.vpcConnectorEgressSettings_);
        return result == null ? VpcConnectorEgressSettings.UNRECOGNIZED : result;
    }

    @Override
    public int getIngressSettingsValue() {
        return this.ingressSettings_;
    }

    @Override
    public IngressSettings getIngressSettings() {
        IngressSettings result = IngressSettings.valueOf(this.ingressSettings_);
        return result == null ? IngressSettings.UNRECOGNIZED : result;
    }

    @Override
    public String getBuildId() {
        Object ref = this.buildId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.buildId_ = s;
        return s;
    }

    @Override
    public ByteString getBuildIdBytes() {
        Object ref = this.buildId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.buildId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!this.getNameBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (!this.getDescriptionBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.description_);
        }
        if (this.sourceCodeCase_ == 3) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.sourceCode_);
        }
        if (this.sourceCodeCase_ == 4) {
            output.writeMessage(4, (MessageLite)((SourceRepository)this.sourceCode_));
        }
        if (this.triggerCase_ == 5) {
            output.writeMessage(5, (MessageLite)((HttpsTrigger)this.trigger_));
        }
        if (this.triggerCase_ == 6) {
            output.writeMessage(6, (MessageLite)((EventTrigger)this.trigger_));
        }
        if (this.status_ != CloudFunctionStatus.CLOUD_FUNCTION_STATUS_UNSPECIFIED.getNumber()) {
            output.writeEnum(7, this.status_);
        }
        if (!this.getEntryPointBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.entryPoint_);
        }
        if (this.timeout_ != null) {
            output.writeMessage(9, (MessageLite)this.getTimeout());
        }
        if (this.availableMemoryMb_ != 0) {
            output.writeInt32(10, this.availableMemoryMb_);
        }
        if (!this.getServiceAccountEmailBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)11, (Object)this.serviceAccountEmail_);
        }
        if (this.updateTime_ != null) {
            output.writeMessage(12, (MessageLite)this.getUpdateTime());
        }
        if (this.versionId_ != 0L) {
            output.writeInt64(14, this.versionId_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, (int)15);
        if (this.sourceCodeCase_ == 16) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)16, (Object)this.sourceCode_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetEnvironmentVariables(), EnvironmentVariablesDefaultEntryHolder.defaultEntry, (int)17);
        if (!this.getNetworkBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)18, (Object)this.network_);
        }
        if (!this.getRuntimeBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)19, (Object)this.runtime_);
        }
        if (this.maxInstances_ != 0) {
            output.writeInt32(20, this.maxInstances_);
        }
        if (!this.getVpcConnectorBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)22, (Object)this.vpcConnector_);
        }
        if (this.vpcConnectorEgressSettings_ != VpcConnectorEgressSettings.VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED.getNumber()) {
            output.writeEnum(23, this.vpcConnectorEgressSettings_);
        }
        if (this.ingressSettings_ != IngressSettings.INGRESS_SETTINGS_UNSPECIFIED.getNumber()) {
            output.writeEnum(24, this.ingressSettings_);
        }
        if (!this.getBuildIdBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)27, (Object)this.buildId_);
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!this.getNameBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (!this.getDescriptionBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.description_);
        }
        if (this.sourceCodeCase_ == 3) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.sourceCode_);
        }
        if (this.sourceCodeCase_ == 4) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)((SourceRepository)this.sourceCode_));
        }
        if (this.triggerCase_ == 5) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)((HttpsTrigger)this.trigger_));
        }
        if (this.triggerCase_ == 6) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)((EventTrigger)this.trigger_));
        }
        if (this.status_ != CloudFunctionStatus.CLOUD_FUNCTION_STATUS_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)7, (int)this.status_);
        }
        if (!this.getEntryPointBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)8, (Object)this.entryPoint_);
        }
        if (this.timeout_ != null) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getTimeout());
        }
        if (this.availableMemoryMb_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)10, (int)this.availableMemoryMb_);
        }
        if (!this.getServiceAccountEmailBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)11, (Object)this.serviceAccountEmail_);
        }
        if (this.updateTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)this.getUpdateTime());
        }
        if (this.versionId_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)14, (long)this.versionId_);
        }
        for (Map.Entry entry : this.internalGetLabels().getMap().entrySet()) {
            MapEntry labels__ = LabelsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)15, (MessageLite)labels__);
        }
        if (this.sourceCodeCase_ == 16) {
            size += GeneratedMessageV3.computeStringSize((int)16, (Object)this.sourceCode_);
        }
        for (Map.Entry entry : this.internalGetEnvironmentVariables().getMap().entrySet()) {
            MapEntry environmentVariables__ = EnvironmentVariablesDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)17, (MessageLite)environmentVariables__);
        }
        if (!this.getNetworkBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)18, (Object)this.network_);
        }
        if (!this.getRuntimeBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)19, (Object)this.runtime_);
        }
        if (this.maxInstances_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)20, (int)this.maxInstances_);
        }
        if (!this.getVpcConnectorBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)22, (Object)this.vpcConnector_);
        }
        if (this.vpcConnectorEgressSettings_ != VpcConnectorEgressSettings.VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)23, (int)this.vpcConnectorEgressSettings_);
        }
        if (this.ingressSettings_ != IngressSettings.INGRESS_SETTINGS_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)24, (int)this.ingressSettings_);
        }
        if (!this.getBuildIdBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)27, (Object)this.buildId_);
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CloudFunction)) {
            return super.equals(obj);
        }
        CloudFunction other = (CloudFunction)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (!this.getEntryPoint().equals(other.getEntryPoint())) {
            return false;
        }
        if (!this.getRuntime().equals(other.getRuntime())) {
            return false;
        }
        if (this.hasTimeout() != other.hasTimeout()) {
            return false;
        }
        if (this.hasTimeout() && !this.getTimeout().equals((Object)other.getTimeout())) {
            return false;
        }
        if (this.getAvailableMemoryMb() != other.getAvailableMemoryMb()) {
            return false;
        }
        if (!this.getServiceAccountEmail().equals(other.getServiceAccountEmail())) {
            return false;
        }
        if (this.hasUpdateTime() != other.hasUpdateTime()) {
            return false;
        }
        if (this.hasUpdateTime() && !this.getUpdateTime().equals((Object)other.getUpdateTime())) {
            return false;
        }
        if (this.getVersionId() != other.getVersionId()) {
            return false;
        }
        if (!this.internalGetLabels().equals(other.internalGetLabels())) {
            return false;
        }
        if (!this.internalGetEnvironmentVariables().equals(other.internalGetEnvironmentVariables())) {
            return false;
        }
        if (!this.getNetwork().equals(other.getNetwork())) {
            return false;
        }
        if (this.getMaxInstances() != other.getMaxInstances()) {
            return false;
        }
        if (!this.getVpcConnector().equals(other.getVpcConnector())) {
            return false;
        }
        if (this.vpcConnectorEgressSettings_ != other.vpcConnectorEgressSettings_) {
            return false;
        }
        if (this.ingressSettings_ != other.ingressSettings_) {
            return false;
        }
        if (!this.getBuildId().equals(other.getBuildId())) {
            return false;
        }
        if (!this.getSourceCodeCase().equals((Object)other.getSourceCodeCase())) {
            return false;
        }
        switch (this.sourceCodeCase_) {
            case 3: {
                if (this.getSourceArchiveUrl().equals(other.getSourceArchiveUrl())) break;
                return false;
            }
            case 4: {
                if (this.getSourceRepository().equals(other.getSourceRepository())) break;
                return false;
            }
            case 16: {
                if (this.getSourceUploadUrl().equals(other.getSourceUploadUrl())) break;
                return false;
            }
        }
        if (!this.getTriggerCase().equals((Object)other.getTriggerCase())) {
            return false;
        }
        switch (this.triggerCase_) {
            case 5: {
                if (this.getHttpsTrigger().equals(other.getHttpsTrigger())) break;
                return false;
            }
            case 6: {
                if (this.getEventTrigger().equals(other.getEventTrigger())) break;
                return false;
            }
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + CloudFunction.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getDescription().hashCode();
        hash = 37 * hash + 7;
        hash = 53 * hash + this.status_;
        hash = 37 * hash + 8;
        hash = 53 * hash + this.getEntryPoint().hashCode();
        hash = 37 * hash + 19;
        hash = 53 * hash + this.getRuntime().hashCode();
        if (this.hasTimeout()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getTimeout().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + this.getAvailableMemoryMb();
        hash = 37 * hash + 11;
        hash = 53 * hash + this.getServiceAccountEmail().hashCode();
        if (this.hasUpdateTime()) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getUpdateTime().hashCode();
        }
        hash = 37 * hash + 14;
        hash = 53 * hash + Internal.hashLong((long)this.getVersionId());
        if (!this.internalGetLabels().getMap().isEmpty()) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.internalGetLabels().hashCode();
        }
        if (!this.internalGetEnvironmentVariables().getMap().isEmpty()) {
            hash = 37 * hash + 17;
            hash = 53 * hash + this.internalGetEnvironmentVariables().hashCode();
        }
        hash = 37 * hash + 18;
        hash = 53 * hash + this.getNetwork().hashCode();
        hash = 37 * hash + 20;
        hash = 53 * hash + this.getMaxInstances();
        hash = 37 * hash + 22;
        hash = 53 * hash + this.getVpcConnector().hashCode();
        hash = 37 * hash + 23;
        hash = 53 * hash + this.vpcConnectorEgressSettings_;
        hash = 37 * hash + 24;
        hash = 53 * hash + this.ingressSettings_;
        hash = 37 * hash + 27;
        hash = 53 * hash + this.getBuildId().hashCode();
        switch (this.sourceCodeCase_) {
            case 3: {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getSourceArchiveUrl().hashCode();
                break;
            }
            case 4: {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getSourceRepository().hashCode();
                break;
            }
            case 16: {
                hash = 37 * hash + 16;
                hash = 53 * hash + this.getSourceUploadUrl().hashCode();
                break;
            }
        }
        switch (this.triggerCase_) {
            case 5: {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.getHttpsTrigger().hashCode();
                break;
            }
            case 6: {
                hash = 37 * hash + 6;
                hash = 53 * hash + this.getEventTrigger().hashCode();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static CloudFunction parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (CloudFunction)PARSER.parseFrom(data);
    }

    public static CloudFunction parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CloudFunction)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CloudFunction parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (CloudFunction)PARSER.parseFrom(data);
    }

    public static CloudFunction parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CloudFunction)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CloudFunction parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (CloudFunction)PARSER.parseFrom(data);
    }

    public static CloudFunction parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CloudFunction)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CloudFunction parseFrom(InputStream input) throws IOException {
        return (CloudFunction)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static CloudFunction parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CloudFunction)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CloudFunction parseDelimitedFrom(InputStream input) throws IOException {
        return (CloudFunction)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static CloudFunction parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CloudFunction)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CloudFunction parseFrom(CodedInputStream input) throws IOException {
        return (CloudFunction)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static CloudFunction parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CloudFunction)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return CloudFunction.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(CloudFunction prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static CloudFunction getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<CloudFunction> parser() {
        return PARSER;
    }

    public Parser<CloudFunction> getParserForType() {
        return PARSER;
    }

    public CloudFunction getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements CloudFunctionOrBuilder {
        private int sourceCodeCase_ = 0;
        private Object sourceCode_;
        private int triggerCase_ = 0;
        private Object trigger_;
        private int bitField0_;
        private Object name_ = "";
        private Object description_ = "";
        private SingleFieldBuilderV3<SourceRepository, SourceRepository.Builder, SourceRepositoryOrBuilder> sourceRepositoryBuilder_;
        private SingleFieldBuilderV3<HttpsTrigger, HttpsTrigger.Builder, HttpsTriggerOrBuilder> httpsTriggerBuilder_;
        private SingleFieldBuilderV3<EventTrigger, EventTrigger.Builder, EventTriggerOrBuilder> eventTriggerBuilder_;
        private int status_ = 0;
        private Object entryPoint_ = "";
        private Object runtime_ = "";
        private Duration timeout_;
        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> timeoutBuilder_;
        private int availableMemoryMb_;
        private Object serviceAccountEmail_ = "";
        private Timestamp updateTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> updateTimeBuilder_;
        private long versionId_;
        private MapField<String, String> labels_;
        private MapField<String, String> environmentVariables_;
        private Object network_ = "";
        private int maxInstances_;
        private Object vpcConnector_ = "";
        private int vpcConnectorEgressSettings_ = 0;
        private int ingressSettings_ = 0;
        private Object buildId_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return FunctionsProto.internal_static_google_cloud_functions_v1_CloudFunction_descriptor;
        }

        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 15: {
                    return this.internalGetLabels();
                }
                case 17: {
                    return this.internalGetEnvironmentVariables();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapField internalGetMutableMapField(int number) {
            switch (number) {
                case 15: {
                    return this.internalGetMutableLabels();
                }
                case 17: {
                    return this.internalGetMutableEnvironmentVariables();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return FunctionsProto.internal_static_google_cloud_functions_v1_CloudFunction_fieldAccessorTable.ensureFieldAccessorsInitialized(CloudFunction.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        public Builder clear() {
            super.clear();
            this.name_ = "";
            this.description_ = "";
            this.status_ = 0;
            this.entryPoint_ = "";
            this.runtime_ = "";
            if (this.timeoutBuilder_ == null) {
                this.timeout_ = null;
            } else {
                this.timeout_ = null;
                this.timeoutBuilder_ = null;
            }
            this.availableMemoryMb_ = 0;
            this.serviceAccountEmail_ = "";
            if (this.updateTimeBuilder_ == null) {
                this.updateTime_ = null;
            } else {
                this.updateTime_ = null;
                this.updateTimeBuilder_ = null;
            }
            this.versionId_ = 0L;
            this.internalGetMutableLabels().clear();
            this.internalGetMutableEnvironmentVariables().clear();
            this.network_ = "";
            this.maxInstances_ = 0;
            this.vpcConnector_ = "";
            this.vpcConnectorEgressSettings_ = 0;
            this.ingressSettings_ = 0;
            this.buildId_ = "";
            this.sourceCodeCase_ = 0;
            this.sourceCode_ = null;
            this.triggerCase_ = 0;
            this.trigger_ = null;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return FunctionsProto.internal_static_google_cloud_functions_v1_CloudFunction_descriptor;
        }

        public CloudFunction getDefaultInstanceForType() {
            return CloudFunction.getDefaultInstance();
        }

        public CloudFunction build() {
            CloudFunction result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public CloudFunction buildPartial() {
            CloudFunction result = new CloudFunction(this);
            int from_bitField0_ = this.bitField0_;
            result.name_ = this.name_;
            result.description_ = this.description_;
            if (this.sourceCodeCase_ == 3) {
                result.sourceCode_ = this.sourceCode_;
            }
            if (this.sourceCodeCase_ == 4) {
                if (this.sourceRepositoryBuilder_ == null) {
                    result.sourceCode_ = this.sourceCode_;
                } else {
                    result.sourceCode_ = this.sourceRepositoryBuilder_.build();
                }
            }
            if (this.sourceCodeCase_ == 16) {
                result.sourceCode_ = this.sourceCode_;
            }
            if (this.triggerCase_ == 5) {
                if (this.httpsTriggerBuilder_ == null) {
                    result.trigger_ = this.trigger_;
                } else {
                    result.trigger_ = this.httpsTriggerBuilder_.build();
                }
            }
            if (this.triggerCase_ == 6) {
                if (this.eventTriggerBuilder_ == null) {
                    result.trigger_ = this.trigger_;
                } else {
                    result.trigger_ = this.eventTriggerBuilder_.build();
                }
            }
            result.status_ = this.status_;
            result.entryPoint_ = this.entryPoint_;
            result.runtime_ = this.runtime_;
            if (this.timeoutBuilder_ == null) {
                result.timeout_ = this.timeout_;
            } else {
                result.timeout_ = (Duration)this.timeoutBuilder_.build();
            }
            result.availableMemoryMb_ = this.availableMemoryMb_;
            result.serviceAccountEmail_ = this.serviceAccountEmail_;
            if (this.updateTimeBuilder_ == null) {
                result.updateTime_ = this.updateTime_;
            } else {
                result.updateTime_ = (Timestamp)this.updateTimeBuilder_.build();
            }
            result.versionId_ = this.versionId_;
            result.labels_ = this.internalGetLabels();
            result.labels_.makeImmutable();
            result.environmentVariables_ = this.internalGetEnvironmentVariables();
            result.environmentVariables_.makeImmutable();
            result.network_ = this.network_;
            result.maxInstances_ = this.maxInstances_;
            result.vpcConnector_ = this.vpcConnector_;
            result.vpcConnectorEgressSettings_ = this.vpcConnectorEgressSettings_;
            result.ingressSettings_ = this.ingressSettings_;
            result.buildId_ = this.buildId_;
            result.sourceCodeCase_ = this.sourceCodeCase_;
            result.triggerCase_ = this.triggerCase_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof CloudFunction) {
                return this.mergeFrom((CloudFunction)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(CloudFunction other) {
            if (other == CloudFunction.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.onChanged();
            }
            if (!other.getDescription().isEmpty()) {
                this.description_ = other.description_;
                this.onChanged();
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            if (!other.getEntryPoint().isEmpty()) {
                this.entryPoint_ = other.entryPoint_;
                this.onChanged();
            }
            if (!other.getRuntime().isEmpty()) {
                this.runtime_ = other.runtime_;
                this.onChanged();
            }
            if (other.hasTimeout()) {
                this.mergeTimeout(other.getTimeout());
            }
            if (other.getAvailableMemoryMb() != 0) {
                this.setAvailableMemoryMb(other.getAvailableMemoryMb());
            }
            if (!other.getServiceAccountEmail().isEmpty()) {
                this.serviceAccountEmail_ = other.serviceAccountEmail_;
                this.onChanged();
            }
            if (other.hasUpdateTime()) {
                this.mergeUpdateTime(other.getUpdateTime());
            }
            if (other.getVersionId() != 0L) {
                this.setVersionId(other.getVersionId());
            }
            this.internalGetMutableLabels().mergeFrom(other.internalGetLabels());
            this.internalGetMutableEnvironmentVariables().mergeFrom(other.internalGetEnvironmentVariables());
            if (!other.getNetwork().isEmpty()) {
                this.network_ = other.network_;
                this.onChanged();
            }
            if (other.getMaxInstances() != 0) {
                this.setMaxInstances(other.getMaxInstances());
            }
            if (!other.getVpcConnector().isEmpty()) {
                this.vpcConnector_ = other.vpcConnector_;
                this.onChanged();
            }
            if (other.vpcConnectorEgressSettings_ != 0) {
                this.setVpcConnectorEgressSettingsValue(other.getVpcConnectorEgressSettingsValue());
            }
            if (other.ingressSettings_ != 0) {
                this.setIngressSettingsValue(other.getIngressSettingsValue());
            }
            if (!other.getBuildId().isEmpty()) {
                this.buildId_ = other.buildId_;
                this.onChanged();
            }
            switch (other.getSourceCodeCase()) {
                case SOURCE_ARCHIVE_URL: {
                    this.sourceCodeCase_ = 3;
                    this.sourceCode_ = other.sourceCode_;
                    this.onChanged();
                    break;
                }
                case SOURCE_REPOSITORY: {
                    this.mergeSourceRepository(other.getSourceRepository());
                    break;
                }
                case SOURCE_UPLOAD_URL: {
                    this.sourceCodeCase_ = 16;
                    this.sourceCode_ = other.sourceCode_;
                    this.onChanged();
                    break;
                }
            }
            switch (other.getTriggerCase()) {
                case HTTPS_TRIGGER: {
                    this.mergeHttpsTrigger(other.getHttpsTrigger());
                    break;
                }
                case EVENT_TRIGGER: {
                    this.mergeEventTrigger(other.getEventTrigger());
                    break;
                }
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            CloudFunction parsedMessage = null;
            try {
                parsedMessage = (CloudFunction)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (CloudFunction)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public SourceCodeCase getSourceCodeCase() {
            return SourceCodeCase.forNumber(this.sourceCodeCase_);
        }

        public Builder clearSourceCode() {
            this.sourceCodeCase_ = 0;
            this.sourceCode_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public TriggerCase getTriggerCase() {
            return TriggerCase.forNumber(this.triggerCase_);
        }

        public Builder clearTrigger() {
            this.triggerCase_ = 0;
            this.trigger_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = CloudFunction.getDefaultInstance().getName();
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CloudFunction.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getDescription() {
            Object ref = this.description_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.description_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDescriptionBytes() {
            Object ref = this.description_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.description_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDescription(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.description_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearDescription() {
            this.description_ = CloudFunction.getDefaultInstance().getDescription();
            this.onChanged();
            return this;
        }

        public Builder setDescriptionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CloudFunction.checkByteStringIsUtf8((ByteString)value);
            this.description_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasSourceArchiveUrl() {
            return this.sourceCodeCase_ == 3;
        }

        @Override
        public String getSourceArchiveUrl() {
            Object ref = "";
            if (this.sourceCodeCase_ == 3) {
                ref = this.sourceCode_;
            }
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                if (this.sourceCodeCase_ == 3) {
                    this.sourceCode_ = s;
                }
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getSourceArchiveUrlBytes() {
            Object ref = "";
            if (this.sourceCodeCase_ == 3) {
                ref = this.sourceCode_;
            }
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                if (this.sourceCodeCase_ == 3) {
                    this.sourceCode_ = b;
                }
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setSourceArchiveUrl(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.sourceCodeCase_ = 3;
            this.sourceCode_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearSourceArchiveUrl() {
            if (this.sourceCodeCase_ == 3) {
                this.sourceCodeCase_ = 0;
                this.sourceCode_ = null;
                this.onChanged();
            }
            return this;
        }

        public Builder setSourceArchiveUrlBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CloudFunction.checkByteStringIsUtf8((ByteString)value);
            this.sourceCodeCase_ = 3;
            this.sourceCode_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasSourceRepository() {
            return this.sourceCodeCase_ == 4;
        }

        @Override
        public SourceRepository getSourceRepository() {
            if (this.sourceRepositoryBuilder_ == null) {
                if (this.sourceCodeCase_ == 4) {
                    return (SourceRepository)this.sourceCode_;
                }
                return SourceRepository.getDefaultInstance();
            }
            if (this.sourceCodeCase_ == 4) {
                return (SourceRepository)this.sourceRepositoryBuilder_.getMessage();
            }
            return SourceRepository.getDefaultInstance();
        }

        public Builder setSourceRepository(SourceRepository value) {
            if (this.sourceRepositoryBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.sourceCode_ = value;
                this.onChanged();
            } else {
                this.sourceRepositoryBuilder_.setMessage((AbstractMessage)value);
            }
            this.sourceCodeCase_ = 4;
            return this;
        }

        public Builder setSourceRepository(SourceRepository.Builder builderForValue) {
            if (this.sourceRepositoryBuilder_ == null) {
                this.sourceCode_ = builderForValue.build();
                this.onChanged();
            } else {
                this.sourceRepositoryBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.sourceCodeCase_ = 4;
            return this;
        }

        public Builder mergeSourceRepository(SourceRepository value) {
            if (this.sourceRepositoryBuilder_ == null) {
                this.sourceCode_ = this.sourceCodeCase_ == 4 && this.sourceCode_ != SourceRepository.getDefaultInstance() ? SourceRepository.newBuilder((SourceRepository)this.sourceCode_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                if (this.sourceCodeCase_ == 4) {
                    this.sourceRepositoryBuilder_.mergeFrom((AbstractMessage)value);
                }
                this.sourceRepositoryBuilder_.setMessage((AbstractMessage)value);
            }
            this.sourceCodeCase_ = 4;
            return this;
        }

        public Builder clearSourceRepository() {
            if (this.sourceRepositoryBuilder_ == null) {
                if (this.sourceCodeCase_ == 4) {
                    this.sourceCodeCase_ = 0;
                    this.sourceCode_ = null;
                    this.onChanged();
                }
            } else {
                if (this.sourceCodeCase_ == 4) {
                    this.sourceCodeCase_ = 0;
                    this.sourceCode_ = null;
                }
                this.sourceRepositoryBuilder_.clear();
            }
            return this;
        }

        public SourceRepository.Builder getSourceRepositoryBuilder() {
            return (SourceRepository.Builder)this.getSourceRepositoryFieldBuilder().getBuilder();
        }

        @Override
        public SourceRepositoryOrBuilder getSourceRepositoryOrBuilder() {
            if (this.sourceCodeCase_ == 4 && this.sourceRepositoryBuilder_ != null) {
                return (SourceRepositoryOrBuilder)this.sourceRepositoryBuilder_.getMessageOrBuilder();
            }
            if (this.sourceCodeCase_ == 4) {
                return (SourceRepository)this.sourceCode_;
            }
            return SourceRepository.getDefaultInstance();
        }

        private SingleFieldBuilderV3<SourceRepository, SourceRepository.Builder, SourceRepositoryOrBuilder> getSourceRepositoryFieldBuilder() {
            if (this.sourceRepositoryBuilder_ == null) {
                if (this.sourceCodeCase_ != 4) {
                    this.sourceCode_ = SourceRepository.getDefaultInstance();
                }
                this.sourceRepositoryBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((SourceRepository)this.sourceCode_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.sourceCode_ = null;
            }
            this.sourceCodeCase_ = 4;
            this.onChanged();
            return this.sourceRepositoryBuilder_;
        }

        @Override
        public boolean hasSourceUploadUrl() {
            return this.sourceCodeCase_ == 16;
        }

        @Override
        public String getSourceUploadUrl() {
            Object ref = "";
            if (this.sourceCodeCase_ == 16) {
                ref = this.sourceCode_;
            }
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                if (this.sourceCodeCase_ == 16) {
                    this.sourceCode_ = s;
                }
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getSourceUploadUrlBytes() {
            Object ref = "";
            if (this.sourceCodeCase_ == 16) {
                ref = this.sourceCode_;
            }
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                if (this.sourceCodeCase_ == 16) {
                    this.sourceCode_ = b;
                }
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setSourceUploadUrl(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.sourceCodeCase_ = 16;
            this.sourceCode_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearSourceUploadUrl() {
            if (this.sourceCodeCase_ == 16) {
                this.sourceCodeCase_ = 0;
                this.sourceCode_ = null;
                this.onChanged();
            }
            return this;
        }

        public Builder setSourceUploadUrlBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CloudFunction.checkByteStringIsUtf8((ByteString)value);
            this.sourceCodeCase_ = 16;
            this.sourceCode_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasHttpsTrigger() {
            return this.triggerCase_ == 5;
        }

        @Override
        public HttpsTrigger getHttpsTrigger() {
            if (this.httpsTriggerBuilder_ == null) {
                if (this.triggerCase_ == 5) {
                    return (HttpsTrigger)this.trigger_;
                }
                return HttpsTrigger.getDefaultInstance();
            }
            if (this.triggerCase_ == 5) {
                return (HttpsTrigger)this.httpsTriggerBuilder_.getMessage();
            }
            return HttpsTrigger.getDefaultInstance();
        }

        public Builder setHttpsTrigger(HttpsTrigger value) {
            if (this.httpsTriggerBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.trigger_ = value;
                this.onChanged();
            } else {
                this.httpsTriggerBuilder_.setMessage((AbstractMessage)value);
            }
            this.triggerCase_ = 5;
            return this;
        }

        public Builder setHttpsTrigger(HttpsTrigger.Builder builderForValue) {
            if (this.httpsTriggerBuilder_ == null) {
                this.trigger_ = builderForValue.build();
                this.onChanged();
            } else {
                this.httpsTriggerBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.triggerCase_ = 5;
            return this;
        }

        public Builder mergeHttpsTrigger(HttpsTrigger value) {
            if (this.httpsTriggerBuilder_ == null) {
                this.trigger_ = this.triggerCase_ == 5 && this.trigger_ != HttpsTrigger.getDefaultInstance() ? HttpsTrigger.newBuilder((HttpsTrigger)this.trigger_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                if (this.triggerCase_ == 5) {
                    this.httpsTriggerBuilder_.mergeFrom((AbstractMessage)value);
                }
                this.httpsTriggerBuilder_.setMessage((AbstractMessage)value);
            }
            this.triggerCase_ = 5;
            return this;
        }

        public Builder clearHttpsTrigger() {
            if (this.httpsTriggerBuilder_ == null) {
                if (this.triggerCase_ == 5) {
                    this.triggerCase_ = 0;
                    this.trigger_ = null;
                    this.onChanged();
                }
            } else {
                if (this.triggerCase_ == 5) {
                    this.triggerCase_ = 0;
                    this.trigger_ = null;
                }
                this.httpsTriggerBuilder_.clear();
            }
            return this;
        }

        public HttpsTrigger.Builder getHttpsTriggerBuilder() {
            return (HttpsTrigger.Builder)this.getHttpsTriggerFieldBuilder().getBuilder();
        }

        @Override
        public HttpsTriggerOrBuilder getHttpsTriggerOrBuilder() {
            if (this.triggerCase_ == 5 && this.httpsTriggerBuilder_ != null) {
                return (HttpsTriggerOrBuilder)this.httpsTriggerBuilder_.getMessageOrBuilder();
            }
            if (this.triggerCase_ == 5) {
                return (HttpsTrigger)this.trigger_;
            }
            return HttpsTrigger.getDefaultInstance();
        }

        private SingleFieldBuilderV3<HttpsTrigger, HttpsTrigger.Builder, HttpsTriggerOrBuilder> getHttpsTriggerFieldBuilder() {
            if (this.httpsTriggerBuilder_ == null) {
                if (this.triggerCase_ != 5) {
                    this.trigger_ = HttpsTrigger.getDefaultInstance();
                }
                this.httpsTriggerBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((HttpsTrigger)this.trigger_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.trigger_ = null;
            }
            this.triggerCase_ = 5;
            this.onChanged();
            return this.httpsTriggerBuilder_;
        }

        @Override
        public boolean hasEventTrigger() {
            return this.triggerCase_ == 6;
        }

        @Override
        public EventTrigger getEventTrigger() {
            if (this.eventTriggerBuilder_ == null) {
                if (this.triggerCase_ == 6) {
                    return (EventTrigger)this.trigger_;
                }
                return EventTrigger.getDefaultInstance();
            }
            if (this.triggerCase_ == 6) {
                return (EventTrigger)this.eventTriggerBuilder_.getMessage();
            }
            return EventTrigger.getDefaultInstance();
        }

        public Builder setEventTrigger(EventTrigger value) {
            if (this.eventTriggerBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.trigger_ = value;
                this.onChanged();
            } else {
                this.eventTriggerBuilder_.setMessage((AbstractMessage)value);
            }
            this.triggerCase_ = 6;
            return this;
        }

        public Builder setEventTrigger(EventTrigger.Builder builderForValue) {
            if (this.eventTriggerBuilder_ == null) {
                this.trigger_ = builderForValue.build();
                this.onChanged();
            } else {
                this.eventTriggerBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.triggerCase_ = 6;
            return this;
        }

        public Builder mergeEventTrigger(EventTrigger value) {
            if (this.eventTriggerBuilder_ == null) {
                this.trigger_ = this.triggerCase_ == 6 && this.trigger_ != EventTrigger.getDefaultInstance() ? EventTrigger.newBuilder((EventTrigger)this.trigger_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                if (this.triggerCase_ == 6) {
                    this.eventTriggerBuilder_.mergeFrom((AbstractMessage)value);
                }
                this.eventTriggerBuilder_.setMessage((AbstractMessage)value);
            }
            this.triggerCase_ = 6;
            return this;
        }

        public Builder clearEventTrigger() {
            if (this.eventTriggerBuilder_ == null) {
                if (this.triggerCase_ == 6) {
                    this.triggerCase_ = 0;
                    this.trigger_ = null;
                    this.onChanged();
                }
            } else {
                if (this.triggerCase_ == 6) {
                    this.triggerCase_ = 0;
                    this.trigger_ = null;
                }
                this.eventTriggerBuilder_.clear();
            }
            return this;
        }

        public EventTrigger.Builder getEventTriggerBuilder() {
            return (EventTrigger.Builder)this.getEventTriggerFieldBuilder().getBuilder();
        }

        @Override
        public EventTriggerOrBuilder getEventTriggerOrBuilder() {
            if (this.triggerCase_ == 6 && this.eventTriggerBuilder_ != null) {
                return (EventTriggerOrBuilder)this.eventTriggerBuilder_.getMessageOrBuilder();
            }
            if (this.triggerCase_ == 6) {
                return (EventTrigger)this.trigger_;
            }
            return EventTrigger.getDefaultInstance();
        }

        private SingleFieldBuilderV3<EventTrigger, EventTrigger.Builder, EventTriggerOrBuilder> getEventTriggerFieldBuilder() {
            if (this.eventTriggerBuilder_ == null) {
                if (this.triggerCase_ != 6) {
                    this.trigger_ = EventTrigger.getDefaultInstance();
                }
                this.eventTriggerBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((EventTrigger)this.trigger_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.trigger_ = null;
            }
            this.triggerCase_ = 6;
            this.onChanged();
            return this.eventTriggerBuilder_;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public CloudFunctionStatus getStatus() {
            CloudFunctionStatus result = CloudFunctionStatus.valueOf(this.status_);
            return result == null ? CloudFunctionStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(CloudFunctionStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getEntryPoint() {
            Object ref = this.entryPoint_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.entryPoint_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getEntryPointBytes() {
            Object ref = this.entryPoint_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.entryPoint_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setEntryPoint(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.entryPoint_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearEntryPoint() {
            this.entryPoint_ = CloudFunction.getDefaultInstance().getEntryPoint();
            this.onChanged();
            return this;
        }

        public Builder setEntryPointBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CloudFunction.checkByteStringIsUtf8((ByteString)value);
            this.entryPoint_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getRuntime() {
            Object ref = this.runtime_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.runtime_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRuntimeBytes() {
            Object ref = this.runtime_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.runtime_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRuntime(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.runtime_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearRuntime() {
            this.runtime_ = CloudFunction.getDefaultInstance().getRuntime();
            this.onChanged();
            return this;
        }

        public Builder setRuntimeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CloudFunction.checkByteStringIsUtf8((ByteString)value);
            this.runtime_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTimeout() {
            return this.timeoutBuilder_ != null || this.timeout_ != null;
        }

        @Override
        public Duration getTimeout() {
            if (this.timeoutBuilder_ == null) {
                return this.timeout_ == null ? Duration.getDefaultInstance() : this.timeout_;
            }
            return (Duration)this.timeoutBuilder_.getMessage();
        }

        public Builder setTimeout(Duration value) {
            if (this.timeoutBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.timeout_ = value;
                this.onChanged();
            } else {
                this.timeoutBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setTimeout(Duration.Builder builderForValue) {
            if (this.timeoutBuilder_ == null) {
                this.timeout_ = builderForValue.build();
                this.onChanged();
            } else {
                this.timeoutBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeTimeout(Duration value) {
            if (this.timeoutBuilder_ == null) {
                this.timeout_ = this.timeout_ != null ? Duration.newBuilder((Duration)this.timeout_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.timeoutBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearTimeout() {
            if (this.timeoutBuilder_ == null) {
                this.timeout_ = null;
                this.onChanged();
            } else {
                this.timeout_ = null;
                this.timeoutBuilder_ = null;
            }
            return this;
        }

        public Duration.Builder getTimeoutBuilder() {
            this.onChanged();
            return (Duration.Builder)this.getTimeoutFieldBuilder().getBuilder();
        }

        @Override
        public DurationOrBuilder getTimeoutOrBuilder() {
            if (this.timeoutBuilder_ != null) {
                return (DurationOrBuilder)this.timeoutBuilder_.getMessageOrBuilder();
            }
            return this.timeout_ == null ? Duration.getDefaultInstance() : this.timeout_;
        }

        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getTimeoutFieldBuilder() {
            if (this.timeoutBuilder_ == null) {
                this.timeoutBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTimeout(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.timeout_ = null;
            }
            return this.timeoutBuilder_;
        }

        @Override
        public int getAvailableMemoryMb() {
            return this.availableMemoryMb_;
        }

        public Builder setAvailableMemoryMb(int value) {
            this.availableMemoryMb_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearAvailableMemoryMb() {
            this.availableMemoryMb_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getServiceAccountEmail() {
            Object ref = this.serviceAccountEmail_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.serviceAccountEmail_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getServiceAccountEmailBytes() {
            Object ref = this.serviceAccountEmail_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.serviceAccountEmail_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setServiceAccountEmail(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.serviceAccountEmail_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearServiceAccountEmail() {
            this.serviceAccountEmail_ = CloudFunction.getDefaultInstance().getServiceAccountEmail();
            this.onChanged();
            return this;
        }

        public Builder setServiceAccountEmailBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CloudFunction.checkByteStringIsUtf8((ByteString)value);
            this.serviceAccountEmail_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasUpdateTime() {
            return this.updateTimeBuilder_ != null || this.updateTime_ != null;
        }

        @Override
        public Timestamp getUpdateTime() {
            if (this.updateTimeBuilder_ == null) {
                return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
            }
            return (Timestamp)this.updateTimeBuilder_.getMessage();
        }

        public Builder setUpdateTime(Timestamp value) {
            if (this.updateTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.updateTime_ = value;
                this.onChanged();
            } else {
                this.updateTimeBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setUpdateTime(Timestamp.Builder builderForValue) {
            if (this.updateTimeBuilder_ == null) {
                this.updateTime_ = builderForValue.build();
                this.onChanged();
            } else {
                this.updateTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeUpdateTime(Timestamp value) {
            if (this.updateTimeBuilder_ == null) {
                this.updateTime_ = this.updateTime_ != null ? Timestamp.newBuilder((Timestamp)this.updateTime_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.updateTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearUpdateTime() {
            if (this.updateTimeBuilder_ == null) {
                this.updateTime_ = null;
                this.onChanged();
            } else {
                this.updateTime_ = null;
                this.updateTimeBuilder_ = null;
            }
            return this;
        }

        public Timestamp.Builder getUpdateTimeBuilder() {
            this.onChanged();
            return (Timestamp.Builder)this.getUpdateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getUpdateTimeOrBuilder() {
            if (this.updateTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.updateTimeBuilder_.getMessageOrBuilder();
            }
            return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getUpdateTimeFieldBuilder() {
            if (this.updateTimeBuilder_ == null) {
                this.updateTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getUpdateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.updateTime_ = null;
            }
            return this.updateTimeBuilder_;
        }

        @Override
        public long getVersionId() {
            return this.versionId_;
        }

        public Builder setVersionId(long value) {
            this.versionId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearVersionId() {
            this.versionId_ = 0L;
            this.onChanged();
            return this;
        }

        private MapField<String, String> internalGetLabels() {
            if (this.labels_ == null) {
                return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            return this.labels_;
        }

        private MapField<String, String> internalGetMutableLabels() {
            this.onChanged();
            if (this.labels_ == null) {
                this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            if (!this.labels_.isMutable()) {
                this.labels_ = this.labels_.copy();
            }
            return this.labels_;
        }

        @Override
        public int getLabelsCount() {
            return this.internalGetLabels().getMap().size();
        }

        @Override
        public boolean containsLabels(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            return this.internalGetLabels().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getLabels() {
            return this.getLabelsMap();
        }

        @Override
        public Map<String, String> getLabelsMap() {
            return this.internalGetLabels().getMap();
        }

        @Override
        public String getLabelsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException();
            }
            Map map = this.internalGetLabels().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getLabelsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Map map = this.internalGetLabels().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearLabels() {
            this.internalGetMutableLabels().getMutableMap().clear();
            return this;
        }

        public Builder removeLabels(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            this.internalGetMutableLabels().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableLabels() {
            return this.internalGetMutableLabels().getMutableMap();
        }

        public Builder putLabels(String key, String value) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (value == null) {
                throw new NullPointerException();
            }
            this.internalGetMutableLabels().getMutableMap().put(key, value);
            return this;
        }

        public Builder putAllLabels(Map<String, String> values) {
            this.internalGetMutableLabels().getMutableMap().putAll(values);
            return this;
        }

        private MapField<String, String> internalGetEnvironmentVariables() {
            if (this.environmentVariables_ == null) {
                return MapField.emptyMapField(EnvironmentVariablesDefaultEntryHolder.defaultEntry);
            }
            return this.environmentVariables_;
        }

        private MapField<String, String> internalGetMutableEnvironmentVariables() {
            this.onChanged();
            if (this.environmentVariables_ == null) {
                this.environmentVariables_ = MapField.newMapField(EnvironmentVariablesDefaultEntryHolder.defaultEntry);
            }
            if (!this.environmentVariables_.isMutable()) {
                this.environmentVariables_ = this.environmentVariables_.copy();
            }
            return this.environmentVariables_;
        }

        @Override
        public int getEnvironmentVariablesCount() {
            return this.internalGetEnvironmentVariables().getMap().size();
        }

        @Override
        public boolean containsEnvironmentVariables(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            return this.internalGetEnvironmentVariables().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getEnvironmentVariables() {
            return this.getEnvironmentVariablesMap();
        }

        @Override
        public Map<String, String> getEnvironmentVariablesMap() {
            return this.internalGetEnvironmentVariables().getMap();
        }

        @Override
        public String getEnvironmentVariablesOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException();
            }
            Map map = this.internalGetEnvironmentVariables().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getEnvironmentVariablesOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Map map = this.internalGetEnvironmentVariables().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearEnvironmentVariables() {
            this.internalGetMutableEnvironmentVariables().getMutableMap().clear();
            return this;
        }

        public Builder removeEnvironmentVariables(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            this.internalGetMutableEnvironmentVariables().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableEnvironmentVariables() {
            return this.internalGetMutableEnvironmentVariables().getMutableMap();
        }

        public Builder putEnvironmentVariables(String key, String value) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (value == null) {
                throw new NullPointerException();
            }
            this.internalGetMutableEnvironmentVariables().getMutableMap().put(key, value);
            return this;
        }

        public Builder putAllEnvironmentVariables(Map<String, String> values) {
            this.internalGetMutableEnvironmentVariables().getMutableMap().putAll(values);
            return this;
        }

        @Override
        public String getNetwork() {
            Object ref = this.network_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.network_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNetworkBytes() {
            Object ref = this.network_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.network_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setNetwork(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.network_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearNetwork() {
            this.network_ = CloudFunction.getDefaultInstance().getNetwork();
            this.onChanged();
            return this;
        }

        public Builder setNetworkBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CloudFunction.checkByteStringIsUtf8((ByteString)value);
            this.network_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public int getMaxInstances() {
            return this.maxInstances_;
        }

        public Builder setMaxInstances(int value) {
            this.maxInstances_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearMaxInstances() {
            this.maxInstances_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getVpcConnector() {
            Object ref = this.vpcConnector_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.vpcConnector_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getVpcConnectorBytes() {
            Object ref = this.vpcConnector_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.vpcConnector_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setVpcConnector(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.vpcConnector_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearVpcConnector() {
            this.vpcConnector_ = CloudFunction.getDefaultInstance().getVpcConnector();
            this.onChanged();
            return this;
        }

        public Builder setVpcConnectorBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CloudFunction.checkByteStringIsUtf8((ByteString)value);
            this.vpcConnector_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public int getVpcConnectorEgressSettingsValue() {
            return this.vpcConnectorEgressSettings_;
        }

        public Builder setVpcConnectorEgressSettingsValue(int value) {
            this.vpcConnectorEgressSettings_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public VpcConnectorEgressSettings getVpcConnectorEgressSettings() {
            VpcConnectorEgressSettings result = VpcConnectorEgressSettings.valueOf(this.vpcConnectorEgressSettings_);
            return result == null ? VpcConnectorEgressSettings.UNRECOGNIZED : result;
        }

        public Builder setVpcConnectorEgressSettings(VpcConnectorEgressSettings value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.vpcConnectorEgressSettings_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearVpcConnectorEgressSettings() {
            this.vpcConnectorEgressSettings_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getIngressSettingsValue() {
            return this.ingressSettings_;
        }

        public Builder setIngressSettingsValue(int value) {
            this.ingressSettings_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public IngressSettings getIngressSettings() {
            IngressSettings result = IngressSettings.valueOf(this.ingressSettings_);
            return result == null ? IngressSettings.UNRECOGNIZED : result;
        }

        public Builder setIngressSettings(IngressSettings value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ingressSettings_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearIngressSettings() {
            this.ingressSettings_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getBuildId() {
            Object ref = this.buildId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.buildId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getBuildIdBytes() {
            Object ref = this.buildId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.buildId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setBuildId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.buildId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearBuildId() {
            this.buildId_ = CloudFunction.getDefaultInstance().getBuildId();
            this.onChanged();
            return this;
        }

        public Builder setBuildIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CloudFunction.checkByteStringIsUtf8((ByteString)value);
            this.buildId_ = value;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class EnvironmentVariablesDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)FunctionsProto.internal_static_google_cloud_functions_v1_CloudFunction_EnvironmentVariablesEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private EnvironmentVariablesDefaultEntryHolder() {
        }
    }

    private static final class LabelsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)FunctionsProto.internal_static_google_cloud_functions_v1_CloudFunction_LabelsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private LabelsDefaultEntryHolder() {
        }
    }

    public static enum TriggerCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        HTTPS_TRIGGER(5),
        EVENT_TRIGGER(6),
        TRIGGER_NOT_SET(0);

        private final int value;

        private TriggerCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static TriggerCase valueOf(int value) {
            return TriggerCase.forNumber(value);
        }

        public static TriggerCase forNumber(int value) {
            switch (value) {
                case 5: {
                    return HTTPS_TRIGGER;
                }
                case 6: {
                    return EVENT_TRIGGER;
                }
                case 0: {
                    return TRIGGER_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }

    public static enum SourceCodeCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        SOURCE_ARCHIVE_URL(3),
        SOURCE_REPOSITORY(4),
        SOURCE_UPLOAD_URL(16),
        SOURCECODE_NOT_SET(0);

        private final int value;

        private SourceCodeCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static SourceCodeCase valueOf(int value) {
            return SourceCodeCase.forNumber(value);
        }

        public static SourceCodeCase forNumber(int value) {
            switch (value) {
                case 3: {
                    return SOURCE_ARCHIVE_URL;
                }
                case 4: {
                    return SOURCE_REPOSITORY;
                }
                case 16: {
                    return SOURCE_UPLOAD_URL;
                }
                case 0: {
                    return SOURCECODE_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }

    public static enum IngressSettings implements ProtocolMessageEnum
    {
        INGRESS_SETTINGS_UNSPECIFIED(0),
        ALLOW_ALL(1),
        ALLOW_INTERNAL_ONLY(2),
        ALLOW_INTERNAL_AND_GCLB(3),
        UNRECOGNIZED(-1);

        public static final int INGRESS_SETTINGS_UNSPECIFIED_VALUE = 0;
        public static final int ALLOW_ALL_VALUE = 1;
        public static final int ALLOW_INTERNAL_ONLY_VALUE = 2;
        public static final int ALLOW_INTERNAL_AND_GCLB_VALUE = 3;
        private static final Internal.EnumLiteMap<IngressSettings> internalValueMap;
        private static final IngressSettings[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static IngressSettings valueOf(int value) {
            return IngressSettings.forNumber(value);
        }

        public static IngressSettings forNumber(int value) {
            switch (value) {
                case 0: {
                    return INGRESS_SETTINGS_UNSPECIFIED;
                }
                case 1: {
                    return ALLOW_ALL;
                }
                case 2: {
                    return ALLOW_INTERNAL_ONLY;
                }
                case 3: {
                    return ALLOW_INTERNAL_AND_GCLB;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<IngressSettings> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)IngressSettings.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return IngressSettings.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)CloudFunction.getDescriptor().getEnumTypes().get(1);
        }

        public static IngressSettings valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != IngressSettings.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private IngressSettings(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<IngressSettings>(){

                public IngressSettings findValueByNumber(int number) {
                    return IngressSettings.forNumber(number);
                }
            };
            VALUES = IngressSettings.values();
        }
    }

    public static enum VpcConnectorEgressSettings implements ProtocolMessageEnum
    {
        VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED(0),
        PRIVATE_RANGES_ONLY(1),
        ALL_TRAFFIC(2),
        UNRECOGNIZED(-1);

        public static final int VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED_VALUE = 0;
        public static final int PRIVATE_RANGES_ONLY_VALUE = 1;
        public static final int ALL_TRAFFIC_VALUE = 2;
        private static final Internal.EnumLiteMap<VpcConnectorEgressSettings> internalValueMap;
        private static final VpcConnectorEgressSettings[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static VpcConnectorEgressSettings valueOf(int value) {
            return VpcConnectorEgressSettings.forNumber(value);
        }

        public static VpcConnectorEgressSettings forNumber(int value) {
            switch (value) {
                case 0: {
                    return VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED;
                }
                case 1: {
                    return PRIVATE_RANGES_ONLY;
                }
                case 2: {
                    return ALL_TRAFFIC;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<VpcConnectorEgressSettings> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)VpcConnectorEgressSettings.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return VpcConnectorEgressSettings.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)CloudFunction.getDescriptor().getEnumTypes().get(0);
        }

        public static VpcConnectorEgressSettings valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != VpcConnectorEgressSettings.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private VpcConnectorEgressSettings(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<VpcConnectorEgressSettings>(){

                public VpcConnectorEgressSettings findValueByNumber(int number) {
                    return VpcConnectorEgressSettings.forNumber(number);
                }
            };
            VALUES = VpcConnectorEgressSettings.values();
        }
    }
}

