/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AnyPathName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}/documents/{document}/{any_path=**}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String database;
    private final String document;
    private final String anyPath;

    public String getProject() {
        return this.project;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getDocument() {
        return this.document;
    }

    public String getAnyPath() {
        return this.anyPath;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AnyPathName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
        this.document = (String)Preconditions.checkNotNull((Object)builder.getDocument());
        this.anyPath = (String)Preconditions.checkNotNull((Object)builder.getAnyPath());
    }

    public static AnyPathName of(String project, String database, String document, String anyPath) {
        return AnyPathName.newBuilder().setProject(project).setDatabase(database).setDocument(document).setAnyPath(anyPath).build();
    }

    public static String format(String project, String database, String document, String anyPath) {
        return AnyPathName.newBuilder().setProject(project).setDatabase(database).setDocument(document).setAnyPath(anyPath).build().toString();
    }

    public static AnyPathName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AnyPathName.parse: formattedString not in valid format");
        return AnyPathName.of((String)matchMap.get("project"), (String)matchMap.get("database"), (String)matchMap.get("document"), (String)matchMap.get("any_path"));
    }

    public static List<AnyPathName> parseList(List<String> formattedStrings) {
        ArrayList<AnyPathName> list = new ArrayList<AnyPathName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AnyPathName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AnyPathName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AnyPathName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AnyPathName anyPathName = this;
            synchronized (anyPathName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"database", (Object)this.database);
                    fieldMapBuilder.put((Object)"document", (Object)this.document);
                    fieldMapBuilder.put((Object)"anyPath", (Object)this.anyPath);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "database", this.database, "document", this.document, "any_path", this.anyPath});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AnyPathName) {
            AnyPathName that = (AnyPathName)o;
            return this.project.equals(that.project) && this.database.equals(that.database) && this.document.equals(that.document) && this.anyPath.equals(that.anyPath);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.database.hashCode();
        h *= 1000003;
        h ^= this.document.hashCode();
        h *= 1000003;
        return h ^= this.anyPath.hashCode();
    }

    public static class Builder {
        private String project;
        private String database;
        private String document;
        private String anyPath;

        public String getProject() {
            return this.project;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getDocument() {
            return this.document;
        }

        public String getAnyPath() {
            return this.anyPath;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setDocument(String document) {
            this.document = document;
            return this;
        }

        public Builder setAnyPath(String anyPath) {
            this.anyPath = anyPath;
            return this;
        }

        private Builder() {
        }

        private Builder(AnyPathName anyPathName) {
            this.project = anyPathName.project;
            this.database = anyPathName.database;
            this.document = anyPathName.document;
            this.anyPath = anyPathName.anyPath;
        }

        public AnyPathName build() {
            return new AnyPathName(this);
        }
    }
}

