/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/firestore.proto

package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * The request for [Firestore.PartitionQuery][google.firestore.v1.Firestore.PartitionQuery].
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.PartitionQueryRequest}
 */
public final class PartitionQueryRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.PartitionQueryRequest)
    PartitionQueryRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PartitionQueryRequest.newBuilder() to construct.
  private PartitionQueryRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PartitionQueryRequest() {
    parent_ = "";
    pageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PartitionQueryRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private PartitionQueryRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              parent_ = s;
              break;
            }
          case 18:
            {
              com.google.firestore.v1.StructuredQuery.Builder subBuilder = null;
              if (queryTypeCase_ == 2) {
                subBuilder = ((com.google.firestore.v1.StructuredQuery) queryType_).toBuilder();
              }
              queryType_ =
                  input.readMessage(
                      com.google.firestore.v1.StructuredQuery.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.firestore.v1.StructuredQuery) queryType_);
                queryType_ = subBuilder.buildPartial();
              }
              queryTypeCase_ = 2;
              break;
            }
          case 24:
            {
              partitionCount_ = input.readInt64();
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              pageToken_ = s;
              break;
            }
          case 40:
            {
              pageSize_ = input.readInt32();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_PartitionQueryRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_PartitionQueryRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.PartitionQueryRequest.class,
            com.google.firestore.v1.PartitionQueryRequest.Builder.class);
  }

  private int queryTypeCase_ = 0;
  private java.lang.Object queryType_;

  public enum QueryTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STRUCTURED_QUERY(2),
    QUERYTYPE_NOT_SET(0);
    private final int value;

    private QueryTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueryTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static QueryTypeCase forNumber(int value) {
      switch (value) {
        case 2:
          return STRUCTURED_QUERY;
        case 0:
          return QUERYTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public QueryTypeCase getQueryTypeCase() {
    return QueryTypeCase.forNumber(queryTypeCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. The parent resource name. In the format:
   * `projects/{project_id}/databases/{database_id}/documents`.
   * Document resource names are not supported; only database resource names
   * can be specified.
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent resource name. In the format:
   * `projects/{project_id}/databases/{database_id}/documents`.
   * Document resource names are not supported; only database resource names
   * can be specified.
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STRUCTURED_QUERY_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A structured query.
   * Query must specify collection with all descendants and be ordered by name
   * ascending. Other filters, order bys, limits, offsets, and start/end
   * cursors are not supported.
   * </pre>
   *
   * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
   *
   * @return Whether the structuredQuery field is set.
   */
  @java.lang.Override
  public boolean hasStructuredQuery() {
    return queryTypeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A structured query.
   * Query must specify collection with all descendants and be ordered by name
   * ascending. Other filters, order bys, limits, offsets, and start/end
   * cursors are not supported.
   * </pre>
   *
   * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
   *
   * @return The structuredQuery.
   */
  @java.lang.Override
  public com.google.firestore.v1.StructuredQuery getStructuredQuery() {
    if (queryTypeCase_ == 2) {
      return (com.google.firestore.v1.StructuredQuery) queryType_;
    }
    return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A structured query.
   * Query must specify collection with all descendants and be ordered by name
   * ascending. Other filters, order bys, limits, offsets, and start/end
   * cursors are not supported.
   * </pre>
   *
   * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.StructuredQueryOrBuilder getStructuredQueryOrBuilder() {
    if (queryTypeCase_ == 2) {
      return (com.google.firestore.v1.StructuredQuery) queryType_;
    }
    return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
  }

  public static final int PARTITION_COUNT_FIELD_NUMBER = 3;
  private long partitionCount_;
  /**
   *
   *
   * <pre>
   * The desired maximum number of partition points.
   * The partitions may be returned across multiple pages of results.
   * The number must be positive. The actual number of partitions
   * returned may be fewer.
   * For example, this may be set to one fewer than the number of parallel
   * queries to be run, or in running a data pipeline job, one fewer than the
   * number of workers or compute instances available.
   * </pre>
   *
   * <code>int64 partition_count = 3;</code>
   *
   * @return The partitionCount.
   */
  @java.lang.Override
  public long getPartitionCount() {
    return partitionCount_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 4;
  private volatile java.lang.Object pageToken_;
  /**
   *
   *
   * <pre>
   * The `next_page_token` value returned from a previous call to
   * PartitionQuery that may be used to get an additional set of results.
   * There are no ordering guarantees between sets of results. Thus, using
   * multiple sets of results will require merging the different result sets.
   * For example, two subsequent calls using a page_token may return:
   *  * cursor B, cursor M, cursor Q
   *  * cursor A, cursor U, cursor W
   * To obtain a complete result set ordered with respect to the results of the
   * query supplied to PartitionQuery, the results sets should be merged:
   * cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
   * </pre>
   *
   * <code>string page_token = 4;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The `next_page_token` value returned from a previous call to
   * PartitionQuery that may be used to get an additional set of results.
   * There are no ordering guarantees between sets of results. Thus, using
   * multiple sets of results will require merging the different result sets.
   * For example, two subsequent calls using a page_token may return:
   *  * cursor B, cursor M, cursor Q
   *  * cursor A, cursor U, cursor W
   * To obtain a complete result set ordered with respect to the results of the
   * query supplied to PartitionQuery, the results sets should be merged:
   * cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
   * </pre>
   *
   * <code>string page_token = 4;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 5;
  private int pageSize_;
  /**
   *
   *
   * <pre>
   * The maximum number of partitions to return in this call, subject to
   * `partition_count`.
   * For example, if `partition_count` = 10 and `page_size` = 8, the first call
   * to PartitionQuery will return up to 8 partitions and a `next_page_token`
   * if more results exist. A second call to PartitionQuery will return up to
   * 2 partitions, to complete the total of 10 specified in `partition_count`.
   * </pre>
   *
   * <code>int32 page_size = 5;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (queryTypeCase_ == 2) {
      output.writeMessage(2, (com.google.firestore.v1.StructuredQuery) queryType_);
    }
    if (partitionCount_ != 0L) {
      output.writeInt64(3, partitionCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, pageToken_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(5, pageSize_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (queryTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.firestore.v1.StructuredQuery) queryType_);
    }
    if (partitionCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, partitionCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, pageToken_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, pageSize_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.PartitionQueryRequest)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.PartitionQueryRequest other =
        (com.google.firestore.v1.PartitionQueryRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (getPartitionCount() != other.getPartitionCount()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getQueryTypeCase().equals(other.getQueryTypeCase())) return false;
    switch (queryTypeCase_) {
      case 2:
        if (!getStructuredQuery().equals(other.getStructuredQuery())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + PARTITION_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPartitionCount());
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    switch (queryTypeCase_) {
      case 2:
        hash = (37 * hash) + STRUCTURED_QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getStructuredQuery().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.PartitionQueryRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.PartitionQueryRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.PartitionQueryRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.PartitionQueryRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.PartitionQueryRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.PartitionQueryRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.PartitionQueryRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.PartitionQueryRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.PartitionQueryRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.PartitionQueryRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.PartitionQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.PartitionQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.PartitionQueryRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for [Firestore.PartitionQuery][google.firestore.v1.Firestore.PartitionQuery].
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.PartitionQueryRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.PartitionQueryRequest)
      com.google.firestore.v1.PartitionQueryRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_PartitionQueryRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_PartitionQueryRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.PartitionQueryRequest.class,
              com.google.firestore.v1.PartitionQueryRequest.Builder.class);
    }

    // Construct using com.google.firestore.v1.PartitionQueryRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      partitionCount_ = 0L;

      pageToken_ = "";

      pageSize_ = 0;

      queryTypeCase_ = 0;
      queryType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_PartitionQueryRequest_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.PartitionQueryRequest getDefaultInstanceForType() {
      return com.google.firestore.v1.PartitionQueryRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.PartitionQueryRequest build() {
      com.google.firestore.v1.PartitionQueryRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.PartitionQueryRequest buildPartial() {
      com.google.firestore.v1.PartitionQueryRequest result =
          new com.google.firestore.v1.PartitionQueryRequest(this);
      result.parent_ = parent_;
      if (queryTypeCase_ == 2) {
        if (structuredQueryBuilder_ == null) {
          result.queryType_ = queryType_;
        } else {
          result.queryType_ = structuredQueryBuilder_.build();
        }
      }
      result.partitionCount_ = partitionCount_;
      result.pageToken_ = pageToken_;
      result.pageSize_ = pageSize_;
      result.queryTypeCase_ = queryTypeCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.PartitionQueryRequest) {
        return mergeFrom((com.google.firestore.v1.PartitionQueryRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.PartitionQueryRequest other) {
      if (other == com.google.firestore.v1.PartitionQueryRequest.getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (other.getPartitionCount() != 0L) {
        setPartitionCount(other.getPartitionCount());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      switch (other.getQueryTypeCase()) {
        case STRUCTURED_QUERY:
          {
            mergeStructuredQuery(other.getStructuredQuery());
            break;
          }
        case QUERYTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.firestore.v1.PartitionQueryRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.firestore.v1.PartitionQueryRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int queryTypeCase_ = 0;
    private java.lang.Object queryType_;

    public QueryTypeCase getQueryTypeCase() {
      return QueryTypeCase.forNumber(queryTypeCase_);
    }

    public Builder clearQueryType() {
      queryTypeCase_ = 0;
      queryType_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents`.
     * Document resource names are not supported; only database resource names
     * can be specified.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents`.
     * Document resource names are not supported; only database resource names
     * can be specified.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents`.
     * Document resource names are not supported; only database resource names
     * can be specified.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents`.
     * Document resource names are not supported; only database resource names
     * can be specified.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents`.
     * Document resource names are not supported; only database resource names
     * can be specified.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.StructuredQuery,
            com.google.firestore.v1.StructuredQuery.Builder,
            com.google.firestore.v1.StructuredQueryOrBuilder>
        structuredQueryBuilder_;
    /**
     *
     *
     * <pre>
     * A structured query.
     * Query must specify collection with all descendants and be ordered by name
     * ascending. Other filters, order bys, limits, offsets, and start/end
     * cursors are not supported.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     *
     * @return Whether the structuredQuery field is set.
     */
    @java.lang.Override
    public boolean hasStructuredQuery() {
      return queryTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * Query must specify collection with all descendants and be ordered by name
     * ascending. Other filters, order bys, limits, offsets, and start/end
     * cursors are not supported.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     *
     * @return The structuredQuery.
     */
    @java.lang.Override
    public com.google.firestore.v1.StructuredQuery getStructuredQuery() {
      if (structuredQueryBuilder_ == null) {
        if (queryTypeCase_ == 2) {
          return (com.google.firestore.v1.StructuredQuery) queryType_;
        }
        return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
      } else {
        if (queryTypeCase_ == 2) {
          return structuredQueryBuilder_.getMessage();
        }
        return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * Query must specify collection with all descendants and be ordered by name
     * ascending. Other filters, order bys, limits, offsets, and start/end
     * cursors are not supported.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     */
    public Builder setStructuredQuery(com.google.firestore.v1.StructuredQuery value) {
      if (structuredQueryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryType_ = value;
        onChanged();
      } else {
        structuredQueryBuilder_.setMessage(value);
      }
      queryTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * Query must specify collection with all descendants and be ordered by name
     * ascending. Other filters, order bys, limits, offsets, and start/end
     * cursors are not supported.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     */
    public Builder setStructuredQuery(
        com.google.firestore.v1.StructuredQuery.Builder builderForValue) {
      if (structuredQueryBuilder_ == null) {
        queryType_ = builderForValue.build();
        onChanged();
      } else {
        structuredQueryBuilder_.setMessage(builderForValue.build());
      }
      queryTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * Query must specify collection with all descendants and be ordered by name
     * ascending. Other filters, order bys, limits, offsets, and start/end
     * cursors are not supported.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     */
    public Builder mergeStructuredQuery(com.google.firestore.v1.StructuredQuery value) {
      if (structuredQueryBuilder_ == null) {
        if (queryTypeCase_ == 2
            && queryType_ != com.google.firestore.v1.StructuredQuery.getDefaultInstance()) {
          queryType_ =
              com.google.firestore.v1.StructuredQuery.newBuilder(
                      (com.google.firestore.v1.StructuredQuery) queryType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          queryType_ = value;
        }
        onChanged();
      } else {
        if (queryTypeCase_ == 2) {
          structuredQueryBuilder_.mergeFrom(value);
        }
        structuredQueryBuilder_.setMessage(value);
      }
      queryTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * Query must specify collection with all descendants and be ordered by name
     * ascending. Other filters, order bys, limits, offsets, and start/end
     * cursors are not supported.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     */
    public Builder clearStructuredQuery() {
      if (structuredQueryBuilder_ == null) {
        if (queryTypeCase_ == 2) {
          queryTypeCase_ = 0;
          queryType_ = null;
          onChanged();
        }
      } else {
        if (queryTypeCase_ == 2) {
          queryTypeCase_ = 0;
          queryType_ = null;
        }
        structuredQueryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * Query must specify collection with all descendants and be ordered by name
     * ascending. Other filters, order bys, limits, offsets, and start/end
     * cursors are not supported.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     */
    public com.google.firestore.v1.StructuredQuery.Builder getStructuredQueryBuilder() {
      return getStructuredQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * Query must specify collection with all descendants and be ordered by name
     * ascending. Other filters, order bys, limits, offsets, and start/end
     * cursors are not supported.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.StructuredQueryOrBuilder getStructuredQueryOrBuilder() {
      if ((queryTypeCase_ == 2) && (structuredQueryBuilder_ != null)) {
        return structuredQueryBuilder_.getMessageOrBuilder();
      } else {
        if (queryTypeCase_ == 2) {
          return (com.google.firestore.v1.StructuredQuery) queryType_;
        }
        return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * Query must specify collection with all descendants and be ordered by name
     * ascending. Other filters, order bys, limits, offsets, and start/end
     * cursors are not supported.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.StructuredQuery,
            com.google.firestore.v1.StructuredQuery.Builder,
            com.google.firestore.v1.StructuredQueryOrBuilder>
        getStructuredQueryFieldBuilder() {
      if (structuredQueryBuilder_ == null) {
        if (!(queryTypeCase_ == 2)) {
          queryType_ = com.google.firestore.v1.StructuredQuery.getDefaultInstance();
        }
        structuredQueryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.StructuredQuery,
                com.google.firestore.v1.StructuredQuery.Builder,
                com.google.firestore.v1.StructuredQueryOrBuilder>(
                (com.google.firestore.v1.StructuredQuery) queryType_,
                getParentForChildren(),
                isClean());
        queryType_ = null;
      }
      queryTypeCase_ = 2;
      onChanged();
      ;
      return structuredQueryBuilder_;
    }

    private long partitionCount_;
    /**
     *
     *
     * <pre>
     * The desired maximum number of partition points.
     * The partitions may be returned across multiple pages of results.
     * The number must be positive. The actual number of partitions
     * returned may be fewer.
     * For example, this may be set to one fewer than the number of parallel
     * queries to be run, or in running a data pipeline job, one fewer than the
     * number of workers or compute instances available.
     * </pre>
     *
     * <code>int64 partition_count = 3;</code>
     *
     * @return The partitionCount.
     */
    @java.lang.Override
    public long getPartitionCount() {
      return partitionCount_;
    }
    /**
     *
     *
     * <pre>
     * The desired maximum number of partition points.
     * The partitions may be returned across multiple pages of results.
     * The number must be positive. The actual number of partitions
     * returned may be fewer.
     * For example, this may be set to one fewer than the number of parallel
     * queries to be run, or in running a data pipeline job, one fewer than the
     * number of workers or compute instances available.
     * </pre>
     *
     * <code>int64 partition_count = 3;</code>
     *
     * @param value The partitionCount to set.
     * @return This builder for chaining.
     */
    public Builder setPartitionCount(long value) {

      partitionCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired maximum number of partition points.
     * The partitions may be returned across multiple pages of results.
     * The number must be positive. The actual number of partitions
     * returned may be fewer.
     * For example, this may be set to one fewer than the number of parallel
     * queries to be run, or in running a data pipeline job, one fewer than the
     * number of workers or compute instances available.
     * </pre>
     *
     * <code>int64 partition_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPartitionCount() {

      partitionCount_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * The `next_page_token` value returned from a previous call to
     * PartitionQuery that may be used to get an additional set of results.
     * There are no ordering guarantees between sets of results. Thus, using
     * multiple sets of results will require merging the different result sets.
     * For example, two subsequent calls using a page_token may return:
     *  * cursor B, cursor M, cursor Q
     *  * cursor A, cursor U, cursor W
     * To obtain a complete result set ordered with respect to the results of the
     * query supplied to PartitionQuery, the results sets should be merged:
     * cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The `next_page_token` value returned from a previous call to
     * PartitionQuery that may be used to get an additional set of results.
     * There are no ordering guarantees between sets of results. Thus, using
     * multiple sets of results will require merging the different result sets.
     * For example, two subsequent calls using a page_token may return:
     *  * cursor B, cursor M, cursor Q
     *  * cursor A, cursor U, cursor W
     * To obtain a complete result set ordered with respect to the results of the
     * query supplied to PartitionQuery, the results sets should be merged:
     * cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The `next_page_token` value returned from a previous call to
     * PartitionQuery that may be used to get an additional set of results.
     * There are no ordering guarantees between sets of results. Thus, using
     * multiple sets of results will require merging the different result sets.
     * For example, two subsequent calls using a page_token may return:
     *  * cursor B, cursor M, cursor Q
     *  * cursor A, cursor U, cursor W
     * To obtain a complete result set ordered with respect to the results of the
     * query supplied to PartitionQuery, the results sets should be merged:
     * cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `next_page_token` value returned from a previous call to
     * PartitionQuery that may be used to get an additional set of results.
     * There are no ordering guarantees between sets of results. Thus, using
     * multiple sets of results will require merging the different result sets.
     * For example, two subsequent calls using a page_token may return:
     *  * cursor B, cursor M, cursor Q
     *  * cursor A, cursor U, cursor W
     * To obtain a complete result set ordered with respect to the results of the
     * query supplied to PartitionQuery, the results sets should be merged:
     * cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {

      pageToken_ = getDefaultInstance().getPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `next_page_token` value returned from a previous call to
     * PartitionQuery that may be used to get an additional set of results.
     * There are no ordering guarantees between sets of results. Thus, using
     * multiple sets of results will require merging the different result sets.
     * For example, two subsequent calls using a page_token may return:
     *  * cursor B, cursor M, cursor Q
     *  * cursor A, cursor U, cursor W
     * To obtain a complete result set ordered with respect to the results of the
     * query supplied to PartitionQuery, the results sets should be merged:
     * cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      pageToken_ = value;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * The maximum number of partitions to return in this call, subject to
     * `partition_count`.
     * For example, if `partition_count` = 10 and `page_size` = 8, the first call
     * to PartitionQuery will return up to 8 partitions and a `next_page_token`
     * if more results exist. A second call to PartitionQuery will return up to
     * 2 partitions, to complete the total of 10 specified in `partition_count`.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of partitions to return in this call, subject to
     * `partition_count`.
     * For example, if `partition_count` = 10 and `page_size` = 8, the first call
     * to PartitionQuery will return up to 8 partitions and a `next_page_token`
     * if more results exist. A second call to PartitionQuery will return up to
     * 2 partitions, to complete the total of 10 specified in `partition_count`.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of partitions to return in this call, subject to
     * `partition_count`.
     * For example, if `partition_count` = 10 and `page_size` = 8, the first call
     * to PartitionQuery will return up to 8 partitions and a `next_page_token`
     * if more results exist. A second call to PartitionQuery will return up to
     * 2 partitions, to complete the total of 10 specified in `partition_count`.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {

      pageSize_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.PartitionQueryRequest)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.PartitionQueryRequest)
  private static final com.google.firestore.v1.PartitionQueryRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.PartitionQueryRequest();
  }

  public static com.google.firestore.v1.PartitionQueryRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PartitionQueryRequest> PARSER =
      new com.google.protobuf.AbstractParser<PartitionQueryRequest>() {
        @java.lang.Override
        public PartitionQueryRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new PartitionQueryRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<PartitionQueryRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PartitionQueryRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.PartitionQueryRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
