/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.admin.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ParentName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}/collectionGroups/{collection_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String database;
    private final String collectionId;

    public String getProject() {
        return this.project;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ParentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
        this.collectionId = (String)Preconditions.checkNotNull((Object)builder.getCollectionId());
    }

    public static ParentName of(String project, String database, String collectionId) {
        return ParentName.newBuilder().setProject(project).setDatabase(database).setCollectionId(collectionId).build();
    }

    public static String format(String project, String database, String collectionId) {
        return ParentName.newBuilder().setProject(project).setDatabase(database).setCollectionId(collectionId).build().toString();
    }

    public static ParentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ParentName.parse: formattedString not in valid format");
        return ParentName.of((String)matchMap.get("project"), (String)matchMap.get("database"), (String)matchMap.get("collection_id"));
    }

    public static List<ParentName> parseList(List<String> formattedStrings) {
        ArrayList<ParentName> list = new ArrayList<ParentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ParentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ParentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ParentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ParentName parentName = this;
            synchronized (parentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"database", (Object)this.database);
                    fieldMapBuilder.put((Object)"collectionId", (Object)this.collectionId);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "database", this.database, "collection_id", this.collectionId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ParentName) {
            ParentName that = (ParentName)o;
            return this.project.equals(that.project) && this.database.equals(that.database) && this.collectionId.equals(that.collectionId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.database.hashCode();
        h *= 1000003;
        return h ^= this.collectionId.hashCode();
    }

    public static class Builder {
        private String project;
        private String database;
        private String collectionId;

        public String getProject() {
            return this.project;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getCollectionId() {
            return this.collectionId;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setCollectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        private Builder() {
        }

        private Builder(ParentName parentName) {
            this.project = parentName.project;
            this.database = parentName.database;
            this.collectionId = parentName.collectionId;
        }

        public ParentName build() {
            return new ParentName(this);
        }
    }
}

