/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PipelineName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PIPELINE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/pipelines/{pipeline}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String pipeline;

    @Deprecated
    protected PipelineName() {
        this.project = null;
        this.location = null;
        this.pipeline = null;
    }

    private PipelineName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.pipeline = (String)Preconditions.checkNotNull((Object)builder.getPipeline());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PipelineName of(String project, String location, String pipeline) {
        return PipelineName.newBuilder().setProject(project).setLocation(location).setPipeline(pipeline).build();
    }

    public static String format(String project, String location, String pipeline) {
        return PipelineName.newBuilder().setProject(project).setLocation(location).setPipeline(pipeline).build().toString();
    }

    public static PipelineName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PIPELINE.validatedMatch(formattedString, "PipelineName.parse: formattedString not in valid format");
        return PipelineName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("pipeline"));
    }

    public static List<PipelineName> parseList(List<String> formattedStrings) {
        ArrayList<PipelineName> list = new ArrayList<PipelineName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PipelineName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PipelineName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PipelineName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PIPELINE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PipelineName pipelineName = this;
            synchronized (pipelineName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.pipeline != null) {
                        fieldMapBuilder.put((Object)"pipeline", (Object)this.pipeline);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PIPELINE.instantiate(new String[]{"project", this.project, "location", this.location, "pipeline", this.pipeline});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PipelineName that = (PipelineName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.pipeline, that.pipeline);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.pipeline);
    }

    public static class Builder {
        private String project;
        private String location;
        private String pipeline;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPipeline() {
            return this.pipeline;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPipeline(String pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        private Builder(PipelineName pipelineName) {
            this.project = pipelineName.project;
            this.location = pipelineName.location;
            this.pipeline = pipelineName.pipeline;
        }

        public PipelineName build() {
            return new PipelineName(this);
        }
    }
}

