/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChannelName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CHANNEL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/channels/{channel}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String channel;

    @Deprecated
    protected ChannelName() {
        this.project = null;
        this.location = null;
        this.channel = null;
    }

    private ChannelName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.channel = (String)Preconditions.checkNotNull((Object)builder.getChannel());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getChannel() {
        return this.channel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ChannelName of(String project, String location, String channel) {
        return ChannelName.newBuilder().setProject(project).setLocation(location).setChannel(channel).build();
    }

    public static String format(String project, String location, String channel) {
        return ChannelName.newBuilder().setProject(project).setLocation(location).setChannel(channel).build().toString();
    }

    public static ChannelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CHANNEL.validatedMatch(formattedString, "ChannelName.parse: formattedString not in valid format");
        return ChannelName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("channel"));
    }

    public static List<ChannelName> parseList(List<String> formattedStrings) {
        ArrayList<ChannelName> list = new ArrayList<ChannelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ChannelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ChannelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ChannelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CHANNEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ChannelName channelName = this;
            synchronized (channelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.channel != null) {
                        fieldMapBuilder.put((Object)"channel", (Object)this.channel);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CHANNEL.instantiate(new String[]{"project", this.project, "location", this.location, "channel", this.channel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ChannelName that = (ChannelName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.channel, that.channel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.channel);
    }

    public static class Builder {
        private String project;
        private String location;
        private String channel;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getChannel() {
            return this.channel;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setChannel(String channel) {
            this.channel = channel;
            return this;
        }

        private Builder(ChannelName channelName) {
            this.project = channelName.project;
            this.location = channelName.location;
            this.channel = channelName.channel;
        }

        public ChannelName build() {
            return new ChannelName(this);
        }
    }
}

